/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space.asm;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.sisu.space.asm.AnnotationVisitor;
import org.eclipse.sisu.space.asm.Attribute;
import org.eclipse.sisu.space.asm.ByteVector;
import org.eclipse.sisu.space.asm.ClassVisitor;
import org.eclipse.sisu.space.asm.ClassWriter;
import org.eclipse.sisu.space.asm.Context;
import org.eclipse.sisu.space.asm.FieldVisitor;
import org.eclipse.sisu.space.asm.Handle;
import org.eclipse.sisu.space.asm.Item;
import org.eclipse.sisu.space.asm.Label;
import org.eclipse.sisu.space.asm.MethodVisitor;
import org.eclipse.sisu.space.asm.MethodWriter;
import org.eclipse.sisu.space.asm.Opcodes;
import org.eclipse.sisu.space.asm.Type;
import org.eclipse.sisu.space.asm.TypePath;

public final class ClassReader {
    static final boolean SIGNATURES = true;
    static final boolean ANNOTATIONS = true;
    static final boolean FRAMES = true;
    static final boolean WRITER = true;
    static final boolean RESIZE = true;
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] b2) {
        this(b2, 0, b2.length);
    }

    public ClassReader(byte[] b2, int off, int len) {
        this.b = b2;
        if (this.readShort(off + 6) > 58) {
            throw new IllegalArgumentException();
        }
        this.items = new int[this.readUnsignedShort(off + 8)];
        int n = this.items.length;
        this.strings = new String[n];
        int max = 0;
        int index2 = off + 10;
        int i2 = 1;
        while (i2 < n) {
            int size;
            this.items[i2] = index2 + 1;
            switch (b2[index2]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i2;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index2 + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                case 15: {
                    size = 4;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index2 += size;
            ++i2;
        }
        this.maxStringLength = max;
        this.header = index2;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        return this.readClass(this.header + 4, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int index2 = this.header + 6;
        int n = this.readUnsignedShort(index2);
        String[] interfaces = new String[n];
        if (n > 0) {
            char[] buf = new char[this.maxStringLength];
            int i2 = 0;
            while (i2 < n) {
                interfaces[i2] = this.readClass(index2 += 2, buf);
                ++i2;
            }
        }
        return interfaces;
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll = this.items.length;
        Item[] items2 = new Item[ll];
        int i2 = 1;
        while (i2 < ll) {
            int index2 = this.items[i2];
            byte tag = this.b[index2 - 1];
            Item item = new Item(i2);
            switch (tag) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(tag, this.readClass(index2, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index2));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index2)));
                    break;
                }
                case 12: {
                    item.set(tag, this.readUTF8(index2, buf), this.readUTF8(index2 + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index2));
                    ++i2;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index2)));
                    ++i2;
                    break;
                }
                case 1: {
                    String s2 = this.strings[i2];
                    if (s2 == null) {
                        index2 = this.items[i2];
                        s2 = this.strings[i2] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
                    }
                    item.set(tag, s2, null, null);
                    break;
                }
                case 15: {
                    int fieldOrMethodRef = this.items[this.readUnsignedShort(index2 + 1)];
                    int nameType = this.items[this.readUnsignedShort(fieldOrMethodRef + 2)];
                    item.set(20 + this.readByte(index2), this.readClass(fieldOrMethodRef, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 18: {
                    if (classWriter.bootstrapMethods == null) {
                        this.copyBootstrapMethods(classWriter, items2, buf);
                    }
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf), this.readUnsignedShort(index2));
                    break;
                }
                default: {
                    item.set(tag, this.readUTF8(index2, buf), null, null);
                }
            }
            int index22 = item.hashCode % items2.length;
            item.next = items2[index22];
            items2[index22] = item;
            ++i2;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll);
        classWriter.index = ll;
    }

    private void copyBootstrapMethods(ClassWriter classWriter, Item[] items2, char[] c2) {
        int u = this.getAttributes();
        boolean found = false;
        int i2 = this.readUnsignedShort(u);
        while (i2 > 0) {
            String attrName = this.readUTF8(u + 2, c2);
            if ("BootstrapMethods".equals(attrName)) {
                found = true;
                break;
            }
            u += 6 + this.readInt(u + 4);
            --i2;
        }
        if (!found) {
            return;
        }
        int boostrapMethodCount = this.readUnsignedShort(u + 8);
        int j = 0;
        int v2 = u + 10;
        while (j < boostrapMethodCount) {
            int position = v2 - u - 10;
            int hashCode = this.readConst(this.readUnsignedShort(v2), c2).hashCode();
            int k = this.readUnsignedShort(v2 + 2);
            while (k > 0) {
                hashCode ^= this.readConst(this.readUnsignedShort(v2 + 4), c2).hashCode();
                v2 += 2;
                --k;
            }
            v2 += 4;
            Item item = new Item(j);
            item.set(position, hashCode & Integer.MAX_VALUE);
            int index2 = item.hashCode % items2.length;
            item.next = items2[index2];
            items2[index2] = item;
            ++j;
        }
        int attrSize = this.readInt(u + 4);
        ByteVector bootstrapMethods = new ByteVector(attrSize + 62);
        bootstrapMethods.putByteArray(this.b, u + 10, attrSize - 2);
        classWriter.bootstrapMethodsCount = boostrapMethodCount;
        classWriter.bootstrapMethods = bootstrapMethods;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is, false));
    }

    public ClassReader(String name2) throws IOException {
        this(ClassReader.readClass(ClassLoader.getSystemResourceAsStream(String.valueOf(name2.replace('.', '/')) + ".class"), true));
    }

    private static byte[] readClass(InputStream is, boolean close2) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        try {
            byte[] b2 = new byte[is.available()];
            int len = 0;
            while (true) {
                int n;
                if ((n = is.read(b2, len, b2.length - len)) == -1) {
                    if (len < b2.length) {
                        byte[] c2 = new byte[len];
                        System.arraycopy(b2, 0, c2, 0, len);
                        b2 = c2;
                    }
                    byte[] byArray = b2;
                    return byArray;
                }
                if ((len += n) != b2.length) continue;
                int last2 = is.read();
                if (last2 < 0) {
                    byte[] byArray = b2;
                    return byArray;
                }
                byte[] c3 = new byte[b2.length + 1000];
                System.arraycopy(b2, 0, c3, 0, len);
                c3[len++] = (byte)last2;
                b2 = c3;
            }
        }
        finally {
            if (close2) {
                is.close();
            }
        }
    }

    public void accept(ClassVisitor classVisitor, int flags) {
        this.accept(classVisitor, new Attribute[0], flags);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attrs, int flags) {
        int u = this.header;
        char[] c2 = new char[this.maxStringLength];
        Context context = new Context();
        context.attrs = attrs;
        context.flags = flags;
        context.buffer = c2;
        int access = this.readUnsignedShort(u);
        String name2 = this.readClass(u + 2, c2);
        String superClass = this.readClass(u + 4, c2);
        String[] interfaces = new String[this.readUnsignedShort(u + 6)];
        u += 8;
        int i2 = 0;
        while (i2 < interfaces.length) {
            interfaces[i2] = this.readClass(u, c2);
            u += 2;
            ++i2;
        }
        String signature2 = null;
        String sourceFile = null;
        String sourceDebug = null;
        String enclosingOwner = null;
        String enclosingName = null;
        String enclosingDesc = null;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        int innerClasses = 0;
        Attribute attributes2 = null;
        u = this.getAttributes();
        int i3 = this.readUnsignedShort(u);
        while (i3 > 0) {
            String attrName = this.readUTF8(u + 2, c2);
            if ("SourceFile".equals(attrName)) {
                sourceFile = this.readUTF8(u + 8, c2);
            } else if ("InnerClasses".equals(attrName)) {
                innerClasses = u + 8;
            } else if ("EnclosingMethod".equals(attrName)) {
                enclosingOwner = this.readClass(u + 8, c2);
                int item = this.readUnsignedShort(u + 10);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c2);
                    enclosingDesc = this.readUTF8(this.items[item] + 2, c2);
                }
            } else if ("Signature".equals(attrName)) {
                signature2 = this.readUTF8(u + 8, c2);
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x41000;
            } else if ("SourceDebugExtension".equals(attrName)) {
                int len = this.readInt(u + 4);
                sourceDebug = this.readUTF(u + 8, len, new char[len]);
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else if ("BootstrapMethods".equals(attrName)) {
                int[] bootstrapMethods = new int[this.readUnsignedShort(u + 8)];
                int j = 0;
                int v2 = u + 10;
                while (j < bootstrapMethods.length) {
                    bootstrapMethods[j] = v2;
                    v2 += 2 + this.readUnsignedShort(v2 + 2) << 1;
                    ++j;
                }
                context.bootstrapMethods = bootstrapMethods;
            } else {
                Attribute attr = this.readAttribute(attrs, attrName, u + 8, this.readInt(u + 4), c2, -1, null);
                if (attr != null) {
                    attr.next = attributes2;
                    attributes2 = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
            --i3;
        }
        classVisitor.visit(this.readInt(this.items[1] - 7), access, name2, signature2, superClass, interfaces);
        if ((flags & 2) == 0 && (sourceFile != null || sourceDebug != null)) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (enclosingOwner != null) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        if (anns != 0) {
            i3 = this.readUnsignedShort(anns);
            int v3 = anns + 2;
            while (i3 > 0) {
                v3 = this.readAnnotationValues(v3 + 2, c2, true, classVisitor.visitAnnotation(this.readUTF8(v3, c2), true));
                --i3;
            }
        }
        if (ianns != 0) {
            i3 = this.readUnsignedShort(ianns);
            int v4 = ianns + 2;
            while (i3 > 0) {
                v4 = this.readAnnotationValues(v4 + 2, c2, true, classVisitor.visitAnnotation(this.readUTF8(v4, c2), false));
                --i3;
            }
        }
        if (tanns != 0) {
            i3 = this.readUnsignedShort(tanns);
            int v5 = tanns + 2;
            while (i3 > 0) {
                v5 = this.readAnnotationTarget(context, v5);
                v5 = this.readAnnotationValues(v5 + 2, c2, true, classVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v5, c2), true));
                --i3;
            }
        }
        if (itanns != 0) {
            i3 = this.readUnsignedShort(itanns);
            int v6 = itanns + 2;
            while (i3 > 0) {
                v6 = this.readAnnotationTarget(context, v6);
                v6 = this.readAnnotationValues(v6 + 2, c2, true, classVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v6, c2), false));
                --i3;
            }
        }
        while (attributes2 != null) {
            Attribute attr = attributes2.next;
            attributes2.next = null;
            classVisitor.visitAttribute(attributes2);
            attributes2 = attr;
        }
        if (innerClasses != 0) {
            int v7 = innerClasses + 2;
            int i4 = this.readUnsignedShort(innerClasses);
            while (i4 > 0) {
                classVisitor.visitInnerClass(this.readClass(v7, c2), this.readClass(v7 + 2, c2), this.readUTF8(v7 + 4, c2), this.readUnsignedShort(v7 + 6));
                v7 += 8;
                --i4;
            }
        }
        u = this.header + 10 + 2 * interfaces.length;
        i = this.readUnsignedShort(u - 2);
        while (i > 0) {
            u = this.readField(classVisitor, context, u);
            --i;
        }
        i = this.readUnsignedShort((u += 2) - 2);
        while (i > 0) {
            u = this.readMethod(classVisitor, context, u);
            --i;
        }
        classVisitor.visitEnd();
    }

    private int readField(ClassVisitor classVisitor, Context context, int u) {
        int v2;
        char[] c2 = context.buffer;
        int access = this.readUnsignedShort(u);
        String name2 = this.readUTF8(u + 2, c2);
        String desc = this.readUTF8(u + 4, c2);
        u += 6;
        String signature2 = null;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        Object value2 = null;
        Attribute attributes2 = null;
        int i2 = this.readUnsignedShort(u);
        while (i2 > 0) {
            String attrName = this.readUTF8(u + 2, c2);
            if ("ConstantValue".equals(attrName)) {
                int item = this.readUnsignedShort(u + 8);
                value2 = item == 0 ? null : this.readConst(item, c2);
            } else if ("Signature".equals(attrName)) {
                signature2 = this.readUTF8(u + 8, c2);
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x41000;
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else {
                Attribute attr = this.readAttribute(context.attrs, attrName, u + 8, this.readInt(u + 4), c2, -1, null);
                if (attr != null) {
                    attr.next = attributes2;
                    attributes2 = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
            --i2;
        }
        u += 2;
        FieldVisitor fv = classVisitor.visitField(access, name2, desc, signature2, value2);
        if (fv == null) {
            return u;
        }
        if (anns != 0) {
            int i3 = this.readUnsignedShort(anns);
            v2 = anns + 2;
            while (i3 > 0) {
                v2 = this.readAnnotationValues(v2 + 2, c2, true, fv.visitAnnotation(this.readUTF8(v2, c2), true));
                --i3;
            }
        }
        if (ianns != 0) {
            int i4 = this.readUnsignedShort(ianns);
            v2 = ianns + 2;
            while (i4 > 0) {
                v2 = this.readAnnotationValues(v2 + 2, c2, true, fv.visitAnnotation(this.readUTF8(v2, c2), false));
                --i4;
            }
        }
        if (tanns != 0) {
            int i5 = this.readUnsignedShort(tanns);
            v2 = tanns + 2;
            while (i5 > 0) {
                v2 = this.readAnnotationTarget(context, v2);
                v2 = this.readAnnotationValues(v2 + 2, c2, true, fv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v2, c2), true));
                --i5;
            }
        }
        if (itanns != 0) {
            int i6 = this.readUnsignedShort(itanns);
            v2 = itanns + 2;
            while (i6 > 0) {
                v2 = this.readAnnotationTarget(context, v2);
                v2 = this.readAnnotationValues(v2 + 2, c2, true, fv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v2, c2), false));
                --i6;
            }
        }
        while (attributes2 != null) {
            Attribute attr = attributes2.next;
            attributes2.next = null;
            fv.visitAttribute(attributes2);
            attributes2 = attr;
        }
        fv.visitEnd();
        return u;
    }

    private int readMethod(ClassVisitor classVisitor, Context context, int u) {
        char[] c2 = context.buffer;
        context.access = this.readUnsignedShort(u);
        context.name = this.readUTF8(u + 2, c2);
        context.desc = this.readUTF8(u + 4, c2);
        u += 6;
        int code = 0;
        int exception = 0;
        String[] exceptions = null;
        String signature2 = null;
        int methodParameters = 0;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        int dann = 0;
        int mpanns = 0;
        int impanns = 0;
        int firstAttribute = u;
        Attribute attributes2 = null;
        int i2 = this.readUnsignedShort(u);
        while (i2 > 0) {
            String attrName = this.readUTF8(u + 2, c2);
            if ("Code".equals(attrName)) {
                if ((context.flags & 1) == 0) {
                    code = u + 8;
                }
            } else if ("Exceptions".equals(attrName)) {
                exceptions = new String[this.readUnsignedShort(u + 8)];
                exception = u + 10;
                int j = 0;
                while (j < exceptions.length) {
                    exceptions[j] = this.readClass(exception, c2);
                    exception += 2;
                    ++j;
                }
            } else if ("Signature".equals(attrName)) {
                signature2 = this.readUTF8(u + 8, c2);
            } else if ("Deprecated".equals(attrName)) {
                context.access |= 0x20000;
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("AnnotationDefault".equals(attrName)) {
                dann = u + 8;
            } else if ("Synthetic".equals(attrName)) {
                context.access |= 0x41000;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else if ("RuntimeVisibleParameterAnnotations".equals(attrName)) {
                mpanns = u + 8;
            } else if ("RuntimeInvisibleParameterAnnotations".equals(attrName)) {
                impanns = u + 8;
            } else if ("MethodParameters".equals(attrName)) {
                methodParameters = u + 8;
            } else {
                Attribute attr = this.readAttribute(context.attrs, attrName, u + 8, this.readInt(u + 4), c2, -1, null);
                if (attr != null) {
                    attr.next = attributes2;
                    attributes2 = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
            --i2;
        }
        u += 2;
        MethodVisitor mv = classVisitor.visitMethod(context.access, context.name, context.desc, signature2, exceptions);
        if (mv == null) {
            return u;
        }
        if (mv instanceof MethodWriter) {
            MethodWriter mw = (MethodWriter)mv;
            if (mw.cw.cr == this && signature2 == mw.signature) {
                boolean sameExceptions = false;
                if (exceptions == null) {
                    sameExceptions = mw.exceptionCount == 0;
                } else if (exceptions.length == mw.exceptionCount) {
                    sameExceptions = true;
                    int j = exceptions.length - 1;
                    while (j >= 0) {
                        if (mw.exceptions[j] != this.readUnsignedShort(exception -= 2)) {
                            sameExceptions = false;
                            break;
                        }
                        --j;
                    }
                }
                if (sameExceptions) {
                    mw.classReaderOffset = firstAttribute;
                    mw.classReaderLength = u - firstAttribute;
                    return u;
                }
            }
        }
        if (methodParameters != 0) {
            int i3 = this.b[methodParameters] & 0xFF;
            int v2 = methodParameters + 1;
            while (i3 > 0) {
                mv.visitParameter(this.readUTF8(v2, c2), this.readUnsignedShort(v2 + 2));
                --i3;
                v2 += 4;
            }
        }
        if (dann != 0) {
            AnnotationVisitor dv2 = mv.visitAnnotationDefault();
            this.readAnnotationValue(dann, c2, null, dv2);
            if (dv2 != null) {
                dv2.visitEnd();
            }
        }
        if (anns != 0) {
            int i4 = this.readUnsignedShort(anns);
            int v3 = anns + 2;
            while (i4 > 0) {
                v3 = this.readAnnotationValues(v3 + 2, c2, true, mv.visitAnnotation(this.readUTF8(v3, c2), true));
                --i4;
            }
        }
        if (ianns != 0) {
            int i5 = this.readUnsignedShort(ianns);
            int v4 = ianns + 2;
            while (i5 > 0) {
                v4 = this.readAnnotationValues(v4 + 2, c2, true, mv.visitAnnotation(this.readUTF8(v4, c2), false));
                --i5;
            }
        }
        if (tanns != 0) {
            int i6 = this.readUnsignedShort(tanns);
            int v5 = tanns + 2;
            while (i6 > 0) {
                v5 = this.readAnnotationTarget(context, v5);
                v5 = this.readAnnotationValues(v5 + 2, c2, true, mv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v5, c2), true));
                --i6;
            }
        }
        if (itanns != 0) {
            int i7 = this.readUnsignedShort(itanns);
            int v6 = itanns + 2;
            while (i7 > 0) {
                v6 = this.readAnnotationTarget(context, v6);
                v6 = this.readAnnotationValues(v6 + 2, c2, true, mv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v6, c2), false));
                --i7;
            }
        }
        if (mpanns != 0) {
            this.readParameterAnnotations(mv, context, mpanns, true);
        }
        if (impanns != 0) {
            this.readParameterAnnotations(mv, context, impanns, false);
        }
        while (attributes2 != null) {
            Attribute attr = attributes2.next;
            attributes2.next = null;
            mv.visitAttribute(attributes2);
            attributes2 = attr;
        }
        if (code != 0) {
            mv.visitCode();
            this.readCode(mv, context, code);
        }
        mv.visitEnd();
        return u;
    }

    private void readCode(MethodVisitor mv, Context context, int u) {
        byte[] b2 = this.b;
        char[] c2 = context.buffer;
        int maxStack = this.readUnsignedShort(u);
        int maxLocals = this.readUnsignedShort(u + 2);
        int codeLength = this.readInt(u + 4);
        int codeStart = u += 8;
        int codeEnd = u + codeLength;
        context.labels = new Label[codeLength + 2];
        Label[] labels = context.labels;
        this.readLabel(codeLength + 1, labels);
        while (u < codeEnd) {
            int offset = u - codeStart;
            int opcode = b2[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: 
                case 4: {
                    ++u;
                    break;
                }
                case 9: {
                    this.readLabel(offset + this.readShort(u + 1), labels);
                    u += 3;
                    break;
                }
                case 10: {
                    this.readLabel(offset + this.readInt(u + 1), labels);
                    u += 5;
                    break;
                }
                case 17: {
                    opcode = b2[u + 1] & 0xFF;
                    if (opcode == 132) {
                        u += 6;
                        break;
                    }
                    u += 4;
                    break;
                }
                case 14: {
                    u = u + 4 - (offset & 3);
                    this.readLabel(offset + this.readInt(u), labels);
                    int i2 = this.readInt(u + 8) - this.readInt(u + 4) + 1;
                    while (i2 > 0) {
                        this.readLabel(offset + this.readInt(u + 12), labels);
                        u += 4;
                        --i2;
                    }
                    u += 12;
                    break;
                }
                case 15: {
                    u = u + 4 - (offset & 3);
                    this.readLabel(offset + this.readInt(u), labels);
                    int i2 = this.readInt(u + 4);
                    while (i2 > 0) {
                        this.readLabel(offset + this.readInt(u + 12), labels);
                        u += 8;
                        --i2;
                    }
                    u += 8;
                    break;
                }
                case 1: 
                case 3: 
                case 11: {
                    u += 2;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 12: 
                case 13: {
                    u += 3;
                    break;
                }
                case 7: 
                case 8: {
                    u += 5;
                    break;
                }
                default: {
                    u += 4;
                }
            }
        }
        int i3 = this.readUnsignedShort(u);
        while (i3 > 0) {
            Label start2 = this.readLabel(this.readUnsignedShort(u + 2), labels);
            Label end = this.readLabel(this.readUnsignedShort(u + 4), labels);
            Label handler2 = this.readLabel(this.readUnsignedShort(u + 6), labels);
            String type = this.readUTF8(this.items[this.readUnsignedShort(u + 8)], c2);
            mv.visitTryCatchBlock(start2, end, handler2, type);
            u += 8;
            --i3;
        }
        u += 2;
        int[] tanns = null;
        int[] itanns = null;
        int tann = 0;
        int itann = 0;
        int ntoff = -1;
        int nitoff = -1;
        int varTable = 0;
        int varTypeTable = 0;
        boolean zip = true;
        boolean unzip = (context.flags & 8) != 0;
        int stackMap = 0;
        int stackMapSize = 0;
        int frameCount = 0;
        Context frame = null;
        Attribute attributes2 = null;
        int i4 = this.readUnsignedShort(u);
        while (i4 > 0) {
            int label2;
            int j;
            String attrName = this.readUTF8(u + 2, c2);
            if ("LocalVariableTable".equals(attrName)) {
                if ((context.flags & 2) == 0) {
                    varTable = u + 8;
                    j = this.readUnsignedShort(u + 8);
                    int v2 = u;
                    while (j > 0) {
                        label2 = this.readUnsignedShort(v2 + 10);
                        if (labels[label2] == null) {
                            this.readLabel((int)label2, (Label[])labels).status |= 1;
                        }
                        if (labels[label2 += this.readUnsignedShort(v2 + 12)] == null) {
                            this.readLabel((int)label2, (Label[])labels).status |= 1;
                        }
                        v2 += 10;
                        --j;
                    }
                }
            } else if ("LocalVariableTypeTable".equals(attrName)) {
                varTypeTable = u + 8;
            } else if ("LineNumberTable".equals(attrName)) {
                if ((context.flags & 2) == 0) {
                    j = this.readUnsignedShort(u + 8);
                    int v3 = u;
                    while (j > 0) {
                        label2 = this.readUnsignedShort(v3 + 10);
                        if (labels[label2] == null) {
                            this.readLabel((int)label2, (Label[])labels).status |= 1;
                        }
                        labels[label2].line = this.readUnsignedShort(v3 + 12);
                        v3 += 4;
                        --j;
                    }
                }
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = this.readTypeAnnotations(mv, context, u + 8, true);
                ntoff = tanns.length == 0 || this.readByte(tanns[0]) < 67 ? -1 : this.readUnsignedShort(tanns[0] + 1);
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = this.readTypeAnnotations(mv, context, u + 8, false);
                nitoff = itanns.length == 0 || this.readByte(itanns[0]) < 67 ? -1 : this.readUnsignedShort(itanns[0] + 1);
            } else if ("StackMapTable".equals(attrName)) {
                if ((context.flags & 4) == 0) {
                    stackMap = u + 10;
                    stackMapSize = this.readInt(u + 4);
                    frameCount = this.readUnsignedShort(u + 8);
                }
            } else if ("StackMap".equals(attrName)) {
                if ((context.flags & 4) == 0) {
                    zip = false;
                    stackMap = u + 10;
                    stackMapSize = this.readInt(u + 4);
                    frameCount = this.readUnsignedShort(u + 8);
                }
            } else {
                j = 0;
                while (j < context.attrs.length) {
                    Attribute attr;
                    if (context.attrs[j].type.equals(attrName) && (attr = context.attrs[j].read(this, u + 8, this.readInt(u + 4), c2, codeStart - 8, labels)) != null) {
                        attr.next = attributes2;
                        attributes2 = attr;
                    }
                    ++j;
                }
            }
            u += 6 + this.readInt(u + 4);
            --i4;
        }
        u += 2;
        if (stackMap != 0) {
            frame = context;
            frame.offset = -1;
            frame.mode = 0;
            frame.localCount = 0;
            frame.localDiff = 0;
            frame.stackCount = 0;
            frame.local = new Object[maxLocals];
            frame.stack = new Object[maxStack];
            if (unzip) {
                this.getImplicitFrame(context);
            }
            i4 = stackMap;
            while (i4 < stackMap + stackMapSize - 2) {
                int v4;
                if (b2[i4] == 8 && (v4 = this.readUnsignedShort(i4 + 1)) >= 0 && v4 < codeLength && (b2[codeStart + v4] & 0xFF) == 187) {
                    this.readLabel(v4, labels);
                }
                ++i4;
            }
        }
        u = codeStart;
        while (u < codeEnd) {
            int offset = u - codeStart;
            Label l = labels[offset];
            if (l != null) {
                mv.visitLabel(l);
                if ((context.flags & 2) == 0 && l.line > 0) {
                    mv.visitLineNumber(l.line, l);
                }
            }
            while (frame != null && (frame.offset == offset || frame.offset == -1)) {
                if (frame.offset != -1) {
                    if (!zip || unzip) {
                        mv.visitFrame(-1, frame.localCount, frame.local, frame.stackCount, frame.stack);
                    } else {
                        mv.visitFrame(frame.mode, frame.localDiff, frame.local, frame.stackCount, frame.stack);
                    }
                }
                if (frameCount > 0) {
                    stackMap = this.readFrame(stackMap, zip, unzip, frame);
                    --frameCount;
                    continue;
                }
                frame = null;
            }
            int opcode = b2[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: {
                    mv.visitInsn(opcode);
                    ++u;
                    break;
                }
                case 4: {
                    if (opcode > 54) {
                        mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                    } else {
                        mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                    }
                    ++u;
                    break;
                }
                case 9: {
                    mv.visitJumpInsn(opcode, labels[offset + this.readShort(u + 1)]);
                    u += 3;
                    break;
                }
                case 10: {
                    mv.visitJumpInsn(opcode - 33, labels[offset + this.readInt(u + 1)]);
                    u += 5;
                    break;
                }
                case 17: {
                    opcode = b2[u + 1] & 0xFF;
                    if (opcode == 132) {
                        mv.visitIincInsn(this.readUnsignedShort(u + 2), this.readShort(u + 4));
                        u += 6;
                        break;
                    }
                    mv.visitVarInsn(opcode, this.readUnsignedShort(u + 2));
                    u += 4;
                    break;
                }
                case 14: {
                    u = u + 4 - (offset & 3);
                    int label3 = offset + this.readInt(u);
                    int min = this.readInt(u + 4);
                    int max = this.readInt(u + 8);
                    Label[] table = new Label[max - min + 1];
                    u += 12;
                    int i5 = 0;
                    while (i5 < table.length) {
                        table[i5] = labels[offset + this.readInt(u)];
                        u += 4;
                        ++i5;
                    }
                    mv.visitTableSwitchInsn(min, max, labels[label3], table);
                    break;
                }
                case 15: {
                    u = u + 4 - (offset & 3);
                    int label4 = offset + this.readInt(u);
                    int len = this.readInt(u + 4);
                    int[] keys2 = new int[len];
                    Label[] values2 = new Label[len];
                    u += 8;
                    int i6 = 0;
                    while (i6 < len) {
                        keys2[i6] = this.readInt(u);
                        values2[i6] = labels[offset + this.readInt(u + 4)];
                        u += 8;
                        ++i6;
                    }
                    mv.visitLookupSwitchInsn(labels[label4], keys2, values2);
                    break;
                }
                case 3: {
                    mv.visitVarInsn(opcode, b2[u + 1] & 0xFF);
                    u += 2;
                    break;
                }
                case 1: {
                    mv.visitIntInsn(opcode, b2[u + 1]);
                    u += 2;
                    break;
                }
                case 2: {
                    mv.visitIntInsn(opcode, this.readShort(u + 1));
                    u += 3;
                    break;
                }
                case 11: {
                    mv.visitLdcInsn(this.readConst(b2[u + 1] & 0xFF, c2));
                    u += 2;
                    break;
                }
                case 12: {
                    mv.visitLdcInsn(this.readConst(this.readUnsignedShort(u + 1), c2));
                    u += 3;
                    break;
                }
                case 6: 
                case 7: {
                    int cpIndex = this.items[this.readUnsignedShort(u + 1)];
                    boolean itf = b2[cpIndex - 1] == 11;
                    String iowner = this.readClass(cpIndex, c2);
                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                    String iname = this.readUTF8(cpIndex, c2);
                    String idesc = this.readUTF8(cpIndex + 2, c2);
                    if (opcode < 182) {
                        mv.visitFieldInsn(opcode, iowner, iname, idesc);
                    } else {
                        mv.visitMethodInsn(opcode, iowner, iname, idesc, itf);
                    }
                    if (opcode == 185) {
                        u += 5;
                        break;
                    }
                    u += 3;
                    break;
                }
                case 8: {
                    int cpIndex = this.items[this.readUnsignedShort(u + 1)];
                    int bsmIndex = context.bootstrapMethods[this.readUnsignedShort(cpIndex)];
                    Handle bsm = (Handle)this.readConst(this.readUnsignedShort(bsmIndex), c2);
                    int bsmArgCount = this.readUnsignedShort(bsmIndex + 2);
                    Object[] bsmArgs = new Object[bsmArgCount];
                    bsmIndex += 4;
                    int i7 = 0;
                    while (i7 < bsmArgCount) {
                        bsmArgs[i7] = this.readConst(this.readUnsignedShort(bsmIndex), c2);
                        bsmIndex += 2;
                        ++i7;
                    }
                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                    String iname = this.readUTF8(cpIndex, c2);
                    String idesc = this.readUTF8(cpIndex + 2, c2);
                    mv.visitInvokeDynamicInsn(iname, idesc, bsm, bsmArgs);
                    u += 5;
                    break;
                }
                case 5: {
                    mv.visitTypeInsn(opcode, this.readClass(u + 1, c2));
                    u += 3;
                    break;
                }
                case 13: {
                    mv.visitIincInsn(b2[u + 1] & 0xFF, b2[u + 2]);
                    u += 3;
                    break;
                }
                default: {
                    mv.visitMultiANewArrayInsn(this.readClass(u + 1, c2), b2[u + 3] & 0xFF);
                    u += 4;
                    break;
                }
            }
            while (tanns != null && tann < tanns.length && ntoff <= offset) {
                if (ntoff == offset) {
                    int v5 = this.readAnnotationTarget(context, tanns[tann]);
                    this.readAnnotationValues(v5 + 2, c2, true, mv.visitInsnAnnotation(context.typeRef, context.typePath, this.readUTF8(v5, c2), true));
                }
                int n = ntoff = ++tann >= tanns.length || this.readByte(tanns[tann]) < 67 ? -1 : this.readUnsignedShort(tanns[tann] + 1);
            }
            while (itanns != null && itann < itanns.length && nitoff <= offset) {
                if (nitoff == offset) {
                    int v6 = this.readAnnotationTarget(context, itanns[itann]);
                    this.readAnnotationValues(v6 + 2, c2, true, mv.visitInsnAnnotation(context.typeRef, context.typePath, this.readUTF8(v6, c2), false));
                }
                int n = nitoff = ++itann >= itanns.length || this.readByte(itanns[itann]) < 67 ? -1 : this.readUnsignedShort(itanns[itann] + 1);
            }
        }
        if (labels[codeLength] != null) {
            mv.visitLabel(labels[codeLength]);
        }
        if ((context.flags & 2) == 0 && varTable != 0) {
            int[] typeTable = null;
            if (varTypeTable != 0) {
                u = varTypeTable + 2;
                typeTable = new int[this.readUnsignedShort(varTypeTable) * 3];
                int i8 = typeTable.length;
                while (i8 > 0) {
                    typeTable[--i8] = u + 6;
                    typeTable[--i8] = this.readUnsignedShort(u + 8);
                    typeTable[--i8] = this.readUnsignedShort(u);
                    u += 10;
                }
            }
            u = varTable + 2;
            int i9 = this.readUnsignedShort(varTable);
            while (i9 > 0) {
                int start3 = this.readUnsignedShort(u);
                int length = this.readUnsignedShort(u + 2);
                int index2 = this.readUnsignedShort(u + 8);
                String vsignature = null;
                if (typeTable != null) {
                    int j = 0;
                    while (j < typeTable.length) {
                        if (typeTable[j] == start3 && typeTable[j + 1] == index2) {
                            vsignature = this.readUTF8(typeTable[j + 2], c2);
                            break;
                        }
                        j += 3;
                    }
                }
                mv.visitLocalVariable(this.readUTF8(u + 4, c2), this.readUTF8(u + 6, c2), vsignature, labels[start3], labels[start3 + length], index2);
                u += 10;
                --i9;
            }
        }
        if (tanns != null) {
            i = 0;
            while (i < tanns.length) {
                if (this.readByte((int)tanns[i]) >> 1 == 32) {
                    int v7 = this.readAnnotationTarget(context, tanns[i]);
                    v7 = this.readAnnotationValues(v7 + 2, c2, true, mv.visitLocalVariableAnnotation(context.typeRef, context.typePath, context.start, context.end, context.index, this.readUTF8(v7, c2), true));
                }
                ++i;
            }
        }
        if (itanns != null) {
            i = 0;
            while (i < itanns.length) {
                if (this.readByte((int)itanns[i]) >> 1 == 32) {
                    int v8 = this.readAnnotationTarget(context, itanns[i]);
                    v8 = this.readAnnotationValues(v8 + 2, c2, true, mv.visitLocalVariableAnnotation(context.typeRef, context.typePath, context.start, context.end, context.index, this.readUTF8(v8, c2), false));
                }
                ++i;
            }
        }
        while (attributes2 != null) {
            Attribute attr = attributes2.next;
            attributes2.next = null;
            mv.visitAttribute(attributes2);
            attributes2 = attr;
        }
        mv.visitMaxs(maxStack, maxLocals);
    }

    private int[] readTypeAnnotations(MethodVisitor mv, Context context, int u, boolean visible) {
        char[] c2 = context.buffer;
        int[] offsets = new int[this.readUnsignedShort(u)];
        u += 2;
        int i2 = 0;
        while (i2 < offsets.length) {
            offsets[i2] = u;
            int target2 = this.readInt(u);
            switch (target2 >>> 24) {
                case 0: 
                case 1: 
                case 22: {
                    u += 2;
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    ++u;
                    break;
                }
                case 64: 
                case 65: {
                    int j = this.readUnsignedShort(u + 1);
                    while (j > 0) {
                        int start2 = this.readUnsignedShort(u + 3);
                        int length = this.readUnsignedShort(u + 5);
                        this.readLabel(start2, context.labels);
                        this.readLabel(start2 + length, context.labels);
                        u += 6;
                        --j;
                    }
                    u += 3;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    u += 4;
                    break;
                }
                default: {
                    u += 3;
                }
            }
            int pathLength = this.readByte(u);
            if (target2 >>> 24 == 66) {
                TypePath path = pathLength == 0 ? null : new TypePath(this.b, u);
                u += 1 + 2 * pathLength;
                u = this.readAnnotationValues(u + 2, c2, true, mv.visitTryCatchAnnotation(target2, path, this.readUTF8(u, c2), visible));
            } else {
                u = this.readAnnotationValues(u + 3 + 2 * pathLength, c2, true, null);
            }
            ++i2;
        }
        return offsets;
    }

    private int readAnnotationTarget(Context context, int u) {
        int target2 = this.readInt(u);
        switch (target2 >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                target2 &= 0xFFFF0000;
                u += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                target2 &= 0xFF000000;
                ++u;
                break;
            }
            case 64: 
            case 65: {
                target2 &= 0xFF000000;
                int n = this.readUnsignedShort(u + 1);
                context.start = new Label[n];
                context.end = new Label[n];
                context.index = new int[n];
                u += 3;
                int i2 = 0;
                while (i2 < n) {
                    int start2 = this.readUnsignedShort(u);
                    int length = this.readUnsignedShort(u + 2);
                    context.start[i2] = this.readLabel(start2, context.labels);
                    context.end[i2] = this.readLabel(start2 + length, context.labels);
                    context.index[i2] = this.readUnsignedShort(u + 4);
                    u += 6;
                    ++i2;
                }
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                target2 &= 0xFF0000FF;
                u += 4;
                break;
            }
            default: {
                target2 &= target2 >>> 24 < 67 ? -256 : -16777216;
                u += 3;
            }
        }
        int pathLength = this.readByte(u);
        context.typeRef = target2;
        context.typePath = pathLength == 0 ? null : new TypePath(this.b, u);
        return u + 1 + 2 * pathLength;
    }

    private void readParameterAnnotations(MethodVisitor mv, Context context, int v2, boolean visible) {
        AnnotationVisitor av;
        int n = this.b[v2++] & 0xFF;
        int synthetics = Type.getArgumentTypes(context.desc).length - n;
        int i2 = 0;
        while (i2 < synthetics) {
            av = mv.visitParameterAnnotation(i2, "Ljava/lang/Synthetic;", false);
            if (av != null) {
                av.visitEnd();
            }
            ++i2;
        }
        char[] c2 = context.buffer;
        while (i2 < n + synthetics) {
            int j = this.readUnsignedShort(v2);
            v2 += 2;
            while (j > 0) {
                av = mv.visitParameterAnnotation(i2, this.readUTF8(v2, c2), visible);
                v2 = this.readAnnotationValues(v2 + 2, c2, true, av);
                --j;
            }
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int readAnnotationValues(int v, char[] buf, boolean named, AnnotationVisitor av) {
        block3: {
            i = this.readUnsignedShort(v);
            v += 2;
            if (!named) ** GOTO lbl11
            while (i > 0) {
                v = this.readAnnotationValue(v + 2, buf, this.readUTF8(v, buf), av);
                --i;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                v = this.readAnnotationValue(v, buf, null, av);
                --i;
lbl11:
                // 2 sources

                ** while (i > 0)
            }
        }
        if (av != null) {
            av.visitEnd();
        }
        return v;
    }

    private int readAnnotationValue(int v2, char[] buf, String name2, AnnotationVisitor av) {
        if (av == null) {
            switch (this.b[v2] & 0xFF) {
                case 101: {
                    return v2 + 5;
                }
                case 64: {
                    return this.readAnnotationValues(v2 + 3, buf, true, null);
                }
                case 91: {
                    return this.readAnnotationValues(v2 + 1, buf, false, null);
                }
            }
            return v2 + 3;
        }
        block5 : switch (this.b[v2++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name2, this.readConst(this.readUnsignedShort(v2), buf));
                v2 += 2;
                break;
            }
            case 66: {
                av.visit(name2, (byte)this.readInt(this.items[this.readUnsignedShort(v2)]));
                v2 += 2;
                break;
            }
            case 90: {
                av.visit(name2, this.readInt(this.items[this.readUnsignedShort(v2)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                v2 += 2;
                break;
            }
            case 83: {
                av.visit(name2, (short)this.readInt(this.items[this.readUnsignedShort(v2)]));
                v2 += 2;
                break;
            }
            case 67: {
                av.visit(name2, Character.valueOf((char)this.readInt(this.items[this.readUnsignedShort(v2)])));
                v2 += 2;
                break;
            }
            case 115: {
                av.visit(name2, this.readUTF8(v2, buf));
                v2 += 2;
                break;
            }
            case 101: {
                av.visitEnum(name2, this.readUTF8(v2, buf), this.readUTF8(v2 + 2, buf));
                v2 += 4;
                break;
            }
            case 99: {
                av.visit(name2, Type.getType(this.readUTF8(v2, buf)));
                v2 += 2;
                break;
            }
            case 64: {
                v2 = this.readAnnotationValues(v2 + 2, buf, true, av.visitAnnotation(name2, this.readUTF8(v2, buf)));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v2);
                v2 += 2;
                if (size == 0) {
                    return this.readAnnotationValues(v2 - 2, buf, false, av.visitArray(name2));
                }
                switch (this.b[v2++] & 0xFF) {
                    case 66: {
                        byte[] bv = new byte[size];
                        int i2 = 0;
                        while (i2 < size) {
                            bv[i2] = (byte)this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                            ++i2;
                        }
                        av.visit(name2, bv);
                        --v2;
                        break block5;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        int i3 = 0;
                        while (i3 < size) {
                            zv[i3] = this.readInt(this.items[this.readUnsignedShort(v2)]) != 0;
                            v2 += 3;
                            ++i3;
                        }
                        av.visit(name2, zv);
                        --v2;
                        break block5;
                    }
                    case 83: {
                        short[] sv = new short[size];
                        int i4 = 0;
                        while (i4 < size) {
                            sv[i4] = (short)this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                            ++i4;
                        }
                        av.visit(name2, sv);
                        --v2;
                        break block5;
                    }
                    case 67: {
                        char[] cv = new char[size];
                        int i5 = 0;
                        while (i5 < size) {
                            cv[i5] = (char)this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                            ++i5;
                        }
                        av.visit(name2, cv);
                        --v2;
                        break block5;
                    }
                    case 73: {
                        int[] iv = new int[size];
                        int i6 = 0;
                        while (i6 < size) {
                            iv[i6] = this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                            ++i6;
                        }
                        av.visit(name2, iv);
                        --v2;
                        break block5;
                    }
                    case 74: {
                        long[] lv = new long[size];
                        int i7 = 0;
                        while (i7 < size) {
                            lv[i7] = this.readLong(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                            ++i7;
                        }
                        av.visit(name2, lv);
                        --v2;
                        break block5;
                    }
                    case 70: {
                        float[] fv = new float[size];
                        int i8 = 0;
                        while (i8 < size) {
                            fv[i8] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v2)]));
                            v2 += 3;
                            ++i8;
                        }
                        av.visit(name2, fv);
                        --v2;
                        break block5;
                    }
                    case 68: {
                        double[] dv2 = new double[size];
                        int i9 = 0;
                        while (i9 < size) {
                            dv2[i9] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v2)]));
                            v2 += 3;
                            ++i9;
                        }
                        av.visit(name2, dv2);
                        --v2;
                        break block5;
                    }
                }
                v2 = this.readAnnotationValues(v2 - 3, buf, false, av.visitArray(name2));
            }
        }
        return v2;
    }

    private void getImplicitFrame(Context frame) {
        String desc = frame.desc;
        Object[] locals = frame.local;
        int local = 0;
        if ((frame.access & 8) == 0) {
            locals[local++] = "<init>".equals(frame.name) ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, frame.buffer);
        }
        int i2 = 1;
        block8: while (true) {
            int j = i2;
            switch (desc.charAt(i2++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    locals[local++] = Opcodes.INTEGER;
                    continue block8;
                }
                case 'F': {
                    locals[local++] = Opcodes.FLOAT;
                    continue block8;
                }
                case 'J': {
                    locals[local++] = Opcodes.LONG;
                    continue block8;
                }
                case 'D': {
                    locals[local++] = Opcodes.DOUBLE;
                    continue block8;
                }
                case '[': {
                    while (desc.charAt(i2) == '[') {
                        ++i2;
                    }
                    if (desc.charAt(i2) == 'L') {
                        ++i2;
                        while (desc.charAt(i2) != ';') {
                            ++i2;
                        }
                    }
                    locals[local++] = desc.substring(j, ++i2);
                    continue block8;
                }
                case 'L': {
                    while (desc.charAt(i2) != ';') {
                        ++i2;
                    }
                    locals[local++] = desc.substring(j + 1, i2++);
                    continue block8;
                }
            }
            break;
        }
        frame.localCount = local;
    }

    private int readFrame(int stackMap, boolean zip, boolean unzip, Context frame) {
        int delta;
        int tag;
        char[] c2 = frame.buffer;
        Label[] labels = frame.labels;
        if (zip) {
            tag = this.b[stackMap++] & 0xFF;
        } else {
            tag = 255;
            frame.offset = -1;
        }
        frame.localDiff = 0;
        if (tag < 64) {
            delta = tag;
            frame.mode = 3;
            frame.stackCount = 0;
        } else if (tag < 128) {
            delta = tag - 64;
            stackMap = this.readFrameType(frame.stack, 0, stackMap, c2, labels);
            frame.mode = 4;
            frame.stackCount = 1;
        } else {
            delta = this.readUnsignedShort(stackMap);
            stackMap += 2;
            if (tag == 247) {
                stackMap = this.readFrameType(frame.stack, 0, stackMap, c2, labels);
                frame.mode = 4;
                frame.stackCount = 1;
            } else if (tag >= 248 && tag < 251) {
                frame.mode = 2;
                frame.localDiff = 251 - tag;
                frame.localCount -= frame.localDiff;
                frame.stackCount = 0;
            } else if (tag == 251) {
                frame.mode = 3;
                frame.stackCount = 0;
            } else if (tag < 255) {
                int local = unzip ? frame.localCount : 0;
                int i2 = tag - 251;
                while (i2 > 0) {
                    stackMap = this.readFrameType(frame.local, local++, stackMap, c2, labels);
                    --i2;
                }
                frame.mode = 1;
                frame.localDiff = tag - 251;
                frame.localCount += frame.localDiff;
                frame.stackCount = 0;
            } else {
                frame.mode = 0;
                int n = this.readUnsignedShort(stackMap);
                stackMap += 2;
                frame.localDiff = n;
                frame.localCount = n;
                int local = 0;
                while (n > 0) {
                    stackMap = this.readFrameType(frame.local, local++, stackMap, c2, labels);
                    --n;
                }
                n = this.readUnsignedShort(stackMap);
                stackMap += 2;
                frame.stackCount = n;
                int stack = 0;
                while (n > 0) {
                    stackMap = this.readFrameType(frame.stack, stack++, stackMap, c2, labels);
                    --n;
                }
            }
        }
        frame.offset += delta + 1;
        this.readLabel(frame.offset, labels);
        return stackMap;
    }

    private int readFrameType(Object[] frame, int index2, int v2, char[] buf, Label[] labels) {
        int type = this.b[v2++] & 0xFF;
        switch (type) {
            case 0: {
                frame[index2] = Opcodes.TOP;
                break;
            }
            case 1: {
                frame[index2] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                frame[index2] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                frame[index2] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                frame[index2] = Opcodes.LONG;
                break;
            }
            case 5: {
                frame[index2] = Opcodes.NULL;
                break;
            }
            case 6: {
                frame[index2] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                frame[index2] = this.readClass(v2, buf);
                v2 += 2;
                break;
            }
            default: {
                frame[index2] = this.readLabel(this.readUnsignedShort(v2), labels);
                v2 += 2;
            }
        }
        return v2;
    }

    protected Label readLabel(int offset, Label[] labels) {
        if (labels[offset] == null) {
            labels[offset] = new Label();
        }
        return labels[offset];
    }

    private int getAttributes() {
        int j;
        int u = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        int i2 = this.readUnsignedShort(u);
        while (i2 > 0) {
            j = this.readUnsignedShort(u + 8);
            while (j > 0) {
                u += 6 + this.readInt(u + 12);
                --j;
            }
            u += 8;
            --i2;
        }
        i2 = this.readUnsignedShort(u += 2);
        while (i2 > 0) {
            j = this.readUnsignedShort(u + 8);
            while (j > 0) {
                u += 6 + this.readInt(u + 12);
                --j;
            }
            u += 8;
            --i2;
        }
        return u + 2;
    }

    private Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        int i2 = 0;
        while (i2 < attrs.length) {
            if (attrs[i2].type.equals(type)) {
                return attrs[i2].read(this, off, len, buf, codeOff, labels);
            }
            ++i2;
        }
        return new Attribute(type).read(this, off, len, null, -1, null);
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int readByte(int index2) {
        return this.b[index2] & 0xFF;
    }

    public int readUnsignedShort(int index2) {
        byte[] b2 = this.b;
        return (b2[index2] & 0xFF) << 8 | b2[index2 + 1] & 0xFF;
    }

    public short readShort(int index2) {
        byte[] b2 = this.b;
        return (short)((b2[index2] & 0xFF) << 8 | b2[index2 + 1] & 0xFF);
    }

    public int readInt(int index2) {
        byte[] b2 = this.b;
        return (b2[index2] & 0xFF) << 24 | (b2[index2 + 1] & 0xFF) << 16 | (b2[index2 + 2] & 0xFF) << 8 | b2[index2 + 3] & 0xFF;
    }

    public long readLong(int index2) {
        long l1 = this.readInt(index2);
        long l0 = (long)this.readInt(index2 + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index2, char[] buf) {
        int item = this.readUnsignedShort(index2);
        if (index2 == 0 || item == 0) {
            return null;
        }
        String s2 = this.strings[item];
        if (s2 != null) {
            return s2;
        }
        index2 = this.items[item];
        this.strings[item] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
        return this.strings[item];
    }

    private String readUTF(int index2, int utfLen, char[] buf) {
        int endIndex = index2 + utfLen;
        byte[] b2 = this.b;
        int strLen = 0;
        int st = 0;
        int cc = 0;
        while (index2 < endIndex) {
            int c2 = b2[index2++];
            switch (st) {
                case 0: {
                    if ((c2 &= 0xFF) < 128) {
                        buf[strLen++] = (char)c2;
                        break;
                    }
                    if (c2 < 224 && c2 > 191) {
                        cc = (char)(c2 & 0x1F);
                        st = 1;
                        break;
                    }
                    cc = (char)(c2 & 0xF);
                    st = 2;
                    break;
                }
                case 1: {
                    buf[strLen++] = (char)(cc << 6 | c2 & 0x3F);
                    st = 0;
                    break;
                }
                case 2: {
                    cc = (char)(cc << 6 | c2 & 0x3F);
                    st = 1;
                }
            }
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index2, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index2)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index2 = this.items[item];
        switch (this.b[index2 - 1]) {
            case 3: {
                return this.readInt(index2);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.readInt(index2)));
            }
            case 5: {
                return this.readLong(index2);
            }
            case 6: {
                return Double.longBitsToDouble(this.readLong(index2));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(index2, buf));
            }
            case 8: {
                return this.readUTF8(index2, buf);
            }
            case 16: {
                return Type.getMethodType(this.readUTF8(index2, buf));
            }
        }
        int tag = this.readByte(index2);
        int[] items2 = this.items;
        int cpIndex = items2[this.readUnsignedShort(index2 + 1)];
        String owner = this.readClass(cpIndex, buf);
        cpIndex = items2[this.readUnsignedShort(cpIndex + 2)];
        String name2 = this.readUTF8(cpIndex, buf);
        String desc = this.readUTF8(cpIndex + 2, buf);
        return new Handle(tag, owner, name2, desc);
    }
}

