/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.sisu.bean.BeanBinder;
import org.eclipse.sisu.bean.BeanInjector;
import org.eclipse.sisu.bean.BeanProperties;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.bean.PropertyBinding;

public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type, encounter);
        if (propertyBinder == null) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited = new HashSet<String>();
        for (BeanProperty<Object> property : new BeanProperties(type.getRawType())) {
            String name2;
            if (property.getAnnotation(javax.inject.Inject.class) != null || property.getAnnotation(Inject.class) != null || !visited.add(name2 = property.getName())) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding != null) {
                    bindings.add(binding);
                    continue;
                }
                visited.remove(name2);
            }
            catch (RuntimeException e2) {
                encounter.addError((Throwable)new ProvisionException("Error binding: " + property, (Throwable)e2));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }
}

