/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.Collection;
import java.util.Map;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;

public final class DependencyManagerUtils {
    public static final String CONFIG_PROP_VERBOSE = "aether.dependencyManager.verbose";
    public static final String NODE_DATA_PREMANAGED_VERSION = "premanaged.version";
    public static final String NODE_DATA_PREMANAGED_SCOPE = "premanaged.scope";
    public static final String NODE_DATA_PREMANAGED_OPTIONAL = "premanaged.optional";
    public static final String NODE_DATA_PREMANAGED_EXCLUSIONS = "premanaged.exclusions";
    public static final String NODE_DATA_PREMANAGED_PROPERTIES = "premanaged.properties";

    public static String getPremanagedVersion(DependencyNode node2) {
        if ((node2.getManagedBits() & 1) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node2.getData().get(NODE_DATA_PREMANAGED_VERSION), String.class);
    }

    public static String getPremanagedScope(DependencyNode node2) {
        if ((node2.getManagedBits() & 2) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node2.getData().get(NODE_DATA_PREMANAGED_SCOPE), String.class);
    }

    public static Boolean getPremanagedOptional(DependencyNode node2) {
        if ((node2.getManagedBits() & 4) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node2.getData().get(NODE_DATA_PREMANAGED_OPTIONAL), Boolean.class);
    }

    public static Collection<Exclusion> getPremanagedExclusions(DependencyNode node2) {
        if ((node2.getManagedBits() & 0x10) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node2.getData().get(NODE_DATA_PREMANAGED_EXCLUSIONS), Collection.class);
    }

    public static Map<String, String> getPremanagedProperties(DependencyNode node2) {
        if ((node2.getManagedBits() & 8) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node2.getData().get(NODE_DATA_PREMANAGED_PROPERTIES), Map.class);
    }

    private static <T> T cast(Object obj2, Class<T> type) {
        return type.isInstance(obj2) ? (T)type.cast(obj2) : null;
    }
}

