/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.MetadataTransferException;

public class MetadataNotFoundException
extends MetadataTransferException {
    public MetadataNotFoundException(Metadata metadata, LocalRepository repository) {
        super(metadata, null, "Could not find metadata " + metadata + MetadataNotFoundException.getString(" in ", repository));
    }

    private static String getString(String prefix, LocalRepository repository) {
        if (repository == null) {
            return "";
        }
        return prefix + repository.getId() + " (" + repository.getBasedir() + ")";
    }

    public MetadataNotFoundException(Metadata metadata, RemoteRepository repository) {
        super(metadata, repository, "Could not find metadata " + metadata + MetadataNotFoundException.getString(" in ", repository));
    }

    public MetadataNotFoundException(Metadata metadata, RemoteRepository repository, String message2) {
        super(metadata, repository, message2);
    }

    public MetadataNotFoundException(Metadata metadata, RemoteRepository repository, String message2, boolean fromCache) {
        super(metadata, repository, message2, fromCache);
    }

    public MetadataNotFoundException(Metadata metadata, RemoteRepository repository, String message2, Throwable cause) {
        super(metadata, repository, message2, cause);
    }
}

