/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.CachingArtifactTypeRegistry;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyGraphTransformationContext;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.NodeStack;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultDependencyCollector
implements DependencyCollector,
Service {
    private static final String CONFIG_PROP_MAX_EXCEPTIONS = "aether.dependencyCollector.maxExceptions";
    private static final int CONFIG_PROP_MAX_EXCEPTIONS_DEFAULT = 50;
    private static final String CONFIG_PROP_MAX_CYCLES = "aether.dependencyCollector.maxCycles";
    private static final int CONFIG_PROP_MAX_CYCLES_DEFAULT = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDependencyCollector.class);
    private RemoteRepositoryManager remoteRepositoryManager;
    private ArtifactDescriptorReader descriptorReader;
    private VersionRangeResolver versionRangeResolver;

    public DefaultDependencyCollector() {
    }

    @Inject
    DefaultDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setVersionRangeResolver(versionRangeResolver);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
    }

    public DefaultDependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultDependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.descriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DefaultDependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session2, CollectRequest request) throws DependencyCollectionException {
        DefaultDependencyNode node2;
        session2 = DefaultDependencyCollector.optimizeSession(session2);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        CollectResult result2 = new CollectResult(request);
        DependencySelector depSelector = session2.getDependencySelector();
        DependencyManager depManager = session2.getDependencyManager();
        DependencyTraverser depTraverser = session2.getDependencyTraverser();
        VersionFilter verFilter = session2.getVersionFilter();
        Dependency root2 = request.getRoot();
        List<RemoteRepository> repositories = request.getRepositories();
        List<Dependency> dependencies = request.getDependencies();
        List<Dependency> managedDependencies = request.getManagedDependencies();
        LinkedHashMap<String, Long> stats = new LinkedHashMap<String, Long>();
        long time1 = System.nanoTime();
        if (root2 != null) {
            ArtifactDescriptorResult descriptorResult;
            List<? extends Version> versions;
            VersionRangeResult rangeResult;
            try {
                VersionRangeRequest rangeRequest = new VersionRangeRequest(root2.getArtifact(), request.getRepositories(), request.getRequestContext());
                rangeRequest.setTrace(trace);
                rangeResult = this.versionRangeResolver.resolveVersionRange(session2, rangeRequest);
                versions = DefaultDependencyCollector.filterVersions(root2, rangeResult, verFilter, new DefaultVersionFilterContext(session2));
            }
            catch (VersionRangeResolutionException e2) {
                result2.addException(e2);
                throw new DependencyCollectionException(result2, e2.getMessage());
            }
            Version version = versions.get(versions.size() - 1);
            root2 = root2.setArtifact(root2.getArtifact().setVersion(version.toString()));
            try {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(root2.getArtifact());
                descriptorRequest.setRepositories(request.getRepositories());
                descriptorRequest.setRequestContext(request.getRequestContext());
                descriptorRequest.setTrace(trace);
                descriptorResult = DefaultDependencyCollector.isLackingDescriptor(root2.getArtifact()) ? new ArtifactDescriptorResult(descriptorRequest) : this.descriptorReader.readArtifactDescriptor(session2, descriptorRequest);
            }
            catch (ArtifactDescriptorException e3) {
                result2.addException(e3);
                throw new DependencyCollectionException(result2, e3.getMessage());
            }
            root2 = root2.setArtifact(descriptorResult.getArtifact());
            if (!session2.isIgnoreArtifactDescriptorRepositories()) {
                repositories = this.remoteRepositoryManager.aggregateRepositories(session2, repositories, descriptorResult.getRepositories(), true);
            }
            dependencies = this.mergeDeps(dependencies, descriptorResult.getDependencies());
            managedDependencies = this.mergeDeps(managedDependencies, descriptorResult.getManagedDependencies());
            node2 = new DefaultDependencyNode(root2);
            node2.setRequestContext(request.getRequestContext());
            node2.setRelocations(descriptorResult.getRelocations());
            node2.setVersionConstraint(rangeResult.getVersionConstraint());
            node2.setVersion(version);
            node2.setAliases(descriptorResult.getAliases());
            node2.setRepositories(request.getRepositories());
        } else {
            node2 = new DefaultDependencyNode(request.getRootArtifact());
            node2.setRequestContext(request.getRequestContext());
            node2.setRepositories(request.getRepositories());
        }
        result2.setRoot(node2);
        boolean traverse2 = root2 == null || depTraverser == null || depTraverser.traverseDependency(root2);
        String errorPath = null;
        if (traverse2 && !dependencies.isEmpty()) {
            DataPool pool = new DataPool(session2);
            NodeStack nodes = new NodeStack();
            nodes.push(node2);
            DefaultDependencyCollectionContext context = new DefaultDependencyCollectionContext(session2, request.getRootArtifact(), root2, managedDependencies);
            DefaultVersionFilterContext versionContext = new DefaultVersionFilterContext(session2);
            Args args2 = new Args(session2, trace, pool, nodes, context, versionContext, request);
            Results results2 = new Results(result2, session2);
            this.process(args2, results2, dependencies, repositories, depSelector != null ? depSelector.deriveChildSelector(context) : null, depManager != null ? depManager.deriveChildManager(context) : null, depTraverser != null ? depTraverser.deriveChildTraverser(context) : null, verFilter != null ? verFilter.deriveChildFilter(context) : null);
            errorPath = results2.errorPath;
        }
        long time2 = System.nanoTime();
        DependencyGraphTransformer transformer = session2.getDependencyGraphTransformer();
        if (transformer != null) {
            try {
                DefaultDependencyGraphTransformationContext context = new DefaultDependencyGraphTransformationContext(session2);
                context.put(TransformationContextKeys.STATS, stats);
                result2.setRoot(transformer.transformGraph(node2, context));
            }
            catch (RepositoryException e4) {
                result2.addException(e4);
            }
        }
        long time3 = System.nanoTime();
        stats.put("DefaultDependencyCollector.collectTime", time2 - time1);
        stats.put("DefaultDependencyCollector.transformTime", time3 - time2);
        LOGGER.debug("Dependency collection stats {}", stats);
        if (errorPath != null) {
            throw new DependencyCollectionException(result2, "Failed to collect dependencies at " + errorPath);
        }
        if (!result2.getExceptions().isEmpty()) {
            throw new DependencyCollectionException(result2);
        }
        return result2;
    }

    private static RepositorySystemSession optimizeSession(RepositorySystemSession session2) {
        DefaultRepositorySystemSession optimized = new DefaultRepositorySystemSession(session2);
        optimized.setArtifactTypeRegistry(CachingArtifactTypeRegistry.newInstance(session2));
        return optimized;
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result2;
        if (dominant == null || dominant.isEmpty()) {
            result2 = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result2 = dominant;
        } else {
            int initialCapacity = dominant.size() + recessive.size();
            result2 = new ArrayList<Dependency>(initialCapacity);
            HashSet<String> ids = new HashSet<String>(initialCapacity, 1.0f);
            for (Dependency dependency : dominant) {
                ids.add(DefaultDependencyCollector.getId(dependency.getArtifact()));
                result2.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(DefaultDependencyCollector.getId(dependency.getArtifact()))) continue;
                result2.add(dependency);
            }
        }
        return result2;
    }

    private static String getId(Artifact a) {
        return a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getClassifier() + ':' + a.getExtension();
    }

    private void process(Args args2, Results results2, List<Dependency> dependencies, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter) {
        for (Dependency dependency : dependencies) {
            this.processDependency(args2, results2, repositories, depSelector, depManager, depTraverser, verFilter, dependency);
        }
    }

    private void processDependency(Args args2, Results results2, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency) {
        List<Artifact> relocations = Collections.emptyList();
        boolean disableVersionManagement = false;
        this.processDependency(args2, results2, repositories, depSelector, depManager, depTraverser, verFilter, dependency, relocations, disableVersionManagement);
    }

    private void processDependency(Args args2, Results results2, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency, List<Artifact> relocations, boolean disableVersionManagement) {
        List<? extends Version> versions;
        VersionRangeResult rangeResult;
        if (depSelector != null && !depSelector.selectDependency(dependency)) {
            return;
        }
        PremanagedDependency preManaged = PremanagedDependency.create(depManager, dependency, disableVersionManagement, args2.premanagedState);
        dependency = preManaged.managedDependency;
        boolean noDescriptor = DefaultDependencyCollector.isLackingDescriptor(dependency.getArtifact());
        boolean traverse2 = !noDescriptor && (depTraverser == null || depTraverser.traverseDependency(dependency));
        try {
            VersionRangeRequest rangeRequest = DefaultDependencyCollector.createVersionRangeRequest(args2, repositories, dependency);
            rangeResult = this.cachedResolveRangeResult(rangeRequest, args2.pool, args2.session);
            versions = DefaultDependencyCollector.filterVersions(dependency, rangeResult, verFilter, args2.versionContext);
        }
        catch (VersionRangeResolutionException e2) {
            results2.addException(dependency, e2, args2.nodes);
            return;
        }
        for (Version version : versions) {
            ArtifactDescriptorRequest descriptorRequest;
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d2 = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = this.getArtifactDescriptorResult(args2, results2, noDescriptor, d2, descriptorRequest = DefaultDependencyCollector.createArtifactDescriptorRequest(args2, repositories, d2));
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                d2 = d2.setArtifact(descriptorResult.getArtifact());
                DependencyNode node2 = args2.nodes.top();
                int cycleEntry = args2.nodes.find(d2.getArtifact());
                if (cycleEntry >= 0) {
                    results2.addCycle(args2.nodes, cycleEntry, d2);
                    DependencyNode cycleNode = args2.nodes.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = DefaultDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d2, descriptorResult, cycleNode);
                        node2.getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d2.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d2.getArtifact().getArtifactId());
                    this.processDependency(args2, results2, repositories, depSelector, depManager, depTraverser, verFilter, d2, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    return;
                }
                d2 = args2.pool.intern(d2.setArtifact(args2.pool.intern(d2.getArtifact())));
                List<RemoteRepository> repos = DefaultDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
                child = DefaultDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d2, descriptorResult.getAliases(), repos, args2.request.getRequestContext());
                node2.getChildren().add(child);
                boolean recurse = traverse2 && !descriptorResult.getDependencies().isEmpty();
                if (!recurse) continue;
                this.doRecurse(args2, results2, repositories, depSelector, depManager, depTraverser, verFilter, d2, descriptorResult, child);
                continue;
            }
            DependencyNode node2 = args2.nodes.top();
            List<RemoteRepository> repos = DefaultDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
            DefaultDependencyNode child = DefaultDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d2, null, repos, args2.request.getRequestContext());
            node2.getChildren().add(child);
        }
    }

    private void doRecurse(Args args2, Results results2, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency d2, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child) {
        DefaultDependencyCollectionContext context = args2.collectionContext;
        context.set(d2, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = depSelector != null ? depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = depManager != null ? depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = depTraverser != null ? depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = verFilter != null ? verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args2.ignoreRepos ? repositories : this.remoteRepositoryManager.aggregateRepositories(args2.session, repositories, descriptorResult.getRepositories(), true);
        Object key2 = args2.pool.toKey(d2.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children2 = args2.pool.getChildren(key2);
        if (children2 == null) {
            args2.pool.putChildren(key2, child.getChildren());
            args2.nodes.push(child);
            this.process(args2, results2, descriptorResult.getDependencies(), childRepos, childSelector, childManager, childTraverser, childFilter);
            args2.nodes.pop();
        } else {
            child.setChildren(children2);
        }
    }

    private ArtifactDescriptorResult getArtifactDescriptorResult(Args args2, Results results2, boolean noDescriptor, Dependency d2, ArtifactDescriptorRequest descriptorRequest) {
        return noDescriptor ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args2.pool, descriptorRequest, args2.session, d2, results2, args2);
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session2, Dependency d2, Results results2, Args args2) {
        Object key2 = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key2, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session2, descriptorRequest);
                pool.putDescriptor(key2, descriptorResult);
            }
            catch (ArtifactDescriptorException e2) {
                results2.addException(d2, e2, args2.nodes);
                pool.putDescriptor(key2, e2);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    private static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d2, Collection<Artifact> aliases, List<RemoteRepository> repos, String requestContext) {
        DefaultDependencyNode child = new DefaultDependencyNode(d2);
        preManaged.applyTo(child);
        child.setRelocations(relocations);
        child.setVersionConstraint(rangeResult.getVersionConstraint());
        child.setVersion(version);
        child.setAliases(aliases);
        child.setRepositories(repos);
        child.setRequestContext(requestContext);
        return child;
    }

    private static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d2, ArtifactDescriptorResult descriptorResult, DependencyNode cycleNode) {
        DefaultDependencyNode child = DefaultDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d2, descriptorResult.getAliases(), cycleNode.getRepositories(), cycleNode.getRequestContext());
        child.setChildren(cycleNode.getChildren());
        return child;
    }

    private static ArtifactDescriptorRequest createArtifactDescriptorRequest(Args args2, List<RemoteRepository> repositories, Dependency d2) {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(d2.getArtifact());
        descriptorRequest.setRepositories(repositories);
        descriptorRequest.setRequestContext(args2.request.getRequestContext());
        descriptorRequest.setTrace(args2.trace);
        return descriptorRequest;
    }

    private static VersionRangeRequest createVersionRangeRequest(Args args2, List<RemoteRepository> repositories, Dependency dependency) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(dependency.getArtifact());
        rangeRequest.setRepositories(repositories);
        rangeRequest.setRequestContext(args2.request.getRequestContext());
        rangeRequest.setTrace(args2.trace);
        return rangeRequest;
    }

    private VersionRangeResult cachedResolveRangeResult(VersionRangeRequest rangeRequest, DataPool pool, RepositorySystemSession session2) throws VersionRangeResolutionException {
        Object key2 = pool.toKey(rangeRequest);
        VersionRangeResult rangeResult = pool.getConstraint(key2, rangeRequest);
        if (rangeResult == null) {
            rangeResult = this.versionRangeResolver.resolveVersionRange(session2, rangeRequest);
            pool.putConstraint(key2, rangeResult);
        }
        return rangeResult;
    }

    private static boolean isLackingDescriptor(Artifact artifact) {
        return artifact.getProperty("localPath", null) != null;
    }

    private static List<RemoteRepository> getRemoteRepositories(ArtifactRepository repository, List<RemoteRepository> repositories) {
        if (repository instanceof RemoteRepository) {
            return Collections.singletonList((RemoteRepository)repository);
        }
        if (repository != null) {
            return Collections.emptyList();
        }
        return repositories;
    }

    private static List<? extends Version> filterVersions(Dependency dependency, VersionRangeResult rangeResult, VersionFilter verFilter, DefaultVersionFilterContext verContext) throws VersionRangeResolutionException {
        List<Version> versions;
        if (rangeResult.getVersions().isEmpty()) {
            throw new VersionRangeResolutionException(rangeResult, "No versions available for " + dependency.getArtifact() + " within specified range");
        }
        if (verFilter != null && rangeResult.getVersionConstraint().getRange() != null) {
            verContext.set(dependency, rangeResult);
            try {
                verFilter.filterVersions(verContext);
            }
            catch (RepositoryException e2) {
                throw new VersionRangeResolutionException(rangeResult, "Failed to filter versions for " + dependency.getArtifact() + ": " + e2.getMessage(), e2);
            }
            versions = verContext.get();
            if (versions.isEmpty()) {
                throw new VersionRangeResolutionException(rangeResult, "No acceptable versions for " + dependency.getArtifact() + ": " + rangeResult.getVersions());
            }
        } else {
            versions = rangeResult.getVersions();
        }
        return versions;
    }

    static class PremanagedDependency {
        final String premanagedVersion;
        final String premanagedScope;
        final Boolean premanagedOptional;
        final Collection<Exclusion> premanagedExclusions;
        final Map<String, String> premanagedProperties;
        final int managedBits;
        final Dependency managedDependency;
        final boolean premanagedState;

        PremanagedDependency(String premanagedVersion, String premanagedScope, Boolean premanagedOptional, Collection<Exclusion> premanagedExclusions, Map<String, String> premanagedProperties, int managedBits, Dependency managedDependency, boolean premanagedState) {
            this.premanagedVersion = premanagedVersion;
            this.premanagedScope = premanagedScope;
            this.premanagedOptional = premanagedOptional;
            this.premanagedExclusions = premanagedExclusions != null ? Collections.unmodifiableCollection(new ArrayList<Exclusion>(premanagedExclusions)) : null;
            this.premanagedProperties = premanagedProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(premanagedProperties)) : null;
            this.managedBits = managedBits;
            this.managedDependency = managedDependency;
            this.premanagedState = premanagedState;
        }

        static PremanagedDependency create(DependencyManager depManager, Dependency dependency, boolean disableVersionManagement, boolean premanagedState) {
            DependencyManagement depMngt = depManager != null ? depManager.manageDependency(dependency) : null;
            int managedBits = 0;
            String premanagedVersion = null;
            String premanagedScope = null;
            Boolean premanagedOptional = null;
            Collection<Exclusion> premanagedExclusions = null;
            Map<String, String> premanagedProperties = null;
            if (depMngt != null) {
                Artifact artifact;
                if (depMngt.getVersion() != null && !disableVersionManagement) {
                    artifact = dependency.getArtifact();
                    premanagedVersion = artifact.getVersion();
                    dependency = dependency.setArtifact(artifact.setVersion(depMngt.getVersion()));
                    managedBits |= 1;
                }
                if (depMngt.getProperties() != null) {
                    artifact = dependency.getArtifact();
                    premanagedProperties = artifact.getProperties();
                    dependency = dependency.setArtifact(artifact.setProperties(depMngt.getProperties()));
                    managedBits |= 8;
                }
                if (depMngt.getScope() != null) {
                    premanagedScope = dependency.getScope();
                    dependency = dependency.setScope(depMngt.getScope());
                    managedBits |= 2;
                }
                if (depMngt.getOptional() != null) {
                    premanagedOptional = dependency.isOptional();
                    dependency = dependency.setOptional(depMngt.getOptional());
                    managedBits |= 4;
                }
                if (depMngt.getExclusions() != null) {
                    premanagedExclusions = dependency.getExclusions();
                    dependency = dependency.setExclusions(depMngt.getExclusions());
                    managedBits |= 0x10;
                }
            }
            return new PremanagedDependency(premanagedVersion, premanagedScope, premanagedOptional, premanagedExclusions, premanagedProperties, managedBits, dependency, premanagedState);
        }

        public void applyTo(DefaultDependencyNode child) {
            child.setManagedBits(this.managedBits);
            if (this.premanagedState) {
                child.setData("premanaged.version", this.premanagedVersion);
                child.setData("premanaged.scope", this.premanagedScope);
                child.setData("premanaged.optional", this.premanagedOptional);
                child.setData("premanaged.exclusions", this.premanagedExclusions);
                child.setData("premanaged.properties", this.premanagedProperties);
            }
        }
    }

    static class Results {
        private final CollectResult result;
        final int maxExceptions;
        final int maxCycles;
        String errorPath;

        Results(CollectResult result2, RepositorySystemSession session2) {
            this.result = result2;
            this.maxExceptions = ConfigUtils.getInteger(session2, 50, DefaultDependencyCollector.CONFIG_PROP_MAX_EXCEPTIONS);
            this.maxCycles = ConfigUtils.getInteger(session2, 10, DefaultDependencyCollector.CONFIG_PROP_MAX_CYCLES);
        }

        public void addException(Dependency dependency, Exception e2, NodeStack nodes) {
            if (this.maxExceptions < 0 || this.result.getExceptions().size() < this.maxExceptions) {
                this.result.addException(e2);
                if (this.errorPath == null) {
                    StringBuilder buffer = new StringBuilder(256);
                    for (int i2 = 0; i2 < nodes.size(); ++i2) {
                        Dependency dep;
                        if (buffer.length() > 0) {
                            buffer.append(" -> ");
                        }
                        if ((dep = nodes.get(i2).getDependency()) == null) continue;
                        buffer.append(dep.getArtifact());
                    }
                    if (buffer.length() > 0) {
                        buffer.append(" -> ");
                    }
                    buffer.append(dependency.getArtifact());
                    this.errorPath = buffer.toString();
                }
            }
        }

        public void addCycle(NodeStack nodes, int cycleEntry, Dependency dependency) {
            if (this.maxCycles < 0 || this.result.getCycles().size() < this.maxCycles) {
                this.result.addCycle(new DefaultDependencyCycle(nodes, cycleEntry, dependency));
            }
        }
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final RequestTrace trace;
        final DataPool pool;
        final NodeStack nodes;
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;

        Args(RepositorySystemSession session2, RequestTrace trace, DataPool pool, NodeStack nodes, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request) {
            this.session = session2;
            this.request = request;
            this.ignoreRepos = session2.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session2, false, "aether.dependencyManager.verbose");
            this.trace = trace;
            this.pool = pool;
            this.nodes = nodes;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
        }
    }
}

