/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryConnectorProvider.class);
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();

    public DefaultRepositoryConnectorProvider() {
    }

    @Inject
    DefaultRepositoryConnectorProvider(Set<RepositoryConnectorFactory> connectorFactories) {
        this.setRepositoryConnectorFactories(connectorFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRepositoryConnectorProvider addRepositoryConnectorFactory(RepositoryConnectorFactory factory) {
        this.connectorFactories.add(Objects.requireNonNull(factory, "repository connector factory cannot be null"));
        return this;
    }

    public DefaultRepositoryConnectorProvider setRepositoryConnectorFactories(Collection<RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<RepositoryConnectorFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session2, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<RepositoryConnectorFactory> factories = new PrioritizedComponents<RepositoryConnectorFactory>(session2);
        for (RepositoryConnectorFactory repositoryConnectorFactory : this.connectorFactories) {
            factories.add(repositoryConnectorFactory, repositoryConnectorFactory.getPriority());
        }
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent prioritizedComponent : factories.getEnabled()) {
            try {
                RepositoryConnector connector = ((RepositoryConnectorFactory)prioritizedComponent.getComponent()).newInstance(session2, repository);
                if (LOGGER.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(connector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, connector);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                return connector;
            }
            catch (NoRepositoryConnectorException e2) {
                errors.add(e2);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain connector factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No connector factories available");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getUrl());
            stringBuilder.append(" with type ").append(repository.getContentType());
            stringBuilder.append(" using the available connector factories: ");
            factories.list(stringBuilder);
        }
        throw new NoRepositoryConnectorException(repository, stringBuilder.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)errors.get(0) : null);
    }
}

