/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;

@Named
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    private static final String CONFIG_PROP_SNAPSHOT_NORMALIZATION = "aether.artifactResolver.snapshotNormalization";
    private static final Logger LOGGER = org.slf4j.LoggerFactory.getLogger(DefaultArtifactResolver.class);
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private VersionResolver versionResolver;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultArtifactResolver() {
    }

    @Inject
    DefaultArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setVersionResolver(versionResolver);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    @Deprecated
    public DefaultArtifactResolver setLoggerFactory(LoggerFactory loggerFactory) {
        return this;
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultArtifactResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session2, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session2, Collections.singleton(request)).get(0);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);){
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
            for (ArtifactRequest artifactRequest : requests) {
                if (artifactRequest.getArtifact().getProperty("localPath", null) != null) continue;
                artifacts.add(artifactRequest.getArtifact());
            }
            syncContext.acquire(artifacts, null);
            List<ArtifactResult> list = this.resolve(session2, requests);
            return list;
        }
    }

    private List<ArtifactResult> resolve(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results2 = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        WorkspaceReader workspace = session2.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups2 = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file;
            VersionResult versionResult;
            RequestTrace trace = RequestTrace.newChild(artifactRequest.getTrace(), artifactRequest);
            ArtifactResult result2 = new ArtifactResult(artifactRequest);
            results2.add(result2);
            Artifact artifact = artifactRequest.getArtifact();
            List<RemoteRepository> repos = artifactRequest.getRepositories();
            this.artifactResolving(session2, trace, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file2 = new File(localPath);
                if (!file2.isFile()) {
                    failures = true;
                    result2.addException(new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file2);
                result2.setArtifact(artifact);
                this.artifactResolved(session2, trace, artifact, null, result2.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, repos, artifactRequest.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
            }
            catch (VersionResolutionException e2) {
                result2.addException(e2);
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file);
                result2.setArtifact(artifact);
                result2.setRepository(workspace.getRepository());
                this.artifactResolved(session2, trace, artifact, result2.getRepository(), null);
                continue;
            }
            LocalArtifactResult local = lrm.find(session2, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (this.isLocallyInstalled(local, versionResult)) {
                if (local.getRepository() != null) {
                    result2.setRepository(local.getRepository());
                } else {
                    result2.setRepository(lrm.getRepository());
                }
                try {
                    artifact = artifact.setFile(this.getFile(session2, artifact, local.getFile()));
                    result2.setArtifact(artifact);
                    this.artifactResolved(session2, trace, artifact, result2.getRepository(), null);
                }
                catch (ArtifactTransferException e3) {
                    result2.addException(e3);
                }
                if (local.isAvailable()) continue;
                lrm.add(session2, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local.getFile() != null) {
                LOGGER.debug("Verifying availability of {} from {}", (Object)local.getFile(), repos);
            }
            LOGGER.debug("Resolving artifact {} from {}", (Object)artifact, repos);
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups2.iterator();
            for (RemoteRepository repo : repos) {
                if (!repo.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                try {
                    Utils.checkOffline(session2, this.offlineController, repo);
                }
                catch (RepositoryOfflineException e4) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, repo, "Cannot access " + repo.getId() + " (" + repo.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", e4);
                    result2.addException(exception);
                    continue;
                }
                ResolutionGroup group2 = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(repo)) continue;
                    group2 = t;
                    break;
                }
                if (group2 == null) {
                    group2 = new ResolutionGroup(repo);
                    groups2.add(group2);
                    groupIt = Collections.emptyList().iterator();
                }
                group2.items.add(new ResolutionItem(trace, artifact, resolved, result2, local, repo));
            }
        }
        for (ResolutionGroup resolutionGroup : groups2) {
            this.performDownloads(session2, resolutionGroup);
        }
        for (ArtifactResult artifactResult : results2) {
            ArtifactRequest request = artifactResult.getRequest();
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), null);
                artifactResult.addException(exception);
            }
            RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
            this.artifactResolved(session2, trace, request.getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results2);
        }
        return results2;
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getFile() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            if (vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private File getFile(RepositorySystemSession session2, Artifact artifact, File file) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean(session2, true, CONFIG_PROP_SNAPSHOT_NORMALIZATION)) {
            boolean copy;
            String name2 = file.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file.getParent(), name2);
            boolean bl = copy = dst.length() != file.length() || dst.lastModified() != file.lastModified();
            if (copy) {
                try {
                    this.fileProcessor.copy(file, dst);
                    dst.setLastModified(file.lastModified());
                }
                catch (IOException e2) {
                    throw new ArtifactTransferException(artifact, null, e2);
                }
            }
            file = dst;
        }
        return file;
    }

    private void performDownloads(RepositorySystemSession session2, ResolutionGroup group2) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session2, group2);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download : downloads) {
            this.artifactDownloading(session2, download.getTrace(), download.getArtifact(), group2.repository);
        }
        try {
            RemoteRepository repo = group2.repository;
            if (repo.isBlocked()) {
                if (repo.getMirroredRepositories().isEmpty()) {
                    throw new NoRepositoryConnectorException(repo, "Blocked repository: " + repo);
                }
                throw new NoRepositoryConnectorException(repo, "Blocked mirror for repositories: " + repo.getMirroredRepositories());
            }
            try (RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session2, group2.repository);){
                connector.get(downloads, null);
            }
        }
        catch (NoRepositoryConnectorException e2) {
            for (ArtifactDownload download : downloads) {
                download.setException(new ArtifactTransferException(download.getArtifact(), group2.repository, e2));
            }
        }
        this.evaluateDownloads(session2, group2);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session2, ResolutionGroup group2) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group2.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRequestContext(item.request.getRequestContext());
            download.setListener(SafeTransferListener.wrap(session2));
            download.setTrace(item.trace);
            if (item.local.getFile() != null) {
                download.setFile(item.local.getFile());
                download.setExistenceCheck(true);
            } else {
                String path = lrm.getPathForRemoteArtifact(artifact, group2.repository, item.request.getRequestContext());
                download.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
            boolean snapshot = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session2, group2.repository, !snapshot, snapshot);
            int errorPolicy = Utils.getPolicy(session2, artifact, group2.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check = new UpdateCheck<Artifact, ArtifactTransferException>();
                check.setItem(artifact);
                check.setFile(download.getFile());
                check.setFileValid(false);
                check.setRepository(group2.repository);
                check.setPolicy(policy.getUpdatePolicy());
                item.updateCheck = check;
                this.updateCheckManager.checkArtifact(session2, check);
                if (!check.isRequired()) {
                    item.result.addException(check.getException());
                    continue;
                }
            }
            download.setChecksumPolicy(policy.getChecksumPolicy());
            download.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download);
            item.download = download;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session2, ResolutionGroup group2) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        for (ResolutionItem item : group2.items) {
            ArtifactDownload download = item.download;
            if (download == null) continue;
            Artifact artifact = download.getArtifact();
            if (download.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository(group2.repository);
                try {
                    artifact = artifact.setFile(this.getFile(session2, artifact, download.getFile()));
                    item.result.setArtifact(artifact);
                    lrm.add(session2, new LocalArtifactRegistration(artifact, group2.repository, download.getSupportedContexts()));
                }
                catch (ArtifactTransferException e2) {
                    download.setException(e2);
                    item.result.addException(e2);
                }
            } else {
                item.result.addException(download.getException());
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download.getException());
                this.updateCheckManager.touchArtifact(session2, item.updateCheck);
            }
            this.artifactDownloaded(session2, download.getTrace(), artifact, group2.repository, download.getException());
            if (download.getException() != null) continue;
            this.artifactResolved(session2, download.getTrace(), artifact, group2.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session2, RequestTrace trace, Artifact artifact) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactResolved(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions(exceptions);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloading(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloaded(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setException(exception);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace, Artifact artifact, AtomicBoolean resolved, ArtifactResult result2, LocalArtifactResult local, RemoteRepository repository) {
            this.trace = trace;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result2;
            this.request = result2.getRequest();
            this.local = local;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

