/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorReaderDelegate;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.repository.internal.DefaultModelCache;
import org.apache.maven.repository.internal.DefaultModelResolver;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.ArtifactNotFoundException;

@Named
@Singleton
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    private RemoteRepositoryManager remoteRepositoryManager;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private ModelBuilder modelBuilder;

    public DefaultArtifactDescriptorReader() {
    }

    @Inject
    DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "versionResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "versionRangeResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifactResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder cannot be null");
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session2, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result2 = new ArtifactDescriptorResult(request);
        Model model2 = this.loadPom(session2, request, result2);
        if (model2 != null) {
            Map<String, Object> config = session2.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = new ArtifactDescriptorReaderDelegate();
            }
            delegate.populateResult(session2, result2, model2);
        }
        return result2;
    }

    private Model loadPom(RepositorySystemSession session2, ArtifactDescriptorRequest request, ArtifactDescriptorResult result2) throws ArtifactDescriptorException {
        Model model2;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Artifact a = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e2) {
                result2.addException(e2);
                throw new ArtifactDescriptorException(result2);
            }
            if (!visited.add(a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session2, trace, a, exception);
                if ((this.getPolicy(session2, a, request) & 2) != 0) {
                    return null;
                }
                result2.addException(exception);
                throw new ArtifactDescriptorException(result2);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session2, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result2.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e3) {
                if (e3.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session2, trace, a, (Exception)e3.getCause());
                    if ((this.getPolicy(session2, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result2.addException(e3);
                throw new ArtifactDescriptorException(result2);
            }
            WorkspaceReader workspace = session2.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model2 = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model2;
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session2.getUserProperties(), session2.getSystemProperties()));
                modelRequest.setUserProperties(new Properties());
                modelRequest.setModelCache(DefaultModelCache.newInstance(session2));
                modelRequest.setModelResolver(new DefaultModelResolver(session2, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model2 = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e4) {
                for (ModelProblem problem : e4.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result2.addException(problem.getException());
                    throw new ArtifactDescriptorException(result2);
                }
                this.invalidDescriptor(session2, trace, a, e4);
                if ((this.getPolicy(session2, a, request) & 2) != 0) {
                    return null;
                }
                result2.addException(e4);
                throw new ArtifactDescriptorException(result2);
            }
            Relocation relocation = this.getRelocation(model2);
            if (relocation == null) break;
            result2.addRelocation(a);
            a = new RelocatedArtifact(a, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion(), relocation.getMessage());
            result2.setArtifact(a);
        }
        return model2;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model2) {
        Relocation relocation = null;
        DistributionManagement distMgmt = model2.getDistributionManagement();
        if (distMgmt != null) {
            relocation = distMgmt.getRelocation();
        }
        return relocation;
    }

    private void missingDescriptor(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session2, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session2.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session2, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

