/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.profile.ProfileInjector;

@Named
@Singleton
public class DefaultProfileInjector
implements ProfileInjector {
    private ProfileModelMerger merger = new ProfileModelMerger();

    @Override
    public void injectProfile(Model model2, Profile profile2, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (profile2 != null) {
            this.merger.mergeModelBase(model2, profile2);
            if (profile2.getBuild() != null) {
                if (model2.getBuild() == null) {
                    model2.setBuild(new Build());
                }
                this.merger.mergeBuildBase(model2.getBuild(), profile2.getBuild());
            }
        }
    }

    protected static class ProfileModelMerger
    extends MavenModelMerger {
        protected ProfileModelMerger() {
        }

        public void mergeModelBase(ModelBase target2, ModelBase source) {
            this.mergeModelBase(target2, source, true, Collections.emptyMap());
        }

        public void mergeBuildBase(BuildBase target2, BuildBase source) {
            this.mergeBuildBase(target2, source, true, Collections.emptyMap());
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer target2, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List<Plugin> src2 = source.getPlugins();
            if (!src2.isEmpty()) {
                List<Plugin> tgt = target2.getPlugins();
                LinkedHashMap<Iterator<Plugin>, Plugin> master = new LinkedHashMap<Iterator<Plugin>, Plugin>(tgt.size() * 2);
                for (Plugin element2 : tgt) {
                    Iterator<Plugin> key2 = this.getPluginKey(element2);
                    master.put(key2, element2);
                }
                LinkedHashMap predecessors = new LinkedHashMap();
                ArrayList<Plugin> pending = new ArrayList<Plugin>();
                for (Plugin element3 : src2) {
                    Object key3 = this.getPluginKey(element3);
                    Plugin existing = (Plugin)master.get(key3);
                    if (existing != null) {
                        this.mergePlugin(existing, element3, sourceDominant, context);
                        if (pending.isEmpty()) continue;
                        predecessors.put(key3, pending);
                        pending = new ArrayList();
                        continue;
                    }
                    pending.add(element3);
                }
                ArrayList<Plugin> result2 = new ArrayList<Plugin>(src2.size() + tgt.size());
                for (Map.Entry entry : master.entrySet()) {
                    List pre = (List)predecessors.get(entry.getKey());
                    if (pre != null) {
                        result2.addAll(pre);
                    }
                    result2.add((Plugin)entry.getValue());
                }
                result2.addAll(pending);
                target2.setPlugins(result2);
            }
        }

        @Override
        protected void mergePlugin_Executions(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            List<PluginExecution> src2 = source.getExecutions();
            if (!src2.isEmpty()) {
                Object key2;
                List<PluginExecution> tgt = target2.getExecutions();
                LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src2.size() + tgt.size()) * 2);
                for (PluginExecution element2 : tgt) {
                    key2 = this.getPluginExecutionKey(element2);
                    merged.put(key2, element2);
                }
                for (PluginExecution element2 : src2) {
                    key2 = this.getPluginExecutionKey(element2);
                    PluginExecution existing = (PluginExecution)merged.get(key2);
                    if (existing != null) {
                        this.mergePluginExecution(existing, element2, sourceDominant, context);
                        continue;
                    }
                    merged.put(key2, element2);
                }
                target2.setExecutions(new ArrayList<PluginExecution>(merged.values()));
            }
        }

        @Override
        protected void mergeReporting_Plugins(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List<ReportPlugin> src2 = source.getPlugins();
            if (!src2.isEmpty()) {
                Object key2;
                List<ReportPlugin> tgt = target2.getPlugins();
                LinkedHashMap<Object, ReportPlugin> merged = new LinkedHashMap<Object, ReportPlugin>((src2.size() + tgt.size()) * 2);
                for (ReportPlugin element2 : tgt) {
                    key2 = this.getReportPluginKey(element2);
                    merged.put(key2, element2);
                }
                for (ReportPlugin element2 : src2) {
                    key2 = this.getReportPluginKey(element2);
                    ReportPlugin existing = (ReportPlugin)merged.get(key2);
                    if (existing == null) {
                        merged.put(key2, element2);
                        continue;
                    }
                    this.mergeReportPlugin(existing, element2, sourceDominant, context);
                }
                target2.setPlugins(new ArrayList<ReportPlugin>(merged.values()));
            }
        }

        @Override
        protected void mergeReportPlugin_ReportSets(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
            List<ReportSet> src2 = source.getReportSets();
            if (!src2.isEmpty()) {
                Object key2;
                List<ReportSet> tgt = target2.getReportSets();
                LinkedHashMap<Object, ReportSet> merged = new LinkedHashMap<Object, ReportSet>((src2.size() + tgt.size()) * 2);
                for (ReportSet element2 : tgt) {
                    key2 = this.getReportSetKey(element2);
                    merged.put(key2, element2);
                }
                for (ReportSet element2 : src2) {
                    key2 = this.getReportSetKey(element2);
                    ReportSet existing = (ReportSet)merged.get(key2);
                    if (existing != null) {
                        this.mergeReportSet(existing, element2, sourceDominant, context);
                        continue;
                    }
                    merged.put(key2, element2);
                }
                target2.setReportSets(new ArrayList<ReportSet>(merged.values()));
            }
        }
    }
}

