/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.path;

import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.path.PathTranslator;

@Named
@Singleton
public class DefaultModelPathTranslator
implements ModelPathTranslator {
    @Inject
    private PathTranslator pathTranslator;

    public DefaultModelPathTranslator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    @Override
    public void alignToBaseDirectory(Model model2, File basedir, ModelBuildingRequest request) {
        Reporting reporting;
        if (model2 == null || basedir == null) {
            return;
        }
        Build build2 = model2.getBuild();
        if (build2 != null) {
            build2.setDirectory(this.alignToBaseDirectory(build2.getDirectory(), basedir));
            build2.setSourceDirectory(this.alignToBaseDirectory(build2.getSourceDirectory(), basedir));
            build2.setTestSourceDirectory(this.alignToBaseDirectory(build2.getTestSourceDirectory(), basedir));
            build2.setScriptSourceDirectory(this.alignToBaseDirectory(build2.getScriptSourceDirectory(), basedir));
            for (Resource resource : build2.getResources()) {
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            for (Resource resource : build2.getTestResources()) {
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build2.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>(build2.getFilters().size());
                for (String filter2 : build2.getFilters()) {
                    filters.add(this.alignToBaseDirectory(filter2, basedir));
                }
                build2.setFilters(filters);
            }
            build2.setOutputDirectory(this.alignToBaseDirectory(build2.getOutputDirectory(), basedir));
            build2.setTestOutputDirectory(this.alignToBaseDirectory(build2.getTestOutputDirectory(), basedir));
        }
        if ((reporting = model2.getReporting()) != null) {
            reporting.setOutputDirectory(this.alignToBaseDirectory(reporting.getOutputDirectory(), basedir));
        }
    }

    private String alignToBaseDirectory(String path, File basedir) {
        return this.pathTranslator.alignToBaseDirectory(path, basedir);
    }
}

