/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.normalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultModelNormalizer
implements ModelNormalizer {
    private DuplicateMerger merger = new DuplicateMerger();

    @Override
    public void mergeDuplicates(Model model2, ModelBuildingRequest request, ModelProblemCollector problems) {
        LinkedHashMap<String, InputLocationTracker> normalized;
        Build build2 = model2.getBuild();
        if (build2 != null) {
            List<Plugin> plugins = build2.getPlugins();
            normalized = new LinkedHashMap<String, InputLocationTracker>(plugins.size() * 2);
            for (Plugin plugin : plugins) {
                String key2 = plugin.getKey();
                Plugin first2 = (Plugin)normalized.get(key2);
                if (first2 != null) {
                    this.merger.mergePlugin(plugin, first2);
                }
                normalized.put(key2, plugin);
            }
            if (plugins.size() != normalized.size()) {
                build2.setPlugins(new ArrayList<Plugin>(normalized.values()));
            }
        }
        List<Dependency> dependencies = model2.getDependencies();
        normalized = new LinkedHashMap(dependencies.size() * 2);
        for (Dependency dependency : dependencies) {
            normalized.put(dependency.getManagementKey(), dependency);
        }
        if (dependencies.size() != normalized.size()) {
            model2.setDependencies(new ArrayList<Dependency>(normalized.values()));
        }
    }

    @Override
    public void injectDefaultValues(Model model2, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.injectDependencyDefaults(model2.getDependencies());
        Build build2 = model2.getBuild();
        if (build2 != null) {
            for (Plugin plugin : build2.getPlugins()) {
                this.injectDependencyDefaults(plugin.getDependencies());
            }
        }
    }

    private void injectDependencyDefaults(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (!StringUtils.isEmpty(dependency.getScope())) continue;
            dependency.setScope("compile");
        }
    }

    protected static class DuplicateMerger
    extends MavenModelMerger {
        protected DuplicateMerger() {
        }

        public void mergePlugin(Plugin target2, Plugin source) {
            super.mergePlugin(target2, source, false, Collections.emptyMap());
        }
    }
}

