/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.AbstractStringBasedModelInterpolator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Deprecated
public class StringSearchModelInterpolator
extends AbstractStringBasedModelInterpolator {
    private static final Map<Class<?>, InterpolateObjectAction.CacheItem> CACHED_ENTRIES = new ConcurrentHashMap(80, 0.75f, 2);

    @Override
    public Model interpolateModel(Model model2, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        this.interpolateObject(model2, model2, projectDir, config, problems);
        return model2;
    }

    void interpolateObject(Object obj2, Model model2, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        List<ValueSource> valueSources = this.createValueSources(model2, projectDir, config, problems);
        List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model2, projectDir, config);
        InnerInterpolator innerInterpolator = this.createInterpolator(valueSources, postProcessors, problems);
        InterpolateObjectAction action = new InterpolateObjectAction(obj2, innerInterpolator, problems);
        AccessController.doPrivileged(action);
    }

    private InnerInterpolator createInterpolator(List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, final ModelProblemCollector problems) {
        final HashMap cache2 = new HashMap();
        final StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        for (ValueSource valueSource : valueSources) {
            interpolator.addValueSource(valueSource);
        }
        for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
            interpolator.addPostProcessor(interpolationPostProcessor);
        }
        final RecursionInterceptor recursionInterceptor = this.createRecursionInterceptor();
        return new InnerInterpolator(){

            @Override
            public String interpolate(String value2) {
                if (value2 != null && value2.contains("${")) {
                    String c2 = (String)cache2.get(value2);
                    if (c2 == null) {
                        try {
                            c2 = interpolator.interpolate(value2, recursionInterceptor);
                        }
                        catch (InterpolationException e2) {
                            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(e2.getMessage()).setException(e2));
                        }
                        cache2.put(value2, c2);
                    }
                    return c2;
                }
                return value2;
            }
        };
    }

    private static final class InterpolateObjectAction
    implements PrivilegedAction<Object> {
        private final LinkedList<Object> interpolationTargets = new LinkedList();
        private final InnerInterpolator interpolator;
        private final ModelProblemCollector problems;

        InterpolateObjectAction(Object target2, InnerInterpolator interpolator, ModelProblemCollector problems) {
            this.interpolationTargets.add(target2);
            this.interpolator = interpolator;
            this.problems = problems;
        }

        @Override
        public Object run() {
            while (!this.interpolationTargets.isEmpty()) {
                Object obj2 = this.interpolationTargets.removeFirst();
                this.traverseObjectWithParents(obj2.getClass(), obj2);
            }
            return null;
        }

        private String interpolate(String value2) {
            return this.interpolator.interpolate(value2);
        }

        private void traverseObjectWithParents(Class<?> cls, Object target2) {
            if (cls == null) {
                return;
            }
            CacheItem cacheEntry = this.getCacheEntry(cls);
            if (cacheEntry.isArray()) {
                InterpolateObjectAction.evaluateArray(target2, this);
            } else if (cacheEntry.isQualifiedForInterpolation) {
                cacheEntry.interpolate(target2, this);
                this.traverseObjectWithParents(cls.getSuperclass(), target2);
            }
        }

        private CacheItem getCacheEntry(Class<?> cls) {
            CacheItem cacheItem = (CacheItem)CACHED_ENTRIES.get(cls);
            if (cacheItem == null) {
                cacheItem = new CacheItem(cls);
                CACHED_ENTRIES.put(cls, cacheItem);
            }
            return cacheItem;
        }

        private static void evaluateArray(Object target2, InterpolateObjectAction ctx) {
            int len = Array.getLength(target2);
            for (int i2 = 0; i2 < len; ++i2) {
                Object value2 = Array.get(target2, i2);
                if (value2 == null) continue;
                if (String.class == value2.getClass()) {
                    String interpolated = ctx.interpolate((String)value2);
                    if (interpolated.equals(value2)) continue;
                    Array.set(target2, i2, interpolated);
                    continue;
                }
                ctx.interpolationTargets.add(value2);
            }
        }

        static final class ObjectField
        extends CacheField {
            private final boolean isArray;

            ObjectField(Field field) {
                super(field);
                this.isArray = field.getType().isArray();
            }

            @Override
            void doInterpolate(Object target2, InterpolateObjectAction ctx) throws IllegalAccessException {
                Object value2 = this.field.get(target2);
                if (value2 != null) {
                    if (this.isArray) {
                        InterpolateObjectAction.evaluateArray(value2, ctx);
                    } else {
                        ctx.interpolationTargets.add(value2);
                    }
                }
            }
        }

        static final class MapField
        extends CacheField {
            MapField(Field field) {
                super(field);
            }

            @Override
            void doInterpolate(Object target2, InterpolateObjectAction ctx) throws IllegalAccessException {
                Map m = (Map)this.field.get(target2);
                if (m == null || m.isEmpty()) {
                    return;
                }
                for (Map.Entry entry : m.entrySet()) {
                    Object value2 = entry.getValue();
                    if (value2 == null) continue;
                    if (String.class == value2.getClass()) {
                        String interpolated = ctx.interpolate((String)value2);
                        if (interpolated == null || interpolated.equals(value2)) continue;
                        try {
                            entry.setValue(interpolated);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {}
                        continue;
                    }
                    if (value2.getClass().isArray()) {
                        InterpolateObjectAction.evaluateArray(value2, ctx);
                        continue;
                    }
                    ctx.interpolationTargets.add(value2);
                }
            }
        }

        static final class ListField
        extends CacheField {
            ListField(Field field) {
                super(field);
            }

            @Override
            void doInterpolate(Object target2, InterpolateObjectAction ctx) throws IllegalAccessException {
                List c2 = (List)this.field.get(target2);
                if (c2 == null) {
                    return;
                }
                int size = c2.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    Object value2 = c2.get(i2);
                    if (value2 == null) continue;
                    if (String.class == value2.getClass()) {
                        String interpolated = ctx.interpolate((String)value2);
                        if (interpolated.equals(value2)) continue;
                        try {
                            c2.set(i2, interpolated);
                            continue;
                        }
                        catch (UnsupportedOperationException e2) {
                            return;
                        }
                    }
                    if (value2.getClass().isArray()) {
                        InterpolateObjectAction.evaluateArray(value2, ctx);
                        continue;
                    }
                    ctx.interpolationTargets.add(value2);
                }
            }
        }

        static final class StringField
        extends CacheField {
            StringField(Field field) {
                super(field);
            }

            @Override
            void doInterpolate(Object target2, InterpolateObjectAction ctx) throws IllegalAccessException {
                String value2 = (String)this.field.get(target2);
                if (value2 == null) {
                    return;
                }
                String interpolated = ctx.interpolate(value2);
                if (interpolated != null && !interpolated.equals(value2)) {
                    this.field.set(target2, interpolated);
                }
            }
        }

        static abstract class CacheField {
            final Field field;

            CacheField(Field field) {
                this.field = field;
                field.setAccessible(true);
            }

            void interpolate(Object target2, InterpolateObjectAction interpolateObjectAction) {
                try {
                    this.doInterpolate(target2, interpolateObjectAction);
                }
                catch (IllegalArgumentException e2) {
                    interpolateObjectAction.problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate field3: " + this.field + " on class: " + this.field.getType().getName()).setException(e2));
                }
                catch (IllegalAccessException e3) {
                    interpolateObjectAction.problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate field4: " + this.field + " on class: " + this.field.getType().getName()).setException(e3));
                }
            }

            abstract void doInterpolate(Object var1, InterpolateObjectAction var2) throws IllegalAccessException;
        }

        private static class CacheItem {
            private final boolean isArray;
            private final boolean isQualifiedForInterpolation;
            private final CacheField[] fields;

            private boolean isQualifiedForInterpolation(Class<?> cls) {
                Package pkg = cls.getPackage();
                if (pkg == null) {
                    return true;
                }
                String pkgName = pkg.getName();
                return !pkgName.startsWith("java.") && !pkgName.startsWith("javax.");
            }

            private boolean isQualifiedForInterpolation(Field field, Class<?> fieldType) {
                if (Map.class.equals(fieldType) && "locations".equals(field.getName())) {
                    return false;
                }
                if (InputLocation.class.equals(fieldType)) {
                    return false;
                }
                if (fieldType.isPrimitive()) {
                    return false;
                }
                return !"parent".equals(field.getName());
            }

            CacheItem(Class clazz) {
                this.isQualifiedForInterpolation = this.isQualifiedForInterpolation(clazz);
                this.isArray = clazz.isArray();
                ArrayList<CacheField> fields = new ArrayList<CacheField>();
                if (this.isQualifiedForInterpolation) {
                    for (Field currentField : clazz.getDeclaredFields()) {
                        Class<?> type = currentField.getType();
                        if (!this.isQualifiedForInterpolation(currentField, type)) continue;
                        if (String.class == type) {
                            if (Modifier.isFinal(currentField.getModifiers())) continue;
                            fields.add(new StringField(currentField));
                            continue;
                        }
                        if (List.class.isAssignableFrom(type)) {
                            fields.add(new ListField(currentField));
                            continue;
                        }
                        if (Collection.class.isAssignableFrom(type)) {
                            throw new RuntimeException("We dont interpolate into collections, use a list instead");
                        }
                        if (Map.class.isAssignableFrom(type)) {
                            fields.add(new MapField(currentField));
                            continue;
                        }
                        fields.add(new ObjectField(currentField));
                    }
                }
                this.fields = fields.toArray(new CacheField[0]);
            }

            void interpolate(Object target2, InterpolateObjectAction interpolateObjectAction) {
                for (CacheField field : this.fields) {
                    field.interpolate(target2, interpolateObjectAction);
                }
            }

            boolean isArray() {
                return this.isArray;
            }
        }
    }

    private static interface InnerInterpolator {
        public String interpolate(String var1);
    }
}

