/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.refactoring.extractFunction.RefInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import com.intellij.sql.refactoring.extractFunction.SqlOriginalParameterInfo;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "", "originalExpression", "Lcom/intellij/sql/psi/SqlExpression;", "container", "Lcom/intellij/sql/psi/SqlElement;", "(Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlElement;)V", "getContainer", "()Lcom/intellij/sql/psi/SqlElement;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "Lorg/jetbrains/annotations/NotNull;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "isQuery", "", "()Z", "isTableFunction", "getOriginalExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "parameterInfos", "", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "getParameterInfos", "()Ljava/util/Collection;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "virtualExpression", "getVirtualExpression", "computeParameterKey", "expression", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "detectArgumentDirection", "Lcom/intellij/database/model/ArgumentDirection;", "intellij.database.sql.core.impl"})
public final class SqlExtractableCodeInfo {
    @NotNull
    private final SqlExpression originalExpression;
    @NotNull
    private final SqlElement container;
    @NotNull
    private final Project project;
    @NotNull
    private final SqlLanguageDialectEx dialect;
    @NotNull
    private final Collection<SqlExtractableParameterInfo> parameterInfos;
    @NotNull
    private final SqlExpression virtualExpression;

    public SqlExtractableCodeInfo(@NotNull SqlExpression originalExpression, @NotNull SqlElement container) {
        Intrinsics.checkNotNullParameter((Object)originalExpression, (String)"originalExpression");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.originalExpression = originalExpression;
        this.container = container;
        Project project = this.container.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)this.container);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        this.dialect = sqlLanguageDialectEx;
        SqlExtractableCodeInfoKt.access$processReferences(this.originalExpression, 1.INSTANCE);
        final LinkedHashMap<Object, SqlExtractableParameterInfo> parameterInfos = new LinkedHashMap<Object, SqlExtractableParameterInfo>();
        final HashSet<String> usedNames = new HashSet<String>();
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
        SqlPsiFacade psiFacade2 = sqlPsiFacade;
        SqlCodeFragment sqlCodeFragment = psiFacade2.createExpressionFragment((Language)this.dialect, null, null, "1", false, false);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createExpressionFragment(...)");
        SqlCodeFragment codeFragment = sqlCodeFragment;
        codeFragment.setContext((PsiElement)this.container);
        PsiElement psiElement = codeFragment.getFirstChild().replace((PsiElement)this.originalExpression);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlExpression");
        this.virtualExpression = (SqlExpression)psiElement;
        SqlExtractableCodeInfoKt.access$processReferences(this.virtualExpression, (Function1)new Function1<SqlReferenceExpression, Unit>(){

            public final void invoke(@NotNull SqlReferenceExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                RefInfo refInfo = (RefInfo)it2.getCopyableUserData(SqlExtractableCodeInfoKt.access$getREF_INFO$p());
                if (refInfo == null) {
                    return;
                }
                RefInfo refInfo2 = refInfo;
                it2.putCopyableUserData(SqlExtractableCodeInfoKt.access$getREF_INFO$p(), null);
                String string = refInfo2.getDefinition().getName();
                if (string == null) {
                    return;
                }
                String defName = string;
                String string2 = SqlNamesGenerator.suggestUniqueName(defName, (Collection<String>)usedNames);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suggestUniqueName(...)");
                String paramName = string2;
                if (!this.isQuery() && Intrinsics.areEqual((Object)it2.getReferenceElementType().getTargetKind(), (Object)ObjectKind.COLUMN) || !Intrinsics.areEqual((Object)it2.resolve(), (Object)refInfo2.getDefinition())) {
                    Object object;
                    Object object2 = this.computeParameterKey(refInfo2.getOriginalExpression());
                    if (object2 == null) {
                        return;
                    }
                    Object key2 = object2;
                    ArgumentDirection direction = this.detectArgumentDirection((SqlExpression)refInfo2.getOriginalExpression());
                    Map $this$getOrPut$iv = parameterInfos;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key2);
                    if (value$iv == null) {
                        boolean bl = false;
                        SqlExtractableParameterInfo answer$iv = new SqlOriginalParameterInfo(paramName, refInfo2.getDefinition(), refInfo2.getOriginalExpression(), refInfo2.getDasType(), direction);
                        $this$getOrPut$iv.put(key2, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    SqlExtractableParameterInfo paramInfo = (SqlExtractableParameterInfo)object;
                    it2.putCopyableUserData(SqlExtractableCodeInfoKt.access$getPARAM_OCCURRENCE$p(), (Object)paramInfo);
                    ((Collection)usedNames).add(paramName);
                }
            }
        });
        Collection<SqlExtractableParameterInfo> collection2 = parameterInfos.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        this.parameterInfos = CollectionsKt.toList((Iterable)collection2);
    }

    @NotNull
    public final SqlExpression getOriginalExpression() {
        return this.originalExpression;
    }

    @NotNull
    public final SqlElement getContainer() {
        return this.container;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    @NotNull
    public final Collection<SqlExtractableParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }

    @NotNull
    public final SqlExpression getVirtualExpression() {
        return this.virtualExpression;
    }

    private final ArgumentDirection detectArgumentDirection(SqlExpression expression) {
        DasArgument dasArgument;
        ArgumentDirection inDirection = ArgumentDirection.IN;
        if (!(expression instanceof SqlReferenceExpression)) {
            return inDirection;
        }
        PsiElement parent2 = ((SqlReferenceExpression)expression).getParent();
        if (!(parent2 instanceof SqlNamedParameterValueExpression) && !(parent2 instanceof SqlExpressionList)) {
            return inDirection;
        }
        DasArgument dasArgument2 = dasArgument = SqlPsiUtilCoreKt.findParameterDefinition(expression);
        ArgumentDirection argumentDirection = dasArgument2 != null ? dasArgument2.getArgumentDirection() : null;
        if (argumentDirection == null) {
            argumentDirection = inDirection;
        }
        return argumentDirection;
    }

    private final Object computeParameterKey(SqlReferenceExpression expression) {
        SqlExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null && !(qualifierExpression instanceof SqlReferenceExpression)) {
            return expression;
        }
        List<Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified(expression);
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveQualified(...)");
        return CollectionsKt.firstOrNull(list);
    }

    public final boolean isTableFunction() {
        return this.originalExpression.getDasType() instanceof SqlTableType;
    }

    public final boolean isQuery() {
        return this.originalExpression instanceof SqlQueryExpression || this.originalExpression instanceof SqlSetOperatorExpression;
    }
}

