/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.Dbms;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u001c\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0018*\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "", "codeInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "name", "", "parameters", "", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "(Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;Ljava/lang/String;Ljava/util/Collection;)V", "getCodeInfo", "()Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "getName", "()Ljava/lang/String;", "parameterMap", "", "getParameterMap", "()Ljava/util/Map;", "parameterMap$delegate", "Lkotlin/Lazy;", "getParameters", "()Ljava/util/Collection;", "substitutedExpression", "Lcom/intellij/sql/psi/SqlExpression;", "Lorg/jetbrains/annotations/Nullable;", "getSubstitutedExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "substitutedExpression$delegate", "getReplacement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "intellij.database.sql.core.impl"})
public final class SqlExtractFunctionInfo {
    @NotNull
    private final SqlExtractableCodeInfo codeInfo;
    @NotNull
    private final String name;
    @NotNull
    private final Collection<SqlExtractableParameterInfo> parameters;
    @NotNull
    private final Lazy parameterMap$delegate;
    @NotNull
    private final Lazy substitutedExpression$delegate;

    public SqlExtractFunctionInfo(@NotNull SqlExtractableCodeInfo codeInfo, @NotNull String name2, @NotNull Collection<? extends SqlExtractableParameterInfo> parameters2) {
        Intrinsics.checkNotNullParameter((Object)codeInfo, (String)"codeInfo");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        this.codeInfo = codeInfo;
        this.name = name2;
        this.parameters = parameters2;
        this.parameterMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<SqlExtractableParameterInfo, ? extends SqlExtractableParameterInfo>>(this){
            final /* synthetic */ SqlExtractFunctionInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<SqlExtractableParameterInfo, SqlExtractableParameterInfo> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getParameters();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it2;
                    SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(it2.getOriginal(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.substitutedExpression$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SqlExpression>(this){
            final /* synthetic */ SqlExtractFunctionInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SqlExpression invoke() {
                Object object;
                SqlReferenceExpression sqlReferenceExpression;
                SqlExpression expression = this.this$0.getCodeInfo().getVirtualExpression();
                SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression = expression instanceof SqlReferenceExpression ? (SqlReferenceExpression)expression : null;
                if (sqlReferenceExpression != null && (object = SqlExtractFunctionInfo.access$getReplacement(this.this$0, sqlReferenceExpression)) != null) {
                    SqlExpression it2 = object;
                    boolean bl = false;
                    return it2;
                }
                LinkedHashMap<PsiElement, PsiElement> replacementMap = new LinkedHashMap<PsiElement, PsiElement>();
                SqlExtractableCodeInfoKt.access$processReferences(expression, (Function1)new Function1<SqlReferenceExpression, Unit>(this.this$0, replacementMap){
                    final /* synthetic */ SqlExtractFunctionInfo this$0;
                    final /* synthetic */ LinkedHashMap<PsiElement, PsiElement> $replacementMap;
                    {
                        this.this$0 = $receiver;
                        this.$replacementMap = $replacementMap;
                        super(1);
                    }

                    public final void invoke(@NotNull SqlReferenceExpression it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        SqlExpression sqlExpression = SqlExtractFunctionInfo.access$getReplacement(this.this$0, it2);
                        if (sqlExpression == null) {
                            return;
                        }
                        SqlExpression replacement = sqlExpression;
                        ((Map)this.$replacementMap).put(it2, replacement);
                    }
                });
                for (Map.Entry entry : ((Map)replacementMap).entrySet()) {
                    PsiElement element2 = (PsiElement)entry.getKey();
                    PsiElement replacement = (PsiElement)entry.getValue();
                    element2.replace(replacement);
                }
                return expression;
            }
        }));
    }

    @NotNull
    public final SqlExtractableCodeInfo getCodeInfo() {
        return this.codeInfo;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Collection<SqlExtractableParameterInfo> getParameters() {
        return this.parameters;
    }

    private final Map<SqlExtractableParameterInfo, SqlExtractableParameterInfo> getParameterMap() {
        Lazy lazy = this.parameterMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final SqlExpression getSubstitutedExpression() {
        Lazy lazy = this.substitutedExpression$delegate;
        return (SqlExpression)lazy.getValue();
    }

    private final SqlExpression getReplacement(SqlReferenceExpression $this$getReplacement) {
        SqlExpression sqlExpression;
        SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)$this$getReplacement.getCopyableUserData(SqlExtractableCodeInfoKt.access$getPARAM_OCCURRENCE$p());
        if (sqlExtractableParameterInfo != null) {
            SqlExtractableParameterInfo it2 = sqlExtractableParameterInfo;
            boolean bl = false;
            SqlExtractableParameterInfo sqlExtractableParameterInfo2 = this.getParameterMap().get(it2);
            if (sqlExtractableParameterInfo2 == null) {
                sqlExtractableParameterInfo2 = it2;
            }
            SqlExtractableParameterInfo param = sqlExtractableParameterInfo2;
            String quotes = SqlPsiMiscUtil.settings((PsiElement)$this$getReplacement).getQuotesPriority();
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)this.codeInfo.getOriginalExpression());
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            NamingService namingService2 = NamingServices.getNamingService$default(dbms, null, null, 6, null);
            String name2 = NamingService.catToScript$default(namingService2, param.getName(), param.getOriginalExpression().getKind(), true, quotes, false, 16, null);
            sqlExpression = SqlPsiElementFactory.createExpressionFromText(name2, this.codeInfo.getDialect(), this.codeInfo.getProject(), null);
        } else {
            sqlExpression = null;
        }
        return sqlExpression;
    }

    public static final /* synthetic */ SqlExpression access$getReplacement(SqlExtractFunctionInfo $this, SqlReferenceExpression $receiver) {
        return $this.getReplacement($receiver);
    }
}

