/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0014J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0016\u0010+\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0004J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0004J\u0018\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u00106\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u00020!R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u00068"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "()V", "parenthesizeEmptyParameterList", "", "getParenthesizeEmptyParameterList", "()Z", "returnTypeKeyword", "", "getReturnTypeKeyword", "()Ljava/lang/String;", "supportsTableFunctions", "getSupportsTableFunctions", "addRoutine", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "declaration", "anchor", "Lcom/intellij/psi/PsiElement;", "block", "Lcom/intellij/sql/psi/SqlElement;", "doGenerateCall", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "findAnchor", "element", "container", "findTopmostBlock", "generateBody", "generateBodyStatement", "generateCall", "Lcom/intellij/sql/psi/SqlExpression;", "generateCallExpression", "generateParameter", "param", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "generatePreamble", "generateReturnClause", "codeInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "generateReturnExpression", "generateRoutine", "isPreview", "generateTableCallExpression", "generateTableType", "sqlType", "Lcom/intellij/sql/psi/SqlTableType;", "generateTableTypeColumns", "generateType", "dasType", "Lcom/intellij/database/types/DasType;", "getRoutineKeyword", "validateExpression", "e", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExtractFunctionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExtractFunctionHelper.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,201:1\n1864#2,3:202\n1864#2,3:205\n60#3,2:208\n*S KotlinDebug\n*F\n+ 1 SqlExtractFunctionHelper.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper\n*L\n115#1:202,3\n151#1:205,3\n164#1:208,2\n*E\n"})
public abstract class SqlExtractFunctionHelper
implements SqlIntroduceHelper {
    @Nullable
    public final String validateExpression(@NotNull SqlExpression e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DasType dasType = e2.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (dasType2 instanceof DasBuiltinType && !Intrinsics.areEqual((Object)dasType2, DasTypeSystemBase.UNKNOWN) && !Intrinsics.areEqual((Object)dasType2, DasTypeSystemBase.VOID)) {
            return null;
        }
        if (this.getSupportsTableFunctions()) {
            if (!(dasType2 instanceof DasTableType)) {
                return "dialog.message.only.primitives.and.tables.are.supported";
            }
            if (e2 instanceof SqlQueryExpression || e2 instanceof SqlResultSetExpression) {
                return null;
            }
            if (UtilsKt.wrapAlias(e2) instanceof SqlFromClause) {
                return null;
            }
            return "dialog.message.only.queries.and.froms.are.supported";
        }
        return "dialog.message.only.primitives.are.supported";
    }

    public boolean getSupportsTableFunctions() {
        return false;
    }

    @NotNull
    public String getRoutineKeyword(@NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        return "function";
    }

    @Override
    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element2) {
        PsiElement psiElement = element2;
        return (PsiElement)(psiElement != null ? psiElement.getContainingFile() : null);
    }

    @Nullable
    public PsiElement findAnchor(@NotNull PsiElement element2, @NotNull PsiElement container) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return PsiTreeUtil.findPrevParent((PsiElement)container, (PsiElement)element2);
    }

    public boolean getParenthesizeEmptyParameterList() {
        return true;
    }

    @NotNull
    public String getReturnTypeKeyword() {
        return "returns";
    }

    protected void generateParameter(@NotNull DdlBuilder builder, @NotNull SqlExtractableParameterInfo param) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        builder.identifier(param.getName(), ObjectKind.VARIABLE);
        builder.space();
        builder.type(param.getDasType().toDataType());
    }

    protected void generateReturnExpression(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        if (functionInfo.getCodeInfo().isTableFunction() && !functionInfo.getCodeInfo().isQuery()) {
            builder.keyword("select ").symbol("*").keyword(" from ");
        }
        builder.plain(functionInfo.getSubstitutedExpression().getText());
    }

    protected void generateBodyStatement(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generateBodyStatement_u24lambda_u240 = builder;
        boolean bl = false;
        $this$generateBodyStatement_u24lambda_u240.keyword("begin");
        $this$generateBodyStatement_u24lambda_u240.newLine();
        $this$generateBodyStatement_u24lambda_u240.keyword("return ");
        this.generateReturnExpression($this$generateBodyStatement_u24lambda_u240, functionInfo);
        $this$generateBodyStatement_u24lambda_u240.symbol(";");
        $this$generateBodyStatement_u24lambda_u240.newLine();
        $this$generateBodyStatement_u24lambda_u240.keyword("end");
    }

    public void generateBody(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generateBody_u24lambda_u241 = builder;
        boolean bl = false;
        $this$generateBody_u24lambda_u241.keyword("as ");
        this.generateBodyStatement($this$generateBody_u24lambda_u241, functionInfo);
    }

    protected final void generateTableTypeColumns(@NotNull DdlBuilder builder, @NotNull SqlTableType sqlType) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        int n = sqlType.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                builder.symbol(", ");
            }
            ObjectName name2 = ObjectName.create(sqlType.getColumnName(i2), sqlType.isColumnQuoted(i2));
            builder.identifier(name2, ObjectKind.COLUMN);
            builder.space();
            DasType dasType = sqlType.getColumnDasType(i2);
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getColumnDasType(...)");
            this.generateType(builder, dasType);
        }
    }

    public void generateTableType(@NotNull DdlBuilder builder, @NotNull SqlTableType sqlType) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        builder.keyword("table");
        builder.symbol("(");
        this.generateTableTypeColumns(builder, sqlType);
        builder.symbol(")");
    }

    public void generateType(@NotNull DdlBuilder builder, @NotNull DasType dasType) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
        if (dasType instanceof SqlTableType) {
            this.generateTableType(builder, (SqlTableType)dasType);
        } else {
            builder.type(dasType.toDataType());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SqlRoutineDefinition generateRoutine(@NotNull SqlExtractFunctionInfo functionInfo, boolean isPreview) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        SqlExtractableCodeInfo codeInfo = functionInfo.getCodeInfo();
        DdlBuilder $this$generateRoutine_u24lambda_u243 = ddlBuilder = SqlExtractableCodeInfoKt.createBuilder(functionInfo);
        boolean bl = false;
        this.generatePreamble($this$generateRoutine_u24lambda_u243, functionInfo);
        Collection<SqlExtractableParameterInfo> parameters2 = functionInfo.getParameters();
        if (!parameters2.isEmpty()) {
            $this$generateRoutine_u24lambda_u243.symbol("(");
            Iterable $this$forEachIndexed$iv = parameters2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void param;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv;
                int i2 = n;
                boolean bl2 = false;
                if (i2 > 0) {
                    $this$generateRoutine_u24lambda_u243.symbol(", ");
                }
                this.generateParameter($this$generateRoutine_u24lambda_u243, (SqlExtractableParameterInfo)param);
            }
            $this$generateRoutine_u24lambda_u243.symbol(")");
        } else if (this.getParenthesizeEmptyParameterList()) {
            $this$generateRoutine_u24lambda_u243.symbol("()");
        }
        this.generateReturnClause($this$generateRoutine_u24lambda_u243, codeInfo);
        if (!isPreview) {
            $this$generateRoutine_u24lambda_u243.space();
            this.generateBody($this$generateRoutine_u24lambda_u243, functionInfo);
        }
        DdlBuilder builder = ddlBuilder;
        SqlStatement sqlStatement = SqlPsiElementFactory.createStatementFromText(builder.getStatement(), codeInfo.getDialect(), codeInfo.getProject(), null);
        Intrinsics.checkNotNull((Object)sqlStatement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        return (SqlRoutineDefinition)sqlStatement;
    }

    protected void generatePreamble(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generatePreamble_u24lambda_u244 = builder;
        boolean bl = false;
        $this$generatePreamble_u24lambda_u244.keyword("create " + this.getRoutineKeyword(functionInfo) + " ");
        $this$generatePreamble_u24lambda_u244.identifier(functionInfo.getName(), ObjectKind.ROUTINE);
    }

    protected void generateReturnClause(@NotNull DdlBuilder builder, @NotNull SqlExtractableCodeInfo codeInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)codeInfo, (String)"codeInfo");
        DdlBuilder $this$generateReturnClause_u24lambda_u245 = builder;
        boolean bl = false;
        $this$generateReturnClause_u24lambda_u245.keyword(" " + this.getReturnTypeKeyword() + " ");
        DasType dasType = codeInfo.getOriginalExpression().getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        this.generateType($this$generateReturnClause_u24lambda_u245, dasType);
    }

    /*
     * WARNING - void declaration
     */
    protected final void generateCallExpression(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        builder.identifier(functionInfo.getName(), ObjectKind.ROUTINE);
        builder.symbol("(");
        Iterable $this$forEachIndexed$iv = functionInfo.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv;
            int i2 = n;
            boolean bl = false;
            if (i2 > 0) {
                builder.symbol(", ");
            }
            builder.plain(param.getOriginalExpression().getText());
        }
        builder.symbol(")");
    }

    protected void generateTableCallExpression(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        this.generateCallExpression(builder, functionInfo);
    }

    private final void doGenerateCall(DdlBuilder builder, SqlExtractFunctionInfo functionInfo) {
        if (functionInfo.getCodeInfo().isTableFunction()) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)functionInfo.getCodeInfo().getOriginalExpression();
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlQueryExpression.class, (boolean)true) == null) {
                builder.keyword("select ").symbol("*").keyword(" from ");
            }
            this.generateTableCallExpression(builder, functionInfo);
        } else {
            this.generateCallExpression(builder, functionInfo);
        }
    }

    @NotNull
    public final SqlExpression generateCall(@NotNull SqlExtractFunctionInfo functionInfo) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        SqlExtractableCodeInfo codeInfo = functionInfo.getCodeInfo();
        DdlBuilder $this$generateCall_u24lambda_u247 = ddlBuilder = SqlExtractableCodeInfoKt.createBuilder(functionInfo);
        boolean bl = false;
        $this$generateCall_u24lambda_u247.configureBuilder(codeInfo.getProject(), codeInfo.getDialect());
        this.doGenerateCall($this$generateCall_u24lambda_u247, functionInfo);
        DdlBuilder builder = ddlBuilder;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(builder.getStatement(), codeInfo.getDialect(), codeInfo.getProject(), null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        return sqlExpression;
    }

    @NotNull
    public final SqlRoutineDefinition addRoutine(@NotNull SqlRoutineDefinition declaration, @Nullable PsiElement anchor2, @NotNull SqlElement block) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        PsiElement psiElement = block.addBefore((PsiElement)declaration, anchor2);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        SqlRoutineDefinition element2 = (SqlRoutineDefinition)psiElement;
        Project project = block.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        PsiElement psiElement2 = SqlPsiElementFactory.createLeafFromText(project2, dialect, ";");
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createLeafFromText(...)");
        PsiElement semi = psiElement2;
        PsiElement psiElement3 = SqlPsiElementFactory.newLine(project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"newLine(...)");
        PsiElement newLine = psiElement3;
        block.addBefore(newLine, (PsiElement)element2);
        block.addAfter(newLine, (PsiElement)element2);
        block.addAfter(newLine, (PsiElement)element2);
        block.addAfter(semi, (PsiElement)element2);
        return element2;
    }
}

