/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLeafTokenPattern
extends InitialPatternCondition<PsiElement>
implements ElementPattern<PsiElement>,
Cloneable {
    private final List<String[]> mySequences = new ArrayList<String[]>();

    protected SqlLeafTokenPattern() {
        super(PsiElement.class);
    }

    public SqlLeafTokenPattern or(String ... names2) {
        ContainerUtil.addIfNotNull(this.mySequences, (Object)names2);
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        SqlLeafTokenPattern clone = (SqlLeafTokenPattern)super.clone();
        clone.mySequences.addAll(this.mySequences);
        return clone;
    }

    public boolean accepts(@Nullable Object o2) {
        return this.accepts(o2, new ProcessingContext());
    }

    public boolean accepts(@Nullable Object o2, ProcessingContext context) {
        if (this.mySequences.isEmpty() || !(o2 instanceof PsiElement)) {
            return false;
        }
        PsiElement t = (PsiElement)o2;
        int end = t.getTextRange().getEndOffset();
        PsiElement e2 = PsiTreeUtil.getDeepestVisibleFirst((PsiElement)t);
        if (e2 != null && !SqlLeafTokenPattern.isInside(e2, end)) {
            e2 = null;
        }
        if (e2 != null && !SqlLeafTokenPattern.isOk(e2)) {
            e2 = SqlLeafTokenPattern.nextOk(e2, end);
        }
        ArrayList<String[]> variants = new ArrayList<String[]>(this.mySequences);
        int i2 = 0;
        while (true) {
            IElementType type = PsiUtilCore.getElementType((PsiElement)e2);
            boolean unmatched = false;
            Iterator it2 = variants.iterator();
            while (it2.hasNext()) {
                String[] variant = (String[])it2.next();
                if (i2 >= variant.length) {
                    it2.remove();
                    continue;
                }
                if (SqlLeafTokenPattern.isToken(type, variant[i2])) continue;
                unmatched = true;
                it2.remove();
            }
            if (variants.isEmpty() && !unmatched) break;
            if (e2 == null) {
                return false;
            }
            if (variants.isEmpty()) {
                return false;
            }
            ++i2;
            e2 = SqlLeafTokenPattern.nextOk(e2, end);
        }
        return e2 == null;
    }

    private static boolean isToken(IElementType token, String value2) {
        return token instanceof SqlTokenType && token == SqlTokenRegistry.findTokenType((String)value2);
    }

    private static boolean isOk(@NotNull PsiElement e2) {
        if (e2 == null) {
            SqlLeafTokenPattern.$$$reportNull$$$0(0);
        }
        if (e2 instanceof PsiComment) {
            return false;
        }
        return !SqlTokens.COMMENT_TOKENS.contains(PsiUtilCore.getElementType((PsiElement)e2));
    }

    private static boolean isInside(@NotNull PsiElement e2, int end) {
        if (e2 == null) {
            SqlLeafTokenPattern.$$$reportNull$$$0(1);
        }
        return e2.getTextRange().getEndOffset() <= end;
    }

    @Nullable
    private static PsiElement nextOk(@Nullable PsiElement e2, int end) {
        while (e2 != null) {
            if ((e2 = PsiTreeUtil.nextVisibleLeaf((PsiElement)e2)) == null || !SqlLeafTokenPattern.isInside(e2, end)) {
                return null;
            }
            if (!SqlLeafTokenPattern.isOk(e2)) continue;
            return e2;
        }
        return null;
    }

    public ElementPatternCondition<PsiElement> getCondition() {
        return new ElementPatternCondition((InitialPatternCondition)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/sql/psi/patterns/SqlLeafTokenPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isOk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInside";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

