/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBasedSqlTableTypeImpl<T extends DasTypedObject>
extends SqlTableTypeBase {
    private final List<T> myColumns;
    private final List<DasObject> myMethods;
    private final DasObject myDatabaseElement;
    private final PsiElement myTypeElement;
    private final String myTableName;
    private final PsiElement myQualifier;
    private DataType myDataType;

    private TableBasedSqlTableTypeImpl(DasObject databaseElement, PsiElement typeElement, @Nullable PsiElement place, @NotNull List<T> columns2) {
        if (columns2 == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(0);
        }
        this.myDatabaseElement = databaseElement;
        this.myTypeElement = typeElement;
        this.myQualifier = TableBasedSqlTableTypeImpl.resolved(place);
        this.myTableName = databaseElement.getName();
        this.myDataType = DataTypeFactory.of(this.myTableName);
        ArrayList methods = new ArrayList();
        this.myDatabaseElement.getDasChildren(ObjectKind.ROUTINE).addAllTo(methods);
        this.myDatabaseElement.getDasChildren(ObjectKind.METHOD).addAllTo(methods);
        this.myMethods = methods.isEmpty() ? Collections.emptyList() : methods;
        this.myColumns = columns2;
    }

    @NotNull
    public static <T extends DasTypedObject> TableBasedSqlTableTypeImpl<T> createTypeWithColumns(DasObject databaseElement, PsiElement typeElement, @Nullable PsiElement place, Class<T> columnClass, ObjectKind columnKind) {
        PsiElement infoPsi = DbSqlUtilCore.getPsiDelegate(databaseElement);
        ArrayList columns2 = infoPsi == null && place == null ? ContainerUtil.newArrayList((Iterable)databaseElement.getDasChildren(columnKind).filter(columnClass)) : TableBasedSqlTableTypeImpl.calcColumns(databaseElement, infoPsi, place, columnClass, columnKind);
        return new TableBasedSqlTableTypeImpl<T>(databaseElement, typeElement, place, columns2);
    }

    @NotNull
    public static <T extends DasTypedObject> TableBasedSqlTableTypeImpl<T> createTypeWithoutColumns(DasObject databaseElement, PsiElement typeElement, @Nullable PsiElement place) {
        return new TableBasedSqlTableTypeImpl(databaseElement, typeElement, place, Collections.emptyList());
    }

    @NotNull
    public DataType toDataType() {
        if (this.myDataType == null) {
            this.myDataType = SqlTypeFactory.createTableDataType(this.myColumns);
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    public TableBasedSqlTableTypeImpl(List<T> columns2, @Nullable PsiElement qualifier) {
        this.myDatabaseElement = null;
        this.myTypeElement = null;
        this.myColumns = columns2;
        this.myTableName = null;
        this.myQualifier = TableBasedSqlTableTypeImpl.resolved(qualifier);
        this.myMethods = Collections.emptyList();
    }

    @Nullable
    private static PsiElement resolved(@Nullable PsiElement place) {
        return (PsiElement)ObjectUtils.chooseNotNull((Object)(place instanceof SqlReferenceExpression ? ((SqlReferenceExpression)place).resolve() : place), (Object)place);
    }

    @NotNull
    public List<DasObject> getMethods() {
        List<DasObject> list = this.myMethods;
        if (list == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myTypeElement;
    }

    public int getColumnCount() {
        return this.myColumns.size();
    }

    public String getColumnName(int i2) {
        return ((DasTypedObject)this.myColumns.get(i2)).getName();
    }

    public boolean isColumnQuoted(int i2) {
        return DbSqlUtilCore.isQuoted((DasObject)this.myColumns.get(i2));
    }

    public DasType getColumnDasType(int i2) {
        return ((DasTypedObject)this.myColumns.get(i2)).getDasType();
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        return this.myQualifier;
    }

    @NotNull
    private DasType getDasType(int i2) {
        DasType dasType = ((DasTypedObject)this.myColumns.get(i2)).getDasType();
        if (dasType == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(3);
        }
        return dasType;
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        if (this.myTypeElement == null) {
            PsiElement psiElement = (PsiElement)this.myColumns.get(i2);
            if (psiElement == null) {
                TableBasedSqlTableTypeImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement psiElement = SqlImplUtil.wrapObjectToPsi((DasObject)this.myColumns.get(i2), this.myTypeElement.getProject());
        if (psiElement == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public PsiElement getSourceColumnElement(int i2) {
        PsiElement psiElement = this.getColumnElement(i2);
        return psiElement instanceof FakePsiElement ? psiElement.getNavigationElement() : psiElement;
    }

    public List<T> getColumns() {
        return this.myColumns;
    }

    @NotNull
    private static <T extends DasTypedObject> List<T> calcColumns(DasObject info2, PsiElement infoPsi, PsiElement place, Class<T> clazz, ObjectKind kind) {
        ArrayList columns2 = ContainerUtil.newArrayList((Iterable)info2.getDasChildren(kind).filter(clazz));
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(SqlImplUtil.getSqlDialectSafe(place), place == null ? Collections.emptyList() : SqlImplUtil.getDataSources(place));
        Map<String, DasTypedObject> named = DasUtil.newCaseAwareMap(DasUtil.isCaseSensitive(casingProvider.getCasing(ObjectKind.COLUMN, info2)));
        for (DasTypedObject column2 : columns2) {
            named.put(column2.getName(), column2);
        }
        PsiFile file = infoPsi == null ? null : infoPsi.getContainingFile();
        PsiFile placeFile = place != null ? place.getContainingFile().getOriginalFile() : null;
        Ref checkPlace = Ref.create((Object)(file == placeFile ? 1 : 0));
        Processor processor2 = instruction2 -> {
            block10: {
                IElementType instructionType;
                block9: {
                    int idx;
                    if (((Boolean)checkPlace.get()).booleanValue() && !SqlDialectImplUtilCore.placeBefore((PsiElement)instruction2, place)) {
                        return true;
                    }
                    instructionType = instruction2.getInstructionType();
                    if (instructionType != SqlCommonKeywords.SQL_MODIFY && instructionType != SqlCommonKeywords.SQL_CHANGE && instructionType != SqlCommonKeywords.SQL_RENAME) break block9;
                    String fromName = null;
                    String toName = null;
                    DasTypedObject to = null;
                    for (PsiElement element2 : SqlImplUtil.childrenIt((PsiElement)instruction2)) {
                        SqlReferenceExpression ref2;
                        if (element2 instanceof SqlTypedDefinition && clazz.isAssignableFrom(element2.getClass())) {
                            to = (DasTypedObject)clazz.cast(element2);
                            if (fromName == null) {
                                fromName = to.getName();
                            }
                            toName = to.getName();
                            break;
                        }
                        if (!(element2 instanceof SqlReferenceExpression) || (ref2 = (SqlReferenceExpression)element2).getReferenceElementType().getTargetKind() != kind) continue;
                        if (fromName != null) break;
                        fromName = ref2.getName();
                    }
                    if (to == null || (idx = columns2.indexOf(named.get(fromName))) == -1) break block10;
                    columns2.set(idx, to);
                    named.remove(fromName);
                    named.put(toName, to);
                    break block10;
                }
                if (instructionType == SqlCommonKeywords.SQL_ADD) {
                    for (DasTypedObject col : SqlImplUtil.childrenIt((PsiElement)instruction2).filter(SqlTypedDefinition.class).filter(clazz)) {
                        if (named.containsKey(col.getName())) continue;
                        columns2.add(col);
                        named.put(col.getName(), col);
                    }
                } else if (instructionType == SqlCommonKeywords.SQL_DROP) {
                    for (SqlReferenceExpression col : SqlImplUtil.childrenIt((PsiElement)instruction2).filter(SqlReferenceExpression.class)) {
                        if (col.getReferenceElementType().getTargetKind() != kind) continue;
                        DasTypedObject toDrop = (DasTypedObject)named.get(col.getName());
                        columns2.remove(toDrop);
                        named.remove(col.getName());
                    }
                }
            }
            return true;
        };
        SqlImplUtil.processAlterStatements(file, place, info2, (Processor<? super SqlAlterInstruction>)processor2);
        if (place != null && !((Boolean)checkPlace.get()).booleanValue()) {
            checkPlace.set((Object)true);
            SqlImplUtil.processAlterStatements(place.getContainingFile(), place, info2, (Processor<? super SqlAlterInstruction>)processor2);
        }
        ArrayList arrayList = columns2;
        if (arrayList == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getColumnTypeAlias(int i2) {
        return this.myTableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/TableBasedSqlTableTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/TableBasedSqlTableTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toDataType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

