/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlValuesParameterInfoUtils {
    private SqlValuesParameterInfoUtils() {
    }

    public static int getCurrentParameterIndex(@NotNull SqlExpressionList element2, int offset) {
        if (element2 == null) {
            SqlValuesParameterInfoUtils.$$$reportNull$$$0(0);
        }
        ASTNode node2 = element2.getNode();
        SyntaxTraverser s2 = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)node2).expandAndSkip(Conditions.is((Object)node2))).forceDisregard(Conditions.compose((Function)SyntaxTraverser.astApi().TO_TYPE, (Condition)Conditions.is((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        return SqlValuesParameterInfoUtils.getCurrentParameterIndex(s2, offset, (IElementType)SqlCommonTokens.SQL_COMMA);
    }

    private static <V> int getCurrentParameterIndex(SyntaxTraverser<V> s2, int offset, IElementType delimiterType) {
        Object root2 = s2.getRoot();
        int curOffset = s2.api.rangeOf(root2).getStartOffset();
        if (offset < curOffset) {
            return -1;
        }
        int index2 = 0;
        for (Object child : s2) {
            if (offset < (curOffset += s2.api.rangeOf(child).getLength())) break;
            IElementType type = s2.api.typeOf(child);
            if (type != delimiterType) continue;
            ++index2;
        }
        return index2;
    }

    @Nullable
    public static SqlExpressionList findExpressions(@Nullable PsiElement at) {
        if (at == null || !at.isValid()) {
            return null;
        }
        if (!(at.getContainingFile() instanceof SqlFile)) {
            return null;
        }
        SqlValuesExpression valuesExpression = (SqlValuesExpression)PsiTreeUtil.getParentOfType((PsiElement)at, SqlValuesExpression.class);
        if (valuesExpression == null) {
            return null;
        }
        for (SqlExpression expression : valuesExpression.getExpressions()) {
            if (!expression.getTextRange().contains(at.getTextRange().getStartOffset())) continue;
            return expression instanceof SqlParenthesizedExpression ? (SqlParenthesizedExpression)expression : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlValuesParameterInfoUtils", "getCurrentParameterIndex"));
    }
}

