/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypeParameterList;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTypeElementBase
extends SqlCompositeElementImpl
implements SqlTypeElement {
    protected SqlTypeElementBase(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlTypeElementBase.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlTypeElement((SqlTypeElement)this);
    }

    @NotNull
    public DasType getDasType() {
        return this.getDasTypeWithCaching();
    }

    @NotNull
    public final DasType getDasTypeWithCaching() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)this, this::computeDasType);
        if (dasType == null) {
            SqlTypeElementBase.$$$reportNull$$$0(1);
        }
        return dasType;
    }

    @NotNull
    protected DasType computeDasType() {
        DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
        if (dasBuiltinType == null) {
            SqlTypeElementBase.$$$reportNull$$$0(2);
        }
        return dasBuiltinType;
    }

    @NotNull
    protected DataType parseDataType() {
        DataType dataType = new DataTypeParser(this).parse();
        if (dataType == null) {
            SqlTypeElementBase.$$$reportNull$$$0(3);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeElementBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasTypeWithCaching";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class DataTypeParser {
        private final SqlTypeElementBase myElement;
        private String mySchema;
        private final StringBuilder myTypeName;

        DataTypeParser(@NotNull SqlTypeElementBase element2) {
            if (element2 == null) {
                DataTypeParser.$$$reportNull$$$0(0);
            }
            this.mySchema = null;
            this.myTypeName = new StringBuilder();
            this.myElement = element2;
        }

        @NotNull
        public DataType parse() {
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)this.myElement);
            int state = 0;
            String suffix2 = null;
            int i1 = -1;
            int i2 = 0;
            LengthUnit unit = null;
            boolean setof = false;
            StringBuilder vague = new StringBuilder();
            for (PsiElement cur = this.myElement.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
                String text2;
                ASTNode node2 = cur.getNode();
                IElementType type = node2 == null ? null : node2.getElementType();
                boolean isIdentToken = type instanceof SqlKeywordTokenType || SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(type) || type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_IDENT_DELIMITED || type instanceof SqlIdentifierKeywordTokenType;
                String string = text2 = cur instanceof SqlTypeElement ? ((SqlTypeElement)cur).getDasType().getSpecification() : cur.getText();
                if (state == 0 && this.isGenericType()) {
                    DataType dataType = DataTypeFactory.of(this.parseGenericType(text2));
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(1);
                    }
                    return dataType;
                }
                if (state == 0 && (type == SqlCommonKeywords.SQL_ENUM || type == SqlCompositeElementTypes.SQL_TYPE_REFERENCE && ("enum8".equalsIgnoreCase(text2) || "enum16".equalsIgnoreCase(text2)))) {
                    DataType dataType = DataTypeFactory.ofValues(null, null, "enum", this.getEnumArgs(), false);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(2);
                    }
                    return dataType;
                }
                if (state == 0 && type == SqlCommonKeywords.SQL_SET) {
                    DataType dataType = DataTypeFactory.ofArgs(null, "set", this.getEnumVagueArgs(), false);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(3);
                    }
                    return dataType;
                }
                if (state == 0 && type instanceof SqlKeywordTokenType && text2.equalsIgnoreCase("setof")) {
                    setof = true;
                    continue;
                }
                if (state == 0 && cur instanceof SqlReferenceExpression) {
                    state = 2;
                    this.parseTypeAndSchema((SqlReferenceExpression)cur);
                    continue;
                }
                if (state < 2 && isIdentToken) {
                    state = 1;
                    DataTypeParser.spAppend(this.myTypeName, cur instanceof SqlStringTokenElement ? ((SqlStringTokenElement)cur).getTokenText() : text2);
                    continue;
                }
                if (state < 3 && (type == SqlTokens.SQL_LEFT_BRACKET || type == SqlTokens.SQL_RIGHT_BRACKET)) {
                    state = 1;
                    this.myTypeName.append(text2);
                    continue;
                }
                if ((state == 1 || state == 2) && type == SqlTokens.SQL_LEFT_PAREN) {
                    state = 3;
                    continue;
                }
                if (state == 3 && this.isNumeric(type)) {
                    ++state;
                    i1 = StringUtil.parseInt((String)text2, (int)i1);
                    continue;
                }
                if (state == 3 && type == SqlCommonKeywords.SQL_MAX) {
                    ++state;
                    i1 = Integer.MAX_VALUE;
                    continue;
                }
                if (state == 3 && dbms.isClickHouse() && type != SqlTokens.SQL_RIGHT_PAREN) {
                    if (!vague.isEmpty()) {
                        vague.append(", ");
                    }
                    vague.append(text2);
                    continue;
                }
                if (state == 4 && this.isNumeric(type)) {
                    ++state;
                    i2 = StringUtil.parseInt((String)text2, (int)i2);
                    continue;
                }
                if (state == 4 && type instanceof SqlKeywordTokenType) {
                    ++state;
                    unit = LengthUnit.of(text2);
                    continue;
                }
                if (state > 2 && type == SqlTokens.SQL_RIGHT_PAREN) {
                    state = 10;
                    continue;
                }
                if (state >= 11 || type != SqlCompositeElementTypes.SQL_TYPE_SUFFIX) continue;
                state = 11;
                suffix2 = text2;
            }
            String name2 = DasUtil.NO_NAME;
            if (!this.myTypeName.isEmpty()) {
                name2 = this.myTypeName.toString();
            }
            if (!vague.isEmpty()) {
                DataType dataType = DataTypeFactory.ofArgs(this.mySchema, name2, vague.toString(), false);
                if (dataType == null) {
                    DataTypeParser.$$$reportNull$$$0(4);
                }
                return dataType;
            }
            DataType dataType = DataTypeFactory.of(this.mySchema, name2, i1, i2, unit, suffix2, unit != null, false);
            DataType dataType2 = setof ? DataTypeFactory.of(null, "setof", -1, 0, null, dataType.getSpecification(), false, false) : dataType;
            if (dataType2 == null) {
                DataTypeParser.$$$reportNull$$$0(5);
            }
            return dataType2;
        }

        private String parseGenericType(String text2) {
            SqlTypeParameterList parameterList = (SqlTypeParameterList)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlTypeParameterList.class);
            if (parameterList == null) {
                return text2;
            }
            StringBuilder sb = new StringBuilder(text2).append("<");
            boolean first2 = true;
            boolean hasIdent = false;
            for (PsiElement child : parameterList.getChildren()) {
                IElementType type = SqlImplUtil.getElementType(child);
                if (type == SqlTokens.SQL_COLON) {
                    sb.append(child.getText());
                }
                if (type == SqlTokens.SQL_IDENT || type instanceof SqlIdentifierKeywordTokenType) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                    hasIdent = true;
                    sb.append(child.getText());
                    continue;
                }
                if (!(child instanceof SqlTypeElement)) continue;
                if (!hasIdent) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                }
                sb.append(((SqlTypeElement)child).getDasType().getSpecification());
            }
            return sb.append(">").toString();
        }

        private boolean isGenericType() {
            return PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlTypeParameterList.class) != null;
        }

        public void parseTypeAndSchema(SqlReferenceExpression cur) {
            this.myTypeName.append(StringUtil.notNullize((String)DataTypeParser.getNameAsIs(cur)));
            this.mySchema = DataTypeParser.getNameAsIs((SqlReferenceExpression)ObjectUtils.tryCast((Object)cur.getQualifierExpression(), SqlReferenceExpression.class));
        }

        @Nullable
        public static String getNameAsIs(@Nullable SqlReferenceExpression ref2) {
            SqlIdentifier identifier = ref2 == null ? null : ref2.getIdentifier();
            return identifier == null ? null : identifier.getText();
        }

        private static void spAppend(StringBuilder b2, String text2) {
            if (!b2.isEmpty()) {
                b2.append(' ').append(text2);
            } else {
                b2.append(text2);
            }
        }

        public boolean isNumeric(IElementType type) {
            return type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || type == SqlTokens.SQL_INTEGER_TOKEN;
        }

        @Nullable
        private String getEnumVagueArgs() {
            SqlExpressionList child = (SqlExpressionList)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlExpressionList.class);
            JBIterable items2 = SqlImplUtil.sqlChildren((PsiElement)child).filter(SqlExpression.class);
            return StringUtil.nullize((String)StringUtil.join((Iterable)items2, PsiElement::getText, (String)", "));
        }

        @NotNull
        private List<String> getEnumArgs() {
            SqlExpressionList child = (SqlExpressionList)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlExpressionList.class);
            JBIterable items2 = SqlImplUtil.sqlChildren((PsiElement)child).filter(SqlExpression.class);
            List list = ContainerUtil.map((Iterable)items2, PsiElement::getText);
            if (list == null) {
                DataTypeParser.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeElementBase$DataTypeParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeElementBase$DataTypeParser";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnumArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

