/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.AliasedSqlTableType;
import com.intellij.sql.psi.impl.FlattenedAliasedSqlTableType;
import com.intellij.sql.psi.impl.SqlTableTypeComposite;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableTypeBase
extends SqlTableType {
    public static final SqlTableType EMPTY_TABLE = new Empty(){

        @Override
        public SqlTableType join(SqlTableType type) {
            return type;
        }

        @Override
        public SqlTableType add(SqlTableType type) {
            return type;
        }
    };

    public static SqlTableType ensureTableType(DasType dasType, @NotNull PsiElement element2, @Nullable PsiElement qualifier) {
        if (element2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(0);
        }
        if (dasType instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)dasType;
            return tableType2;
        }
        return SqlTableTypeBase.createType(element2, dasType, element2 instanceof SqlNameElement ? ((SqlNameElement)element2).getName() : element2.getText(), element2 instanceof SqlNameElement && ((SqlNameElement)element2).isQuotedIdentifier(), false, qualifier, null);
    }

    public static SqlTableType createType(final @NotNull PsiElement element2, final @NotNull DasType dasType, final @Nullable String name2, final boolean quoted, final boolean generated, final @Nullable PsiElement qualifier, final @Nullable String aliasName) {
        if (element2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(1);
        }
        if (dasType == null) {
            SqlTableTypeBase.$$$reportNull$$$0(2);
        }
        String colTypeSpec = dasType.getSpecification();
        final DataType dataType = DataTypeFactory.ofArgs(null, "table", (String)(name2 == null ? colTypeSpec : name2 + " " + colTypeSpec), false);
        return new SqlTableTypeBase(){

            @NotNull
            public List<DasObject> getMethods() {
                List<DasObject> list = Collections.emptyList();
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public DataType toDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return dataType2;
            }

            public int getColumnCount() {
                return 1;
            }

            public String getColumnName(int i2) {
                return name2;
            }

            public boolean isColumnQuoted(int i2) {
                return quoted;
            }

            public DasType getColumnDasType(int i2) {
                return dasType;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).resolve() : element2;
            }

            @Override
            @Nullable
            public PsiElement getImmediateSourceColumnElement(int i2) {
                return element2;
            }

            @Override
            @Nullable
            public PsiElement getTypeElement() {
                PsiElement e2 = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).resolve() : element2;
                DasTable table = e2 instanceof PsiColumn ? ((PsiColumn)e2).getTable() : null;
                return table instanceof PsiElement ? (PsiElement)table : null;
            }

            @Override
            @Nullable
            public String getColumnTypeAlias(int i2) {
                return aliasName;
            }

            public boolean isGeneratedColumn(int i2) {
                return generated;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toDataType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static SqlTableType createUnresolvedTableType(@NotNull PsiReference reference) {
        if (reference == null) {
            SqlTableTypeBase.$$$reportNull$$$0(3);
        }
        return new UnresolvedRefType(reference);
    }

    public static SqlTableType createType(@NotNull DasTable info2, @Nullable PsiElement tableElement, @Nullable PsiElement place) {
        if (info2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(4);
        }
        return TableBasedSqlTableTypeImpl.createTypeWithColumns(info2, tableElement, place, DasColumn.class, ObjectKind.COLUMN);
    }

    @NotNull
    public static SqlTableType createObjectTypeType(@NotNull DasObject info2, @NotNull PsiElement typeElement, @Nullable PsiElement place) {
        if (info2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(5);
        }
        if (typeElement == null) {
            SqlTableTypeBase.$$$reportNull$$$0(6);
        }
        return SqlTableTypeBase.createObjectTypeType(info2, typeElement, place, true);
    }

    @NotNull
    public static SqlTableType createObjectTypeType(@NotNull DasObject info2, @NotNull PsiElement typeElement, @Nullable PsiElement place, boolean withAttributes) {
        SqlTableType superTypeType;
        DbCustomType superType;
        TableBasedSqlTableTypeImpl res2;
        if (info2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(7);
        }
        if (typeElement == null) {
            SqlTableTypeBase.$$$reportNull$$$0(8);
        }
        TableBasedSqlTableTypeImpl<Object> tableBasedSqlTableTypeImpl = res2 = withAttributes ? TableBasedSqlTableTypeImpl.createTypeWithColumns(info2, typeElement, place, DasTypedObject.class, ObjectKind.OBJECT_ATTRIBUTE) : TableBasedSqlTableTypeImpl.createTypeWithoutColumns(info2, typeElement, place);
        if (info2 instanceof DbCustomType && (superType = ((DbCustomType)info2).getSuperType()) != null && (superTypeType = (SqlTableType)RecursionManager.doPreventingRecursion((Object)superType.getDelegate(), (boolean)true, () -> SqlTableTypeBase.createObjectTypeType(superType, superType, null))) != null) {
            SqlTableType sqlTableType = SqlTableTypeBase.inherit(res2, superTypeType);
            if (sqlTableType == null) {
                SqlTableTypeBase.$$$reportNull$$$0(9);
            }
            return sqlTableType;
        }
        TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl2 = res2;
        if (tableBasedSqlTableTypeImpl2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(10);
        }
        return tableBasedSqlTableTypeImpl2;
    }

    static SqlTableType inherit(SqlTableType type, SqlTableType superType) {
        final List methods = ContainerUtil.concat((List)type.getMethods(), (List)superType.getMethods());
        final DataType dataType = DataTypeFactory.of(StringUtil.notNullize((String)type.getTypeName()));
        return new SqlTableTypeComposite(superType, type){

            @Override
            @NotNull
            public List<DasObject> getMethods() {
                List list = methods;
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public DataType toDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return dataType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toDataType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public PsiElement getTypeElement() {
        return null;
    }

    @Nullable
    public PsiElement getImmediateTypeElement() {
        return this.getTypeElement();
    }

    @Nullable
    public String getTypeName() {
        return null;
    }

    @Nullable
    public String getColumnTypeAlias(int i2) {
        return null;
    }

    public boolean isColumnTypeAliasQuoted(int i2) {
        return (Boolean)ObjectUtils.chooseNotNull((Object)SqlTableTypeBase.isQuoted(this.getColumnQualifier(i2)), (Object)false);
    }

    @Nullable
    public PsiElement getImmediateSourceColumnElement(int i2) {
        return this.getSourceColumnElement(i2);
    }

    @Nullable
    protected static Boolean isQuoted(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof SqlNameElement) {
            return DbSqlUtilCore.isQuoted((SqlNameElement)element2);
        }
        if (element2 instanceof DasObject) {
            return DbSqlUtilCore.isQuoted((DasObject)element2);
        }
        return null;
    }

    public SqlTableType join(SqlTableType type) {
        return SqlTableTypeComposite.join(this, type);
    }

    public SqlTableType add(SqlTableType type) {
        return SqlTableTypeComposite.add(this, type);
    }

    public SqlTableType subtract(@Nullable PsiElement element2) {
        return SubtractedSqlTableTypeImpl.subtract((SqlTableType)this, element2);
    }

    public SqlTableType subtract(int columnIndex) {
        return SubtractedSqlTableTypeImpl.subtract((SqlTableType)this, columnIndex);
    }

    public SqlTableType alias(String aliasName, @Nullable PsiElement aliasElement, @NotNull List<? extends SqlNameElement> newColumns) {
        if (newColumns == null) {
            SqlTableTypeBase.$$$reportNull$$$0(11);
        }
        return AliasedSqlTableType.fromNames(this, aliasName, aliasElement, newColumns);
    }

    public SqlTableType aliasByDefs(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlDefinition> newColumns) {
        if (newColumns == null) {
            SqlTableTypeBase.$$$reportNull$$$0(12);
        }
        return AliasedSqlTableType.fromDefs(this, aliasName, aliasElement, newColumns);
    }

    public SqlTableType flattenedAlias(String aliasName, PsiElement aliasElement, SqlElement sourceElement) {
        return new FlattenedAliasedSqlTableType((SqlTableType)this, aliasName, aliasElement, sourceElement);
    }

    public static <T> List<T> expand(List<T> aliases, int size) {
        ArrayList<T> res2 = new ArrayList<T>(aliases);
        for (int i2 = res2.size(); i2 < size; ++i2) {
            res2.add(null);
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableTypeBase";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectTypeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureTableType";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUnresolvedTableType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createObjectTypeType";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "aliasByDefs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }

    public static class UnresolvedRefType
    extends Empty {
        private final PsiReference myReference;

        public UnresolvedRefType(PsiReference reference) {
            this.myReference = reference;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myReference.getCanonicalText();
        }

        @Override
        @Nullable
        public PsiElement getTypeElement() {
            return this.myReference.getElement();
        }
    }

    public static class Empty
    extends SqlTableTypeBase {
        @NotNull
        public List<DasObject> getMethods() {
            List<DasObject> list = Collections.emptyList();
            if (list == null) {
                Empty.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = DataTypeFactory.of("table()");
            if (dataType == null) {
                Empty.$$$reportNull$$$0(1);
            }
            return dataType;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int i2) {
            throw new NoSuchElementException();
        }

        public boolean isColumnQuoted(int i2) {
            throw new NoSuchElementException();
        }

        public DasType getColumnDasType(int i2) {
            throw new NoSuchElementException();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            throw new NoSuchElementException();
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        public PsiElement getSourceColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public String getColumnTypeAlias(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public SqlTableType subtract(PsiElement element2) {
            return this;
        }

        @Override
        public SqlTableType subtract(int columnIndex) {
            return this;
        }

        @Override
        public SqlTableType alias(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlNameElement> newColumns) {
            if (newColumns == null) {
                Empty.$$$reportNull$$$0(2);
            }
            return newColumns.isEmpty() ? this : AliasedSqlTableType.fromNames(this, aliasName, aliasElement, newColumns);
        }

        @Override
        public SqlTableType aliasByDefs(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlDefinition> newColumns) {
            if (newColumns == null) {
                Empty.$$$reportNull$$$0(3);
            }
            return newColumns.isEmpty() ? this : AliasedSqlTableType.fromDefs(this, aliasName, aliasElement, newColumns);
        }

        @Override
        public SqlTableType flattenedAlias(String aliasName, PsiElement aliasElement, SqlElement sourceElement) {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$Empty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toDataType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableTypeBase$Empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "alias";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "aliasByDefs";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

