/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNAryExpressionImpl
extends SqlExpressionImpl
implements SqlNAryExpression {
    private static final Logger LOG = Logger.getInstance(SqlNAryExpressionImpl.class);

    public SqlNAryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public List<SqlExpression> getOperands() {
        List list = SqlImplUtil.childrenIt((PsiElement)this).filter(SqlExpression.class).toList();
        if (list == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public PsiElement getOpSignElement(int i2) {
        SqlExpression op = null;
        if (i2 != 0) {
            List<SqlExpression> operands2 = this.getOperands();
            if (i2 < operands2.size()) {
                op = operands2.get(i2);
            }
        } else {
            op = this.getLOperand();
        }
        return SqlNAryExpressionImpl.getOpAfter((PsiElement)op);
    }

    @NotNull
    public SqlExpression getLOperand() {
        SqlExpression sqlExpression = this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(2);
        }
        return sqlExpression;
    }

    @Nullable
    public IElementType getOpSign() {
        SyntaxTraverser.ApiEx api;
        PsiElement sub;
        PsiElement signElement = this.getOpSignElement();
        IElementType sign = PsiUtilCore.getElementType((PsiElement)signElement);
        if (sign == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && (sub = (PsiElement)(api = SyntaxTraverser.psiApi()).children((Object)signElement).filter(e2 -> {
            IElementType type = api.typeOf(e2);
            return type != SqlCommonKeywords.SQL_NOT && type != SqlCommonKeywords.SQL_GLOBAL && !SqlTokens.WS_OR_COMMENTS.contains(type);
        }).first()) != null) {
            sign = api.typeOf((Object)sub);
        }
        if (sign == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
            PsiElement nameToken;
            SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getOpSignElement(), SqlReferenceExpression.class);
            SqlIdentifier identifier = ref2 == null ? null : ref2.getIdentifier();
            PsiElement psiElement = nameToken = identifier == null ? null : PsiTreeUtil.getDeepestFirst((PsiElement)identifier);
            if (nameToken != null) {
                sign = PsiUtilCore.getElementType((PsiElement)nameToken);
            }
        }
        return sign;
    }

    @Nullable
    public PsiElement getOpSignElement() {
        PsiElement node2 = SqlNAryExpressionImpl.getOpAfter((PsiElement)this.getLOperand());
        if (node2 == null) {
            PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{SqlStatement.class, PsiFile.class});
            LOG.error("Operator expression with no operator", new Throwable(), new Attachment[]{new Attachment("expression.txt", this.getText()), new Attachment("context.txt", (parent2 == null ? this : parent2).getText())});
        }
        return node2;
    }

    @Nullable
    private static PsiElement getOpAfter(@Nullable PsiElement el) {
        if (el == null) {
            return null;
        }
        for (ASTNode node2 = el.getNode().getTreeNext(); node2 != null; node2 = node2.getTreeNext()) {
            IElementType type = node2.getElementType();
            if (SqlTokens.WS_OR_COMMENTS.contains(type)) continue;
            if (type instanceof SqlTokenType) {
                return node2.getPsi();
            }
            if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                return node2.getPsi();
            }
            if (type == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) {
                return node2.getPsi();
            }
            if (type instanceof SqlCompositeElementType) break;
        }
        return null;
    }

    @NotNull
    public DasType getDasTypeWithOperatorResolution() {
        PsiElement opSignElement = this.getOpSignElement();
        if (opSignElement instanceof SqlReferenceExpression) {
            ResolveResult[] opResults = ((SqlReferenceExpression)opSignElement).multiResolve(false);
            if (opResults.length == 0) {
                DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
                if (dasBuiltinType == null) {
                    SqlNAryExpressionImpl.$$$reportNull$$$0(3);
                }
                return dasBuiltinType;
            }
            DasType resultType = null;
            PsiElement resultPsi = null;
            for (ResolveResult opResult : opResults) {
                DasObject dasObject;
                resultPsi = opResult.getElement();
                DasSymbol symbol = DasSymbolUtil.getSymbol(opResult);
                DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
                if (!(dasObject instanceof DasOperator)) continue;
                DasType dasType = ((DasOperator)dasObject).getResultType();
                if (resultType != null && !resultType.toDataType().equals(dasType.toDataType())) {
                    DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
                    if (dasBuiltinType == null) {
                        SqlNAryExpressionImpl.$$$reportNull$$$0(4);
                    }
                    return dasBuiltinType;
                }
                resultType = dasType;
            }
            DasType dasType = resultType != null && resultPsi != null ? SqlImplUtil.rebuildDasType(resultType, SqlImplUtil.getSqlDialectSafe((PsiElement)this), resultPsi) : DasTypeSystemBase.UNKNOWN;
            if (dasType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(5);
            }
            return dasType;
        }
        DasType dasType = this.getDasType();
        if (dasType == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(6);
        }
        return dasType;
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        DasType lDasType = this.getLOperand().getDasType();
        IElementType sign = this.getOpSign();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        DasTypeSystemBase typeSystem = dialect.getTypeSystem();
        Dbms dbms = dialect.getDbms();
        if (sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_LOGICAL_AND || sign == SqlTokens.SQL_OP_NULLSAFE_EQ || sign == SqlTokens.SQL_OP_LOGICAL_OR && (dbms.isTransactSql() || dbms.isMysql()) || sign == SqlTokens.SQL_OP_NEQ2 || sign == SqlTokens.SQL_OP_NEQ3 || sign == SqlTokens.SQL_OP_NEQ_WS || sign == SqlTokens.SQL_OP_NEQ2_WS || sign == SqlTokens.SQL_OP_NEQ3_WS || sign == SqlTokens.SQL_LIKE || sign == SqlTokens.SQL_IS) {
            DasType dasType = typeSystem.getBooleanType();
            if (dasType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(7);
            }
            return dasType;
        }
        if (sign == SqlTokens.SQL_OP_PLUS || sign == SqlTokens.SQL_OP_MINUS || sign == SqlTokens.SQL_OP_MUL || sign == SqlTokens.SQL_OP_DIV) {
            if (DasTypeUtilsKt.is(lDasType, DasTypeCategory.REAL) || DasTypeUtilsKt.is(lDasType, DasTypeCategory.DATE) || DasTypeUtilsKt.is(lDasType, DasTypeCategory.TIME) || DasTypeUtilsKt.is(lDasType, DasTypeCategory.TIMESTAMP) || DasTypeUtilsKt.is(lDasType, DasTypeCategory.DATE_TIME) || DasTypeUtilsKt.is(lDasType, DasTypeCategory.INTEGER)) {
                DasType dasType = lDasType;
                if (dasType == null) {
                    SqlNAryExpressionImpl.$$$reportNull$$$0(8);
                }
                return dasType;
            }
            DasType dasType = typeSystem.getIntType();
            if (dasType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(9);
            }
            return dasType;
        }
        if (sign == SqlTokens.SQL_OP_BITWISE_XOR || sign == SqlTokens.SQL_OP_BITWISE_AND || sign == SqlTokens.SQL_OP_BITWISE_OR || sign == SqlTokens.SQL_OP_INVERT || sign == SqlTokens.SQL_OP_LEFT_SHIFT || sign == SqlTokens.SQL_OP_RIGHT_SHIFT || sign == SqlTokens.SQL_OP_MODULO) {
            DasType dasType = typeSystem.getIntType();
            if (dasType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(10);
            }
            return dasType;
        }
        if (sign == SqlTokens.SQL_OP_CONCAT) {
            DasType dasType = typeSystem.getStringType();
            if (dasType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(11);
            }
            return dasType;
        }
        if (sign == SqlTokens.SQL_LEFT_BRACKET && lDasType instanceof DasArrayType) {
            DasArrayType arrayType = (DasArrayType)lDasType;
            DasType dasType = arrayType.getComponentType();
            if (dasType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(12);
            }
            return dasType;
        }
        DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
        if (dasBuiltinType == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(13);
        }
        return dasBuiltinType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlNAryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlNAryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLOperand";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasTypeWithOperatorResolution";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

