/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.PsiColumnWithSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyElementType;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateViewStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateViewStatement {
    public SqlCreateViewStatementImpl(@NotNull ASTNode node2) {
        if (node2 == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(0);
        }
        super(node2);
    }

    public SqlCreateViewStatementImpl(SqlTableStub stub) {
        super(stub);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateViewStatement((SqlCreateViewStatement)this);
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    public DasDataSource getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
        boolean all2;
        JBIterable result2 = JBIterable.empty();
        boolean bl = all2 = kind == null || kind == ObjectKind.NONE;
        if (kind == ObjectKind.COLUMN || all2) {
            result2 = result2.append((Iterable)JBIterable.from(this.getColumns()));
        }
        if (kind == ObjectKind.KEY || all2) {
            result2 = result2.append((Iterable)JBIterable.from(this.getDeclaredKeys()));
        }
        JBIterable jBIterable = result2;
        if (jBIterable == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    private List<SqlTableKeyDefinition> getDeclaredKeys() {
        SqlTableKeyElementType<?> pkType = SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION;
        SqlTableKeyDefinition[] children2 = (SqlTableKeyDefinition[])this.getStubOrPsiChildren(pkType, SqlTableKeyDefinition.ARRAY_FACTORY);
        return List.of(children2);
    }

    @NotNull
    public SqlColumnAliasDefinition[] getColumnAliases() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = (SqlColumnAliasDefinition[])stub.getChildrenByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION, SqlColumnAliasDefinition.ARRAY_FACTORY);
            if (sqlColumnAliasDefinitionArray == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(2);
            }
            return sqlColumnAliasDefinitionArray;
        }
        SqlColumnAliasListImpl list = (SqlColumnAliasListImpl)((Object)this.findChildByClass(SqlColumnAliasListImpl.class));
        SqlColumnAliasDefinition[] aliases = (SqlColumnAliasDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)list, SqlColumnAliasDefinition.class);
        SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = aliases == null ? SqlColumnAliasDefinition.EMPTY_ARRAY : aliases;
        if (sqlColumnAliasDefinitionArray == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(3);
        }
        return sqlColumnAliasDefinitionArray;
    }

    @NotNull
    public List<PsiColumnWithSymbol> getColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> calcColumns() {
        DasType type;
        if (SqlImplUtil.isRecursive((SqlTableDefinition)this)) {
            List<PsiColumnWithSymbol> list = Collections.emptyList();
            if (list == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        SqlExpression expression = this.getQueryExpression();
        DasType dasType = type = expression == null ? null : expression.getDasType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumnWithSymbol> list = Collections.emptyList();
            if (list == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        SqlTableType tableType2 = (SqlTableType)type;
        SqlColumnAliasDefinition[] aliases = this.getColumnAliases();
        List<SqlColumnAliasDefinition> columns2 = Arrays.asList(aliases);
        Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDbms();
        if (dbms.isPostgres() || dbms.isClickHouse() || dbms.isH2()) {
            columns2 = SqlTableTypeBase.expand(columns2, tableType2.getColumnCount());
        }
        List<PsiColumnWithSymbol> psiColumns = SqlImplUtil.createColumnInfos((SqlTableDefinition)this, tableType2.alias(this.getName(), (PsiElement)this, columns2));
        List list = ContainerUtil.unmodifiableOrEmptyList(psiColumns);
        if (list == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public SqlExpression getQueryExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getQueryExpression();
        }
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE), SqlExpression.class);
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.findChildByType(SqlCommonKeywords.SQL_TEMP_KEYWORDS) != null;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        Set<DasColumn.Attribute> set = DasUtil.NO_ATTRS;
        if (set == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(11);
        }
        if (lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)true)) {
            return SqlCreateViewStatementImpl.ignoreTablesOrViewsIfNeeded(processor2, this, lastParent, place);
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (SqlImplUtil.isProcessingChildOf(processor2, this.getKind()) && !PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)false)) {
            for (PsiColumnWithSymbol column2 : this.getColumns()) {
                if (processor2.execute((DasSymbol)column2, state)) continue;
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliases";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumns";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

