/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.Case;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a(\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u001a.\u0010\u0016\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u001d\u001a\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001a*\u00020\u001aH\u0086\u0010\u001a\u0016\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0012\u0010#\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010%\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010&\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010'\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0018\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a\u0018\u00010)*\u00020$\u001a\f\u0010*\u001a\u0004\u0018\u00010\u001a*\u00020\u001a\u001a\u000f\u0010+\u001a\u00070\u001a\u00a2\u0006\u0002\b,*\u00020\u001a\u001a\n\u0010-\u001a\u00020 *\u00020\u001a\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006."}, d2={"groupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "Lcom/intellij/sql/psi/SqlQueryExpression;", "getGroupByClause", "(Lcom/intellij/sql/psi/SqlQueryExpression;)Lcom/intellij/sql/psi/SqlGroupByClause;", "valuesKeyword", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/sql/psi/SqlInsertStatement;", "getValuesKeyword", "(Lcom/intellij/sql/psi/SqlInsertStatement;)Ljava/lang/String;", "checkEquivalence", "", "left", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "right", "createGroupByClause", "expressions", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "generateGroupByClause", "query", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "", "Lcom/intellij/sql/psi/SqlExpression;", "getKeywordCaseAware", "text", "Lcom/intellij/lang/Language;", "deparenthesize", "getElementForGroupBy", "Lcom/intellij/psi/PsiElement;", "dbms", "Lcom/intellij/database/Dbms;", "isAnd", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "isAntiEquality", "isEquality", "isOr", "splitWithReference", "Lkotlin/Pair;", "topParenthesized", "unwrapAlias", "Lorg/jetbrains/annotations/Nullable;", "wrapAlias", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/sql/intentions/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n179#2,2:167\n288#3,2:169\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/sql/intentions/UtilsKt\n*L\n21#1:167,2\n155#1:169,2\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final String getValuesKeyword(@NotNull SqlInsertStatement $this$valuesKeyword) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$valuesKeyword, (String)"<this>");
            SqlInsertDmlInstruction sqlInsertDmlInstruction = $this$valuesKeyword.getDmlInstruction();
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)(sqlInsertDmlInstruction != null && (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) != null ? sqlInsertDmlInstruction.getFirstChild() : null), (Function1)valuesKeyword.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it2 = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_VALUES)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        return psiElement != null ? psiElement.getText() : null;
    }

    public static final boolean isEquality(@NotNull SqlBinaryExpression $this$isEquality, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isEquality, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType opToken = $this$isEquality.getOpSign();
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQ)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQEQ) && (dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isSqlite());
    }

    public static final boolean isAntiEquality(@NotNull SqlBinaryExpression $this$isAntiEquality, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isAntiEquality, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType opToken = $this$isAntiEquality.getOpSign();
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ) || Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ2)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ3) || Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ4) && dbms.isOracle();
    }

    public static final boolean isOr(@NotNull SqlBinaryExpression $this$isOr, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isOr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType opToken = $this$isOr.getOpSign();
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_OR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_OR) && dbms.isMysql();
    }

    public static final boolean isAnd(@NotNull SqlBinaryExpression $this$isAnd, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType opToken = $this$isAnd.getOpSign();
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_AND)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_AND) && dbms.isMysql();
    }

    @Nullable
    public static final Pair<SqlReferenceExpression, SqlExpression> splitWithReference(@NotNull SqlBinaryExpression $this$splitWithReference) {
        Intrinsics.checkNotNullParameter((Object)$this$splitWithReference, (String)"<this>");
        SqlExpression sqlExpression = $this$splitWithReference.getLOperand();
        SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression left = sqlReferenceExpression;
        SqlExpression sqlExpression2 = $this$splitWithReference.getROperand();
        if (sqlExpression2 == null) {
            return null;
        }
        SqlExpression right = sqlExpression2;
        return TuplesKt.to((Object)left, (Object)right);
    }

    public static final boolean checkEquivalence(@NotNull SqlReferenceExpression left, @NotNull SqlReferenceExpression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified(left);
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveQualified(...)");
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> leftResolve = list;
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> list2 = SqlImplUtil.resolveQualified(right);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolveQualified(...)");
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> rightResolve = list2;
        if (leftResolve.isEmpty() && rightResolve.isEmpty()) {
            return Intrinsics.areEqual((Object)left.getText(), (Object)right.getText());
        }
        com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)CollectionsKt.singleOrNull(leftResolve);
        if (pair == null) {
            return false;
        }
        com.intellij.openapi.util.Pair leftResult = pair;
        com.intellij.openapi.util.Pair pair2 = (com.intellij.openapi.util.Pair)CollectionsKt.singleOrNull(rightResolve);
        if (pair2 == null) {
            return false;
        }
        com.intellij.openapi.util.Pair rightResult = pair2;
        if (Intrinsics.areEqual((Object)leftResult, (Object)rightResult)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)leftResult.second, (Object)left) && Intrinsics.areEqual((Object)rightResult.second, (Object)right)) {
            return Intrinsics.areEqual((Object)left.getText(), (Object)right.getText()) && Intrinsics.areEqual((Object)leftResult.first, (Object)rightResult.first);
        }
        return false;
    }

    @Nullable
    public static final SqlExpression topParenthesized(@NotNull SqlExpression $this$topParenthesized) {
        Intrinsics.checkNotNullParameter((Object)$this$topParenthesized, (String)"<this>");
        Object object = SqlImplUtil.sqlParents($this$topParenthesized.getParent()).takeWhile(arg_0 -> UtilsKt.topParenthesized$lambda$1(topParenthesized.1.INSTANCE, arg_0)).last();
        return object instanceof SqlExpression ? (SqlExpression)object : null;
    }

    @Nullable
    public static final SqlExpression deparenthesize(@NotNull SqlExpression $this$deparenthesize) {
        SqlExpression nestedExpression;
        Intrinsics.checkNotNullParameter((Object)$this$deparenthesize, (String)"<this>");
        do {
            SqlParenthesizedExpression sqlParenthesizedExpression = $this$deparenthesize instanceof SqlParenthesizedExpression ? (SqlParenthesizedExpression)$this$deparenthesize : null;
            Object object = nestedExpression = sqlParenthesizedExpression != null ? sqlParenthesizedExpression.getExpression() : null;
        } while (nestedExpression != null);
        return $this$deparenthesize;
    }

    @NotNull
    public static final String getKeywordCaseAware(@NotNull String text2, @NotNull Project project, @NotNull Language dialect) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"getSqlSettings(...)");
        SqlCodeStyleSettings settings = sqlCodeStyleSettings;
        Case case_ = settings.getKeywordCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_), (String)"getKeywordCase(...)");
        Case keywordCase = case_;
        String string = keywordCase.apply(text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
        return string;
    }

    @NotNull
    public static final SqlExpression unwrapAlias(@NotNull SqlExpression $this$unwrapAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapAlias, (String)"<this>");
        SqlAsExpression sqlAsExpression = $this$unwrapAlias instanceof SqlAsExpression ? (SqlAsExpression)$this$unwrapAlias : null;
        if (sqlAsExpression == null || (sqlAsExpression = sqlAsExpression.getExpression()) == null) {
            sqlAsExpression = $this$unwrapAlias;
        }
        return sqlAsExpression;
    }

    @NotNull
    public static final PsiElement wrapAlias(@NotNull SqlExpression $this$wrapAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapAlias, (String)"<this>");
        PsiElement p2 = $this$wrapAlias.getParent();
        if (p2 instanceof SqlAsExpression) {
            p2 = ((SqlAsExpression)p2).getParent();
        }
        PsiElement psiElement = p2;
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    @Nullable
    public static final SqlGroupByClause getGroupByClause(@NotNull SqlQueryExpression $this$groupByClause) {
        Intrinsics.checkNotNullParameter((Object)$this$groupByClause, (String)"<this>");
        SqlTableExpression sqlTableExpression = $this$groupByClause.getTableExpression();
        if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getGroupByClause()) == null) {
            sqlTableExpression = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$groupByClause), SqlGroupByClause.class);
        }
        return sqlTableExpression;
    }

    private static final PsiElement getElementForGroupBy(SqlExpression $this$getElementForGroupBy, Dbms dbms) {
        if (!($this$getElementForGroupBy instanceof SqlAsExpression)) {
            return (PsiElement)$this$getElementForGroupBy;
        }
        return dbms.isClickHouse() || dbms.isPostgres() || dbms.isH2() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isSqlite() || dbms.isSnowflake() ? (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getNameElement() : (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getExpression();
    }

    private static final SqlGroupByClause createGroupByClause(String expressions2, SqlLanguageDialect dialect, Project project) {
        String string = new DdlBuilder().configureBuilder(project, dialect).keyword("group by ").plain(expressions2).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String text2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText("select id from foo " + text2, dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlGroupByClause sqlGroupByClause = UtilsKt.getGroupByClause(sqlQueryExpression);
        Intrinsics.checkNotNull((Object)sqlGroupByClause);
        return sqlGroupByClause;
    }

    @Nullable
    public static final SqlGroupByClause generateGroupByClause(@NotNull List<? extends SqlExpression> expressions2, @NotNull SqlQueryExpression query, @NotNull SqlLanguageDialectEx dialect, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return UtilsKt.generateGroupByClause(CollectionsKt.joinToString$default((Iterable)expressions2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<SqlExpression, CharSequence>(dialect){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            {
                this.$dialect = $dialect;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                PsiElement psiElement = UtilsKt.access$getElementForGroupBy(it2, dbms);
                String string = psiElement != null ? psiElement.getText() : null;
                return string == null ? (CharSequence)"?" : (CharSequence)string;
            }
        }), (int)31, null), query, dialect, project);
    }

    @Nullable
    public static final SqlGroupByClause generateGroupByClause(@NotNull String expressions2, @NotNull SqlQueryExpression query, @NotNull SqlLanguageDialectEx dialect, @NotNull Project project) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)expressions2, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SqlTableExpression sqlTableExpression = query.getTableExpression();
        if (sqlTableExpression == null) {
            return null;
        }
        SqlTableExpression tableExpression = sqlTableExpression;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        SqlGroupByClause groupByClause = UtilsKt.createGroupByClause(expressions2, dialect, project);
        if (dbms2.isCassandra()) {
            psiElement = null;
        } else if (dbms2.isClickHouse()) {
            Object v5;
            block11: {
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it2 instanceof SqlClause)) {
                        bl = false;
                    } else {
                        PsiElement first2 = ((SqlClause)it2).getFirstChild();
                        PsiElement second = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)first2);
                        bl = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)first2), (Object)SqlCommonKeywords.SQL_WITH) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)second), (Object)SqlCommonKeywords.SQL_TOTALS);
                    }
                    if (!bl) continue;
                    v5 = element$iv;
                    break block11;
                }
                v5 = null;
            }
            if ((psiElement = (PsiElement)v5) == null) {
                psiElement = (PsiElement)tableExpression.getHavingClause();
            }
        } else if (dbms2.isDerby()) {
            SqlHavingClause sqlHavingClause = tableExpression.getHavingClause();
            psiElement = (PsiElement)(sqlHavingClause != null ? (SqlClause)sqlHavingClause : (SqlClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class));
        } else {
            psiElement = dbms2.isSqlite() ? PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class) : (PsiElement)tableExpression.getHavingClause();
        }
        PsiElement anchor2 = psiElement;
        PsiElement psiElement2 = tableExpression.addBefore((PsiElement)groupByClause, anchor2);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlGroupByClause");
        return (SqlGroupByClause)psiElement2;
    }

    private static final boolean topParenthesized$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ PsiElement access$getElementForGroupBy(SqlExpression $receiver, Dbms dbms) {
        return UtilsKt.getElementForGroupBy($receiver, dbms);
    }
}

