/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\tH\u0002J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceColumnNumberWithNameIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getRefExpr", "Lcom/intellij/sql/psi/impl/SqlPositionalReference;", "element", "Lcom/intellij/psi/PsiElement;", "getRefName", "expr", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlReplaceColumnNumberWithNameIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlReplaceColumnNumberWithNameIntention.kt\ncom/intellij/sql/intentions/SqlReplaceColumnNumberWithNameIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class SqlReplaceColumnNumberWithNameIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.column.number.with.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getRefName(element2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlPositionalReference sqlPositionalReference = this.getRefExpr(element2);
        if (sqlPositionalReference == null) {
            return;
        }
        SqlPositionalReference refExpr = sqlPositionalReference;
        String string = this.getRefName(refExpr);
        if (string == null) {
            return;
        }
        String name2 = string;
        PsiFile file = element2.getContainingFile();
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        PsiElement psiElement = refExpr.resolve();
        DasObject dasObject = psiElement instanceof DasObject ? (DasObject)psiElement : null;
        if (dasObject != null) {
            DasObject it2 = dasObject;
            boolean bl2 = false;
            bl = DbSqlUtil.isQuoted(it2);
        } else {
            bl = false;
        }
        boolean forceQuoting = bl;
        String refText = dialect.getDatabaseDialect().catToScript(name2, refExpr.getKind(), forceQuoting, false, Casing.EXACT);
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(refText, dialect, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (PsiElement)file);
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression newRefExpr = sqlReferenceExpression;
        refExpr.replace((PsiElement)newRefExpr);
    }

    private final SqlPositionalReference getRefExpr(PsiElement element2) {
        PsiElement psiElement = element2.getParent();
        return psiElement instanceof SqlPositionalReference ? (SqlPositionalReference)psiElement : null;
    }

    private final String getRefName(PsiElement element2) {
        String string;
        SqlPositionalReference sqlPositionalReference = this.getRefExpr(element2);
        if (sqlPositionalReference != null) {
            SqlPositionalReference it2 = sqlPositionalReference;
            boolean bl = false;
            string = this.getRefName(it2);
        } else {
            string = null;
        }
        return string;
    }

    private final String getRefName(SqlPositionalReference expr) {
        PsiElement source = expr.getReference().resolveImmediate();
        return source instanceof SqlColumnSymbol ? (((SqlColumnSymbol)source).getTargetDefinition() instanceof PsiNamedElement ? ((SqlColumnSymbol)source).getName() : null) : (source instanceof PsiNamedElement ? ((PsiNamedElement)source).getName() : null);
    }
}

