/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J!\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceColumnNameWithNumberIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "supportGroupByPosition", "", "Lcom/intellij/database/Dbms;", "getSupportGroupByPosition", "(Lcom/intellij/database/Dbms;)Z", "getColumnPosition", "", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "(Lcom/intellij/sql/psi/SqlReferenceExpression;)Ljava/lang/Integer;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getRefExpr", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "intellij.database.sql.impl"})
public final class SqlReplaceColumnNameWithNumberIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.column.name.with.ordinal.number", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final boolean getSupportGroupByPosition(Dbms $this$supportGroupByPosition) {
        return $this$supportGroupByPosition.isMysql() || $this$supportGroupByPosition.isPostgres() || $this$supportGroupByPosition.isExasol() || $this$supportGroupByPosition.isSqlite() || Intrinsics.areEqual((Object)$this$supportGroupByPosition, (Object)Dbms.SNOWFLAKE);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Dbms dbms = SqlImplUtil.getSqlDialectSafe(element2).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra() || dbms2.isClickHouse() || dbms2.isHive() || dbms2.isSpark() || dbms2.isHsqldb()) {
            return false;
        }
        SqlReferenceExpression sqlReferenceExpression = this.getRefExpr(element2);
        if (sqlReferenceExpression == null) {
            return false;
        }
        SqlReferenceExpression refExpr = sqlReferenceExpression;
        PsiElement parent2 = refExpr.getParent();
        return (parent2 instanceof SqlOrderByClause || parent2 instanceof SqlGroupByClause && this.getSupportGroupByPosition(dbms2)) && Intrinsics.areEqual((Object)refExpr.getReferenceElementType().getTargetKind(), (Object)ObjectKind.COLUMN) && this.getColumnPosition(refExpr) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlReferenceExpression sqlReferenceExpression = this.getRefExpr(element2);
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression refExpr = sqlReferenceExpression;
        Integer n = this.getColumnPosition(refExpr);
        if (n == null) {
            return;
        }
        int position = n;
        PsiFile file = element2.getContainingFile();
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlPositionalReference sqlPositionalReference = SqlPsiElementFactory.createPositionalReferenceFromText(position, dialect, (PsiElement)file);
        if (sqlPositionalReference == null) {
            return;
        }
        SqlPositionalReference newRefExpr = sqlPositionalReference;
        refExpr.replace((PsiElement)newRefExpr);
    }

    private final SqlReferenceExpression getRefExpr(PsiElement element2) {
        PsiElement psiElement = element2.getParent();
        SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
        PsiElement psiElement2 = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
        return psiElement2 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement2 : null;
    }

    private final Integer getColumnPosition(SqlReferenceExpression expr) {
        PsiElement source = expr.getReference().resolveImmediate();
        return source instanceof SqlColumnSymbol ? Integer.valueOf(((SqlColumnSymbol)source).getIndex() + 1) : (source instanceof DasPositioned ? Integer.valueOf(((DasPositioned)source).getPosition()) : null);
    }
}

