/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ModelExternalDataUtils;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlAddExternalRelationIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "intellij.database.sql.impl"})
public final class SqlAddExternalRelationIntention
extends SqlBaseElementAtCaretIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.store.table.relation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Couple<Pair<DasTable, List<DasColumn>>> couple = JoinUtilsKt.getRelationInfo(element2);
        if (couple == null) {
            return false;
        }
        Couple<Pair<DasTable, List<DasColumn>>> couple2 = couple;
        Pair<DasTable, List<DasColumn>> t1 = JoinUtilsKt.component1(couple2);
        Pair<DasTable, List<DasColumn>> t2 = JoinUtilsKt.component2(couple2);
        Object object = t1.getFirst();
        DbTable dbTable = object instanceof DbTable ? (DbTable)object : null;
        if (dbTable == null) {
            return false;
        }
        DbTable dbT1 = dbTable;
        Object object2 = t2.getFirst();
        DbTable dbTable2 = object2 instanceof DbTable ? (DbTable)object2 : null;
        if (dbTable2 == null) {
            return false;
        }
        DbTable dbT2 = dbTable2;
        if (!Intrinsics.areEqual((Object)dbT1.getDataSource(), (Object)dbT2.getDataSource()) || DbImplUtil.getMaybeLocalDataSource(dbT1.getDataSource()) == null) {
            return false;
        }
        Set c1 = CollectionsKt.toSet((Iterable)((Iterable)t1.getSecond()));
        Set c2 = CollectionsKt.toSet((Iterable)((Iterable)t2.getSecond()));
        return ModelRelationManager.getForeignKeys(project, dbT1, (DasTable)t2.getFirst()).filter(arg_0 -> SqlAddExternalRelationIntention.isAvailable$lambda$0((Function1)new Function1<DasForeignKey, Boolean>((Set<? extends DasColumn>)c1, (Set<? extends DasColumn>)c2){
            final /* synthetic */ Set<DasColumn> $c1;
            final /* synthetic */ Set<DasColumn> $c2;
            {
                this.$c1 = $c1;
                this.$c2 = $c2;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(DasForeignKey fk) {
                boolean bl;
                Iterable<? extends DasTypedObject> iterable = fk.getColumnsRef().resolveObjects();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"resolveObjects(...)");
                if (Intrinsics.areEqual((Object)CollectionsKt.toSet(iterable), this.$c1)) {
                    Iterable<? extends DasTypedObject> iterable2 = fk.getRefColumns().resolveObjects();
                    Intrinsics.checkNotNullExpressionValue(iterable2, (String)"resolveObjects(...)");
                    if (Intrinsics.areEqual((Object)CollectionsKt.toSet(iterable2), this.$c2)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }, arg_0)).isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Couple<Pair<DasTable, List<DasColumn>>> couple = JoinUtilsKt.getRelationInfo(element2);
        if (couple == null) {
            return;
        }
        Couple<Pair<DasTable, List<DasColumn>>> info2 = couple;
        Object object = ((Pair)info2.first).getFirst();
        DbTable dbTable = object instanceof DbTable ? (DbTable)object : null;
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dbTable != null ? dbTable.getDataSource() : null);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        ModelExternalDataUtils.modifyExternalData(project, ds, (Consumer<? super ModelExternalData.Data>)((Consumer)arg_0 -> SqlAddExternalRelationIntention.invoke$lambda$1((Function1)new Function1<ModelExternalData.Data, Unit>(info2){
            final /* synthetic */ Couple<Pair<DasTable, List<DasColumn>>> $info;
            {
                this.$info = $info;
                super(1);
            }

            public final void invoke(ModelExternalData.Data data) {
                Collection<String> collection2;
                DasColumn it2;
                Collection<String> collection3;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = (Iterable)((Pair)this.$info.first).getSecond();
                String string = null;
                ObjectPath objectPath = ObjectPaths.of((DasObject)((Pair)this.$info.first).getFirst());
                MultiMap<ObjectPath, ModelExternalData.ObjDesc> multiMap = data.objSet;
                boolean $i$f$map = false;
                void var4_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    DasColumn dasColumn = (DasColumn)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(it2.getName());
                }
                collection3 = (List)destination$iv$iv;
                $this$map$iv = (Iterable)((Pair)this.$info.second).getSecond();
                ObjectPath objectPath2 = ObjectPaths.of((DasObject)((Pair)this.$info.second).getFirst());
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (DasColumn)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it2.getName());
                }
                Collection<String> collection4 = collection2 = (List)destination$iv$iv;
                ObjectPath objectPath3 = objectPath2;
                Collection<String> collection5 = collection3;
                String string2 = string;
                multiMap.putValue((Object)objectPath, (Object)new ModelExternalData.FkDesc(string2, (List<String>)collection5, objectPath3, (List<String>)collection4));
            }
        }, arg_0)));
        String path = ModelExternalData.getExternalDataPath(ds);
        if (path != null) {
            Object[] objectArray = new Object[]{((DasTable)((Pair)info2.first).getFirst()).getName(), ((DasTable)((Pair)info2.second).getFirst()).getName(), path};
            String string = SqlBundle.message((String)"notification.content.relation.between.stored.in", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            DatabaseNotifications.GENERAL_BALLOON_GROUP.createNotification(string, NotificationType.INFORMATION).setDisplayId("SqlAddExternalRelationIntention.stored").notify(project);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static final boolean isAvailable$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

