/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.IntentionUtilsKt$getInsertStatements$;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0006*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u001e\u0010\u001d\u001a\u00020\u001e\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0003*\u0002H\u001fH\u0086\b\u00a2\u0006\u0002\u0010 \u001a\u0016\u0010!\u001a\u0004\u0018\u00010\u0003*\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"areEquivalent", "", "e1", "Lcom/intellij/psi/PsiElement;", "e2", "createGroupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "expressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "getInsertStatements", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/psi/SqlInsertStatement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "onlyValues", "isAcceptableDelimiter", "e", "statementDelimiter", "", "addGroupBy", "Lcom/intellij/sql/psi/SqlQueryExpression;", "groupByClause", "dropListItem", "", "T", "(Lcom/intellij/psi/PsiElement;)V", "getElementForGroupBy", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nintentionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 intentionUtils.kt\ncom/intellij/sql/intentions/IntentionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,140:1\n288#2,2:141\n1726#2,3:143\n473#3:146\n1224#3,2:147\n*S KotlinDebug\n*F\n+ 1 intentionUtils.kt\ncom/intellij/sql/intentions/IntentionUtilsKt\n*L\n31#1:141,2\n93#1:143,3\n123#1:146\n133#1:147,2\n*E\n"})
public final class IntentionUtilsKt {
    @Nullable
    public static final SqlGroupByClause addGroupBy(@NotNull SqlQueryExpression $this$addGroupBy, @NotNull SqlGroupByClause groupByClause) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$addGroupBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)groupByClause, (String)"groupByClause");
        SqlTableExpression sqlTableExpression = $this$addGroupBy.getTableExpression();
        if (sqlTableExpression == null) {
            return null;
        }
        SqlTableExpression tableExpression = sqlTableExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)$this$addGroupBy);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra()) {
            psiElement = null;
        } else if (dbms2.isClickHouse()) {
            Object v6;
            block11: {
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it2 instanceof SqlClause)) {
                        bl = false;
                    } else {
                        PsiElement first2 = ((SqlClause)it2).getFirstChild();
                        PsiElement second = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)first2);
                        bl = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)first2), (Object)SqlCommonKeywords.SQL_WITH) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)second), (Object)SqlCommonKeywords.SQL_TOTALS);
                    }
                    if (!bl) continue;
                    v6 = element$iv;
                    break block11;
                }
                v6 = null;
            }
            if ((psiElement = (PsiElement)v6) == null) {
                psiElement = (PsiElement)tableExpression.getHavingClause();
            }
        } else if (dbms2.isDerby()) {
            SqlHavingClause sqlHavingClause = tableExpression.getHavingClause();
            psiElement = (PsiElement)(sqlHavingClause != null ? (SqlClause)sqlHavingClause : (SqlClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class));
        } else {
            psiElement = dbms2.isSqlite() ? PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class) : (PsiElement)tableExpression.getHavingClause();
        }
        PsiElement anchor2 = psiElement;
        PsiElement psiElement2 = tableExpression.addBefore((PsiElement)groupByClause, anchor2);
        return psiElement2 instanceof SqlGroupByClause ? (SqlGroupByClause)psiElement2 : null;
    }

    @Nullable
    public static final SqlGroupByClause createGroupByClause(@NotNull List<? extends SqlExpression> expressions2, @NotNull SqlLanguageDialect dialect, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SqlPsiElementFactory.createGroupByClause(CollectionsKt.joinToString$default((Iterable)expressions2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<SqlExpression, CharSequence>(dialect){
            final /* synthetic */ SqlLanguageDialect $dialect;
            {
                this.$dialect = $dialect;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                PsiElement psiElement = IntentionUtilsKt.access$getElementForGroupBy(it2, dbms);
                String string = psiElement != null ? psiElement.getText() : null;
                return string == null ? (CharSequence)"?" : (CharSequence)string;
            }
        }), (int)31, null), dialect, project);
    }

    private static final PsiElement getElementForGroupBy(SqlExpression $this$getElementForGroupBy, Dbms dbms) {
        if (!($this$getElementForGroupBy instanceof SqlAsExpression)) {
            return (PsiElement)$this$getElementForGroupBy;
        }
        return dbms.isClickHouse() || dbms.isPostgres() || dbms.isH2() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isSqlite() || dbms.isSnowflake() ? (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getNameElement() : (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getExpression();
    }

    public static final /* synthetic */ <T extends PsiElement> void dropListItem(T $this$dropListItem) {
        Intrinsics.checkNotNullParameter($this$dropListItem, (String)"<this>");
        boolean $i$f$dropListItem = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        PsiElement prevItem = PsiTreeUtil.getPrevSiblingOfType($this$dropListItem, PsiElement.class);
        PsiElement from = null;
        PsiElement to = null;
        if (prevItem != null) {
            PsiElement psiElement = prevItem.getNextSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNextSibling(...)");
            from = psiElement;
            to = $this$dropListItem;
        } else {
            from = $this$dropListItem;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            PsiElement psiElement = PsiTreeUtil.getNextSiblingOfType($this$dropListItem, PsiElement.class);
            Object object = psiElement != null ? psiElement.getPrevSibling() : null;
            if (object == null) {
                object = $this$dropListItem;
            }
            to = object;
        }
        $this$dropListItem.getParent().deleteChildRange(from, to);
    }

    private static final boolean areEquivalent(PsiElement e1, PsiElement e2) {
        boolean bl;
        block9: {
            if (e1 == e2) {
                return true;
            }
            if ((e1 instanceof PsiWhiteSpace || e1 instanceof PsiComment) && (e2 instanceof PsiWhiteSpace || e2 instanceof PsiComment)) {
                return true;
            }
            if (e1 instanceof SqlResultSetExpression && e2 instanceof SqlResultSetExpression) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)e1), (Object)PsiUtilCore.getElementType((PsiElement)e2))) {
                return false;
            }
            if (e1 instanceof LeafPsiElement) {
                return e2 instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)e1).getText(), (Object)((LeafPsiElement)e2).getText());
            }
            List list = SqlImplUtil.sqlChildren(e1).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List children1 = list;
            List list2 = SqlImplUtil.sqlChildren(e2).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
            List children2 = list2;
            if (children1.size() != children2.size()) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)children1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i2 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    Object e3 = children1.get(i2);
                    Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
                    PsiElement psiElement = (PsiElement)e3;
                    Object e4 = children2.get(i2);
                    Intrinsics.checkNotNullExpressionValue(e4, (String)"get(...)");
                    if (IntentionUtilsKt.areEquivalent(psiElement, (PsiElement)e4)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isAcceptableDelimiter(PsiElement e2, String statementDelimiter) {
        return e2 instanceof PsiWhiteSpace || e2 instanceof PsiComment || e2 instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)e2).getText(), (Object)statementDelimiter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<SqlInsertStatement> getInsertStatements(@NotNull Editor editor2, @NotNull PsiFile file, boolean onlyValues) {
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int startOffset = selectionModel2.getSelectionStart();
        int endOffset = selectionModel2.getSelectionEnd();
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), SqlInsertStatement.class, (boolean)false);
        if (sqlInsertStatement == null) {
            return SequencesKt.emptySequence();
        }
        SqlInsertStatement fromStatement = sqlInsertStatement;
        String string = DbSqlUtil.getDelimiterAt(file, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDelimiterAt(...)");
        String delimiter = string;
        Sequence statements2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super PsiElement>, Continuation<? super Unit>, Object>(fromStatement, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SqlInsertStatement $fromStatement;
            {
                this.$fromStatement = $fromStatement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        v0 = SqlImplUtil.siblings((PsiElement)this.$fromStatement);
                        Intrinsics.checkNotNullExpressionValue(v0, (String)"siblings(...)");
                        $this$forEach$iv = (Iterable)v0;
                        $i$f$forEach = false;
                        var5_6 = $this$forEach$iv.iterator();
lbl11:
                        // 5 sources

                        while (var5_6.hasNext()) {
                            element$iv = var5_6.next();
                            it = (PsiElement)element$iv;
                            $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1 = false;
                            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.SQL_DUMMY_BLOCK)) break block0;
                            var9_10 = SqlImplUtil.sqlChildren(it);
                            Intrinsics.checkNotNullExpressionValue(var9_10, (String)"sqlChildren(...)");
                            this.L$0 = $this$sequence;
                            this.L$1 = var5_6;
                            this.label = 1;
                            v1 = $this$sequence.yieldAll((Iterable)var9_10, (Continuation)this);
                            if (v1 != var10_2) continue;
                            return var10_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1 = false;
                        var5_6 = (Iterator<T>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl11
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = var5_6;
                this.label = 2;
                v2 = $this$sequence.yield((Object)it, (Continuation)this);
                if (v2 != var10_2) ** GOTO lbl11
                return var10_2;
                {
                    case 2: {
                        $i$f$forEach = false;
                        $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1 = false;
                        var5_6 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super PsiElement> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Sequence sequence = SequencesKt.takeWhile((Sequence)statements2, (Function1)((Function1)new Function1<PsiElement, Boolean>(delimiter){
            final /* synthetic */ String $delimiter;
            {
                this.$delimiter = $delimiter;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(PsiElement it2) {
                boolean bl;
                if (!(it2 instanceof SqlInsertStatement)) {
                    Intrinsics.checkNotNull((Object)it2);
                    if (!IntentionUtilsKt.access$isAcceptableDelimiter(it2, this.$delimiter)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getInsertStatements$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        statements2 = sequence2;
        Function1 checkStatement2 = (Function1)new Function1<SqlInsertStatement, Boolean>(onlyValues, fromStatement){
            final /* synthetic */ boolean $onlyValues;
            final /* synthetic */ SqlInsertStatement $fromStatement;
            {
                this.$onlyValues = $onlyValues;
                this.$fromStatement = $fromStatement;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull SqlInsertStatement s2) {
                boolean bl;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                        if (!this.$onlyValues) break block4;
                        SqlInsertDmlInstruction sqlInsertDmlInstruction = s2.getDmlInstruction();
                        if ((sqlInsertDmlInstruction != null ? sqlInsertDmlInstruction.getValuesExpression() : null) == null) break block5;
                    }
                    if (IntentionUtilsKt.access$areEquivalent((PsiElement)s2, (PsiElement)this.$fromStatement)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        if (selectionModel2.hasSelection()) {
            boolean bl;
            block7: {
                if (UtilsKt.getValuesKeyword(fromStatement) == null) {
                    return SequencesKt.emptySequence();
                }
                if (fromStatement.getTextRange().getStartOffset() != startOffset) {
                    return SequencesKt.emptySequence();
                }
                Sequence $this$all$iv = statements2 = SequencesKt.takeWhile((Sequence)statements2, (Function1)((Function1)new Function1<SqlInsertStatement, Boolean>(endOffset){
                    final /* synthetic */ int $endOffset;
                    {
                        this.$endOffset = $endOffset;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull SqlInsertStatement it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return it2.getTextRange().getEndOffset() <= this.$endOffset;
                    }
                }));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    if (((Boolean)checkStatement2.invoke(element$iv)).booleanValue()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (!bl) {
                return SequencesKt.emptySequence();
            }
        } else {
            statements2 = SequencesKt.takeWhile((Sequence)statements2, (Function1)checkStatement2);
        }
        return statements2;
    }

    public static final /* synthetic */ PsiElement access$getElementForGroupBy(SqlExpression $receiver, Dbms dbms) {
        return IntentionUtilsKt.getElementForGroupBy($receiver, dbms);
    }

    public static final /* synthetic */ boolean access$isAcceptableDelimiter(PsiElement e2, String statementDelimiter) {
        return IntentionUtilsKt.isAcceptableDelimiter(e2, statementDelimiter);
    }

    public static final /* synthetic */ boolean access$areEquivalent(PsiElement e1, PsiElement e2) {
        return IntentionUtilsKt.areEquivalent(e1, e2);
    }
}

