/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.types;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.types.SqlDfType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H&J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0003H&J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lcom/intellij/sql/inspections/dataflow/types/SqlDfPrimitiveType;", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfType;", "asString", "", "doFromRelation", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "relationType", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "doIsSuperType", "", "other", "doJoin", "doMeet", "doSetNullability", "nullability", "Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "doTryJoinExactly", "doTryNegate", "fromRelation", "getTypePresentation", "isSuperType", "join", "meet", "setNullability", "tryJoinExactly", "tryNegate", "intellij.database.sql.core.impl"})
public interface SqlDfPrimitiveType
extends SqlDfType {
    @Override
    @NotNull
    default public DfType setNullability(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        SqlDfaNullability sqlDfaNullability = nullability;
        return sqlDfaNullability == this.getNullability() ? (DfType)this : (sqlDfaNullability == SqlDfaNullability.NULL ? (DfType)SqlDfTypesKt.getNULL() : this.doSetNullability(nullability));
    }

    default public boolean isSuperType(@NotNull DfType other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULL()) && SqlDfTypesKt.isNullable(this)) {
            return true;
        }
        DfType thisDropped = this.dropNullability();
        DfType otherDropped = SqlDfTypesKt.dropNullability(other);
        if (!(thisDropped instanceof SqlDfPrimitiveType) && !thisDropped.isSuperType(otherDropped)) {
            return false;
        }
        if (thisDropped instanceof SqlDfPrimitiveType && !((SqlDfPrimitiveType)thisDropped).doIsSuperType(otherDropped)) {
            return false;
        }
        return this.getNullability() == SqlDfTypesKt.nullability(other) || SqlDfTypesKt.isNullable(this) && SqlDfTypesKt.nullability(other) != SqlDfaNullability.UNKNOWN;
    }

    @NotNull
    default public DfType join(@NotNull DfType other) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULL())) {
            dfType = SqlDfTypesKt.setNullable(this);
        } else if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNOT_NULL()) && SqlDfTypesKt.isNotNull(this)) {
            dfType = SqlDfTypesKt.getNOT_NULL();
        } else if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULLABLE()) && this.getNullability() != SqlDfaNullability.UNKNOWN) {
            dfType = SqlDfTypesKt.getNULLABLE();
        } else {
            DfType dfType2;
            DfType thisDropped = this.dropNullability();
            DfType otherDropped = SqlDfTypesKt.dropNullability(other);
            if (thisDropped instanceof SqlDfPrimitiveType) {
                dfType2 = ((SqlDfPrimitiveType)thisDropped).doJoin(otherDropped);
            } else {
                DfType dfType3 = thisDropped.join(otherDropped);
                dfType2 = dfType3;
                Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"join(...)");
            }
            DfType result2 = dfType2;
            dfType = SqlDfTypesKt.setNullability(result2, this.getNullability().unite(SqlDfTypesKt.nullability(other)));
        }
        return dfType;
    }

    @Nullable
    default public DfType tryJoinExactly(@NotNull DfType other) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULL())) {
            object = SqlDfTypesKt.setNullable(this);
        } else if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNOT_NULL()) && SqlDfTypesKt.isNotNull(this)) {
            object = SqlDfTypesKt.getNOT_NULL();
        } else if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULLABLE()) && this.getNullability() != SqlDfaNullability.UNKNOWN) {
            object = SqlDfTypesKt.getNULLABLE();
        } else {
            DfType result2;
            DfType thisDropped = this.dropNullability();
            DfType otherDropped = SqlDfTypesKt.dropNullability(other);
            DfType dfType = result2 = thisDropped instanceof SqlDfPrimitiveType ? ((SqlDfPrimitiveType)thisDropped).doTryJoinExactly(otherDropped) : thisDropped.tryJoinExactly(otherDropped);
            object = dfType != null ? SqlDfTypesKt.setNullability(dfType, this.getNullability().unite(SqlDfTypesKt.nullability(other))) : null;
        }
        return object;
    }

    @NotNull
    default public DfType meet(@NotNull DfType other) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULL()) && SqlDfTypesKt.isNullable(this)) {
            dfType = other;
        } else if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULL()) && SqlDfTypesKt.isNotNull(this)) {
            DfType dfType2 = DfType.BOTTOM;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
        } else if (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNOT_NULL()) && SqlDfTypesKt.isNotNull(this) || Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULLABLE()) && this.getNullability() != SqlDfaNullability.UNKNOWN) {
            dfType = this;
        } else {
            SqlDfaNullability nullability;
            DfType dfType3;
            DfType thisDropped = this.dropNullability();
            DfType otherDropped = SqlDfTypesKt.dropNullability(other);
            if (thisDropped instanceof SqlDfPrimitiveType) {
                dfType3 = ((SqlDfPrimitiveType)thisDropped).doMeet(otherDropped);
            } else {
                DfType dfType4 = thisDropped.meet(otherDropped);
                dfType3 = dfType4;
                Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"meet(...)");
            }
            DfType result2 = dfType3;
            SqlDfaNullability sqlDfaNullability = nullability = this.getNullability().intersect(SqlDfTypesKt.nullability(other));
            DfType dfType5 = sqlDfaNullability != null ? SqlDfTypesKt.setNullability(result2, sqlDfaNullability) : DfType.BOTTOM;
            Intrinsics.checkNotNull((Object)dfType5);
            dfType = dfType5;
        }
        return dfType;
    }

    @Nullable
    default public DfType tryNegate() {
        if (!SqlDfTypesKt.isNotNull(this)) {
            return null;
        }
        return this.doTryNegate();
    }

    @NotNull
    default public DfType fromRelation(@NotNull RelationType relationType) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)relationType, (String)"relationType");
        if (!SqlDfTypesKt.isNotNull(this)) {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
        } else {
            dfType = this.doFromRelation(relationType);
        }
        return dfType;
    }

    @NotNull
    public DfType doSetNullability(@NotNull SqlDfaNullability var1);

    public boolean doIsSuperType(@NotNull DfType var1);

    @NotNull
    public DfType doJoin(@NotNull DfType var1);

    @Nullable
    public DfType doTryJoinExactly(@NotNull DfType var1);

    @NotNull
    public DfType doMeet(@NotNull DfType var1);

    @Nullable
    default public DfType doTryNegate() {
        return null;
    }

    @NotNull
    default public DfType doFromRelation(@NotNull RelationType relationType) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)relationType, (String)"relationType");
        if (relationType == RelationType.EQ) {
            dfType = this;
        } else {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
        }
        return dfType;
    }

    @NotNull
    default public String asString() {
        return this.getNullability() == SqlDfaNullability.UNKNOWN ? this.getTypePresentation() : this.getNullability() + " " + this.getTypePresentation();
    }

    @NotNull
    public String getTypePresentation();
}

