/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.srcStorage.DbSrcChangeUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.DbSrcMigration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.editor.EditorFun;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlStorageInspection
extends LocalInspectionTool {
    @TestOnly
    public static final Key<Boolean> IGNORE_UNSAVED = Key.create((String)"IGNORE_UNSAVED");
    public static final Key<Boolean> DETAILS_ALREADY_REFRESHED = Key.create((String)"DETAILS_ALREADY_REFRESHED");

    private static boolean autoLoad() {
        return Registry.is((String)"database.automatically.load.sources");
    }

    @NotNull
    public String getShortName() {
        return "SqlStorageInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(1);
        }
        VirtualFile vfile = file.getVirtualFile();
        if (!isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (DbSrcUtilsCore.isDbSrcFile(vfile)) {
            return SqlStorageInspection.checkStorageFile(file, manager, vfile);
        }
        DatabaseElementVirtualFileImpl dbf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)vfile, DatabaseElementVirtualFileImpl.class));
        if (dbf != null && dbf.isSource()) {
            return SqlStorageInspection.checkDbVirtualFile(file, manager, dbf);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static ProblemDescriptor[] checkStorageFile(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(3);
        }
        ArrayList res2 = new ArrayList();
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkStagingConflict(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkInvalidSources(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkIntrospectionLevelOrOutdated(file, manager, vfile));
        return res2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static ProblemDescriptor checkIntrospectionLevelOrOutdated(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        ProblemDescriptor levelProblem;
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(5);
        }
        return (levelProblem = SqlStorageInspection.checkIntrospectionLevels(file, manager, vfile)) == null ? SqlStorageInspection.checkOutdated(file, manager, vfile) : levelProblem;
    }

    private static ProblemDescriptor[] checkDbVirtualFile(@NotNull PsiFile file, @NotNull InspectionManager manager, DatabaseElementVirtualFileImpl vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(7);
        }
        ArrayList res2 = new ArrayList();
        if (vfile instanceof DatabaseElementSourceVirtualFileImpl) {
            ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkTempConflict(file, manager, (DatabaseElementSourceVirtualFileImpl)vfile));
        }
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkIntrospectionLevelOrOutdated(file, manager, vfile));
        return res2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static ProblemDescriptor checkOutdated(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(9);
        }
        DbElement e2 = DbImplUtilCore.findElement(file.getProject(), vfile);
        BasicElement element2 = DbImplUtilCore.getMaybeBasicElement(e2);
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource(e2 == null ? null : e2.getDataSource());
        if (element2 == null || ds == null || !element2.isOutdated() || !ds.shouldCheckOutdated()) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, SqlBundle.message((String)"inspection.message.cached.object.differs.from.object.in.database", (Object[])new Object[0]), true, Holder.OUTDATED_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkIntrospectionLevels(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull VirtualFile vfile) {
        Project project;
        DbElement dbElement;
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(11);
        }
        if (vfile == null) {
            SqlStorageInspection.$$$reportNull$$$0(12);
        }
        if ((dbElement = DbImplUtilCore.findElement(project = file.getProject(), vfile)) == null) {
            return null;
        }
        LevelAnalyzer.Recommendation recommendation = DetailsSyncHelper.analyzeWhatToIntrospect(dbElement);
        if (!recommendation.hasContent()) {
            return null;
        }
        BasicElement element2 = (BasicElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicElement.class);
        if (element2 == null) {
            return null;
        }
        LocalDataSource dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)dbElement.getDataSource().getDelegateDataSource(), LocalDataSource.class);
        if (dataSource2 == null) {
            return null;
        }
        if (SqlStorageInspection.detailsAlreadyRefreshed(vfile)) {
            return null;
        }
        if (SqlStorageInspection.autoLoad() && DbImplUtil.isConnected(project, dataSource2)) {
            SqlStorageInspection.startIntrospection(project, dataSource2, recommendation, dbElement, vfile);
            SqlStorageInspection.markThatDetailsAlreadyRefreshed(vfile);
            return manager.createProblemDescriptor((PsiElement)file, DatabaseBundle.message("notification.content.results.might.be.wrong.due.to.low.level.introspecting", new Object[0]), true, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        ReintrospectWhatIsRecommendedFix fix = new ReintrospectWhatIsRecommendedFix(dataSource2, vfile, recommendation, dbElement);
        LocalQuickFix[] fixes = new LocalQuickFix[]{fix};
        return manager.createProblemDescriptor((PsiElement)file, DatabaseBundle.message("notification.content.results.might.be.wrong.due.to.low.level", new Object[0]), true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static boolean detailsAlreadyRefreshed(@NotNull VirtualFile vfile) {
        if (vfile == null) {
            SqlStorageInspection.$$$reportNull$$$0(13);
        }
        return DETAILS_ALREADY_REFRESHED.isIn((UserDataHolder)vfile);
    }

    private static void markThatDetailsAlreadyRefreshed(@NotNull VirtualFile vfile) {
        if (vfile == null) {
            SqlStorageInspection.$$$reportNull$$$0(14);
        }
        DETAILS_ALREADY_REFRESHED.set((UserDataHolder)vfile, (Object)Boolean.TRUE);
    }

    private static void startIntrospection(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull LevelAnalyzer.Recommendation recommendation, @NotNull DbElement dbElement, @NotNull VirtualFile fileToClose) {
        if (project == null) {
            SqlStorageInspection.$$$reportNull$$$0(15);
        }
        if (dataSource2 == null) {
            SqlStorageInspection.$$$reportNull$$$0(16);
        }
        if (recommendation == null) {
            SqlStorageInspection.$$$reportNull$$$0(17);
        }
        if (dbElement == null) {
            SqlStorageInspection.$$$reportNull$$$0(18);
        }
        if (fileToClose == null) {
            SqlStorageInspection.$$$reportNull$$$0(19);
        }
        LoaderContext loaderContext = LoaderContext.selectTasks(project, dataSource2, recommendation.tasks);
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(loaderContext);
        if (dbElement.getDelegate() instanceof BasicSourceAware) {
            asyncTask.whenComplete(AsyncUtil.getEdtExecutor(), (Function0<Unit>)((Function0)() -> {
                EditorFun.reopenVirtualFile(project, fileToClose, dbElement);
                return null;
            }));
        }
    }

    @Nullable
    private static ProblemDescriptor checkStagingConflict(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        LocalQuickFix[] fixes;
        String msg;
        DbSrcFileSystem fs;
        VirtualFile base;
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(20);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(21);
        }
        if ((base = (fs = DbSrcFileSystem.getInstance()).getSatelliteFile(vfile, DbSrcFileSystemCore.ItemType.USER_BASE, false)) == null) {
            return null;
        }
        VirtualFile orig = fs.getSatelliteFile(vfile, DbSrcFileSystemCore.ItemType.ORIG, false);
        if (orig == null) {
            msg = SqlBundle.message((String)"inspection.message.object.dropped.in.database", (Object[])new Object[0]);
            fixes = Holder.STAGING_CONFLICT_DROPPED_FIXES;
        } else {
            msg = SqlBundle.message((String)"inspection.message.object.has.changed.in.database", (Object[])new Object[0]);
            fixes = Holder.STAGING_CONFLICT_FIXES;
        }
        return manager.createProblemDescriptor((PsiElement)file, msg, true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkTempConflict(@NotNull PsiFile file, @NotNull InspectionManager manager, DatabaseElementSourceVirtualFileImpl vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(22);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(23);
        }
        if (!vfile.isModifiedByUser() || !DatabaseEditorHelper.needsRefresh(vfile, file.getProject())) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, SqlBundle.message((String)"inspection.message.object.has.changed.in.database.but.you.have.local.changes", (Object[])new Object[0]), true, Holder.TMP_CONFLICT_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkInvalidSources(final @NotNull PsiFile file, final @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(24);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(25);
        }
        return DbSrcFileSystemCore.processPath(vfile, new DbSrcFileSystemCore.ItemProcessor<ProblemDescriptor>(){

            @Override
            public ProblemDescriptor processFile(@Nullable Project p2, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                BasicModel model2;
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                Project project = file.getProject();
                if (p2 != null && p2 != project) {
                    return null;
                }
                DbSrcStorage layout = DbSrcStorageManager.getInstance(p2).getStorage(dataSourceId, true);
                DbSrcStorageDsMetadata.MetaData res2 = layout.getMetaData(path);
                if (res2 == null) {
                    return null;
                }
                DbDataSource dataSource2 = DbPsiFacade.getInstance(project).findDataSource(dataSourceId);
                if (dataSource2 == null) {
                    return null;
                }
                BasicSourceAware object = (BasicSourceAware)DbSqlUtilCore.findObjects(dataSource2, path).filter(BasicSourceAware.class).first();
                BasicModel basicModel = model2 = object == null ? null : object.getModel();
                if (model2 == null) {
                    return null;
                }
                int version = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model2.getDbms(), object.getKind());
                if (res2.introContentVersion == version) {
                    return null;
                }
                return manager.createProblemDescriptor((PsiElement)file, SqlBundle.message((String)"inspection.message.object.source.code.may.be.invalid", (Object[])new Object[0]), true, Holder.INVALID_SOURCES_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isUnsaved(VirtualFile vfile) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(vfile);
        return documentManager.isFileModified(vfile) && !Boolean.TRUE.equals(IGNORE_UNSAVED.get((UserDataHolder)document));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommendation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToClose";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStorageFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIntrospectionLevelOrOutdated";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDbVirtualFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOutdated";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIntrospectionLevels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "detailsAlreadyRefreshed";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "markThatDetailsAlreadyRefreshed";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "startIntrospection";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStagingConflict";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTempConflict";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInvalidSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Holder {
        static final LocalQuickFix[] TMP_CONFLICT_FIXES = new LocalQuickFix[]{new RegenerateFix()};
        static final LocalQuickFix[] STAGING_CONFLICT_FIXES = new LocalQuickFix[]{new RevertFix(false), new UseMyFix(), new MergeFix()};
        static final LocalQuickFix[] STAGING_CONFLICT_DROPPED_FIXES = new LocalQuickFix[]{new RevertFix(true), new UseMyFix(), new RestoreOriginalFix()};
        static final LocalQuickFix[] INVALID_SOURCES_FIXES = new LocalQuickFix[]{new ReintrospectFix()};
        static final LocalQuickFix[] OUTDATED_FIXES = new LocalQuickFix[]{new ReintrospectFix(), new DisableOutdatedCheckFix()};

        private Holder() {
        }
    }

    private static class ReintrospectWhatIsRecommendedFix
    extends ReintrospectFix {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final LocalDataSource myDataSource;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final VirtualFile myVirtualFile;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final LevelAnalyzer.Recommendation myRecommendation;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final DbElement myDbElement;

        private ReintrospectWhatIsRecommendedFix(@NotNull LocalDataSource source, @NotNull VirtualFile vfile, @NotNull LevelAnalyzer.Recommendation recommendation, @NotNull DbElement dbElement) {
            if (source == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(0);
            }
            if (vfile == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(1);
            }
            if (recommendation == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(2);
            }
            if (dbElement == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(3);
            }
            this.myDataSource = source;
            this.myVirtualFile = vfile;
            this.myRecommendation = recommendation;
            this.myDbElement = dbElement;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myRecommendation.getTitle();
            if (string == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = DatabaseBundle.message("introspection.recommendation.familyName", new Object[0]);
            if (string == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        protected LoaderContext getContext(@NotNull Project project, @NotNull PsiFile file) {
            if (project == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(6);
            }
            if (file == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(7);
            }
            if (!this.myRecommendation.hasContent()) {
                return null;
            }
            return DetailsSyncHelper.prepareContext(project, this.myDataSource, this.myRecommendation);
        }

        @Override
        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            LoaderContext context;
            if (project == null) {
                ReintrospectWhatIsRecommendedFix.$$$reportNull$$$0(8);
            }
            if ((context = this.getContext(project, file)) == null) {
                return;
            }
            AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(context);
            SqlStorageInspection.markThatDetailsAlreadyRefreshed(this.myVirtualFile);
            if (editor2 != null && this.myDbElement.getDelegate() instanceof BasicSourceAware) {
                asyncTask.whenComplete(AsyncUtil.getEdtExecutor(), (Function0<Unit>)((Function0)() -> {
                    EditorFun.reopenVirtualFile(project, editor2.getVirtualFile(), this.myDbElement);
                    return null;
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vfile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recommendation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectWhatIsRecommendedFix";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectWhatIsRecommendedFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getContext";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class RestoreOriginalFix
    extends IntentionAndQuickFixAction {
        private RestoreOriginalFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RestoreOriginalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.restore.in.database", (Object[])new Object[0]);
            if (string == null) {
                RestoreOriginalFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            VirtualFile vfile;
            if (project == null) {
                RestoreOriginalFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            VirtualFile base = DbSrcFileSystem.getInstance().getSatelliteFile(vfile, DbSrcFileSystemCore.ItemType.USER_BASE, false);
            if (base == null) {
                return;
            }
            String dsId = DbSrcUtilsCore.getDataSource(vfile);
            if (dsId == null) {
                return;
            }
            DbDataSource dataSource2 = DbPsiFacade.getInstance(project).findDataSource(dsId);
            if (dataSource2 == null) {
                return;
            }
            DbSrcMigration.showMigrationDialog(dataSource2, Collections.singleton(base), true);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RestoreOriginalFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RestoreOriginalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MergeFix
    extends IntentionAndQuickFixAction {
        private MergeFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                MergeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.merge", (Object[])new Object[0]);
            if (string == null) {
                MergeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            VirtualFile vfile;
            if (project == null) {
                MergeFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcChangeUtils.merge(project, vfile);
            }
            catch (IOException e2) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(SqlBundle.message((String)"notification.content.failed.to.merge", (Object[])new Object[]{vfile.getUrl()}), MessageType.INFO).setDisplayId("MergeFix.failed").notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$MergeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$MergeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UseMyFix
    extends IntentionAndQuickFixAction {
        private UseMyFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                UseMyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.keep.local.changes", (Object[])new Object[0]);
            if (string == null) {
                UseMyFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            VirtualFile vfile;
            if (project == null) {
                UseMyFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.resolveMy((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e2) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(SqlBundle.message((String)"notification.content.failed.to.merge", (Object[])new Object[]{vfile.getUrl()}), MessageType.INFO).setDisplayId("UseMyFix.failed").notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$UseMyFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$UseMyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RegenerateFix
    extends IntentionAndQuickFixAction {
        private RegenerateFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RegenerateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.regenerate", (Object[])new Object[0]);
            if (string == null) {
                RegenerateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            VirtualFile vfile;
            if (project == null) {
                RegenerateFix.$$$reportNull$$$0(2);
            }
            if ((vfile = file.getVirtualFile()) instanceof DatabaseElementSourceVirtualFileImpl) {
                DatabaseEditorHelper.scheduleReload(project, (DatabaseElementSourceVirtualFileImpl)vfile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RegenerateFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RegenerateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RevertFix
    extends IntentionAndQuickFixAction {
        private final boolean myForget;

        private RevertFix(boolean forget) {
            this.myForget = forget;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RevertFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)(this.myForget ? "intention.family.name.forget.local.changes" : "intention.family.name.revert.local.changes"), (Object[])new Object[0]);
            if (string == null) {
                RevertFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            VirtualFile vfile;
            if (project == null) {
                RevertFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.revert((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e2) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(SqlBundle.message((String)"notification.content.failed.to.revert", (Object[])new Object[]{vfile.getUrl()}), MessageType.INFO).setDisplayId("RevertFix.failed").notify(file.getProject());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RevertFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RevertFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DisableOutdatedCheckFix
    extends IntentionAndQuickFixAction {
        private DisableOutdatedCheckFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.disable.check", (Object[])new Object[0]);
            if (string == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, PsiFile file) {
            VirtualFile vfile;
            if (project == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(2);
            }
            LocalDataSource dataSource2 = DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtilsCore.findDataSource(vfile) : null;
            return dataSource2 != null && dataSource2.shouldCheckOutdated();
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(3);
            }
            LocalDataSource localDataSource = dataSource2 = DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtilsCore.findDataSource(vfile) : null;
            if (dataSource2 == null) {
                return;
            }
            dataSource2.setCheckOutdated(false);
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$DisableOutdatedCheckFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$DisableOutdatedCheckFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReintrospectFix
    extends IntentionAndQuickFixAction {
        private ReintrospectFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                ReintrospectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.synchronize", (Object[])new Object[0]);
            if (string == null) {
                ReintrospectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, PsiFile file) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(2);
            }
            return (dataSource2 = DbImplUtil.getMaybeLocalDataSource(DbImplUtilCore.findDataSource(project, vfile = file.getVirtualFile()))) != null && DbImplUtilCore.canConnectTo(dataSource2) && DataSourceSyncManager.getInstance().isAbleToPerform(project, dataSource2);
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            LoaderContext context;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(3);
            }
            if ((context = this.getContext(project, file)) == null) {
                return;
            }
            DataSourceUtil.performManualSyncTask(context);
        }

        @Nullable
        protected LoaderContext getContext(@NotNull Project project, @NotNull PsiFile file) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(4);
            }
            if (file == null) {
                ReintrospectFix.$$$reportNull$$$0(5);
            }
            if ((dataSource2 = DbImplUtil.getMaybeLocalDataSource(DbImplUtilCore.findDataSource(project, vfile = file.getVirtualFile()))) == null) {
                return null;
            }
            BasicElement element2 = DbSrcUtils.findElement(file.getProject(), vfile.getPath());
            IntrospectionTask task = element2 != null ? IntrospectionTasks.prepareOneElementRefreshTask(element2) : IntrospectionTasks.prepareGeneralTask();
            return LoaderContext.selectTask(project, dataSource2, task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectFix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

