/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlUnusedSubqueryItemInspection;
import com.intellij.sql.inspections.SqlUnusedVariableInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedSubqueryItemInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlUnusedSubqueryItemInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                selectClause = o.getSelectClause();
                if (selectClause == null) {
                    return;
                }
                hasNoArgAggregate = false;
                for (SqlExpression expression : selectClause.getExpressions()) {
                    Intrinsics.checkNotNull((Object)expression);
                    if (this.isStarReference(expression)) {
                        return;
                    }
                    if (!(expression instanceof SqlFunctionCallExpression) || ((SqlFunctionCallExpression)expression).getParameterList() == null) continue;
                    if (parameterList.getExpressionList().size() != 0) ** GOTO lbl-1000
                    var7_7 = ((SqlFunctionCallExpression)expression).getFunctionDefinition();
                    v0 /* !! */  = var7_7 instanceof BuiltinFunction != false ? var7_7 : null;
                    v1 = v0 /* !! */  != null ? SqlPsiUtilCoreKt.isAggregate(v0 /* !! */ ) : false;
                    if (v1) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    hasNoArgAggregate = v2;
                }
                fromExpression = new Ref.ObjectRef();
                v3 = o.getTableExpression();
                v4 /* !! */  = v3 != null && (v3 = v3.getFromClause()) != null ? v3.getFromExpression() : (fromExpression.element = null);
                if (fromExpression.element instanceof SqlAsExpression && !SqlUnusedVariableInspection.foundAnyRefs((PsiElement)fromExpression.element, (Condition<? super SqlElement>)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, visitSqlQueryExpression$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)((Function1)new Function1<SqlElement, Boolean>((Ref.ObjectRef<SqlExpression>)fromExpression, this){
                    final /* synthetic */ Ref.ObjectRef<SqlExpression> $fromExpression;
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    {
                        this.$fromExpression = $fromExpression;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(SqlElement it2) {
                        return it2 == this.$fromExpression.element ? true : it2 instanceof SqlReferenceExpression && createAnnotationVisitor.1.access$isQualifier(this.this$0, (SqlReferenceExpression)it2);
                    }
                })), o.getUseScope())) {
                    fromExpression.element = ((SqlAsExpression)fromExpression.element).getExpression();
                }
                while (fromExpression.element instanceof SqlParenthesizedExpression) {
                    Intrinsics.checkNotNullExpressionValue((Object)((SqlParenthesizedExpression)fromExpression.element).getExpressionList(), (String)"getExpressionList(...)");
                    if (expressionList.size() != 1) break;
                    fromExpression.element = expressionList.get(0);
                }
                v5 = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"emptyList(...)");
                expressionBranches = v5;
                while (fromExpression.element instanceof SqlNAryExpression) {
                    if (expressionBranches.isEmpty()) {
                        expressionBranches = new ArrayList<E>();
                    }
                    v6 = ((SqlNAryExpression)fromExpression.element).getOperands();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getOperands(...)");
                    expressionBranches.addAll(v6);
                    fromExpression.element = ((SqlNAryExpression)fromExpression.element).getLOperand();
                }
                if (fromExpression.element instanceof SqlQueryExpression) {
                    this.inspectQueryExpression((SqlQueryExpression)fromExpression.element, (SearchScope)new LocalSearchScope((PsiElement)o), expressionBranches, hasNoArgAggregate);
                }
                super.visitSqlQueryExpression(o);
            }

            private final SqlExpression skipParenthesized(SqlExpression expression) {
                PsiElement parent2;
                while ((parent2 = SqlImplUtil.sqlParent((PsiElement)expression)) instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)parent2).getExpressionList().size() == 1) {
                    createAnnotationVisitor.1 var3_3 = this_;
                    SqlExpression sqlExpression = (SqlExpression)parent2;
                    createAnnotationVisitor.1 this_ = var3_3;
                    expression = sqlExpression;
                }
                return expression;
            }

            private final boolean isQualifier(SqlReferenceExpression expression) {
                SqlExpression baseExpression = this.skipParenthesized((SqlExpression)expression);
                PsiElement psiElement = baseExpression.getParent();
                SqlReferenceExpression sqlReferenceExpression = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
                return Intrinsics.areEqual((Object)(sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null), (Object)baseExpression);
            }

            private final boolean isStarReference(SqlExpression expression) {
                boolean bl;
                block3: {
                    JBIterable jBIterable = SqlImplUtil.sqlTraverser((PsiElement)expression).filter(SqlReferenceExpression.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlReferenceExpression e2 = (SqlReferenceExpression)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"*", (Object)e2.getName())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final void inspectQueryExpression(SqlQueryExpression o2, SearchScope searchScope, List<? extends SqlExpression> expressionBranches, boolean hasNoArgAggregate) {
                boolean bl;
                List expressions2;
                block9: {
                    SqlSelectClause sqlSelectClause = o2.getSelectClause();
                    if (sqlSelectClause == null) {
                        return;
                    }
                    SqlSelectClause selectClause = sqlSelectClause;
                    List list = selectClause.getExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
                    expressions2 = list;
                    if (expressions2.size() == 1 && hasNoArgAggregate) {
                        return;
                    }
                    List list2 = selectClause.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOptions(...)");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlSelectOption it2 = (SqlSelectOption)element$iv;
                            boolean bl2 = false;
                            String string = it2.getOptionName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOptionName(...)");
                            if (!StringsKt.startsWith((String)string, (String)"DISTINCT", (boolean)true)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                for (SqlExpression expression : expressions2) {
                    PsiElement element2;
                    if (expression instanceof SqlAsExpression) {
                        this.reportErrorForName(expression, this.getErrorElementName(o2, (SqlAsExpression)expression, expressionBranches, searchScope));
                    }
                    if (SqlImplUtil.isAsteriskRef((PsiElement)expression)) {
                        Intrinsics.checkNotNull((Object)expression);
                        this.validateStarReference(o2, expression, expressionBranches, searchScope);
                        continue;
                    }
                    if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || (element2 = ((SqlReferenceExpression)expression).resolve()) == null) continue;
                    this.reportErrorForName(expression, this.getErrorElementName(o2, element2, (PsiElement)expression, expressionBranches, searchScope, false));
                }
            }

            private final void validateStarReference(SqlQueryExpression o2, SqlExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope searchScope) {
                SqlTableType dasType;
                SqlTableExpression sqlTableExpression = o2.getTableExpression();
                Object object = dasType = sqlTableExpression != null ? sqlTableExpression.getDasType() : null;
                if (dasType == null || dasType instanceof SqlTableTypeBase.Empty) {
                    return;
                }
                HashSet<String> unusedNames = new HashSet<String>(dasType.getColumnCount());
                HashSet<String> usedNames = new HashSet<String>(dasType.getColumnCount());
                int index2 = 0;
                int n = dasType.getColumnCount();
                if (index2 <= n) {
                    while (true) {
                        try {
                            PsiElement element2;
                            String name2;
                            Intrinsics.checkNotNullExpressionValue((Object)dasType.getColumnElement(index2), (String)"getColumnElement(...)");
                            String string = name2 = this.getErrorElementName(o2, element2, (PsiElement)expression, expressionBranches, searchScope, false);
                            if (string != null) {
                                unusedNames.add(string);
                            } else {
                                usedNames.add(dasType.getColumnName(index2));
                            }
                        }
                        catch (Throwable e2) {
                            return;
                        }
                        if (index2 == n) break;
                        ++index2;
                    }
                }
                if (unusedNames.isEmpty()) {
                    return;
                }
                Object[] objectArray = new Object[]{unusedNames.stream().map(arg_0 -> createAnnotationVisitor.1.validateStarReference$lambda$3(createAnnotationVisitor.validateStarReference.1.INSTANCE, arg_0)).collect(Collectors.joining(", ")), "select " + StringUtil.join((Collection)usedNames, (String)", ")};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message((String)"subquery.item.star.includes.unused", (Object[])objectArray), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final String getErrorElementName(SqlQueryExpression inspected, SqlAsExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope scope) {
                List list = expression.getColumnAliasList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumnAliasList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlDefinition colAlias = (SqlDefinition)element$iv;
                    boolean bl = false;
                    PsiElement psiElement = (PsiElement)colAlias;
                    Intrinsics.checkNotNull((Object)colAlias);
                    if (this.getErrorElementName(inspected, psiElement, (PsiElement)colAlias, expressionBranches, scope, true) != null) continue;
                    return null;
                }
                if (this.getErrorElementName(inspected, (PsiElement)expression, (PsiElement)expression, expressionBranches, scope, true) == null) {
                    return null;
                }
                Object object = expression.getNameElement();
                if (object == null || (object = object.getName()) == null) {
                    object = expression.getText();
                }
                return object;
            }

            private final String getErrorElementName(SqlQueryExpression inspected, PsiElement element2, PsiElement originalElement, List<? extends SqlExpression> expressionBranches, SearchScope scope, boolean isAlias) {
                if (SqlUnusedVariableInspection.foundAnyRefs(element2, (Condition<? super SqlElement>)((Condition)arg_0 -> createAnnotationVisitor.1.getErrorElementName$lambda$5((Function1)new Function1<SqlElement, Boolean>(this, originalElement, expressionBranches, inspected, isAlias){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ PsiElement $originalElement;
                    final /* synthetic */ List<SqlExpression> $expressionBranches;
                    final /* synthetic */ SqlQueryExpression $inspected;
                    final /* synthetic */ boolean $isAlias;
                    {
                        this.this$0 = $receiver;
                        this.$originalElement = $originalElement;
                        this.$expressionBranches = $expressionBranches;
                        this.$inspected = $inspected;
                        this.$isAlias = $isAlias;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(SqlElement it2) {
                        Intrinsics.checkNotNull((Object)it2);
                        return createAnnotationVisitor.1.access$hasOnlyLocalRefs(this.this$0, it2, this.$originalElement, this.$expressionBranches) ? true : createAnnotationVisitor.1.access$hasOnlyInnerUsages(this.this$0, this.$inspected, (PsiElement)it2, this.$isAlias);
                    }
                }, arg_0)), scope)) {
                    return null;
                }
                PsiNamedElement psiNamedElement = element2 instanceof PsiNamedElement ? (PsiNamedElement)element2 : null;
                return psiNamedElement != null ? psiNamedElement.getName() : null;
            }

            private final void reportErrorForName(SqlExpression expression, String name2) {
                if (name2 == null) {
                    return;
                }
                Object[] objectArray = new Object[]{name2};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message((String)"subquery.item.never.used", (Object[])objectArray), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final boolean hasOnlyInnerUsages(SqlQueryExpression inspected, PsiElement it2, boolean isAlias) {
                if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)inspected), (PsiElement)it2, (boolean)true)) {
                    return false;
                }
                SqlSelectClause selectClause = inspected.getSelectClause();
                if (selectClause == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)it2, (boolean)true)) {
                    return !isAlias;
                }
                Class[] classArray = new Class[]{SqlSelectClause.class};
                return PsiTreeUtil.getParentOfType((PsiElement)it2, SqlAsExpression.class, (boolean)true, (Class[])classArray) == null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasOnlyLocalRefs(SqlElement e2, PsiElement originalElement, List<? extends SqlExpression> expressionBranches) {
                SqlExpression b2;
                if (e2 == originalElement) return true;
                Iterable $this$any$iv = expressionBranches;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    b2 = (SqlExpression)element$iv;
                    boolean bl = false;
                } while (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)b2), (PsiElement)((PsiElement)e2), (boolean)true));
                return true;
            }

            private static final boolean visitSqlQueryExpression$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final String validateStarReference$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }

            private static final boolean getErrorElementName$lambda$5(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            public static final /* synthetic */ boolean access$isQualifier(createAnnotationVisitor.1 $this, SqlReferenceExpression expression) {
                return $this.isQualifier(expression);
            }

            public static final /* synthetic */ boolean access$hasOnlyLocalRefs(createAnnotationVisitor.1 $this, SqlElement e2, PsiElement originalElement, List expressionBranches) {
                return $this.hasOnlyLocalRefs(e2, originalElement, expressionBranches);
            }

            public static final /* synthetic */ boolean access$hasOnlyInnerUsages(createAnnotationVisitor.1 $this, SqlQueryExpression inspected, PsiElement it2, boolean isAlias) {
                return $this.hasOnlyInnerUsages(inspected, it2, isAlias);
            }
        };
    }
}

