/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlQueryValidatorInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNAryExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlTypeInspection
extends SqlQueryValidatorInspectionBase {
    @Override
    @Nullable
    protected SqlQueryValidatorInspectionBase.Visitor createVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly, boolean isQueryValidationPass) {
        if (dialect == null) {
            SqlTypeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlTypeInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlTypeInspection.$$$reportNull$$$0(2);
        }
        return new SqlQueryValidatorInspectionBase.Visitor(manager, dialect, result2, onTheFly, isQueryValidationPass){

            public void visitSqlAsExpression(SqlAsExpression o2) {
                super.visitSqlAsExpression(o2);
                if (this.isQueryValidationPass() || this.shouldNotCheckElement((SqlElement)o2)) {
                    return;
                }
                SqlExpression expression = o2.getExpression();
                if (expression == null) {
                    return;
                }
                DasType type = expression.getDasType();
                DasType asType = o2.getDasType();
                List aliases = o2.getColumnAliasList();
                boolean checkType = true;
                if (dialect.getDbms().isPostgres() && !aliases.isEmpty()) {
                    checkType = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)aliases.get(0)), SqlTypeElement.class) == null;
                }
                if (checkType &= !(expression instanceof SqlTableExpression) || type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, asType, (PsiElement)o2.getNameElement());
                }
                this.checkNamesUnique(aliases, null);
                if (asType instanceof SqlTableType) {
                    this.checkColumnAliasesRequired((SqlTableType)asType, o2.getNameElement());
                }
            }

            private void checkColumnAliasesRequired(SqlTableType type, SqlIdentifier elementToHighlight) {
                Dbms dbms = dialect.getDbms();
                if (!(dbms.isDerby() || dbms.isH2() || dbms.isMysql() || dbms.isMicrosoft() || dbms == Dbms.UNKNOWN)) {
                    return;
                }
                HashSet<String> s2 = new HashSet<String>();
                ArrayList<String> toReportOnAlias = new ArrayList<String>();
                for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
                    String name2 = type.getColumnName(i2);
                    if (!StringUtil.isNotEmpty((String)name2) || s2.add(name2)) continue;
                    PsiElement columnElement = type.getColumnElement(i2);
                    String columnDescription = type.getColumnDisplayName(i2);
                    if (columnElement instanceof SqlReferenceExpression || columnElement instanceof SqlAsExpression) {
                        this.addDescriptor(this.myManager.createProblemDescriptor(columnElement, SqlBundle.message((String)"column.alias.required", (Object[])new Object[]{columnDescription}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        continue;
                    }
                    toReportOnAlias.add(columnDescription);
                }
                if (!toReportOnAlias.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)elementToHighlight, SqlBundle.message((String)"inspection.message.column.alias.required.for", (Object[])new Object[]{StringUtil.join(toReportOnAlias, (String)", ")}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            public void visitSqlCreateViewStatement(SqlCreateViewStatement o2) {
                DasType type;
                super.visitSqlCreateViewStatement(o2);
                if (this.isQueryValidationPass() || this.shouldNotCheckElement((SqlElement)o2)) {
                    return;
                }
                if (PsiTreeUtil.getChildOfType((PsiElement)o2, SqlColumnAliasListImpl.class) == null) {
                    return;
                }
                SqlExpression expression = o2.getQueryExpression();
                DasType dasType = type = expression != null ? expression.getDasType() : null;
                if (type != null && type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, (DasType)SqlTableTypeBase.createType((DasTable)o2, (PsiElement)o2, null), (PsiElement)o2.getNameElement());
                }
                this.checkNamesUnique(Arrays.asList(o2.getColumnAliases()), (SqlCreateStatement)o2);
            }

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o2) {
                super.visitSqlCreateTableStatement(o2);
                if (this.isQueryValidationPass()) {
                    return;
                }
                this.checkNamesUnique(o2.getDasChildren(ObjectKind.COLUMN).filter(SqlDefinition.class).filter(c2 -> DasUtil.getKind(c2.getDasParent()) != ObjectKind.COLUMN).toList(), (SqlCreateStatement)o2);
            }

            public void visitSqlUnaryExpression(SqlUnaryExpression o2) {
                super.visitSqlUnaryExpression(o2);
                if (this.isQueryValidationPass()) {
                    return;
                }
                IElementType sign = o2.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o2.getOpSignElement(), SqlBundle.message((String)"operator.0.not.supported.by.dialect.1", (Object[])new Object[]{sign.toString(), this.myDialect.getDisplayName()}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            public void visitSqlBinaryExpression(SqlBinaryExpression o2) {
                super.visitSqlBinaryExpression(o2);
                if (this.isQueryValidationPass()) {
                    return;
                }
                IElementType sign = o2.getOpSign();
                if (sign == null) {
                    return;
                }
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    PsiElement opSignElement = o2.getOpSignElement();
                    if (opSignElement == null) {
                        return;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor(opSignElement, SqlBundle.message((String)"operator.0.not.supported.by.dialect.1", (Object[])new Object[]{sign.toString(), this.myDialect.getDisplayName()}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkNamesUnique(List<? extends SqlDefinition> definitions, @Nullable SqlCreateStatement qualifyingStatement) {
                if (definitions.isEmpty()) {
                    return;
                }
                HashMap<Object, String> toMark = new HashMap<Object, String>();
                HashMap toMark2 = new HashMap();
                HashMap<String, SqlNameElement> map2 = new HashMap<String, SqlNameElement>();
                for (SqlDefinition sqlDefinition : definitions) {
                    SqlElement oldElement;
                    boolean isPlain = !DbSqlUtilCore.isQuoted((DasObject)sqlDefinition);
                    String name2 = this.myDialect.getCasing(sqlDefinition.getKind(), (DasObject)sqlDefinition).choose(isPlain).apply(sqlDefinition.getName());
                    SqlNameElement nameElement = StringUtil.isNotEmpty((String)name2) ? sqlDefinition.getNameElement() : null;
                    if (nameElement == null || (oldElement = (SqlElement)map2.put(name2, nameElement)) == null) continue;
                    boolean added = false;
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)oldElement, (boolean)true)) {
                        toMark.put(oldElement, name2);
                        added = true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)nameElement, (boolean)true)) {
                        toMark.put(nameElement, name2);
                        added = true;
                    }
                    if (added || qualifyingStatement == null) continue;
                    SqlNameElement element2 = qualifyingStatement.getNameElement();
                    ContainerUtil.putIfNotNull((Object)element2, (Object)name2, toMark2);
                }
                for (PsiElement psiElement : toMark.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlBundle.message((String)"already.exists", (Object[])new Object[]{toMark.get(psiElement)}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
                for (PsiElement psiElement : toMark2.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlBundle.message((String)"duplicate.column", (Object[])new Object[]{toMark2.get(psiElement)}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkTypesMatching(@NotNull DasType type1, @NotNull DasType type2, PsiElement anchor2) {
                int count2;
                if (type1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                type1 = DasTypeUtilsKt.unwrap(type1);
                type2 = DasTypeUtilsKt.unwrap(type2);
                if (type1 == DasTypeSystemBase.UNKNOWN || type2 == DasTypeSystemBase.UNKNOWN) {
                    return;
                }
                if (SqlTypeInspection.isNotInspectable(type1) || SqlTypeInspection.isNotInspectable(type2)) {
                    return;
                }
                int count1 = 1.countRequiredColumns(type1);
                if (count1 != (count2 = 1.countRequiredColumns(type2)) && anchor2 != null && anchor2.isPhysical()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, SqlBundle.message((String)"incompatible.types", (Object[])new Object[]{type2.getDescription(), type1.getDescription()}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private static int countRequiredColumns(@NotNull DasType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (type instanceof DasTableType) {
                    DasTableType tableType2 = (DasTableType)type;
                    int count = 0;
                    for (int i2 = 0; i2 < tableType2.getColumnCount(); ++i2) {
                        if (tableType2.isGeneratedColumn(i2)) continue;
                        ++count;
                    }
                    return count;
                }
                return 1;
            }

            public void visitSqlWhereClause(SqlWhereClause o2) {
                super.visitSqlWhereClause(o2);
                if (!(this.isQueryValidationPass() && !this.isDml(o2) || dialect.getDbms().isCouchbase() && PsiUtilCore.getElementType((PsiElement)o2.getFirstChild()) == SqlCommonKeywords.SQL_USE)) {
                    this.checkBoolean(o2.getExpression(), true);
                }
            }

            public void visitSqlGroupByClause(SqlGroupByClause o2) {
                super.visitSqlGroupByClause(o2);
                this.checkBoolean((SqlClause)o2);
            }

            public void visitSqlHavingClause(SqlHavingClause o2) {
                super.visitSqlHavingClause(o2);
                if (!this.isQueryValidationPass()) {
                    this.checkBoolean(o2.getExpression(), true);
                }
            }

            public void visitSqlOrderByClause(SqlOrderByClause o2) {
                super.visitSqlOrderByClause(o2);
                this.checkBoolean((SqlClause)o2);
            }

            private void checkBoolean(@NotNull SqlClause clause) {
                if (clause == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!this.isQueryValidationPass() && dialect.getDbms().isMicrosoft()) {
                    for (SqlExpression expression : SqlImplUtil.sqlChildren((PsiElement)clause).filter(SqlExpression.class)) {
                        this.checkBoolean(expression, false);
                    }
                }
            }

            private boolean isDml(@NotNull SqlWhereClause clause) {
                PsiElement p2;
                if (clause == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!((p2 = clause.getParent()) instanceof SqlDmlInstruction)) {
                    return false;
                }
                PsiElement pp = p2.getParent();
                return pp instanceof SqlUpdateStatement || pp instanceof SqlDeleteStatement;
            }

            private boolean checkBooleanByType(@NotNull SqlExpression expression) {
                DasType dasType;
                if (expression == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (expression instanceof SqlNAryExpressionImpl) {
                    SqlNAryExpressionImpl nAryExpression = (SqlNAryExpressionImpl)expression;
                    dasType = nAryExpression.getDasTypeWithOperatorResolution();
                } else {
                    dasType = expression.getDasType();
                }
                DasType type = dasType;
                DasTypeCategory category = DasTypeUtilsKt.getCategoryOrUnknown(type);
                return category == DasTypeCategory.UNKNOWN || category == DasTypeCategory.BOOLEAN || type.equals(dialect.getTypeSystem().getBooleanType());
            }

            private boolean checkBooleanByStructure(@NotNull SqlExpression expression, boolean expectedValue) {
                if (expression == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (expression instanceof SqlBetweenExpression) {
                    return true;
                }
                Dbms dbms = dialect.getDbms();
                if (dbms.isMysql() && expression instanceof SqlReferenceExpression) {
                    DasTypeCategory category = DasTypeUtilsKt.getCategoryOrUnknown(expression.getDasType());
                    return category == DasTypeCategory.INTEGER || category == DasTypeCategory.UNKNOWN;
                }
                if (expression instanceof SqlOperatorExpression) {
                    IElementType opSign = ((SqlOperatorExpression)expression).getOpSign();
                    if (dbms.isClickHouse()) {
                        return Holder.CHOUSE_BOOLEAN_OPS.contains(opSign);
                    }
                    if (dbms.isMicrosoft()) {
                        return Holder.MS_BOOLEAN_OPS.contains(opSign);
                    }
                    if (dbms.isMysql()) {
                        return Holder.MYSQL_BOOLEAN_OPS.contains(opSign);
                    }
                }
                return expectedValue;
            }

            private void checkBoolean(@Nullable SqlExpression expression, boolean expected) {
                boolean isBoolean;
                SqlExpression e2 = expression;
                while (true) {
                    if (e2 instanceof SqlParenthesizedExpression) {
                        e2 = ((SqlParenthesizedExpression)e2).getExpression();
                        continue;
                    }
                    if (!(e2 instanceof SqlAsExpression)) break;
                    e2 = ((SqlAsExpression)e2).getExpression();
                }
                if (e2 == null) {
                    return;
                }
                Dbms dbms = dialect.getDbms();
                boolean bl = isBoolean = dbms.isClickHouse() || dbms.isMicrosoft() || dbms.isMysql() ? this.checkBooleanByStructure(e2, expected) : this.checkBooleanByType(e2);
                if (expected != isBoolean) {
                    boolean isWarning = dbms.isClickHouse() || dbms.isCouchbase() || dbms.isDb2() || dbms.isH2() || dbms.isHive() || dbms.isMysql() || dbms.isRedshift() || dbms.isSpark() || dbms.isSqlite() || dbms.isVertica();
                    this.reportIssue((PsiElement)expression, isWarning ? ProblemHighlightType.WARNING : ProblemHighlightType.GENERIC_ERROR, SqlBundle.message((String)(expected ? "expected.boolean.expression" : "unexpected.boolean.expression"), (Object[])new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clause";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/inspections/SqlTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypesMatching";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "countRequiredColumns";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkBoolean";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDml";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkBooleanByType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkBooleanByStructure";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isOperatorSupported(IElementType sign, SqlLanguageDialectEx dialect) {
        Dbms dbms = dialect.getDbms();
        return dbms != Dbms.UNKNOWN || dialect.isOperatorSupported(sign);
    }

    public static boolean isNotInspectable(@NotNull DasType type) {
        if (type == null) {
            SqlTypeInspection.$$$reportNull$$$0(3);
        }
        if (type instanceof SqlTableTypeBase.UnresolvedRefType) {
            return true;
        }
        SqlTableType tableType2 = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
        if (tableType2 != null) {
            int columnCount = tableType2.getColumnCount();
            if (columnCount == 0) {
                return true;
            }
            int c2 = columnCount;
            for (int i2 = 0; i2 < c2; ++i2) {
                DasType columnType = tableType2.getColumnDasType(i2);
                if (!SqlTypeInspection.isUnknownRecordType(columnType)) continue;
                return true;
            }
            return false;
        }
        return SqlTypeInspection.isUnknownRecordType(type);
    }

    private static boolean isUnknownRecordType(DasType columnType) {
        return DasTypeUtilsKt.getCategory(columnType) == DasTypeCategory.RECORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/SqlTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotInspectable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final TokenSet CHOUSE_BOOLEAN_OPS = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_AND, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_EQEQ, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_LE, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_IN, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_ILIKE, SqlCommonTokens.SQL_LEFT_BRACKET, SqlCommonTokens.SQL_QUESTION_MARK});
        private static final TokenSet MYSQL_BOOLEAN_OPS = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_NOT, SqlCommonTokens.SQL_OP_NOT2, SqlCommonTokens.SQL_OP_LOGICAL_OR, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_XOR, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_LE, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_IN, SqlCommonKeywords.SQL_REGEXP, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_RLIKE, SqlCommonKeywords.SQL_SOUNDS, SqlCommonKeywords.SQL_MEMBER, SqlCommonTokens.SQL_LEFT_BRACKET});
        private static final TokenSet MS_BOOLEAN_OPS = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_AND, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_NOT_LT, SqlCommonTokens.SQL_OP_NOT_GT, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_IN, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_CONTAINS, SqlCommonKeywords.SQL_FREETEXT, SqlCommonKeywords.SQL_MULTISET, SqlCommonTokens.SQL_LEFT_BRACKET});

        private Holder() {
        }
    }
}

