/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlShouldBeInGroupByInspection
extends SqlInspectionBase {
    private static boolean shouldReport(@NotNull Dbms dbms) {
        if (dbms == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(0);
        }
        return dbms.isClickHouse() || dbms.isDb2() || dbms.isDerby() || dbms.isExasol() || dbms.isH2() || dbms.isHsqldb() || dbms.isMicrosoft() || dbms.isOracle() || dbms.isPostgres() || dbms.isSnowflake() || dbms.isVertica();
    }

    @Nullable
    private static PsiElement resolveUnwrappingAliases(@NotNull SqlReferenceExpression ref2) {
        if (ref2 == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(1);
        }
        SqlReferenceExpression e2 = ref2;
        while (true) {
            SqlReferenceExpression next;
            if ((next = e2) instanceof SqlReferenceExpression) {
                next = next.resolve();
            } else if (next instanceof SqlAsExpression) {
                next = ((SqlAsExpression)next).getExpression();
            } else {
                return next;
            }
            if (e2 == next) {
                return e2;
            }
            e2 = next;
        }
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(4);
        }
        if (!SqlShouldBeInGroupByInspection.shouldReport(dbms = dialect.getDbms())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlQueryExpression(SqlQueryExpression o2) {
                super.visitSqlQueryExpression(o2);
                SqlTableExpression tableExpression = o2.getTableExpression();
                if (tableExpression == null || tableExpression.getWindowClause() != null) {
                    return;
                }
                SqlGroupByClause groupBy = tableExpression.getGroupByClause();
                if (groupBy != null) {
                    if (dbms.isH2()) {
                        return;
                    }
                    if (dbms.isHsqldb() || dbms.isGreenplum() || dbms == Dbms.POSTGRES) {
                        for (SqlReferenceExpression groupingRef : SqlImplUtil.sqlChildren((PsiElement)groupBy).filter(SqlReferenceExpression.class)) {
                            PsiElement target2 = SqlShouldBeInGroupByInspection.resolveUnwrappingAliases(groupingRef);
                            if (!(target2 instanceof DasColumn) || !DasUtil.isPrimary((DasColumn)target2)) continue;
                            return;
                        }
                    }
                    if (dbms.isSnowflake()) {
                        boolean groupByAll;
                        boolean bl = groupByAll = groupBy.getNode().getLastChildNode().getElementType() == SqlCommonKeywords.SQL_ALL;
                        if (groupByAll) {
                            return;
                        }
                    }
                }
                for (SqlReferenceExpression ref2 : SqlImplUtil.getNonAggregateColumnRefs(o2)) {
                    JBIterable names2 = SqlImplUtil.getResolvesNotInGroupBy(ref2, o2).transform(element2 -> SqlImplUtil.getResolvedColumnName(this.myDialect.getDatabaseDialect(), ref2, element2));
                    int size = names2.size();
                    if (size == 0) continue;
                    String strNames = StringUtil.join((Iterable)names2, (String)", ");
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ref2, SqlBundle.message((String)(size == 1 ? "column.should.be.in.group.by" : "columns.should.be.in.group.by"), (Object[])new Object[]{strNames}), (LocalQuickFix)new AddToGroupByQuickFix(), ProblemHighlightType.GENERIC_ERROR, onTheFly));
                }
            }
        };
    }

    @NotNull
    private static Iterable<CharSequence> nameElements(@NotNull SqlTableExpression tableExpression, @NotNull SqlReferenceExpression ref2, @NotNull JBIterable<PsiElement> elements2) {
        if (tableExpression == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(5);
        }
        if (ref2 == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(6);
        }
        if (elements2 == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(7);
        }
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref2).getDatabaseDialect();
        SqlTableType partType = (SqlTableType)ObjectUtils.tryCast((Object)ref2.getDasType(), SqlTableType.class);
        if (partType != null) {
            List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(ref2.getProject(), dialect, partType, tableExpression.getDasType(), null);
            ArrayList<CharSequence> filtered2 = new ArrayList<CharSequence>(elements2.size());
            Iterator it2 = elements2.iterator();
            PsiElement cur = (PsiElement)it2.next();
            for (int i2 = 0; i2 < columnNames.size(); ++i2) {
                if (partType.getColumnElement(i2) != cur) continue;
                filtered2.add(columnNames.get(i2));
                if (!it2.hasNext()) break;
                cur = (PsiElement)it2.next();
            }
            ArrayList<CharSequence> arrayList = filtered2;
            if (arrayList == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        JBIterable jBIterable = elements2.transform(element2 -> SqlImplUtil.getResolvedColumnName(dialect, ref2, element2));
        if (jBIterable == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "nameElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldReport";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnwrappingAliases";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nameElements";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class AddToGroupByQuickFix
    implements LocalQuickFix {
        private AddToGroupByQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"quickfix.name.add.to.group.by", (Object[])new Object[0]);
            if (string == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.inspections.group.name", (Object[])new Object[0]);
            if (string == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            SqlTableExpression tableExpression;
            SqlReferenceExpression ref2;
            if (project == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(3);
            }
            if ((ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)descriptor2.getPsiElement(), SqlReferenceExpression.class)) == null) {
                return;
            }
            SqlQueryExpression o2 = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref2, SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = o2 != null ? o2.getTableExpression() : null;
            if (tableExpression == null) {
                return;
            }
            SqlGroupByClause groupByClause = tableExpression.getGroupByClause();
            JBIterable<PsiElement> elements2 = SqlImplUtil.getResolvesNotInGroupBy(ref2, o2);
            if (elements2.isEmpty()) {
                return;
            }
            Iterable<CharSequence> names2 = SqlShouldBeInGroupByInspection.nameElements(tableExpression, ref2, elements2);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)o2);
            if (groupByClause == null) {
                SqlGroupByClause groupBy = SqlPsiElementFactory.createGroupByClause(StringUtil.join(names2, (String)", "), dialect, project);
                if (groupBy != null) {
                    IntentionUtilsKt.addGroupBy(o2, groupBy);
                }
                return;
            }
            PsiFile file = ref2.getContainingFile();
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            int end = groupByClause.getTextRange().getEndOffset();
            PsiElement last2 = groupByClause.getLastChild();
            boolean needComma = true;
            if (last2 == null) {
                needComma = false;
            } else {
                IElementType type = last2.getNode().getElementType();
                if (type == TokenType.ERROR_ELEMENT || type == SqlCommonKeywords.SQL_GROUP || type == SqlCommonKeywords.SQL_BY) {
                    needComma = false;
                }
            }
            document.insertString(end, (CharSequence)((needComma ? "," : "") + " " + StringUtil.join(names2, (String)", ")));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

