/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlNullComparisonInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlNullComparisonInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlNullComparisonInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlNullComparisonInspection.$$$reportNull$$$0(2);
        }
        if ((dbms = dialect.getDbms()).isSybase()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlBinaryExpression(@NotNull SqlBinaryExpression o2) {
                if (o2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)o2, SqlFunctionCallExpression.class) != null) {
                    return;
                }
                if (!this.process(o2, true)) {
                    this.process(o2, false);
                }
                super.visitSqlBinaryExpression(o2);
            }

            public boolean process(@NotNull SqlBinaryExpression o2, boolean left) {
                SqlSpecialLiteralExpression sp;
                boolean neq;
                if (o2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                IElementType sign = o2.getOpSign();
                SqlExpression r = o2.getROperand();
                SqlExpression l = o2.getLOperand();
                SqlExpression operand = left ? l : r;
                SqlExpression opposite = left ? r : l;
                boolean eq = sign == SqlCommonTokens.SQL_OP_EQ;
                boolean bl = neq = sign == SqlCommonTokens.SQL_OP_NEQ || sign == SqlCommonTokens.SQL_OP_NEQ2 || sign == SqlCommonTokens.SQL_OP_NEQ3 || sign == SqlCommonTokens.SQL_OP_NEQ_WS || sign == SqlCommonTokens.SQL_OP_NEQ2_WS || sign == SqlCommonTokens.SQL_OP_NEQ3_WS;
                if ((eq || neq) && opposite != null && operand instanceof SqlSpecialLiteralExpression && (sp = (SqlSpecialLiteralExpression)operand).isNull()) {
                    if (dbms.isTransactSql() && opposite instanceof SqlReferenceExpression && ((SqlReferenceExpression)opposite).getReferenceElementType().getTargetKind() == ObjectKind.VARIABLE) {
                        SqlSelectClause selectClause;
                        SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o2, SqlQueryExpression.class);
                        SqlSelectClause sqlSelectClause = selectClause = query == null ? null : query.getSelectClause();
                        if (PsiTreeUtil.isAncestor((PsiElement)selectClause, (PsiElement)o2, (boolean)true)) {
                            return false;
                        }
                    }
                    DdlBuilder builder = new DdlBuilder().applyCodeStyle(o2.getProject(), SqlImplUtil.getSqlDialectSafe((PsiElement)o2)).keyword("IS");
                    if (neq) {
                        builder.space().keyword("NOT");
                    }
                    String what = builder.space().keyword("NULL").getStatement();
                    String text2 = SqlBundle.message((String)"inspection.message.suspicious.comparison.with.null.probably.operator.should.be.used", (Object[])new Object[]{what});
                    String title = SqlBundle.message((String)"intention.family.name.use.operator", (Object[])new Object[]{StringUtil.toUpperCase((String)what)});
                    String replacement = opposite.getText() + " " + what;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o2, text2, (LocalQuickFix)new MyConvertFix(title, replacement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/sql/inspections/SqlNullComparisonInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSqlBinaryExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlNullComparisonInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyConvertFix
    implements LocalQuickFix {
        @IntentionFamilyName
        private final String myTitle;
        @NotNull
        private final String myReplacement;

        protected MyConvertFix(@IntentionFamilyName @NotNull String title, @NotNull String replacement) {
            if (title == null) {
                MyConvertFix.$$$reportNull$$$0(0);
            }
            if (replacement == null) {
                MyConvertFix.$$$reportNull$$$0(1);
            }
            this.myTitle = title;
            this.myReplacement = replacement;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myTitle;
            if (string == null) {
                MyConvertFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            SqlExpression replacementExpr;
            if (project == null) {
                MyConvertFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                MyConvertFix.$$$reportNull$$$0(4);
            }
            if ((replacementExpr = SqlPsiElementFactory.createExpressionFromText(this.myReplacement, SqlImplUtil.getSqlDialectSafe(element2 = descriptor2.getPsiElement()), element2.getProject(), null)) == null) {
                return;
            }
            element2.replace((PsiElement)replacementExpr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

