/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlNamedArgumentsInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlNamedArgumentsInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (!(dbms2.isOracle() || dbms2.isPostgres() || dbms2.isMicrosoft())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
                boolean bl;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                    SqlExpression sqlExpression = o2.getCallableExpression();
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                    if (sqlReferenceExpression == null) {
                        return;
                    }
                    SqlReferenceExpression callableExpression = sqlReferenceExpression;
                    DasSymbol symbol = callableExpression.resolveSymbol();
                    if (symbol instanceof BuiltinFunction) {
                        return;
                    }
                    DasSymbol dasSymbol = symbol;
                    DasObject dasObject = dasSymbol != null ? dasSymbol.getDasObject() : null;
                    DasRoutine dasRoutine = dasObject instanceof DasRoutine ? (DasRoutine)dasObject : null;
                    if (dasRoutine == null) {
                        return;
                    }
                    DasRoutine routine2 = dasRoutine;
                    Iterable<? extends DasArgument> iterable = routine2.getArguments();
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"getArguments(...)");
                    Iterable<? extends DasArgument> $this$any$iv = iterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<? extends DasArgument> iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            DasArgument element$iv;
                            DasArgument it2 = element$iv = iterator.next();
                            boolean bl2 = false;
                            String string = it2.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            boolean bl3 = ((CharSequence)string).length() == 0;
                            if (!bl3) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                SqlExpressionList sqlExpressionList = o2.getParameterList();
                List<E> list = sqlExpressionList != null ? sqlExpressionList.getExpressionList() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List<E> arguments = list;
                for (SqlExpression argument : arguments) {
                    if (argument instanceof SqlNamedParameterValueExpression) continue;
                    Intrinsics.checkNotNull((Object)argument);
                    this.reportProblem((PsiElement)argument);
                }
                super.visitSqlFunctionCallExpression(o2);
            }

            private final void reportProblem(PsiElement anchor2) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, SqlBundle.message((String)"inspection.message.named.argument.should.be.used", (Object[])new Object[0]), null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
        };
    }
}

