/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.database.Dbms;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.dataflow.SqlDataFlowInstructionVisitor;
import com.intellij.sql.inspections.dataflow.SqlDataFlowRunner;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlDfaProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblemKind;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlUnaryExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlConstantExpressionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "isDialectIgnored", "intellij.database.sql.impl"})
public final class SqlConstantExpressionInspection
extends SqlInspectionBase {
    @Override
    protected boolean isDialectIgnored(@NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        return !dbms2.isPostgres() && !dbms2.isMysql() && !dbms2.isMicrosoft();
    }

    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$dialect = $dialect;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlSelectStatement(@NotNull SqlSelectStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                Project project = o2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SqlDataFlowRunner runner = new SqlDataFlowRunner(project, null, 2, null);
                SqlStatement sqlStatement = (SqlStatement)o2;
                List<DfaMemoryState> list = Collections.singletonList(runner.createMemoryState());
                Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
                this.analyseStatement(sqlStatement, runner, list);
            }

            public void visitSqlDmlStatement(@NotNull SqlDmlStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                Project project = o2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SqlDataFlowRunner runner = new SqlDataFlowRunner(project, null, 2, null);
                SqlStatement sqlStatement = (SqlStatement)o2;
                List<DfaMemoryState> list = Collections.singletonList(runner.createMemoryState());
                Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
                this.analyseStatement(sqlStatement, runner, list);
            }

            private final void analyseStatement(SqlStatement statement2, SqlDataFlowRunner runner, List<? extends DfaMemoryState> initialStates) {
                ControlFlow flow = runner.buildFlow((PsiElement)statement2, this.$dialect);
                if (flow != null) {
                    Object it2;
                    SqlDataFlowInstructionVisitor listener2 = new SqlDataFlowInstructionVisitor();
                    if (runner.analyzeFlow(listener2, (Collection<? extends DfaMemoryState>)initialStates, flow) != RunnerResult.OK) {
                        return;
                    }
                    Object $this$forEach$iv = listener2.getConstantExpressions();
                    boolean $i$f$forEach = false;
                    for (Map.Entry<Object, SqlDataFlowInstructionVisitor.ConstantResult> element$iv : $this$forEach$iv.entrySet()) {
                        it2 = element$iv;
                        boolean bl = false;
                        if (!(it2.getKey() instanceof SqlBinaryExpression) && !(it2.getKey() instanceof SqlUnaryExpression)) continue;
                        this.reportConstantCondition((PsiElement)it2.getKey(), it2.getValue());
                    }
                    $this$forEach$iv = listener2.getNullabilityProblems();
                    $i$f$forEach = false;
                    Iterator<Map.Entry<Object, SqlDataFlowInstructionVisitor.ConstantResult>> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Object, SqlDataFlowInstructionVisitor.ConstantResult> element$iv;
                        element$iv = iterator.next();
                        it2 = (SqlNullabilityProblem)((Object)element$iv);
                        boolean bl = false;
                        if (((SqlDfaProblem)it2).getAnchor() instanceof SqlLiteralExpression) continue;
                        this.reportNullabilityProblem((SqlNullabilityProblem<?>)it2);
                    }
                }
            }

            public final void reportConstantCondition(@NotNull PsiElement element2, @NotNull SqlDataFlowInstructionVisitor.ConstantResult cResult) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)((Object)cResult), (String)"cResult");
                if (cResult == SqlDataFlowInstructionVisitor.ConstantResult.TRUE || cResult == SqlDataFlowInstructionVisitor.ConstantResult.FALSE) {
                    boolean isTrue = cResult == SqlDataFlowInstructionVisitor.ConstantResult.TRUE;
                    Object[] objectArray = new Object[]{element2.getText()};
                    String string = SqlBundle.message((String)(isTrue ? "condition.always.true" : "condition.always.false"), (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message2 = string;
                    this.addDescriptor(this.$manager.createProblemDescriptor(element2, message2, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }

            public final void reportNullabilityProblem(@NotNull SqlNullabilityProblem<?> problem) {
                Intrinsics.checkNotNullParameter(problem, (String)"problem");
                if (Intrinsics.areEqual(problem.getKind(), (Object)SqlNullabilityProblemKind.NullExpression.INSTANCE)) {
                    String string;
                    T expression = problem.getAnchor();
                    PsiElement dereferencedExpr = problem.getDereferencedExpression();
                    if (!Intrinsics.areEqual((Object)dereferencedExpr, expression)) {
                        var6_4 = new Object[]{expression.getText()};
                        string = SqlBundle.message((String)"inspection.message.null.reference", (Object[])var6_4);
                    } else {
                        var6_4 = new Object[]{expression.getText()};
                        string = SqlBundle.message((String)"inspection.message.expression.always.null", (Object[])var6_4);
                    }
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    String message2 = string2;
                    this.addDescriptor(this.$manager.createProblemDescriptor(expression, message2, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }
        };
    }
}

