/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.util.DasUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlAggregatesInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAnalyticClause;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlPivotColumnsClause;
import com.intellij.sql.psi.SqlQualifyClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlAggregatesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlAggregatesInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, dbms2, onTheFly){
            @NotNull
            private final Lazy clausesWithAggregates$delegate;
            @NotNull
            private final Lazy groupByPrimaryKeys$delegate;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dbms = $dbms;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
                this.clausesWithAggregates$delegate = LazyKt.lazy((Function0)createAnnotationVisitor.clausesWithAggregates.2.INSTANCE);
                this.groupByPrimaryKeys$delegate = LazyKt.lazy((Function0)createAnnotationVisitor.groupByPrimaryKeys.2.INSTANCE);
            }

            private final HashSet<SqlClause> getClausesWithAggregates() {
                Lazy lazy = this.clausesWithAggregates$delegate;
                return (HashSet)lazy.getValue();
            }

            private final HashSet<SqlGroupByClause> getGroupByPrimaryKeys() {
                Lazy lazy = this.groupByPrimaryKeys$delegate;
                return (HashSet)lazy.getValue();
            }

            private final boolean getHasAnalyticClause(SqlFunctionCallExpression $this$hasAnalyticClause) {
                return PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$hasAnalyticClause), SqlAnalyticClause.class) != null;
            }

            private final boolean maybeSameRefs(SqlReferenceExpression groupByRef, SqlReferenceExpression testRef, boolean unwrapAlias) {
                PsiElement psiElement = groupByRef.resolve();
                if (psiElement == null) {
                    return true;
                }
                PsiElement groupByResult = psiElement;
                PsiElement psiElement2 = testRef.resolve();
                if (psiElement2 == null) {
                    return true;
                }
                PsiElement testResult = psiElement2;
                if (unwrapAlias && !Intrinsics.areEqual((Object)groupByResult, (Object)testResult) && testResult instanceof SqlAsExpression) {
                    SqlExpression sqlExpression = ((SqlAsExpression)testResult).getExpression();
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                    Object object = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                    if (object == null) {
                        return true;
                    }
                    testResult = object;
                }
                return Intrinsics.areEqual((Object)groupByResult, (Object)testResult);
            }

            private final ObjectKind getEffectiveKind(SqlReferenceExpression $this$getEffectiveKind) {
                ObjectKind objectKind;
                block2: {
                    PsiElement target2;
                    while ((target2 = $this$getEffectiveKind.resolve()) instanceof SqlAsExpression) {
                        SqlReferenceExpression sqlReferenceExpression;
                        SqlExpression sqlExpression = ((SqlAsExpression)target2).getExpression();
                        SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                        if (sqlReferenceExpression != null) {
                            $this$getEffectiveKind = sqlReferenceExpression;
                            continue;
                        }
                        objectKind = null;
                        break block2;
                    }
                    objectKind = target2 instanceof PsiObject ? ((PsiObject)target2).getKind() : null;
                }
                return objectKind;
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o2) {
                block8: {
                    SqlQueryExpression sqlQueryExpression;
                    PsiElement psiElement;
                    block9: {
                        PsiElement targetElement;
                        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                        PsiElement immediateTarget = o2.getReference().resolveImmediate();
                        Object object = immediateTarget instanceof SqlAsExpression ? (PsiElement)((SqlAsExpression)immediateTarget).getExpression() : (targetElement = immediateTarget instanceof SqlColumnSymbol ? ((SqlColumnSymbol)immediateTarget).getContextElement() : null);
                        if (!(targetElement instanceof SqlFunctionCallExpression) || !SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)targetElement)) break block9;
                        SqlQueryExpression currentQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o2), SqlQueryExpression.class);
                        SqlQueryExpression targetQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)targetElement, SqlQueryExpression.class);
                        if (!Intrinsics.areEqual((Object)targetQuery, (Object)currentQuery)) break block8;
                        this.processAggregate((SqlExpression)o2, (SqlFunctionCallExpression)targetElement);
                        break block8;
                    }
                    if (!Intrinsics.areEqual((Object)this.getEffectiveKind(o2), (Object)ObjectKind.COLUMN) || (psiElement = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o2).takeWhile(arg_0 -> createAnnotationVisitor.1.visitSqlReferenceExpression$lambda$0(createAnnotationVisitor.visitSqlReferenceExpression.1.INSTANCE, arg_0)).filter(arg_0 -> createAnnotationVisitor.1.visitSqlReferenceExpression$lambda$1(createAnnotationVisitor.visitSqlReferenceExpression.2.INSTANCE, arg_0)).first()) == null) break block8;
                    PsiElement psiElement2 = psiElement;
                    Dbms dbms = this.$dbms;
                    PsiElement clause = psiElement2;
                    boolean bl = false;
                    PsiElement parent2 = clause.getParent();
                    SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)parent2, SqlGroupByClause.class);
                    if (sqlGroupByClause != null || ((sqlQueryExpression = parent2 instanceof SqlQueryExpression ? (SqlQueryExpression)parent2 : null) != null && (sqlQueryExpression = sqlQueryExpression.getTableExpression()) != null ? sqlQueryExpression.getGroupByClause() : (sqlGroupByClause = null)) != null) {
                        SqlGroupByClause sqlGroupByClause2 = sqlGroupByClause;
                        Intrinsics.checkNotNull((Object)sqlGroupByClause2);
                        SqlGroupByClause groupByClause = sqlGroupByClause2;
                        if (!this.getGroupByPrimaryKeys().contains(groupByClause)) {
                            SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                            if (sqlExpressionArray != null) {
                                SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                                Intrinsics.checkNotNull((Object)sqlExpressionArray2);
                                SqlExpression[] expressions2 = sqlExpressionArray2;
                                boolean isOrderBy = clause instanceof SqlOrderByClause;
                                boolean hasRef = false;
                                for (SqlExpression expression : expressions2) {
                                    if (expression instanceof SqlReferenceExpression) {
                                        if (hasRef || !this.maybeSameRefs((SqlReferenceExpression)expression, o2, isOrderBy)) continue;
                                        hasRef = true;
                                        continue;
                                    }
                                    break block8;
                                }
                                if (!hasRef) {
                                    if (dbms.isSqlite() || dbms.isH2()) {
                                        PsiElement psiElement3 = (PsiElement)o2;
                                        Object[] objectArray = new Object[]{o2.getName()};
                                        String string = SqlBundle.message((String)"inspection.message.nondeterministic.value.column.neither.aggregated.nor.mentioned.in.group.by.clause", (Object[])objectArray);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        this.reportWarning(psiElement3, string);
                                    } else {
                                        PsiElement psiElement4 = (PsiElement)o2;
                                        Object[] objectArray = new Object[]{o2.getName()};
                                        String string = SqlBundle.message((String)"inspection.message.column.must.be.either.aggregated.or.mentioned.in.group.by.clause", (Object[])objectArray);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        this.reportError(psiElement4, string);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (SqlPsiUtilCoreKt.isAggregateCall(o2)) {
                    this.processAggregate((SqlExpression)o2, o2);
                }
                super.visitSqlElement((SqlElement)o2);
            }

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                this.checkIfGroupedByPrimaryKey(o2);
                super.visitSqlQueryExpression(o2);
            }

            public void elementFinished(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                if (element2 instanceof SqlHavingClause && !this.getClausesWithAggregates().contains(element2)) {
                    SqlGroupByClause groupBy = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((SqlHavingClause)element2).getParent(), SqlGroupByClause.class);
                    if (groupBy != null && this.hasMultipleGroupingSets(groupBy)) {
                        return;
                    }
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)((SqlHavingClause)element2).getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_HAVING), (boolean)false, null);
                    String string = SqlBundle.message((String)"inspection.message.using.aggregate.free.condition.s.in.having.clause.might.be.inefficient.consider.moving.them.to.where", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportWarning(psiElement, string);
                }
            }

            private final boolean hasMultipleGroupingSets(SqlGroupByClause $this$hasMultipleGroupingSets) {
                boolean bl;
                block3: {
                    JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)$this$hasMultipleGroupingSets);
                    Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement[] psiElementArray;
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            IElementType type = PsiUtilCore.getElementType((PsiElement)it2);
                            boolean bl3 = Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_CUBE) || Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_ROLLUP) || Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_GROUPING) && !((psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)$this$hasMultipleGroupingSets), SqlExpression.class)) == null || psiElementArray.length == 0);
                            if (!bl3) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            private final void checkIfGroupedByPrimaryKey(SqlQueryExpression query) {
                Collection destination$iv;
                SqlTableExpression sqlTableExpression = query.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getFromClause()) == null) {
                    return;
                }
                SqlTableExpression fromClause = sqlTableExpression;
                SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)query), SqlGroupByClause.class, (boolean)true, SqlQueryExpression.class);
                if (sqlGroupByClause == null) {
                    return;
                }
                SqlGroupByClause groupByClause = sqlGroupByClause;
                SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                if (sqlExpressionArray != null) {
                    void $this$mapNotNullTo$iv;
                    SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                    destination$iv = new HashSet<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        DasTypedObject it$iv;
                        void element$iv$iv;
                        void element$iv = element$iv$iv = $this$forEach$iv$iv[j];
                        boolean bl = false;
                        void it2 = element$iv;
                        boolean bl2 = false;
                        SqlReferenceExpression sqlReferenceExpression = it2 instanceof SqlReferenceExpression ? (SqlReferenceExpression)it2 : null;
                        Object object = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                        if ((object instanceof DasTypedObject ? (DasTypedObject)object : null) == null) continue;
                        it$iv = it$iv;
                        boolean bl3 = false;
                        destination$iv.add(it$iv);
                    }
                } else {
                    return;
                }
                HashSet groupByColumns = (HashSet)destination$iv;
                if (groupByColumns.isEmpty()) {
                    return;
                }
                for (SqlReferenceExpression ref2 : PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)fromClause), SqlReferenceExpression.class)) {
                    boolean bl;
                    block11: {
                        Iterable<T> primaryKeyColumns;
                        DasTable table;
                        PsiElement $i$f$mapNotNullTo;
                        if (!Intrinsics.areEqual((Object)ref2.getReferenceElementType().getTargetKind(), (Object)ObjectKind.TABLE) || (($i$f$mapNotNullTo = ref2.resolve()) instanceof DasTable ? (DasTable)$i$f$mapNotNullTo : null) == null) continue;
                        Object object = DasUtil.getPrimaryKey(table = table);
                        Iterable<T> iterable = object != null && (object = object.getColumnsRef()) != null ? object.resolveObjects() : null;
                        if (iterable == null) {
                            return;
                        }
                        Iterable<T> $this$any$iv = primaryKeyColumns = iterable;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                DasTypedObject it3 = (DasTypedObject)element$iv;
                                boolean bl4 = false;
                                if (!(!groupByColumns.contains(it3))) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    return;
                }
                ((Collection)this.getGroupByPrimaryKeys()).add(groupByClause);
            }

            /*
             * WARNING - void declaration
             */
            private final void processAggregate(SqlExpression e2, SqlFunctionCallExpression aggregateCall) {
                block7: {
                    Object v4;
                    PsiElement psiElement;
                    block6: {
                        void $this$firstOrNull$iv;
                        PsiElement permittedClause2;
                        JBIterable jBIterable = SqlImplUtil.sqlParents(e2.getParent()).takeWhile(arg_0 -> createAnnotationVisitor.1.processAggregate$lambda$6(createAnnotationVisitor.processAggregate.parents.1.INSTANCE, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"takeWhile(...)");
                        JBIterable parents2 = jBIterable;
                        psiElement = permittedClause2 = (PsiElement)parents2.filter(arg_0 -> createAnnotationVisitor.1.processAggregate$lambda$7((Function1)new Function1<PsiElement, Boolean>(this.$dbms){
                            final /* synthetic */ Dbms $dbms;
                            {
                                this.$dbms = $dbms;
                                super(1);
                            }

                            /*
                             * Enabled aggressive block sorting
                             */
                            @NotNull
                            public final Boolean invoke(PsiElement it2) {
                                boolean bl;
                                block4: {
                                    block3: {
                                        if (it2 instanceof SqlSelectClause || it2 instanceof SqlHavingClause || it2 instanceof SqlQualifyClause && this.$dbms.isSnowflake() || it2 instanceof SqlOrderByClause || it2 instanceof SqlPivotColumnsClause || it2 instanceof SqlStatement) break block3;
                                        if (!(it2 instanceof SqlFunctionCallExpression)) break block4;
                                        Object object = ((SqlFunctionCallExpression)it2).getFunctionDefinition();
                                        boolean bl2 = object != null && (object = object.getName()) != null ? StringsKt.equals((String)object, (String)"unnest", (boolean)true) : false;
                                        if (!bl2) break block4;
                                    }
                                    bl = true;
                                    return bl;
                                }
                                bl = false;
                                return bl;
                            }
                        }, arg_0)).first();
                        if (psiElement == null) {
                            PsiElement psiElement2 = (PsiElement)e2;
                            String string = SqlBundle.message((String)"inspection.message.aggregate.calls.are.not.allowed.here", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.reportError(psiElement2, string);
                        } else if (psiElement instanceof SqlHavingClause ? true : psiElement instanceof SqlSelectClause) {
                            HashSet<SqlClause> hashSet = this.getClausesWithAggregates();
                            Intrinsics.checkNotNull((Object)permittedClause2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlClause");
                            hashSet.add((SqlClause)permittedClause2);
                        }
                        if (this.getHasAnalyticClause(aggregateCall) || this.$dbms.isOracle()) break block7;
                        Iterable iterable = (Iterable)parents2;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(it2 instanceof SqlFunctionCallExpression && SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)it2))) continue;
                            v4 = element$iv;
                            break block6;
                        }
                        v4 = null;
                    }
                    psiElement = v4;
                    if (psiElement != null) {
                        PsiElement it3 = psiElement;
                        boolean bl = false;
                        if (!this.getHasAnalyticClause((SqlFunctionCallExpression)it3)) {
                            PsiElement psiElement3 = (PsiElement)e2;
                            String string = SqlBundle.message((String)"inspection.message.nested.aggregate.calls.are.not.allowed", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.reportError(psiElement3, string);
                        }
                    }
                }
            }

            private final void reportError(PsiElement element2, @InspectionMessage String message2) {
                this.reportProblem(element2, message2, ProblemHighlightType.GENERIC_ERROR);
            }

            private final void reportWarning(PsiElement element2, @InspectionMessage String message2) {
                this.reportProblem(element2, message2, ProblemHighlightType.WARNING);
            }

            private final void reportProblem(PsiElement element2, @InspectionMessage String message2, ProblemHighlightType highlightType) {
                PsiElement psiElement = element2 instanceof SqlFunctionCallExpression ? (PsiElement)((SqlFunctionCallExpression)element2).getNameElement() : element2;
                if (psiElement == null) {
                    return;
                }
                PsiElement anchor2 = psiElement;
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, anchor2, message2, highlightType, this.$onTheFly, new LocalQuickFix[0]));
            }

            private static final boolean visitSqlReferenceExpression$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean visitSqlReferenceExpression$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean processAggregate$lambda$6(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean processAggregate$lambda$7(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }
}

