/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlAddNotNullColumnInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(2);
        }
        if (dialect.getDbms() == Dbms.UNKNOWN) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAlterStatement(SqlAlterStatement o2) {
                SqlReferenceExpression target2 = o2.getAlterTargetReference();
                if (target2 == null || target2.getReferenceElementType().getTargetKind() != ObjectKind.TABLE) {
                    return;
                }
                for (SqlAlterInstruction instruction2 : o2.getAlterInstructions()) {
                    IElementType type = instruction2.getInstructionType();
                    if (type != SqlCommonKeywords.SQL_ADD) {
                        return;
                    }
                    for (SqlColumnDefinition col : SqlImplUtil.sqlChildren((PsiElement)instruction2).filter(SqlColumnDefinition.class)) {
                        boolean notNullAlone;
                        if (SqlImplUtil.isAutoVal(col) || SqlImplUtil.isComputedVal(col)) continue;
                        ASTNode nullConstraint = col.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION);
                        ASTNode notNullConstraint = col.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION);
                        ASTNode defaultConstraint = col.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION);
                        SqlTableKeyDefinition pkDefinition = col.getPrimaryKey();
                        Dbms dbms = this.myDialect.getDbms();
                        boolean pkExists = pkDefinition != null;
                        boolean notNullWithoutDefault = notNullConstraint != null && defaultConstraint == null && !dbms.isMysql() && !dbms.isDb2() && (!dbms.isMicrosoft() || DasTypeUtilsKt.getCategory(col.getDasType()) != DasTypeCategory.TIMESTAMP);
                        boolean bl = notNullAlone = notNullConstraint != null && defaultConstraint == null && nullConstraint == null && dbms.isDb2();
                        if (!notNullWithoutDefault && !notNullAlone && !pkExists) continue;
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)col, SqlBundle.message((String)"inspection.message.column.can.not.be.added.because.it.s.mandatory.not.null.but.unknown.how.to.fill.it.for.existing.rows", (Object[])new Object[0]), (LocalQuickFix)(!pkExists && onTheFly ? new AddDefaultFix(col, this.myDialect) : null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddDefaultFix
    extends SqlEditorAwareFix<SqlColumnDefinition> {
        private final SqlLanguageDialect myLanguage;
        private final boolean myIsPreview;

        private AddDefaultFix(SqlColumnDefinition element2, SqlLanguageDialect language, boolean isPreview) {
            super(element2);
            this.myLanguage = language;
            this.myIsPreview = isPreview;
        }

        AddDefaultFix(SqlColumnDefinition element2, SqlLanguageDialect language) {
            this(element2, language, false);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.add.default.value", (Object[])new Object[0]);
            if (string == null) {
                AddDefaultFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
            if (target2 == null) {
                AddDefaultFix.$$$reportNull$$$0(1);
            }
            PsiElement element2 = this.getStartElement();
            if (!((element2 = PsiTreeUtil.findSameElementInCopy((PsiElement)element2, (PsiFile)target2)) instanceof SqlColumnDefinition)) {
                return null;
            }
            return new AddDefaultFix((SqlColumnDefinition)element2, this.myLanguage, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlColumnDefinition element2, @Nullable Editor editor2) {
            if (project == null) {
                AddDefaultFix.$$$reportNull$$$0(2);
            }
            if (element2 == null) {
                AddDefaultFix.$$$reportNull$$$0(3);
            }
            if (editor2 == null) {
                return;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.addTextSegment(" default ");
            template.addVariable("value", (Expression)new ConstantNode(this.myIsPreview ? "foo" : ""), true);
            template.setToReformat(true);
            Dbms dbms = this.myLanguage.getDbms();
            if (dbms.isHsqldb() || dbms.isSybase() || dbms.isOracle()) {
                ASTNode notNullConstraint = element2.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION);
                if (notNullConstraint == null) return;
                editor2.getCaretModel().moveToOffset(notNullConstraint.getTextRange().getStartOffset());
                template.addTextSegment(" ");
            } else {
                editor2.getCaretModel().moveToOffset(element2.getTextRange().getEndOffset());
            }
            templateManager.startTemplate(editor2, template);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection$AddDefaultFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection$AddDefaultFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

