/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.highlighting.SqlHighlightLoopJumpsHandler;
import com.intellij.sql.psi.SqlConditionalJumpStatement;
import com.intellij.sql.psi.SqlLoopStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J,\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0014\u0010\u000f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u0010H\u0014R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/highlighting/SqlHighlightLoopJumpsHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiElement;)V", "computeUsages", "", "targets", "", "getTargets", "selectTargets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "intellij.database.sql.impl"})
public final class SqlHighlightLoopJumpsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    @NotNull
    private final PsiElement target;

    public SqlHighlightLoopJumpsHandler(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull PsiElement target2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        super(editor2, file);
        this.target = target2;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        return CollectionsKt.listOf((Object)this.target);
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets2, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
        selectionConsumer.consume(targets2);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets2) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        PsiElement psiElement = this.target.getParent();
        SqlConditionalJumpStatement sqlConditionalJumpStatement = psiElement instanceof SqlConditionalJumpStatement ? (SqlConditionalJumpStatement)psiElement : null;
        if (sqlConditionalJumpStatement == null) {
            return;
        }
        SqlConditionalJumpStatement jumpStatement = sqlConditionalJumpStatement;
        SqlLoopStatement sqlLoopStatement = SqlPsiUtilCoreKt.getLoopStatement(jumpStatement);
        if (sqlLoopStatement == null) {
            return;
        }
        SqlLoopStatement loopStatement = sqlLoopStatement;
        for (PsiElement element2 : (SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)loopStatement).expand(arg_0 -> SqlHighlightLoopJumpsHandler.computeUsages$lambda$0(computeUsages.1.INSTANCE, arg_0))) {
            if (!(element2 instanceof SqlConditionalJumpStatement) || !Intrinsics.areEqual((Object)SqlPsiUtilCoreKt.getLoopStatement((SqlConditionalJumpStatement)element2), (Object)loopStatement)) continue;
            this.addOccurrence(element2);
        }
    }

    private static final boolean computeUsages$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

