/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.RegularSqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleCommonSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlLanguageCodeStyleSettingsProvider;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageCodeStyleSettingsProviderBase
extends SqlLanguageCodeStyleSettingsProvider
implements DisplayPrioritySortable {
    protected static final SqlGroup SQL_STYLE_GROUP = new SqlGroup();

    protected SqlLanguageCodeStyleSettingsProviderBase(@NotNull Language dialect, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass) {
        if (dialect == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(0);
        }
        if (settingsClass == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(1);
        }
        super(dialect, settingsClass);
    }

    public CodeStyleGroup getGroup() {
        return SQL_STYLE_GROUP;
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(3);
        }
        return SqlCodeStyleSettingsUtil.createSqlFileForCodeStyleSettingsPreview(project, text2, (SqlLanguageDialect)this.myDialect);
    }

    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        SqlCodeStyleCommonSettings settings = new SqlCodeStyleCommonSettings(this.getLanguage());
        settings.initIndentOptions();
        this.customizeDefaults(settings, settings.getIndentOptions());
        SqlCodeStyleCommonSettings sqlCodeStyleCommonSettings = settings;
        if (sqlCodeStyleCommonSettings == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(4);
        }
        return sqlCodeStyleCommonSettings;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer2 == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"INDENT_SIZE", "CONTINUATION_INDENT_SIZE", "TAB_SIZE", "USE_TAB_CHARACTER"});
        }
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(7);
        }
        return "-- something goes wrong";
    }

    public abstract SqlCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings var1);

    @NotNull
    protected String getPreviewTextsPath() {
        return "codeStyle/preview";
    }

    @NotNull
    protected Map<SqlCodeStyleSettingsType, String> loadPreviewTexts() {
        String path = this.getPreviewTextsPath();
        HashMap<SqlCodeStyleSettingsType, String> texts = new HashMap<SqlCodeStyleSettingsType, String>();
        for (SqlCodeStyleSettingsType type : SqlCodeStyleSettingsType.values()) {
            InputStream resourceStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path + "/preview." + type.code + ".template");
            if (resourceStream == null) continue;
            try {
                texts.put(type, ResourceUtil.loadText((InputStream)resourceStream));
            }
            catch (IOException e2) {
                Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e2);
            }
        }
        HashMap<SqlCodeStyleSettingsType, String> hashMap = texts;
        if (hashMap == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    protected SqlCodeStyleMainPanel createSettingsPanel(CodeStyleSettings theSettings, CodeStyleSettings currentSettings) {
        return new RegularSqlCodeStyleMainPanel(this.myDialect, currentSettings, theSettings);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        if (settings == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(9);
        }
        if (modelSettings == null) {
            SqlLanguageCodeStyleSettingsProviderBase.$$$reportNull$$$0(10);
        }
        return new CodeStyleAbstractConfigurable(settings, modelSettings, this.getConfigurableDisplayName()){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings theSettings) {
                if (theSettings == null) {
                    1.$$$reportNull$$$0(0);
                }
                SqlCodeStyleMainPanel sqlCodeStyleMainPanel = SqlLanguageCodeStyleSettingsProviderBase.this.createSettingsPanel(theSettings, this.getCurrentSettings());
                if (sqlCodeStyleMainPanel == null) {
                    1.$$$reportNull$$$0(1);
                }
                return sqlCodeStyleMainPanel;
            }

            public String getHelpTopic() {
                return "code.styles.for.SQL";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "theSettings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProviderBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProviderBase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPanel";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProviderBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProviderBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommonSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPreviewTexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }

    private static class SqlGroup
    extends CodeStyleGroup {
        SqlGroup() {
            super("sql.code.style.group", SqlBundle.message((String)"sql.code.style.group.display.name", (Object[])new Object[0]), SqlBundle.message((String)"sql.code.style.group.description", (Object[])new Object[0]), "code.styles.for.SQL", (Language)SqlLanguage.INSTANCE);
        }
    }

    private class ShortLowercaseCodeStyle
    extends PredefinedCodeStyle {
        ShortLowercaseCodeStyle() {
            super(SqlBundle.message((String)"code.style.short.with.lowercase", (Object[])new Object[0]), (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlLanguageCodeStyleSettingsProviderBase.this.getSettingsClass());
            sqlSettings.KEYWORD_CASE = 1;
        }
    }

    private class ShortUppercaseCodeStyle
    extends PredefinedCodeStyle {
        ShortUppercaseCodeStyle() {
            super(SqlBundle.message((String)"code.style.short.with.uppercase", (Object[])new Object[0]), (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlLanguageCodeStyleSettingsProviderBase.this.getSettingsClass());
            sqlSettings.KEYWORD_CASE = 2;
        }
    }
}

