/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.PgRoutineBodyHostBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCommentsFlowBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlLanguageClauseBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParametersBlock;
import com.intellij.sql.formatter.model.SqlPgRoutineBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlPrefixClauseBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReturnBlock;
import com.intellij.sql.formatter.model.SqlRoutineDeclarationsSectionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0004H\u0014J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlPgRoutineBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "bodyPassed", "", "largeReturn", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "makeBlock", "produceNestedBlocks", "nodes", "", "userRequiresExpand", "whetherToFlatten", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlRoutineBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRoutineBlock.kt\ncom/intellij/sql/formatter/model/SqlPgRoutineBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n*L\n1#1,415:1\n940#2,2:416\n940#2,2:418\n945#2,2:420\n945#2,2:422\n945#2,2:424\n945#2,2:426\n831#2,2:428\n1112#2,2:430\n*S KotlinDebug\n*F\n+ 1 SqlRoutineBlock.kt\ncom/intellij/sql/formatter/model/SqlPgRoutineBlock\n*L\n147#1:416,2\n154#1:418,2\n164#1:420,2\n165#1:422,2\n166#1:424,2\n168#1:426,2\n169#1:428,2\n171#1:430,2\n*E\n"})
public final class SqlPgRoutineBlock
extends SqlNodeBlock {
    private boolean largeReturn;
    private boolean bodyPassed;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return SqlImplUtil.isBodyLazyBlock(node2.getPsi());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes) {
        int d2;
        Object nodes$iv;
        Object object;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        int significantIndex = 0;
        ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(nodes);
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)(aSTNode != null ? aSTNode.getElementType() : null))) {
            void $this$withSetup$iv;
            int j;
            for (j = 1; j < n && SqlFormattingFunKt.getCOMMENT_AND_SPACES_TYPES().contains(nodes.get(j).getElementType()); ++j) {
            }
            significantIndex = j;
            Collection collection2 = this.getNestedBlocks();
            object = new SqlCommentsFlowBlock();
            nodes$iv = nodes.subList(0, significantIndex);
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup(this, (List<? extends ASTNode>)nodes$iv);
            object = $this$withSetup$iv;
            collection2.add(object);
        }
        if ((d2 = SqlUtilFun.indexOf$default(nodes, significantIndex, 0, 0, produceNestedBlocks.d.1.INSTANCE, 6, null)) > 0) {
            int b2 = SqlUtilFun.indexOf$default(nodes, d2, 0, n, produceNestedBlocks.b.1.INSTANCE, 2, null);
            super.produceNestedBlocks(nodes.subList(significantIndex, d2));
            if (d2 < b2) {
                void $this$withSetup$iv;
                object = this.getNestedBlocks();
                nodes$iv = new SqlRoutineDeclarationsSectionBlock();
                List<? extends ASTNode> nodes$iv2 = nodes.subList(d2, b2);
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup(this, nodes$iv2);
                void var7_8 = $this$withSetup$iv;
                object.add(var7_8);
            }
            if (b2 < n) {
                super.produceNestedBlocks(nodes.subList(b2, n));
            }
        } else {
            super.produceNestedBlocks(nodes.subList(significantIndex, n));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node2) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        IElementType iElementType = node2.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARAMETER_LIST)) {
            SqlRangeBlock $this$withSetup$iv = new SqlParametersBlock();
            boolean $i$f$withSetup = false;
            SqlBlock sqlBlock2 = this;
            TextRange textRange = node2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(sqlBlock2, textRange, SqlFormattingModelFun.listChildren(node2));
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.AMENDMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_RETURNS_CLAUSE))) {
            SqlRangeBlock $this$withSetup$iv = new SqlReturnBlock();
            boolean $i$f$withSetup = false;
            SqlBlock sqlBlock3 = this;
            TextRange textRange = node2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(sqlBlock3, textRange, SqlFormattingModelFun.listChildren(node2));
            sqlBlock = $this$withSetup$iv;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE)) {
            SqlRangeBlock $this$withSetup$iv = new SqlLanguageClauseBlock(this.bodyPassed);
            boolean $i$f$withSetup = false;
            SqlBlock sqlBlock4 = this;
            TextRange textRange = node2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(sqlBlock4, textRange, SqlFormattingModelFun.listChildren(node2));
            sqlBlock = $this$withSetup$iv;
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE))) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
            SqlFlowBlock sqlFlowBlock;
            if (SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.BODY) != null) {
                SqlRangeBlock $this$withSetup$iv = new SqlPostfixClauseBlock();
                boolean $i$f$withSetup = false;
                SqlBlock sqlBlock5 = this;
                TextRange textRange = node2.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(sqlBlock5, textRange, SqlFormattingModelFun.listChildren(node2));
                sqlFlowBlock = $this$withSetup$iv;
            } else {
                SqlNodeBlock $this$withSetup$iv = new SqlPrefixClauseBlock();
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(this, node2);
                sqlFlowBlock = $this$withSetup$iv;
            }
            sqlBlock = sqlFlowBlock;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
            if (SqlFormattingModelFun.hasInjection(node2)) {
                void var3_8;
                SqlInjectionHostBlock $this$withSetup$iv = new PgRoutineBodyHostBlock();
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(this, node2);
                sqlBlock = (SqlBlock)var3_8;
            } else {
                sqlBlock = super.makeBlock(node2);
            }
        } else {
            sqlBlock = super.makeBlock(node2);
        }
        return sqlBlock;
    }

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        return Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE) ? BlockRole.ALIAS1 : (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT) ? BlockRole.BODY : (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL) ? BlockRole.BODY : (node2 instanceof SqlStatement ? BlockRole.BODY : super.determineRole(node2))));
    }

    @Override
    public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        super.countRole$intellij_database_sql_core_impl(role);
        if (role == BlockRole.BODY) {
            this.bodyPassed = true;
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        Wrap mainWrap = SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null);
        Wrap prefixOptionsWrap = null;
        Wrap postfixOptionsWrap = null;
        boolean wasLQuote = false;
        for (SqlBlock b2 : this.getNestedBlocks()) {
            IElementType t = SqlFormattingModelFun.primaryElementType(b2);
            if (b2.getRole() == BlockRole.BODY) {
                boolean toWrapEssence = wasLQuote ? s2.ROUTINE_PG_L_QUOTE_WRAP_AFTER : true;
                b2.setMyWrap((Wrap)(toWrapEssence ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (b2 instanceof SqlRoutineDeclarationsSectionBlock) {
                b2.setMyWrap(mainWrap);
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b2 instanceof SqlReturnBlock) {
                this.largeReturn = b2.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS;
                b2.setMyWrap((Wrap)(this.largeReturn ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b2 instanceof SqlPrefixClauseBlock) {
                if (prefixOptionsWrap == null) {
                    b2.setMyWrap(mainWrap);
                    prefixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                } else {
                    b2.setMyWrap(postfixOptionsWrap);
                }
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b2 instanceof SqlPostfixClauseBlock) {
                if (postfixOptionsWrap == null) {
                    b2.setMyWrap(mainWrap);
                    postfixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                } else {
                    b2.setMyWrap(postfixOptionsWrap);
                }
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b2 instanceof SqlLanguageClauseBlock) {
                if (((SqlLanguageClauseBlock)b2).isPostfix$intellij_database_sql_core_impl()) continue;
                b2.setMyWrap(mainWrap);
                continue;
            }
            if (t == SqlTokens.SQL_CREATE) {
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_AS || t == SqlTokens.SQL_IS) {
                b2.setMyWrap((Wrap)(s2.ROUTINE_AS_WRAP || this.largeReturn ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_CUSTOM_LQUOTE) {
                b2.setMyWrap((Wrap)(s2.ROUTINE_PG_L_QUOTE_WRAP_BEFORE ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                wasLQuote = true;
                continue;
            }
            if (t == SqlTokens.SQL_CUSTOM_RQUOTE) {
                b2.setMyWrap((Wrap)(s2.ROUTINE_PG_R_QUOTE_WRAP_BEFORE ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t != SqlTokens.SQL_LANGUAGE) continue;
            b2.setMyWrap(postfixOptionsWrap);
        }
        SqlCommonHandlersKt.configureAttributesForPostfixOptions(this, this.getNestedBlocks());
    }

    @Override
    protected boolean userRequiresExpand() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        IElementType t1 = SqlFormattingModelFun.primaryElementType(block1);
        IElementType t2 = SqlFormattingModelFun.primaryElementType(block2);
        if (block2 instanceof SqlParametersBlock) {
            switch (this.getContext().getSql().ROUTINE_ARG_OPENING) {
                case 1: {
                    spacing = this.getContext().makeSpace(this.getContext().getCom().SPACE_BEFORE_METHOD_PARENTHESES || ((SqlParametersBlock)block2).getOpeningBlock() == null, false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null);
                    break;
                }
            }
        } else {
            spacing = t2 == SqlCompositeElementTypes.SQL_CLAUSE || t2 == SqlTokens.SQL_LANGUAGE ? this.getContext().makeAutoSpacing(true) : (t1 == SqlTokens.SQL_CUSTOM_RQUOTE ? (Intrinsics.areEqual((Object)t2, (Object)SqlCommonTokens.SQL_SEMICOLON) ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (this.getContext().getSql().ROUTINE_PG_R_QUOTE_WRAP_AFTER ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null))) : super.decideSpacing(block1, block2));
        }
        return spacing;
    }
}

