/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.ObjectKind;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.formatter.SqlFormatterHelper;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FindPhraseResult;
import com.intellij.sql.formatter.model.NodeBlockFactoryRecord;
import com.intellij.sql.formatter.model.SqlAS;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlAlterTableBlock;
import com.intellij.sql.formatter.model.SqlArrayAccessBlock;
import com.intellij.sql.formatter.model.SqlAssignmentBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockCommentBlock;
import com.intellij.sql.formatter.model.SqlBlockStatementBlock;
import com.intellij.sql.formatter.model.SqlCaseExpressionBlock;
import com.intellij.sql.formatter.model.SqlCaseStatementBlock;
import com.intellij.sql.formatter.model.SqlColumnAliasCortegeBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlComplexTextBlock;
import com.intellij.sql.formatter.model.SqlConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlConstraintDetailBlock;
import com.intellij.sql.formatter.model.SqlCortegeBlock;
import com.intellij.sql.formatter.model.SqlCreateExoticObjectBlock;
import com.intellij.sql.formatter.model.SqlCreateSchemaBlock;
import com.intellij.sql.formatter.model.SqlCreateTableBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlDeclareSectionBlock;
import com.intellij.sql.formatter.model.SqlDropRoutineBlock;
import com.intellij.sql.formatter.model.SqlElsifSectionBlock;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlExistsClauseBlock;
import com.intellij.sql.formatter.model.SqlExplainPlanBlock;
import com.intellij.sql.formatter.model.SqlExternalParameterBlock;
import com.intellij.sql.formatter.model.SqlFileBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlForeignKeyReferencesBlock;
import com.intellij.sql.formatter.model.SqlForkBlock;
import com.intellij.sql.formatter.model.SqlForkSectionBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlFunctionCallBlock;
import com.intellij.sql.formatter.model.SqlHeadLoopBlock;
import com.intellij.sql.formatter.model.SqlIdentifierBlock;
import com.intellij.sql.formatter.model.SqlInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlLiteralBlock;
import com.intellij.sql.formatter.model.SqlLiteralInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlLoopBlock;
import com.intellij.sql.formatter.model.SqlMergeBlock;
import com.intellij.sql.formatter.model.SqlMonolithBlock;
import com.intellij.sql.formatter.model.SqlNamedConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlNullabilityCheckBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedExpressionBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPgDoStatementBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReferenceBlock;
import com.intellij.sql.formatter.model.SqlRepeatLoopBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlockKt;
import com.intellij.sql.formatter.model.SqlSimpleLoopBlock;
import com.intellij.sql.formatter.model.SqlSimpleSettingAssignmentBlock;
import com.intellij.sql.formatter.model.SqlSimpleTypeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.SqlSizeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.model.SqlTableTypeBlock;
import com.intellij.sql.formatter.model.SqlTriggerBlock;
import com.intellij.sql.formatter.model.SqlTypeParameterListBlock;
import com.intellij.sql.formatter.model.SqlUnsortedBlock;
import com.intellij.sql.formatter.model.SqlViewBlock;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlTableElementType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0086\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0010\u0010-\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0010\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0010\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0018\u00102\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u00103\u001a\u00020\u000eH\u0002\u001a\u0010\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0010\u00106\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0010\u00107\u001a\u0002082\u0006\u0010+\u001a\u000209H\u0002\u001a\u0010\u0010:\u001a\u00020\u00042\u0006\u0010+\u001a\u00020;H\u0002\u001a\u0018\u0010<\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010=\u001a\u00020>H\u0002\u001a(\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u00103\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020>H\u0002\u001a\u0018\u0010A\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010=\u001a\u00020>H\u0000\u001a\u0018\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0000\u001a\u0006\u0010D\u001a\u00020E\u001a\u0006\u0010F\u001a\u00020E\u001a\u0006\u0010G\u001a\u00020E\u001a\u0006\u0010H\u001a\u00020E\u001a\f\u0010I\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a%\u0010J\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a\"\n\b\u0000\u0010\u001b\u0018\u0001*\u00020\u001c*\b\u0012\u0004\u0012\u00020\u001c0\u001dH\u0086\b\u001a+\u0010J\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\u001a\u00a2\u0006\u0002\bK*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010@\u001a\u00020\u0002\u001a+\u0010J\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\u001a\u00a2\u0006\u0002\bK*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010%\u001a\u00020&\u001a3\u0010J\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\u001a\u00a2\u0006\u0002\bK*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020&\u001a;\u0010J\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\u001a\u00a2\u0006\u0002\bK*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020&\u001a<\u0010J\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\u001a\u00a2\u0006\u0002\bK*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0012\u0010O\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020P\"\u00020\u0002\u00a2\u0006\u0002\u0010Q\u001a&\u0010R\u001a\u0004\u0018\u0001H\u001b\"\n\b\u0000\u0010\u001b\u0018\u0001*\u00020\u001c*\b\u0012\u0004\u0012\u00020\u001c0\u001dH\u0086\b\u00a2\u0006\u0002\u0010S\u001a\u001a\u0010R\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010@\u001a\u00020\u0002\u001a\u001a\u0010R\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010%\u001a\u00020&\u001a0\u0010T\u001a\u0004\u0018\u00010\u0013*\b\u0012\u0004\u0012\u00020,0U2\b\b\u0002\u0010V\u001a\u00020\u00122\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00170X\u001a\"\u0010Y\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010Z*\b\u0012\u0004\u0012\u00020[0U2\u0006\u0010+\u001a\u00020,H\u0002\u001a(\u0010\\\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\u0006\u0010]\u001a\u00020\u00122\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170X\u001a \u0010^\u001a\u0004\u0018\u0001H\u001b\"\n\b\u0000\u0010\u001b\u0018\u0001*\u00020\u0004*\u00020\u0004H\u0080\b\u00a2\u0006\u0002\u0010_\u001a5\u0010`\u001a\u0004\u0018\u00010a*\b\u0012\u0004\u0012\u00020,0U2\u0006\u0010]\u001a\u00020\u00122\u0014\u0010b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020P0P\u00a2\u0006\u0002\u0010c\u001a\u000e\u0010d\u001a\u0004\u0018\u00010e*\u0004\u0018\u00010f\u001a\n\u0010g\u001a\u00020\u0017*\u00020,\u001a \u0010h\u001a\u00020\u0017*\u00020,2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00170XH\u0002\u001a6\u0010i\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020,0U2\u0006\u0010@\u001a\u00020\u00022\b\b\u0002\u0010V\u001a\u00020\u00122\b\b\u0002\u0010j\u001a\u00020\u00122\b\b\u0002\u0010k\u001a\u00020\u0012\u001a<\u0010i\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020,0U2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\b\b\u0002\u0010V\u001a\u00020\u00122\b\b\u0002\u0010j\u001a\u00020\u00122\b\b\u0002\u0010k\u001a\u00020\u0012\u001aI\u0010l\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u0004*\u0002H\u001b2,\u0010m\u001a(\u0012\u0004\u0012\u0002H\u001b\u0012\u0013\u0012\u0011H\u001b\u00a2\u0006\f\bo\u0012\b\bp\u0012\u0004\b\b(q\u0012\u0004\u0012\u00020r0n\u00a2\u0006\u0002\bsH\u0000\u00a2\u0006\u0002\u0010t\u001a\f\u0010u\u001a\u00020\u0017*\u0004\u0018\u00010f\u001a\u0012\u0010v\u001a\b\u0012\u0004\u0012\u00020,0U*\u00020,H\u0000\u001a&\u0010v\u001a\b\u0012\u0004\u0012\u00020,0U*\u00020,2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00170XH\u0000\u001a\u000e\u0010x\u001a\u0004\u0018\u00010\u0002*\u00020\u0004H\u0000\u001a\u000e\u0010y\u001a\u0004\u0018\u00010,*\u00020\u0004H\u0000\u001a+\u0010z\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\u001a\u00a2\u0006\u0002\bK*\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010{\u001a\u00020\u0012\"\"\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u00a5\u0001\u0010\u0005\u001a\u0092\u0001\u0012\u008d\u0001\u0012\u008a\u0001\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\b\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t \n*D\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\b\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u00070\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\"6\u0010\r\u001a$\u0012\u0004\u0012\u00020\u000e\u0012\u001a\u0012\u0018\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0016\u0010\u0011\u001a\u00020\u0012*\u00020\u00138\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\",\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0\u001d8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u001c\u0010 \u001a\u0004\u0018\u00010!*\u0004\u0018\u00010\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0018\u0010%\u001a\u00020&*\u0004\u0018\u00010\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006|"}, d2={"COMMON_SIMPLE_ELEMENT_BLOCKS", "", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/reflect/KClass;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "CONSTRAINT_TYPES", "", "Lcom/intellij/sql/psi/stubs/SqlDefinitionStubElementType;", "Lcom/intellij/sql/psi/stubs/SqlNamedElementStub;", "Lcom/intellij/sql/psi/SqlDefinition;", "kotlin.jvm.PlatformType", "getCONSTRAINT_TYPES", "()Ljava/util/Set;", "DIALECT_SPECIFIC_BLOCKS", "Lcom/intellij/database/Dbms;", "getDIALECT_SPECIFIC_BLOCKS", "()Ljava/util/Map;", "finish", "", "Lkotlin/ranges/IntRange;", "getFinish", "(Lkotlin/ranges/IntRange;)I", "isRoutine", "", "(Lcom/intellij/psi/tree/IElementType;)Z", "jbi", "Lcom/intellij/util/containers/JBIterable;", "B", "Lcom/intellij/formatting/Block;", "", "getJbi", "(Ljava/lang/Iterable;)Lcom/intellij/util/containers/JBIterable;", "lowerName", "", "Lcom/intellij/database/model/DasNamed;", "getLowerName", "(Lcom/intellij/database/model/DasNamed;)Ljava/lang/String;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "getRole", "(Lcom/intellij/sql/formatter/model/SqlBlock;)Lcom/intellij/sql/formatter/model/BlockRole;", "createBlockForBinaryExpression", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "node", "Lcom/intellij/lang/ASTNode;", "createBlockForConstraint", "createBlockForIdentifier", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "createBlockForParenthesizedExpression", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "createBlockForStatement", "dbms", "createBlockForUnspecifiedLoop", "Lcom/intellij/sql/formatter/model/SqlLoopBlock;", "createDropBlock", "createFunctionCallOrSubqueryClause", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "createUnaryExpressionBlock", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "handleStringLiteral", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "instantiateCommonDefaultBlock", "type", "instantiateDefaultBlock", "makeDefaultBlock", "parent", "makeLeftAlignment", "Lcom/intellij/formatting/Alignment;", "makeLeftAlignmentBS", "makeRightAlignment", "makeRightAlignmentBS", "adjust", "filter", "Lorg/jetbrains/annotations/NotNull;", "role1", "role2", "role3", "types", "", "(Ljava/lang/Iterable;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/util/containers/JBIterable;", "find", "(Ljava/lang/Iterable;)Lcom/intellij/formatting/Block;", "findConsequence", "", "since", "predicate", "Lkotlin/Function1;", "findCreatorFor", "Lkotlin/reflect/KFunction0;", "Lcom/intellij/sql/formatter/model/NodeBlockFactoryRecord;", "findFirstInnerBlockOnTheSameLine", "offset", "findParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)Lcom/intellij/sql/formatter/model/SqlBlock;", "findPhrase", "Lcom/intellij/sql/formatter/model/FindPhraseResult;", "patterns", "(Ljava/util/List;I[[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/sql/formatter/model/FindPhraseResult;", "getType", "Lcom/intellij/formatting/WrapImpl$Type;", "Lcom/intellij/formatting/Wrap;", "hasInjection", "hasOnlyOneChild", "indexOf", "till", "notFound", "init", "initializer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "that", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/sql/formatter/model/SqlBlock;Lkotlin/jvm/functions/Function2;)Lcom/intellij/sql/formatter/model/SqlBlock;", "isAlways", "listChildren", "flatten", "primaryElementType", "primaryNode", "skip", "count", "intellij.database.sql.core.impl"})
@JvmName(name="SqlFormattingModelFun")
@SourceDebugExtension(value={"SMAP\nSqlFormattingModelFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,488:1\n469#1:497\n469#1:499\n469#1:500\n469#1:501\n469#1:502\n469#1:503\n469#1:504\n831#2,2:489\n1022#2,2:491\n945#2,2:493\n1112#2,2:495\n1#3:498\n*S KotlinDebug\n*F\n+ 1 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n*L\n449#1:497\n457#1:499\n459#1:500\n461#1:501\n463#1:502\n465#1:503\n467#1:504\n117#1:489,2\n118#1:491,2\n119#1:493,2\n120#1:495,2\n*E\n"})
public final class SqlFormattingModelFun {
    @NotNull
    private static final Map<IElementType, KClass<? extends SqlBlock>> COMMON_SIMPLE_ELEMENT_BLOCKS;
    @NotNull
    private static final Map<Dbms, Map<? extends IElementType, KClass<? extends SqlBlock>>> DIALECT_SPECIFIC_BLOCKS;
    @NotNull
    private static final Set<SqlDefinitionStubElementType<? extends SqlNamedElementStub<? extends SqlDefinition>, ? extends SqlDefinition>> CONSTRAINT_TYPES;

    @NotNull
    public static final Map<Dbms, Map<? extends IElementType, KClass<? extends SqlBlock>>> getDIALECT_SPECIFIC_BLOCKS() {
        return DIALECT_SPECIFIC_BLOCKS;
    }

    @NotNull
    public static final Set<SqlDefinitionStubElementType<? extends SqlNamedElementStub<? extends SqlDefinition>, ? extends SqlDefinition>> getCONSTRAINT_TYPES() {
        return CONSTRAINT_TYPES;
    }

    @NotNull
    public static final SqlBlock makeDefaultBlock(@NotNull SqlBlock parent2, @NotNull ASTNode node2) {
        SqlBlock block;
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        KClass<? extends SqlBlock> specificBlockClass = parent2.getContext().getDialectSpecificBlocks().get(type);
        SqlBlock sqlBlock = block = specificBlockClass == null ? SqlFormattingModelFun.instantiateDefaultBlock(node2, parent2.getContext()) : (SqlBlock)KClasses.createInstance(specificBlockClass);
        if (sqlBlock instanceof SqlNodeBlock) {
            SqlNodeBlock $this$withSetup$iv = (SqlNodeBlock)block;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent2, node2);
        } else if (sqlBlock instanceof SqlLeafBlock) {
            SqlLeafBlock $this$withSetup$iv = (SqlLeafBlock)block;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup(parent2, node2);
        } else if (sqlBlock instanceof SqlRangeBlock) {
            SqlRangeBlock $this$withSetup$iv = (SqlRangeBlock)block;
            boolean $i$f$withSetup = false;
            TextRange textRange = node2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent2, textRange, SqlFormattingModelFun.listChildren(node2));
        } else if (sqlBlock instanceof SqlInjectionHostBlock) {
            SqlInjectionHostBlock $this$withSetup$iv = (SqlInjectionHostBlock)block;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent2, node2);
        }
        return block;
    }

    @NotNull
    public static final SqlBlock instantiateDefaultBlock(@NotNull ASTNode node2, @NotNull SqlFormattingContext context) {
        KClass<? extends SqlBlock> simpleBlockClass;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Dbms dbms = context.getDialect().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = SqlFormattingModelFun.adjust(iElementType);
        SqlFormatterHelper dialectHelper = context.getDialectHelper();
        SqlBlock block = null;
        if (dialectHelper != null) {
            KFunction<SqlBlock> creator = dialectHelper.getBasicBlockCreation().get(type);
            if (creator == null) {
                creator = SqlFormattingModelFun.findCreatorFor(dialectHelper.getComplexBlockCreation(), node2);
            }
            if (creator != null) {
                block = (SqlBlock)((Function0)creator).invoke();
            }
        }
        if (block == null && (simpleBlockClass = COMMON_SIMPLE_ELEMENT_BLOCKS.get(type)) != null) {
            block = (SqlBlock)KClasses.createInstance(simpleBlockClass);
        }
        if (block == null) {
            block = SqlFormattingModelFun.instantiateCommonDefaultBlock(type, node2, dbms2, context);
        }
        return block;
    }

    private static final KFunction<SqlBlock> findCreatorFor(List<NodeBlockFactoryRecord> $this$findCreatorFor, ASTNode node2) {
        for (NodeBlockFactoryRecord r : $this$findCreatorFor) {
            if (!r.getMatcher().matches(node2)) continue;
            return r.getCreator();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final SqlBlock instantiateCommonDefaultBlock(IElementType type, ASTNode node2, Dbms dbms, SqlFormattingContext context) {
        SqlBlock sqlBlock;
        if (type instanceof SqlKeywordTokenType) {
            sqlBlock = Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_AS) ? (SqlKeyword)new SqlAS() : new SqlKeyword();
            return sqlBlock;
        }
        if (SqlUtilFun.isSymbol(node2)) {
            sqlBlock = Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_COMMA) ? (SqlSymbol)new SqlComma() : new SqlSymbol();
            return sqlBlock;
        }
        if (node2 instanceof IsExternal) {
            sqlBlock = new SqlLeafBlock();
            return sqlBlock;
        }
        if (node2 instanceof PsiErrorElement) {
            sqlBlock = new SqlErrorNodeBlock();
            return sqlBlock;
        }
        if (node2 instanceof SqlColumnAliasListImpl) {
            sqlBlock = new SqlColumnAliasCortegeBlock();
            return sqlBlock;
        }
        if (node2 instanceof SqlUnaryExpression) {
            sqlBlock = SqlFormattingModelFun.createUnaryExpressionBlock((SqlUnaryExpression)node2);
            return sqlBlock;
        }
        if (node2 instanceof SqlFunctionCallExpression) {
            sqlBlock = SqlFormattingModelFun.createFunctionCallOrSubqueryClause((SqlFunctionCallExpression)node2);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.BIGQUERY)) {
            char[] cArray = new char[]{'`'};
            if (SqlUtilFun.isSymbol(node2.getFirstChildNode(), cArray)) {
                cArray = new char[]{'`'};
                if (SqlUtilFun.isSymbol(node2.getLastChildNode(), cArray)) {
                    sqlBlock = new SqlMonolithBlock();
                    return sqlBlock;
                }
            }
        }
        if (type instanceof IsExternal) {
            sqlBlock = new SqlLeafBlock();
            return sqlBlock;
        }
        if (type instanceof SqlReferenceElementType) {
            sqlBlock = (SqlBlock)(type == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE ? (Block)new SqlExternalParameterBlock() : (Block)new SqlReferenceBlock());
            return sqlBlock;
        }
        if (SqlFormattingFunKt.getLITERAL_TYPES().contains(type)) {
            sqlBlock = new SqlLiteralBlock();
            return sqlBlock;
        }
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLINE_COMMENT_TYPES(), (Object)type)) {
            sqlBlock = new SqlLineCommentBlock();
            return sqlBlock;
        }
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getBLOCK_COMMENT_TYPES(), (Object)type)) {
            sqlBlock = new SqlBlockCommentBlock();
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
            sqlBlock = SqlFormattingModelFun.handleStringLiteral(node2, context);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
            sqlBlock = SqlFormattingModelFun.createBlockForIdentifier(node2);
            return sqlBlock;
        }
        if (SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(type)) {
            sqlBlock = SqlFormattingModelFun.createBlockForBinaryExpression(node2);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_PARENTHESIZED_EXPRESSION)) {
            sqlBlock = SqlFormattingModelFun.createBlockForParenthesizedExpression(node2);
            return sqlBlock;
        }
        if (SqlFormattingModelFun.isRoutine(type)) {
            sqlBlock = SqlRoutineBlockKt.createRoutineBlock(dbms);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_PROCEDURE_DEFINITION)) || Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_FUNCTION_DEFINITION))) {
            sqlBlock = SqlRoutineBlockKt.createRoutineBlock(dbms);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_LOOP_STATEMENT)) {
            sqlBlock = SqlFormattingModelFun.createBlockForUnspecifiedLoop(node2);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_STATEMENT) || Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_CALL_STATEMENT))) {
            sqlBlock = SqlFormattingModelFun.createBlockForStatement(node2, dbms);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_GENERIC_DROP_STATEMENT)) {
            sqlBlock = SqlFormattingModelFun.createDropBlock(node2);
            return sqlBlock;
        }
        if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(type)) {
            sqlBlock = new SqlSimpleTypeBlock();
            return sqlBlock;
        }
        if (SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT.contains(type)) {
            sqlBlock = new SqlTableTypeBlock();
            return sqlBlock;
        }
        if (CollectionsKt.contains((Iterable)CONSTRAINT_TYPES, (Object)type)) {
            sqlBlock = SqlFormattingModelFun.createBlockForConstraint(node2);
            return sqlBlock;
        }
        if (type instanceof SqlFileElementType || type instanceof TemplateDataElementType) {
            sqlBlock = new SqlFileBlock();
            return sqlBlock;
        }
        if (node2 instanceof SqlBlockStatementImpl) {
            sqlBlock = new SqlBlockStatementBlock();
            return sqlBlock;
        }
        if (node2 instanceof SqlDdlStatement) {
            sqlBlock = new SqlDdlStatementBlock();
            return sqlBlock;
        }
        if (SqlUtilFun.isKeyWord(node2)) {
            sqlBlock = new SqlKeyword();
            return sqlBlock;
        }
        if (SqlUtilFun.isComplex(node2)) {
            sqlBlock = new SqlUnsortedBlock();
            return sqlBlock;
        }
        sqlBlock = new SqlLeafBlock();
        return sqlBlock;
    }

    private static final SqlLoopBlock createBlockForUnspecifiedLoop(ASTNode node2) {
        ASTNode c2;
        for (c2 = node2.getFirstChildNode(); c2 != null && !CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLOOP_PRIMARY_WORD_TYPES(), (Object)c2.getElementType()); c2 = c2.getTreeNext()) {
        }
        ASTNode aSTNode = c2;
        return (aSTNode != null ? aSTNode.getElementType() : null) == SqlCommonKeywords.SQL_LOOP ? (SqlLoopBlock)new SqlSimpleLoopBlock() : (SqlLoopBlock)new SqlHeadLoopBlock();
    }

    private static final SqlRangeBlock createBlockForParenthesizedExpression(ASTNode node2) {
        return SqlUtilFun.getMeaningfulChildType(node2, 2) == SqlCommonTokens.SQL_COMMA ? (SqlRangeBlock)new SqlCortegeBlock() : (SqlRangeBlock)new SqlParenthesizedExpressionBlock();
    }

    private static final SqlNodeBlock createBlockForBinaryExpression(ASTNode node2) {
        IElementType t3;
        IElementType t2;
        ASTNode n22;
        ASTNode aSTNode = n22 = SqlUtilFun.getMeaningfulChild(node2, 1);
        Object object = t2 = aSTNode != null ? aSTNode.getElementType() : null;
        if (t2 == SqlCommonTokens.SQL_OP_ASSIGN) {
            return new SqlAssignmentBlock();
        }
        if (t2 == SqlCommonTokens.SQL_LEFT_BRACKET) {
            return new SqlArrayAccessBlock();
        }
        if (t2 == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) {
            IElementType t21;
            ASTNode aSTNode2 = n22;
            Object object2 = t21 = aSTNode2 != null ? SqlUtilFun.getMeaningfulChildType(aSTNode2, 0) : null;
            if (t21 == SqlCommonKeywords.SQL_IS) {
                return new SqlNullabilityCheckBlock();
            }
        }
        if (!((t3 = SqlUtilFun.getMeaningfulChildType(node2, 2)) != SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && t3 != SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL || t2 != SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && t2 != SqlCommonKeywords.SQL_IS)) {
            return new SqlNullabilityCheckBlock();
        }
        return new SqlBinaryExpressionBlock();
    }

    private static final SqlBlock createBlockForStatement(ASTNode node2, Dbms dbms) {
        ASTNode aSTNode = node2.getFirstChildNode();
        if (aSTNode == null || (aSTNode = aSTNode.getElementType()) == null) {
            return new SqlStatementBlock();
        }
        ASTNode firstChildType = aSTNode;
        return Intrinsics.areEqual((Object)firstChildType, (Object)SqlCompositeElementTypes.SQL_WITH_CLAUSE) ? (SqlBlock)new SqlQueryBlock() : (Intrinsics.areEqual((Object)firstChildType, (Object)SqlCommonKeywords.SQL_DO) && dbms.isPostgres() ? (SqlBlock)new SqlPgDoStatementBlock() : (SqlBlock)new SqlStatementBlock());
    }

    private static final SqlLeafBlock createBlockForIdentifier(ASTNode node2) {
        return node2.getTreeParent().getElementType() == SqlCompositeElementTypes.SQL_AS_EXPRESSION ? (SqlLeafBlock)new SqlAliasBlock() : (SqlLeafBlock)new SqlIdentifierBlock();
    }

    private static final SqlBlock createBlockForConstraint(ASTNode node2) {
        IElementType iElementType = SqlUtilFun.firstLeaf(node2).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType firstLeafElementType = iElementType;
        IElementType iElementType2 = SqlUtilFun.lastLeaf(node2).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
        IElementType lastLeafElementType = iElementType2;
        return firstLeafElementType == SqlCommonKeywords.SQL_CONSTRAINT ? (SqlBlock)new SqlNamedConstraintDefinitionBlock() : (firstLeafElementType == SqlCommonKeywords.SQL_DEFAULT ? (SqlBlock)new SqlColumnDefaultBlock() : (lastLeafElementType == SqlCommonKeywords.SQL_NULL ? (SqlBlock)new SqlColumnNullabilityBlock() : (SqlBlock)new SqlConstraintDefinitionBlock()));
    }

    private static final SqlBlock createDropBlock(ASTNode node2) {
        Object object = node2 instanceof SqlDropStatementImpl ? (SqlDropStatementImpl)node2 : null;
        if (object == null || (object = object.getTargetType()) == null) {
            object = ObjectKind.UNKNOWN_OBJECT;
        }
        return Intrinsics.areEqual((Object)object, (Object)ObjectKind.ROUTINE) ? (SqlBlock)new SqlDropRoutineBlock() : (SqlBlock)new SqlStatementBlock();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final SqlBlock createUnaryExpressionBlock(SqlUnaryExpression node2) {
        SqlBlock sqlBlock;
        IElementType iElementType = node2.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOpSign(...)");
        IElementType operation2 = iElementType;
        SqlExpression operand = node2.getOperand();
        if (Intrinsics.areEqual((Object)operation2, (Object)SqlCommonKeywords.SQL_NOT) && operand instanceof SqlFunctionCallExpression) {
            BuiltinFunction builtinFunction = ((SqlFunctionCallExpression)operand).getFunctionDefinition();
            if (Intrinsics.areEqual((Object)(builtinFunction != null ? SqlFormattingModelFun.getLowerName((DasNamed)builtinFunction) : null), (Object)"exists")) {
                sqlBlock = new SqlExistsClauseBlock();
                return sqlBlock;
            }
        }
        sqlBlock = new SqlUnsortedBlock();
        return sqlBlock;
    }

    private static final SqlFlowBlock createFunctionCallOrSubqueryClause(SqlFunctionCallExpression node2) {
        BuiltinFunction builtinFunction = node2.getFunctionDefinition();
        return Intrinsics.areEqual((Object)(builtinFunction != null ? SqlFormattingModelFun.getLowerName((DasNamed)builtinFunction) : null), (Object)"exists") ? (SqlFlowBlock)new SqlExistsClauseBlock() : (SqlFlowBlock)new SqlFunctionCallBlock();
    }

    private static final String getLowerName(DasNamed $this$lowerName) {
        String string;
        Object object = $this$lowerName;
        if (object != null && (object = object.getName()) != null && (object = StringKt.nullize$default((String)object, (boolean)false, (int)1, null)) != null) {
            Object object2 = object;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = ((String)object2).toLowerCase(locale);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final <B extends SqlBlock> B init(@NotNull B $this$init, @NotNull Function2<? super B, ? super B, Unit> initializer) {
        Intrinsics.checkNotNullParameter($this$init, (String)"<this>");
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        initializer.invoke($this$init, $this$init);
        return $this$init;
    }

    private static final boolean isRoutine(IElementType $this$isRoutine) {
        String string = $this$isRoutine.getDebugName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
        String name2 = string;
        return StringsKt.endsWith$default((String)name2, (String)"_CREATE_FUNCTION_STATEMENT", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"_CREATE_PROCEDURE_STATEMENT", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"_CREATE_METHOD_STATEMENT", (boolean)false, (int)2, null);
    }

    private static final IElementType adjust(IElementType $this$adjust) {
        IElementType iElementType;
        String string = $this$adjust.getDebugName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
        String name2 = string;
        if (StringsKt.endsWith$default((String)name2, (String)"_CREATE_TABLE_STATEMENT", (boolean)false, (int)2, null)) {
            SqlTableElementType sqlTableElementType = SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTableElementType), (String)"SQL_CREATE_TABLE_STATEMENT");
            iElementType = (IElementType)sqlTableElementType;
        } else if (StringsKt.endsWith$default((String)name2, (String)"_CREATE_VIEW_STATEMENT", (boolean)false, (int)2, null)) {
            SqlTableElementType sqlTableElementType = SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTableElementType), (String)"SQL_CREATE_VIEW_STATEMENT");
            iElementType = (IElementType)sqlTableElementType;
        } else if (StringsKt.endsWith$default((String)name2, (String)"_CREATE_MATERIALIZED_VIEW_STATEMENT", (boolean)false, (int)2, null)) {
            SqlTableElementType sqlTableElementType = SqlCompositeElementTypes.SQL_CREATE_MATERIALIZED_VIEW_STATEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTableElementType), (String)"SQL_CREATE_MATERIALIZED_VIEW_STATEMENT");
            iElementType = (IElementType)sqlTableElementType;
        } else {
            iElementType = $this$adjust;
        }
        return iElementType;
    }

    public static final /* synthetic */ <B extends SqlBlock> B findParent(SqlBlock $this$findParent) {
        Intrinsics.checkNotNullParameter((Object)$this$findParent, (String)"<this>");
        boolean $i$f$findParent = false;
        for (SqlBlock p2 = $this$findParent.getParent(); p2 != null; p2 = p2.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"B");
            if (!(p2 instanceof SqlBlock)) continue;
            return (B)p2;
        }
        return null;
    }

    @Nullable
    public static final ASTNode primaryNode(@NotNull SqlBlock $this$primaryNode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$primaryNode, (String)"<this>");
        SqlBlock sqlBlock = $this$primaryNode;
        if (sqlBlock instanceof SqlLeafBlock) {
            object = ((SqlLeafBlock)$this$primaryNode).getNode();
        } else if (sqlBlock instanceof SqlNodeBlock) {
            object = ((SqlNodeBlock)$this$primaryNode).getBlockNode();
        } else if (sqlBlock instanceof SqlRangeBlock) {
            object = ((SqlRangeBlock)$this$primaryNode).getNestedBlocks().size() == 1 ? SqlFormattingModelFun.primaryNode(((SqlRangeBlock)$this$primaryNode).getNestedBlocks().get(0)) : null;
        } else if (sqlBlock instanceof SqlInjectionHostBlock) {
            object = ((SqlInjectionHostBlock)$this$primaryNode).getBlockNode();
        } else if (sqlBlock instanceof SqlRootBlock) {
            object = ((SqlRootBlock)$this$primaryNode).getBlockNode();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final IElementType primaryElementType(@NotNull SqlBlock $this$primaryElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$primaryElementType, (String)"<this>");
        ASTNode aSTNode = SqlFormattingModelFun.primaryNode($this$primaryElementType);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $this$listChildren) {
        Intrinsics.checkNotNullParameter((Object)$this$listChildren, (String)"<this>");
        return SqlFormattingModelFun.listChildren($this$listChildren, (Function1<? super ASTNode, Boolean>)((Function1)listChildren.1.INSTANCE));
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $this$listChildren, @NotNull Function1<? super ASTNode, Boolean> flatten) {
        Intrinsics.checkNotNullParameter((Object)$this$listChildren, (String)"<this>");
        Intrinsics.checkNotNullParameter(flatten, (String)"flatten");
        List list = new ArrayList();
        SqlFormattingModelFun.listChildren$listChildrenRecursively(flatten, list, $this$listChildren);
        return list;
    }

    private static final SqlBlock handleStringLiteral(ASTNode node2, SqlFormattingContext context) {
        return SqlUtilFun.doesntIntersect(node2, context.getInterestingRange()) ? (SqlBlock)new SqlLiteralBlock() : (SqlFormattingModelFun.hasInjection(node2) ? (SqlBlock)new SqlLiteralInjectionHostBlock() : (SqlUtilFun.isLeaf(node2) || SqlFormattingModelFun.hasOnlyOneChild(node2, (Function1<? super IElementType, Boolean>)((Function1)handleStringLiteral.1.INSTANCE)) ? (SqlBlock)new SqlLiteralBlock() : (SqlBlock)new SqlComplexTextBlock()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasOnlyOneChild(ASTNode $this$hasOnlyOneChild, Function1<? super IElementType, Boolean> predicate) {
        ASTNode aSTNode = $this$hasOnlyOneChild.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode child1 = aSTNode;
        if (child1.getTreeNext() != null) return false;
        IElementType iElementType = child1.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        if ((Boolean)predicate.invoke((Object)iElementType) == false) return false;
        return true;
    }

    public static final boolean hasInjection(@NotNull ASTNode $this$hasInjection) {
        Intrinsics.checkNotNullParameter((Object)$this$hasInjection, (String)"<this>");
        if (!Registry.is((String)"sql.formatter.consider.language.injection")) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        PsiElement element2 = $this$hasInjection.getPsi();
        InjectedLanguageManager.getInstance((Project)element2.getContainingFile().getProject()).enumerate(element2, (arg_0, arg_1) -> SqlFormattingModelFun.hasInjection$lambda$0(result2, arg_0, arg_1));
        return result2.element;
    }

    public static final int indexOf(@NotNull List<? extends ASTNode> $this$indexOf, @NotNull IElementType type, int since, int till, int notFound) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int n = $this$indexOf.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw new IllegalArgumentException("Negative since = " + since);
        }
        int n3 = Math.min(till, n);
        for (int i2 = since; i2 < n3; ++i2) {
            if ($this$indexOf.get(i2).getElementType() != type) continue;
            return i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, IElementType iElementType, int n, int n3, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = list.size();
        }
        if ((n5 & 8) != 0) {
            n4 = -1;
        }
        return SqlFormattingModelFun.indexOf((List<? extends ASTNode>)list, iElementType, n, n3, n4);
    }

    public static final int indexOf(@NotNull List<? extends ASTNode> $this$indexOf, @NotNull Set<? extends IElementType> types2, int since, int till, int notFound) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        int n = $this$indexOf.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw new IllegalArgumentException("Negative since = " + since);
        }
        int n3 = Math.min(till, n);
        for (int i2 = since; i2 < n3; ++i2) {
            if (!types2.contains($this$indexOf.get(i2).getElementType())) continue;
            return i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, Set set, int n, int n3, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = list.size();
        }
        if ((n5 & 8) != 0) {
            n4 = -1;
        }
        return SqlFormattingModelFun.indexOf((List<? extends ASTNode>)list, set, n, n3, n4);
    }

    @Nullable
    public static final IntRange findConsequence(@NotNull List<? extends ASTNode> $this$findConsequence, int since, @NotNull Function1<? super ASTNode, Boolean> predicate) {
        int f;
        int s2;
        Intrinsics.checkNotNullParameter($this$findConsequence, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int n = $this$findConsequence.size();
        for (s2 = since; s2 < n && !((Boolean)predicate.invoke((Object)$this$findConsequence.get(s2))).booleanValue(); ++s2) {
        }
        if (s2 == n) {
            return null;
        }
        for (f = s2 + 1; f < n && ((Boolean)predicate.invoke((Object)$this$findConsequence.get(f))).booleanValue(); ++f) {
        }
        return RangesKt.until((int)s2, (int)f);
    }

    public static /* synthetic */ IntRange findConsequence$default(List list, int n, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        return SqlFormattingModelFun.findConsequence(list, n, (Function1<? super ASTNode, Boolean>)function1);
    }

    @Nullable
    public static final FindPhraseResult findPhrase(@NotNull List<? extends ASTNode> $this$findPhrase, int offset, @NotNull IElementType[][] patterns2) {
        Intrinsics.checkNotNullParameter($this$findPhrase, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)patterns2, (String)"patterns");
        int n = $this$findPhrase.size();
        int k = offset;
        while (k < n) {
            int begin;
            ASTNode node2;
            if (SqlUtilFun.isWhitespaceOrComment(node2 = $this$findPhrase.get(begin = k++))) continue;
            int n3 = ((Object[])patterns2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                IElementType[] iElementTypeArray = patterns2[i2];
                int m = SqlUtilFun.matchPhrase($this$findPhrase, begin, Arrays.copyOf(iElementTypeArray, iElementTypeArray.length));
                if (m <= 0) continue;
                return new FindPhraseResult(i2, begin, begin + m);
            }
        }
        return null;
    }

    public static final int getFinish(@NotNull IntRange $this$finish) {
        Intrinsics.checkNotNullParameter((Object)$this$finish, (String)"<this>");
        boolean $i$f$getFinish = false;
        return $this$finish.getEndInclusive();
    }

    @NotNull
    public static final Alignment makeLeftAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeLeftAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @Nullable
    public static final WrapImpl.Type getType(@Nullable Wrap $this$getType) {
        WrapImpl wrapImpl = $this$getType instanceof WrapImpl ? (WrapImpl)$this$getType : null;
        return wrapImpl != null ? wrapImpl.getType() : null;
    }

    public static final boolean isAlways(@Nullable Wrap $this$isAlways) {
        return SqlFormattingModelFun.getType($this$isAlways) == WrapImpl.Type.WRAP_ALWAYS;
    }

    @NotNull
    public static final JBIterable<SqlBlock> skip(@NotNull Iterable<? extends SqlBlock> $this$skip, int count) {
        Intrinsics.checkNotNullParameter($this$skip, (String)"<this>");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$skip;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.skip(count);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"skip(...)");
        return jBIterable2;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $this$find, @NotNull BlockRole role) {
        SqlBlock sqlBlock;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            Iterable<? extends SqlBlock> iterable = $this$find;
            Iterator<? extends SqlBlock> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it2 = sqlBlock2 = iterator.next();
                boolean bl = false;
                if (!(it2.getRole() == role)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $this$find, @NotNull IElementType type) {
        SqlBlock sqlBlock;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Iterable<? extends SqlBlock> iterable = $this$find;
            Iterator<? extends SqlBlock> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it2 = sqlBlock2 = iterator.next();
                boolean bl = false;
                if (!(SqlFormattingModelFun.primaryElementType(it2) == type)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    public static final /* synthetic */ <B extends Block> B find(Iterable<? extends Block> $this$find) {
        Block block;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
            boolean $i$f$find = false;
            Iterable<? extends Block> iterable = $this$find;
            Iterator<? extends Block> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Block block2;
                Block it2 = block2 = iterator.next();
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"B");
                if (!(it2 instanceof Block)) continue;
                block = block2;
                break block1;
            }
            block = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"B");
        return (B)block;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$4((Function1)new Function1<SqlBlock, Boolean>(role){
            final /* synthetic */ BlockRole $role;
            {
                this.$role = $role;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SqlBlock it2) {
                return it2.getRole() == this.$role;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role1, @NotNull BlockRole role2) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Intrinsics.checkNotNullParameter((Object)((Object)role2), (String)"role2");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$5((Function1)new Function1<SqlBlock, Boolean>(role1, role2){
            final /* synthetic */ BlockRole $role1;
            final /* synthetic */ BlockRole $role2;
            {
                this.$role1 = $role1;
                this.$role2 = $role2;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SqlBlock it2) {
                return it2.getRole() == this.$role1 || it2.getRole() == this.$role2;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role1, @NotNull BlockRole role2, @NotNull BlockRole role3) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Intrinsics.checkNotNullParameter((Object)((Object)role2), (String)"role2");
        Intrinsics.checkNotNullParameter((Object)((Object)role3), (String)"role3");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$6((Function1)new Function1<SqlBlock, Boolean>(role1, role2, role3){
            final /* synthetic */ BlockRole $role1;
            final /* synthetic */ BlockRole $role2;
            final /* synthetic */ BlockRole $role3;
            {
                this.$role1 = $role1;
                this.$role2 = $role2;
                this.$role3 = $role3;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SqlBlock it2) {
                return it2.getRole() == this.$role1 || it2.getRole() == this.$role2 || it2.getRole() == this.$role3;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$7((Function1)new Function1<SqlBlock, Boolean>(type){
            final /* synthetic */ IElementType $type;
            {
                this.$type = $type;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SqlBlock it2) {
                return it2 instanceof SqlSingleNodeBlock && ((SqlSingleNodeBlock)((Object)it2)).getBlockElementTypes() == this.$type;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, IElementType ... types2) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)types2, (String)"types");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$8((Function1)new Function1<SqlBlock, Boolean>(types2){
            final /* synthetic */ IElementType[] $types;
            {
                this.$types = $types;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SqlBlock it2) {
                return it2 instanceof SqlSingleNodeBlock && ArraysKt.contains((Object[])this.$types, (Object)((SqlSingleNodeBlock)((Object)it2)).getBlockElementTypes());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    public static final /* synthetic */ <B extends Block> JBIterable<B> filter(Iterable<? extends Block> $this$filter) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        boolean $i$f$filter = false;
        Iterable<? extends Block> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        Intrinsics.reifiedOperationMarker((int)4, (String)"B");
        JBIterable jBIterable2 = jBIterable.filter(Block.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final <B extends Block> JBIterable<B> getJbi(@NotNull Iterable<? extends B> $this$jbi) {
        Intrinsics.checkNotNullParameter($this$jbi, (String)"<this>");
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return jBIterable;
    }

    @NotNull
    public static final BlockRole getRole(@Nullable SqlBlock $this$role) {
        boolean $i$f$getRole = false;
        Object object = $this$role;
        if (object == null || (object = object.getRole()) == null) {
            object = BlockRole.NOTHING;
        }
        return object;
    }

    @Nullable
    public static final SqlBlock findFirstInnerBlockOnTheSameLine(@NotNull SqlBlock $this$findFirstInnerBlockOnTheSameLine, int offset, @NotNull Function1<? super SqlBlock, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$findFirstInnerBlockOnTheSameLine, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        SqlBlock candidate = null;
        int n = $this$findFirstInnerBlockOnTheSameLine.getNestedBlocks().size();
        for (int i2 = n - 1; -1 < i2; --i2) {
            SqlBlock b2 = $this$findFirstInnerBlockOnTheSameLine.getNestedBlocks().get(i2);
            int x = b2.getRange().getStartOffset();
            if (x >= offset) continue;
            if ($this$findFirstInnerBlockOnTheSameLine.getContext().textContains(x, offset, '\n')) break;
            if (!((Boolean)predicate.invoke((Object)b2)).booleanValue()) continue;
            candidate = b2;
        }
        return candidate;
    }

    private static final void listChildren$listChildrenRecursively(Function1<? super ASTNode, Boolean> $flatten, List<ASTNode> list, ASTNode parentNode) {
        for (ASTNode node2 = parentNode.getFirstChildNode(); node2 != null; node2 = node2.getTreeNext()) {
            IElementType type;
            Intrinsics.checkNotNullExpressionValue((Object)node2.getElementType(), (String)"getElementType(...)");
            if (type == SqlElementTypes.SQL_DUMMY_BLOCK || ((Boolean)$flatten.invoke((Object)node2)).booleanValue()) {
                SqlFormattingModelFun.listChildren$listChildrenRecursively($flatten, list, node2);
                continue;
            }
            if (SqlUtilFun.isWhitespace(node2)) continue;
            Collection collection2 = list;
            collection2.add(node2);
        }
    }

    private static final void hasInjection$lambda$0(Ref.BooleanRef $result, PsiFile psiFile, List list) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<anonymous parameter 1>");
        $result.element = true;
    }

    private static final boolean filter$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_AS, (Object)Reflection.getOrCreateKotlinClass(SqlAS.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SPECIAL_LITERAL, (Object)Reflection.getOrCreateKotlinClass(SqlLeafBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlBlockStatementBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SELECT_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_UNION_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_INSERT_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_UPDATE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_DELETE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_MERGE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlMergeBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlExplainPlanBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlParenthesizedSubqueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CASE_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlCaseExpressionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CASE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlCaseStatementBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_REFERENCE_LIST, (Object)Reflection.getOrCreateKotlinClass(SqlCortegeBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlCreateTableBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_SCHEMA_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlCreateSchemaBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_COLUMN_DEFINITION), (Object)Reflection.getOrCreateKotlinClass(SqlColumnBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_REFERENCES_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlForeignKeyReferencesBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_CASCADE_OPTION, (Object)Reflection.getOrCreateKotlinClass(SqlConstraintDetailBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CONSTRAINT_CHARACTERISTIC_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlConstraintDetailBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_ALTER_TABLE_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlAlterTableBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION), (Object)Reflection.getOrCreateKotlinClass(SqlAlterInstructionBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlViewBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_MATERIALIZED_VIEW_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlViewBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_IF_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlForkBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_THEN_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlForkSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ELSE_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlForkSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ELSEIF_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlElsifSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlHeadLoopBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlHeadLoopBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlRepeatLoopBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT, (Object)Reflection.getOrCreateKotlinClass(SqlAssignmentBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK, (Object)Reflection.getOrCreateKotlinClass(SqlBatchBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlTriggerBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlCreateExoticObjectBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlSimpleSettingAssignmentBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_TYPE_PARAMETER_LIST, (Object)Reflection.getOrCreateKotlinClass(SqlTypeParameterListBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_DECLARE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlDeclareSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SIZE_WITH_MEASURE, (Object)Reflection.getOrCreateKotlinClass(SqlSizeBlock.class))};
        COMMON_SIMPLE_ELEMENT_BLOCKS = MapsKt.mapOf((Pair[])objectArray);
        DIALECT_SPECIFIC_BLOCKS = MapsKt.mapOf((Pair)TuplesKt.to((Object)Dbms.CLICKHOUSE, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (Object)Reflection.getOrCreateKotlinClass(SqlIdentifierBlock.class)))));
        objectArray = new SqlDefinitionStubElementType[]{SqlCompositeElementTypes.SQL_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION, SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION};
        CONSTRAINT_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

