/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.SqlSpacing;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlCortegeBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.NotNullList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u0004H\u0014J\b\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\u001eH\u0014J\u0006\u0010%\u001a\u00020\u001eJ\b\u0010&\u001a\u00020\u001eH\u0014J\b\u0010'\u001a\u00020\u001eH\u0014J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0001H\u0014J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0015\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0010\u00a2\u0006\u0002\b/J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010\u001f\u001a\u00020\u0001H\u0016J\u0010\u00106\u001a\u00020.2\u0006\u00107\u001a\u000208H\u0016J\u001a\u00109\u001a\u00020\u001e2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010<\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.J\u001a\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020.2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010.J\u0016\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020*2\u0006\u0010-\u001a\u00020.J\u001e\u0010B\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020*2\u0006\u0010C\u001a\u0002052\u0006\u0010-\u001a\u00020.J\u0010\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010EH\u0014J\b\u0010G\u001a\u00020\u0004H\u0014J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u000eH\u0016J\u0018\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010M\u001a\u00020IH\u0016J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020QH\u0016J\u001a\u0010R\u001a\u0004\u0018\u0001012\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020TJ\n\u0010V\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010W\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010X\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.J\b\u0010Y\u001a\u00020\u0004H\u0016J\u0010\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u0001H\u0016J\u0010\u0010\\\u001a\u00020\u00012\u0006\u00107\u001a\u000208H\u0016J\u001e\u0010]\u001a\u0004\u0018\u00010\u00072\b\u0010^\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0004J\u0010\u0010`\u001a\u00020\u00012\u0006\u00107\u001a\u000208H\u0002J*\u0010a\u001a\u00020\u001e2\f\u0010b\u001a\b\u0012\u0004\u0012\u0002080E2\b\b\u0002\u0010c\u001a\u00020\u000e2\b\b\u0002\u0010d\u001a\u00020\u000eH\u0004J-\u0010e\u001a\u0004\u0018\u00010\u00072\b\u0010f\u001a\u0004\u0018\u00010\u00072\b\u0010^\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bgJ+\u0010e\u001a\u0004\u0018\u00010\u00072\b\u0010f\u001a\u0004\u0018\u00010\u00072\u0006\u0010h\u001a\u00020i2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bgJ-\u0010e\u001a\u0004\u0018\u00010\u00072\b\u0010f\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bgJ\u001c\u0010e\u001a\u0004\u0018\u00010\u00072\b\u0010^\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010_\u001a\u00020\u0004J!\u0010e\u001a\u0004\u0018\u00010\u00072\u0006\u0010h\u001a\u00020i2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bgJ#\u0010e\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bgJ\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00010kJ\b\u0010l\u001a\u00020\u001eH\u0014J\b\u0010m\u001a\u00020\u0004H\u0014J\b\u0010n\u001a\u00020\u001eH\u0016J\b\u0010o\u001a\u00020\u0004H\u0016J\u0015\u0010p\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\bqJ\u0018\u0010r\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0002J\u000e\u0010s\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.J\u0016\u0010t\u001a\u00020\u001e2\u0006\u0010u\u001a\u00020.2\u0006\u0010v\u001a\u00020.J\u0006\u0010w\u001a\u00020\u0004J\b\u0010x\u001a\u00020\u0004H\u0016J\b\u0010y\u001a\u00020\u001eH\u0014J\b\u0010z\u001a\u00020\u0004H\u0016J\b\u0010{\u001a\u00020\u000eH\u0017J\b\u0010|\u001a\u00020\u000eH\u0016J\b\u0010}\u001a\u00020\u0004H\u0014J\b\u0010~\u001a\u00020\u000eH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u007f\u0080\u0001\u00a8\u0006\u0081\u0001"}, d2={"Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "()V", "analyzed", "", "hasRoles", "<set-?>", "Lcom/intellij/formatting/Wrap;", "innerWrap", "getInnerWrap", "()Lcom/intellij/formatting/Wrap;", "setInnerWrap", "(Lcom/intellij/formatting/Wrap;)V", "minLength", "", "getMinLength", "()I", "setMinLength", "(I)V", "nestedBlocks", "", "getNestedBlocks", "()Ljava/util/List;", "parent", "getParent", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "refined", "addNestedBlock", "", "block", "addNestedBlock$intellij_database_sql_core_impl", "allowedToCollapse", "analyseFlowForIndenting", "analyseFlowForReformatting", "analyseOriginalCodeStyle", "analyze", "analyzeFlow", "configureFormattingAttributes", "considerBlock", "convertWrapSettingToWrapType", "Lcom/intellij/formatting/WrapType;", "setting", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "distributeAlign", "align", "Lcom/intellij/formatting/Alignment;", "distributeLeftAlign", "distributeRightAlign", "role1", "role2", "distributeWrap", "type", "distributeWrapIndent", "indent", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "flowToProduceCommentsFlowBlocks", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "getChildAttributesForNewElementAfter", "index", "getChildAttributesForNewElementAtTheEnd", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getSpacing", "child1", "Lcom/intellij/formatting/Block;", "child2", "getThisOrParentWrap", "getTransitiveWrap", "hasRole", "incomplete", "isChildTerminal", "child", "makeBlock", "makeCascadeWrap", "wrapType", "wrapFirst", "makeDefaultBlock", "makeDefaultBlocks", "nodes", "since", "till", "makeWrap", "parentWrap", "makeWrap$intellij_database_sql_core_impl", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "nestedBlocksIter", "Lcom/intellij/util/containers/JBIterable;", "patchFormattingAttributesForChildren", "preserveUserLineBreaks", "refine", "requiresFollowingBreak", "setup", "setup$intellij_database_sql_core_impl", "shouldBeSpace", "tabify", "tabifyInner", "outerRole", "innerRole", "tailCompleted", "tailFormed", "tuneNestedNodesAfterAnalysis", "userBreakFirstElement", "userDelimiterSetting", "userElementsLineSetting", "userRequiresExpand", "userWrapSetting", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlFlowBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1121:1\n1#2:1122\n*E\n"})
public abstract class SqlFlowBlock
extends SqlBlock {
    protected SqlBlock parent;
    @NotNull
    private final List<SqlBlock> nestedBlocks = (List)new NotNullList();
    private int minLength;
    private boolean hasRoles;
    @Nullable
    private Wrap innerWrap;
    private boolean analyzed;
    private boolean refined;

    private SqlFlowBlock() {
        super(null);
    }

    @Override
    @NotNull
    public SqlBlock getParent() {
        SqlBlock sqlBlock = this.parent;
        if (sqlBlock != null) {
            return sqlBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        return null;
    }

    protected void setParent(@NotNull SqlBlock sqlBlock) {
        Intrinsics.checkNotNullParameter((Object)sqlBlock, (String)"<set-?>");
        this.parent = sqlBlock;
    }

    @Override
    @NotNull
    public List<SqlBlock> getNestedBlocks() {
        return this.nestedBlocks;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    @Nullable
    public final Wrap getInnerWrap() {
        return this.innerWrap;
    }

    protected final void setInnerWrap(@Nullable Wrap wrap2) {
        this.innerWrap = wrap2;
    }

    public final void setup$intellij_database_sql_core_impl(@NotNull SqlBlock parent2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)parent2, (Object)this);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setParent(parent2);
    }

    @Nullable
    protected List<FlowPattern> flowPatterns() {
        return null;
    }

    protected boolean flowToProduceCommentsFlowBlocks() {
        return true;
    }

    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return SqlFormattingFunKt.usualRole(node2);
    }

    public final void addNestedBlock$intellij_database_sql_core_impl(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ((Collection)this.getNestedBlocks()).add(block);
        this.considerBlock(block);
        this.countRole$intellij_database_sql_core_impl(block.getRole());
        this.hasRoles = this.hasRoles || block.getRole().getExists();
    }

    protected void considerBlock(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
    }

    public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
    }

    @Override
    public final void analyze() {
        if (!this.analyzed) {
            boolean bl;
            boolean bl2 = bl = this.getContext() != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "The context is not initialized yet for block " + this;
                throw new AssertionError((Object)string);
            }
            this.grow();
            boolean childrenHaveBreaks = false;
            for (SqlBlock b2 : this.getNestedBlocks()) {
                b2.analyze();
                childrenHaveBreaks = childrenHaveBreaks || b2.getHasUserBreaks();
            }
            this.setHasUserBreaks(childrenHaveBreaks || this.contains('\n'));
            this.analyzeFlow();
            this.analyzed = true;
        }
    }

    protected void analyzeFlow() {
        this.analyseOriginalCodeStyle();
        switch (this.getNestedBlocks().size()) {
            case 0: {
                break;
            }
            case 1: {
                SqlBlock nestedBlock = (SqlBlock)CollectionsKt.first(this.getNestedBlocks());
                this.setMinLength(nestedBlock.getMinLength());
                this.setShape(nestedBlock.getShape());
                break;
            }
            default: {
                if (this.getContext().getReformatting()) {
                    this.analyseFlowForReformatting();
                } else {
                    this.analyseFlowForIndenting();
                }
                this.tuneNestedNodesAfterAnalysis();
            }
        }
    }

    private final void analyseFlowForReformatting() {
        if (this.getShape() == BlockShape.NOT_DECIDED) {
            int len = this.getNestedBlocks().size() / 2;
            boolean broken = false;
            boolean hasRoles = false;
            for (SqlBlock b2 : this.getNestedBlocks()) {
                len += b2.getMinLength();
                broken = broken || b2.getShape().getExpanding() || b2 instanceof SqlLeafBlock && SqlFormattingFunKt.MUST_FOLLOWED_BY_NL_TYPES.contains(((SqlLeafBlock)b2).getElementType()) && !b2.isLast();
                hasRoles = hasRoles || b2.getRole().getExists();
            }
            this.setMinLength(len);
            this.setShape(broken ? BlockShape.DECIDED_TO_MULTI_ROWS : (len > this.getContext().getLengthThresholdMax() ? BlockShape.DECIDED_TO_MULTI_ROWS : (this.userRequiresExpand() ? BlockShape.DECIDED_TO_MULTI_ROWS : (this.preserveUserLineBreaks() ? BlockShape.DECIDED_TO_MULTI_ROWS : (len <= this.getContext().getLengthThresholdMin() && this.allowedToCollapse() ? BlockShape.DECIDED_TO_ONE_ROW : (hasRoles ? BlockShape.DECIDE_LATER : BlockShape.NOT_DECIDED))))));
        }
    }

    private final void analyseFlowForIndenting() {
        this.setShape(this.getHasUserBreaks() ? BlockShape.DECIDED_TO_MULTI_ROWS : BlockShape.DECIDED_TO_ONE_ROW);
        this.setMinLength(this.getRange().getLength());
    }

    protected void analyseOriginalCodeStyle() {
    }

    protected boolean preserveUserLineBreaks() {
        return this.getContext().getKlb() && this.getHasUserBreaks();
    }

    protected void tuneNestedNodesAfterAnalysis() {
    }

    @Override
    public void refine() {
        if (this.getContext().getDisabled()) {
            return;
        }
        if (!this.refined) {
            this.refined = true;
            if (this.hasRoles && this.getMyWrap() != null || this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) >= 0 || this.getContext().getJustAdjust()) {
                this.configureFormattingAttributes();
            }
            for (SqlBlock b2 : this.getNestedBlocks()) {
                b2.refine();
            }
            this.patchFormattingAttributesForChildren();
        }
    }

    protected void configureFormattingAttributes() {
    }

    protected void patchFormattingAttributesForChildren() {
    }

    public final void distributeWrap(@NotNull WrapType type, @NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Wrap w = this.makeWrap(type, type == WrapType.CHOP_DOWN_IF_LONG || type == WrapType.ALWAYS);
        for (SqlBlock b2 : CollectionsKt.asSequence((Iterable)this.getNestedBlocks())) {
            if (b2.getRole() != role) continue;
            b2.setMyWrap(w);
        }
    }

    public final void distributeWrapIndent(@NotNull WrapType type, @NotNull Indent indent, @NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Wrap w = this.makeWrap(type, true);
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != role) continue;
            b2.setMyWrap(w);
            b2.setMyIndent(indent);
        }
    }

    public final void distributeLeftAlign(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Alignment align = SqlFormattingModelFun.makeLeftAlignment();
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != role) continue;
            b2.setMyAlign(align);
        }
    }

    public final void tabify(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Alignment align = SqlFormattingModelFun.makeLeftAlignmentBS();
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != role) continue;
            b2.setMyAlign(align);
        }
    }

    public final void tabifyInner(@NotNull BlockRole outerRole, @NotNull BlockRole innerRole) {
        Intrinsics.checkNotNullParameter((Object)((Object)outerRole), (String)"outerRole");
        Intrinsics.checkNotNullParameter((Object)((Object)innerRole), (String)"innerRole");
        Alignment align = SqlFormattingModelFun.makeLeftAlignmentBS();
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != outerRole || !(b2 instanceof SqlFlowBlock)) continue;
            ((SqlFlowBlock)b2).distributeAlign(align, innerRole);
        }
    }

    private final void distributeAlign(Alignment align, BlockRole role) {
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != role) continue;
            b2.setMyAlign(align);
        }
    }

    public final void distributeRightAlign(@NotNull BlockRole role1, @Nullable BlockRole role2) {
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Alignment align = SqlFormattingModelFun.makeRightAlignment();
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != role1 && (role2 == null || b2.getRole() != role2)) continue;
            SqlLeafBlock sqlLeafBlock = b2.getLastLeafBlock();
            if (sqlLeafBlock == null) continue;
            sqlLeafBlock.setMyAlign(align);
        }
    }

    public static /* synthetic */ void distributeRightAlign$default(SqlFlowBlock sqlFlowBlock, BlockRole blockRole, BlockRole blockRole2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: distributeRightAlign");
        }
        if ((n & 2) != 0) {
            blockRole2 = null;
        }
        sqlFlowBlock.distributeRightAlign(blockRole, blockRole2);
    }

    @Override
    @Nullable
    public Wrap getTransitiveWrap() {
        Wrap wrap2 = this.getMyWrap();
        if (wrap2 == null) {
            wrap2 = this.getParent().getTransitiveWrap();
        }
        return wrap2;
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_core_impl(@SqlCodeStyleConst.WrapMagicValues int setting, boolean wrapFirst) {
        return this.makeWrap(this.convertWrapSettingToWrapType(setting), wrapFirst);
    }

    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_core_impl$default(SqlFlowBlock sqlFlowBlock, int n, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n3 & 2) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_core_impl(n, bl);
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_core_impl(@Nullable Wrap parentWrap, @SqlCodeStyleConst.WrapMagicValues int setting, boolean wrapFirst) {
        return this.makeWrap$intellij_database_sql_core_impl(parentWrap, this.convertWrapSettingToWrapType(setting), wrapFirst);
    }

    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_core_impl$default(SqlFlowBlock sqlFlowBlock, Wrap wrap2, int n, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_core_impl(wrap2, n, bl);
    }

    private final WrapType convertWrapSettingToWrapType(int setting) {
        return switch (setting) {
            case 2 -> WrapType.CHOP_DOWN_IF_LONG;
            case 1 -> WrapType.ALWAYS;
            case 3 -> WrapType.NORMAL;
            default -> null;
        };
    }

    @Nullable
    protected final Wrap makeCascadeWrap(@Nullable WrapType wrapType, boolean wrapFirst) {
        if (wrapType == null || wrapType == WrapType.NONE) {
            return null;
        }
        if (wrapType == WrapType.ALWAYS) {
            return Wrap.createWrap((WrapType)wrapType, (boolean)wrapFirst);
        }
        Wrap parentWrap = this.getThisOrParentWrap();
        return this.makeWrap$intellij_database_sql_core_impl(parentWrap, wrapType, wrapFirst);
    }

    public static /* synthetic */ Wrap makeCascadeWrap$default(SqlFlowBlock sqlFlowBlock, WrapType wrapType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeCascadeWrap");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeCascadeWrap(wrapType, bl);
    }

    private final Wrap getThisOrParentWrap() {
        for (SqlBlock b2 = (SqlBlock)this; b2 != null; b2 = b2.getParent()) {
            Wrap w;
            Wrap wrap2;
            if (b2 instanceof SqlFlowBlock) {
                wrap2 = ((SqlFlowBlock)b2).innerWrap;
                if (wrap2 == null) {
                    wrap2 = ((SqlFlowBlock)b2).getWrap();
                }
            } else {
                wrap2 = b2.getWrap();
            }
            if ((w = wrap2) == null || SqlFormattingModelFun.getType(w) == WrapImpl.Type.DO_NOT_WRAP) continue;
            return w;
        }
        return null;
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_core_impl(@NotNull BlockShape shape, boolean wrapFirst) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        return this.makeWrap$intellij_database_sql_core_impl(null, shape, wrapFirst);
    }

    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_core_impl$default(SqlFlowBlock sqlFlowBlock, BlockShape blockShape, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_core_impl(blockShape, bl);
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_core_impl(@Nullable Wrap parentWrap, @NotNull BlockShape shape, boolean wrapFirst) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        WrapType wt = switch (WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
            case 1 -> null;
            case 2, 3 -> WrapType.CHOP_DOWN_IF_LONG;
            case 4 -> WrapType.ALWAYS;
            default -> throw new NoWhenBranchMatchedException();
        };
        return this.makeWrap$intellij_database_sql_core_impl(parentWrap, wt, wrapFirst);
    }

    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_core_impl$default(SqlFlowBlock sqlFlowBlock, Wrap wrap2, BlockShape blockShape, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_core_impl(wrap2, blockShape, bl);
    }

    @Nullable
    public final Wrap makeWrap(@Nullable WrapType wrapType, boolean wrapFirst) {
        return this.makeWrap$intellij_database_sql_core_impl(null, wrapType, wrapFirst);
    }

    public static /* synthetic */ Wrap makeWrap$default(SqlFlowBlock sqlFlowBlock, WrapType wrapType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap(wrapType, bl);
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_core_impl(@Nullable Wrap parentWrap, @Nullable WrapType wrapType, boolean wrapFirst) {
        Wrap pw;
        if (wrapType == null || wrapType == WrapType.NONE) {
            return null;
        }
        if (wrapType == WrapType.ALWAYS) {
            return Wrap.createWrap((WrapType)wrapType, (boolean)wrapFirst);
        }
        Wrap wrap2 = parentWrap;
        if (wrap2 == null) {
            wrap2 = this.getParent().getTransitiveWrap();
        }
        Wrap wrap3 = pw = wrap2;
        return wrap3 != null ? Wrap.createChildWrap((Wrap)wrap3, (WrapType)wrapType, (boolean)wrapFirst) : Wrap.createWrap((WrapType)wrapType, (boolean)wrapFirst);
    }

    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_core_impl$default(SqlFlowBlock sqlFlowBlock, Wrap wrap2, WrapType wrapType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_core_impl(wrap2, wrapType, bl);
    }

    public boolean userBreakFirstElement() {
        return this.userElementsLineSetting() == 101;
    }

    public int userElementsLineSetting() {
        return 0;
    }

    @SqlCodeStyleConst.WrapMagicValues
    public int userWrapSetting() {
        return 0;
    }

    @SqlCodeStyleConst.CommaMagicValues
    public int userDelimiterSetting() {
        return 0;
    }

    protected boolean allowedToCollapse() {
        return !this.getContext().getKlb() || !this.getHasUserBreaks();
    }

    protected boolean userRequiresExpand() {
        return this.userWrapSetting() == 1;
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return !((Collection)this.getNestedBlocks()).isEmpty() && Intrinsics.areEqual((Object)this.getNestedBlocks().get(0), (Object)block) ? SqlFormattingFunKt.getNONE_INDENT() : SqlFormattingFunKt.getNORMAL_INDENT();
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        this.analyze();
        this.refine();
        int n = this.getNestedBlocks().size();
        if (newChildIndex < 0) {
            childAttributes = new ChildAttributes(null, null);
        } else if (newChildIndex == 0) {
            childAttributes = new ChildAttributes(SqlFormattingFunKt.getNONE_INDENT(), null);
        } else if (newChildIndex > n) {
            childAttributes = this.getChildAttributesForNewElementAtTheEnd();
        } else {
            int prevIndex = newChildIndex - 1;
            SqlBlock prev = this.getNestedBlocks().get(prevIndex);
            return this.getChildAttributesForNewElementAfter(prevIndex, prev);
        }
        return childAttributes;
    }

    @NotNull
    public ChildAttributes getChildAttributesForNewElementAtTheEnd() {
        SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
        SqlFlowBlock sqlFlowBlock = b2 instanceof SqlFlowBlock ? (SqlFlowBlock)b2 : null;
        if (sqlFlowBlock == null || (sqlFlowBlock = sqlFlowBlock.getChildAttributesForNewElementAtTheEnd()) == null) {
            sqlFlowBlock = new ChildAttributes(null, null);
        }
        return sqlFlowBlock;
    }

    @NotNull
    public ChildAttributes getChildAttributesForNewElementAfter(int index2, @NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new ChildAttributes(SqlFormattingFunKt.getNORMAL_INDENT(), null);
    }

    @Override
    @Nullable
    public final Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (this.getContext().getDisabled()) {
            return null;
        }
        SqlBlock sqlBlock = child1 instanceof SqlBlock ? (SqlBlock)child1 : null;
        if (sqlBlock == null) {
            return null;
        }
        SqlBlock block1 = sqlBlock;
        SqlBlock sqlBlock2 = child2 instanceof SqlBlock ? (SqlBlock)child2 : null;
        if (sqlBlock2 == null) {
            return null;
        }
        SqlBlock block2 = sqlBlock2;
        if (block2 instanceof SqlCommentBlock) {
            boolean keep1 = this.getContext().getCom().KEEP_FIRST_COLUMN_COMMENT && this.getContext().isInPosition1(block2);
            return keep1 ? Spacing.createKeepingFirstColumnSpacing((int)0, (int)1, (boolean)true, (int)this.getContext().getSql().IMP_COMMON_KEEP_BLANK_LINES_IN_CODE) : this.getContext().makeSafeSpacing(true);
        }
        if (block1 instanceof SqlCommentBlock) {
            return this.getContext().makeSafeSpacing(true);
        }
        if (block1.isLeaf() && Intrinsics.areEqual((Object)SqlFormattingModelFun.primaryElementType(block1), (Object)TokenType.BAD_CHARACTER) || block2.isLeaf() && Intrinsics.areEqual((Object)SqlFormattingModelFun.primaryElementType(block2), (Object)TokenType.BAD_CHARACTER)) {
            return null;
        }
        if (block1.requiresFollowingBreak() || block2.requiresPrecedingBreak()) {
            SqlLeafBlock leaf1 = block1.getLastLeafBlock();
            SqlLeafBlock leaf2 = block2.getFirstLeafBlock();
            if (leaf1 == null || leaf2 == null) {
                return this.getContext().makeBreakSafeSpace();
            }
            boolean mustBeLag = SqlSpacing.languageRequiresSpaceBetweenLeafNodes(leaf1.getNode(), leaf2.getNode());
            return this.getContext().makeBreak(mustBeLag);
        }
        return this.decideSpacing(block1, block2);
    }

    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        WrapImpl.Type wrapType = SqlFormattingModelFun.getType(block2.getMyWrap());
        boolean klb = this.getContext().getKlb() && wrapType != WrapImpl.Type.DO_NOT_WRAP;
        int should = this.shouldBeSpace(block1, block2);
        if (should == 1) {
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, klb, 1, null);
        }
        if (should == -1) {
            return this.getContext().makeNoSpace(klb);
        }
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r1 == BlockRole.ERROR || r2 == BlockRole.ERROR ? this.getContext().makeSafeSpacing(false) : (r2 == BlockRole.AMENDMENT ? this.getContext().makeSafeSpacing(false) : (r1 == BlockRole.UNKNOWN || r2 == BlockRole.UNKNOWN ? this.getContext().makeSafeSpacing(klb) : (wrapType == WrapImpl.Type.WRAP_AS_NEEDED || wrapType == WrapImpl.Type.CHOP_IF_NEEDED ? SqlFormattingContext.makeSpace$default(this.getContext(), false, klb, 1, null) : this.getContext().makeSafeSpacing(klb))));
    }

    private final int shouldBeSpace(SqlBlock block1, SqlBlock block2) {
        ASTNode node2;
        SqlLeafBlock leaf1 = block1.getLastLeafBlock();
        SqlLeafBlock leaf2 = block2.getFirstLeafBlock();
        if (leaf1 == null || leaf2 == null) {
            return 0;
        }
        ASTNode node1 = leaf1.getBlockNode();
        if (SqlSpacing.languageRequiresSpaceBetween(node1, node2 = leaf2.getBlockNode())) {
            return 1;
        }
        IElementType t1 = leaf1.getElementType();
        IElementType t2 = leaf2.getElementType();
        return t1 == SqlCommonTokens.SQL_PERIOD || t2 == SqlCommonTokens.SQL_PERIOD ? -1 : (t1 == SqlCommonTokens.SQL_OP_ASSIGN || t2 == SqlCommonTokens.SQL_OP_ASSIGN ? 1 : (SqlFormattingFunKt.getRIGHT_BRACE_TOKENS().contains(t1) ? (leaf2 instanceof SqlSymbol ? 0 : 1) : (!(t2 != SqlCommonTokens.SQL_OP_PLUS && t2 != SqlCommonTokens.SQL_OP_MINUS || node2.getTreeParent().getElementType() != SqlCompositeElementTypes.SQL_UNARY_EXPRESSION || SqlFormattingFunKt.getLEFT_BRACE_TOKENS().contains(t1)) ? 1 : (block1 instanceof SqlKeyword && !SqlFormattingFunKt.getUSUALLY_RIGHT_CLOSELY_SPACES_TOKENS().contains(t2) ? 1 : (block2 instanceof SqlKeyword && !SqlFormattingFunKt.getUSUALLY_LEFT_CLOSELY_SPACES_TOKENS().contains(t1) ? 1 : (block2 instanceof SqlCortegeBlock && !SqlFormattingFunKt.getUSUALLY_LEFT_CLOSELY_SPACES_TOKENS().contains(t1) ? (this.getContext().getSql().CORTEGE_SPACE_BEFORE_L_PAREN ? 1 : -1) : 0))))));
    }

    @Override
    public boolean requiresFollowingBreak() {
        SqlLeafBlock sqlLeafBlock = this.getLastLeafBlock();
        return sqlLeafBlock != null ? sqlLeafBlock.requiresFollowingBreak() : false;
    }

    @Override
    public boolean tailFormed() {
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        if (sqlBlock == null) {
            return false;
        }
        SqlBlock last2 = sqlBlock;
        return switch (WhenMappings.$EnumSwitchMapping$1[last2.getRole().ordinal()]) {
            case 1, 2, 3, 4, 5, 6 -> false;
            default -> true;
        };
    }

    @Override
    public final boolean tailCompleted() {
        if (!this.tailFormed()) {
            return false;
        }
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        if (sqlBlock == null) {
            return false;
        }
        SqlBlock lastBlock = sqlBlock;
        SqlFlowBlock sqlFlowBlock = lastBlock instanceof SqlFlowBlock ? (SqlFlowBlock)lastBlock : null;
        if (sqlFlowBlock == null) {
            return lastBlock.tailFormed();
        }
        SqlFlowBlock lastFlowBlock = sqlFlowBlock;
        return lastFlowBlock.tailCompleted();
    }

    @Override
    public boolean incomplete() {
        this.grow();
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        if (sqlBlock == null) {
            return true;
        }
        SqlBlock last2 = sqlBlock;
        return switch (WhenMappings.$EnumSwitchMapping$1[last2.getRole().ordinal()]) {
            case 1, 3, 4 -> true;
            default -> last2.incomplete();
        };
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        if (blocks.getBeyond()) {
            if (blocks.getRole1() == BlockRole.ERROR) {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                SqlBlock sqlBlock = blocks.getBlock1();
                Intrinsics.checkNotNull((Object)sqlBlock);
                string = SqlFormattingContext.currIndentOf$default(sqlFormattingContext, sqlBlock, false, false, false, 10, null);
            } else {
                SqlBlock sqlBlock = blocks.getBlock1();
                Intrinsics.checkNotNull((Object)sqlBlock);
                string = this.isChildTerminal(sqlBlock) && blocks.getBlock1().tailFormed() ? SqlFormattingContext.currIndentOf$default(this.getContext(), this, false, false, false, 10, null) : null;
            }
        } else {
            string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, false, true, false, 10, null);
        }
        return string;
    }

    public boolean isChildTerminal(@NotNull SqlBlock child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return false;
    }

    protected final void makeDefaultBlocks(@NotNull List<? extends ASTNode> nodes, int since, int till) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        for (int i2 = since; i2 < till; ++i2) {
            ASTNode node2 = nodes.get(i2);
            SqlBlock block = this.makeDefaultBlock(node2);
            if (block.getRole() == BlockRole.NOTHING) {
                block.setRole(this.determineRole(node2));
            }
            this.addNestedBlock$intellij_database_sql_core_impl(block);
        }
    }

    public static /* synthetic */ void makeDefaultBlocks$default(SqlFlowBlock sqlFlowBlock, List list, int n, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeDefaultBlocks");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = list.size();
        }
        sqlFlowBlock.makeDefaultBlocks(list, n, n3);
    }

    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.makeDefaultBlock(node2);
    }

    private final SqlBlock makeDefaultBlock(ASTNode node2) {
        return SqlFormattingModelFun.makeDefaultBlock(this, node2);
    }

    @NotNull
    public final JBIterable<SqlBlock> nestedBlocksIter() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getNestedBlocks());
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return jBIterable;
    }

    public final boolean hasRole(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (b2.getRole() != role) continue;
            return true;
        }
        return false;
    }

    public /* synthetic */ SqlFlowBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BlockShape.values().length];
            try {
                nArray[BlockShape.DECIDED_TO_ONE_ROW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.NOT_DECIDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDE_LATER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDED_TO_MULTI_ROWS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BlockRole.values().length];
            try {
                nArray[BlockRole.PREFIX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.EQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.DELIMITER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

