/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.editor.surroundWith.SqlSurrounderBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/editor/surroundWith/SqlSelectSurrounder;", "Lcom/intellij/sql/editor/surroundWith/SqlSurrounderBase;", "()V", "getExpression", "Lcom/intellij/sql/psi/SqlExpression;", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Lcom/intellij/sql/psi/SqlExpression;", "getTemplateDescription", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isApplicable", "", "([Lcom/intellij/psi/PsiElement;)Z", "surroundElements", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlSelectSurrounder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlSelectSurrounder.kt\ncom/intellij/sql/editor/surroundWith/SqlSelectSurrounder\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n61#2:41\n1#3:42\n*S KotlinDebug\n*F\n+ 1 SqlSelectSurrounder.kt\ncom/intellij/sql/editor/surroundWith/SqlSelectSurrounder\n*L\n36#1:41\n*E\n"})
public final class SqlSelectSurrounder
extends SqlSurrounderBase {
    @NotNull
    public static final SqlSelectSurrounder INSTANCE = new SqlSelectSurrounder();

    private SqlSelectSurrounder() {
    }

    @NotNull
    public String getTemplateDescription() {
        String string = SqlBundle.message((String)"surround.with.select.template", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isApplicable(@NotNull PsiElement[] elements2) {
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        return this.getExpression(elements2) != null;
    }

    @NotNull
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement[] elements2) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        SqlExpression sqlExpression = this.getExpression(elements2);
        if (sqlExpression == null) {
            TextRange textRange = SurroundWithHandler.CARET_IS_OK;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"CARET_IS_OK");
            return textRange;
        }
        SqlExpression expression = sqlExpression;
        boolean needParentheses = expression instanceof SqlResultSetExpression;
        Object open = "select * from ";
        if (needParentheses) {
            open = (String)open + "(";
        }
        Object close2 = "";
        if (needParentheses) {
            close2 = (String)close2 + ") " + SqlNamesGenerator.suggestAliasName(expression);
        }
        TextRange textRange = SqlSurrounderBase.surroundElementsWith(project, editor2, (String)open, (String)close2, true);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"surroundElementsWith(...)");
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final SqlExpression getExpression(PsiElement[] elements2) {
        SqlExpression sqlExpression;
        void $this$parentOfType$iv;
        PsiElement e2;
        PsiElement psiElement = (PsiElement)ArraysKt.singleOrNull((Object[])elements2);
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = e2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        SqlExpression sqlExpression2 = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, SqlExpression.class, (boolean)false);
        if (sqlExpression2 == null) {
            return null;
        }
        SqlExpression expression = sqlExpression2;
        if (!Intrinsics.areEqual((Object)expression.getTextRange(), (Object)e2.getTextRange())) {
            return null;
        }
        SqlExpression it2 = sqlExpression = expression;
        boolean bl = false;
        return it2 instanceof SqlReferenceExpression || it2 instanceof SqlResultSetExpression ? sqlExpression : null;
    }
}

