/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public SqlQuoteHandler() {
        super(new IElementType[]{SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_UNCLOSED_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN, SqlTokens.SQL_CUSTOM_LQUOTE});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        char q2;
        if (super.isOpeningQuote(iterator, offset)) {
            return true;
        }
        IElementType type = iterator.getTokenType();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE && offset == iterator.getEnd() - 1) {
            return true;
        }
        if (SqlTokens.SQL_UNCLOSED_TOKEN != type && SqlTokens.SQL_STRING_TOKEN != type) {
            return false;
        }
        int s2 = iterator.getStart();
        int e2 = Math.min(s2 + 4, offset + 1);
        CharSequence chars = iterator.getDocument().getCharsSequence();
        char c2 = q2 = e2 - 2 < s2 ? (char)'\u0000' : chars.charAt(e2 - 2);
        if (q2 == 'q' || q2 == 'Q') {
            return false;
        }
        return StringUtil.indexOf((CharSequence)chars, (char)'\'', (int)s2, (int)e2) == offset;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        if (StringUtil.indexOf((CharSequence)chars.subSequence(iterator.getStart(), iterator.getEnd()), (char)'\n') > -1) {
            return true;
        }
        IElementType type = iterator.getTokenType();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE) {
            if (iterator.atEnd()) {
                return false;
            }
            iterator.advance();
            type = iterator.getTokenType();
            iterator.retreat();
            return type != SqlTokens.SQL_CUSTOM_RQUOTE && type != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
        }
        return type == SqlTokens.SQL_UNCLOSED_TOKEN || super.isNonClosedLiteral(iterator, chars);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        IElementType type;
        boolean move;
        if (iterator == null) {
            SqlQuoteHandler.$$$reportNull$$$0(0);
        }
        boolean bl = move = (type = iterator.getTokenType()) != SqlTokens.SQL_CUSTOM_LQUOTE;
        if (move) {
            if (iterator.getStart() == 0) {
                return null;
            }
            iterator.retreat();
            type = iterator.getTokenType();
        }
        int s2 = iterator.getStart();
        int e2 = iterator.getEnd();
        if (move) {
            iterator.advance();
        }
        if (type != SqlTokens.SQL_CUSTOM_LQUOTE || offset != e2) {
            return null;
        }
        CharSequence seq = iterator.getDocument().getCharsSequence();
        if (seq.charAt(s2) == '$') {
            return seq.subSequence(s2, e2);
        }
        if (e2 - 3 < s2) {
            return null;
        }
        char q2 = seq.charAt(e2 - 3);
        if (q2 != 'q' && q2 != 'Q') {
            return null;
        }
        q2 = seq.charAt(e2 - 2);
        if (q2 != '\'') {
            return null;
        }
        q2 = seq.charAt(e2 - 1);
        q2 = switch (q2) {
            case '(' -> ')';
            case '<' -> '>';
            case '{' -> '}';
            case '[' -> ']';
            default -> q2;
        };
        return q2 + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/sql/editor/SqlQuoteHandler", "getClosingQuote"));
    }

    public static final class Ms
    extends Concat {
        public boolean canBeConcatenated(@NotNull PsiElement element2) {
            PsiElement parent2;
            if (element2 == null) {
                Ms.$$$reportNull$$$0(0);
            }
            for (parent2 = element2.getParent(); parent2 != null && PsiUtilCore.getElementType((PsiElement)parent2) == SqlCompositeElementTypes.SQL_STRING_LITERAL; parent2 = parent2.getParent()) {
            }
            if (PsiUtilCore.getElementType((PsiElement)parent2) == SqlCompositeElementTypes.SQL_NAMED_PARAMETER_VALUE) {
                return false;
            }
            return super.canBeConcatenated(element2);
        }

        @Override
        public String getStringConcatenationOperatorRepresentation() {
            return "+";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/editor/SqlQuoteHandler$Ms", "canBeConcatenated"));
        }
    }

    public static class Concat
    extends SqlQuoteHandler
    implements JavaLikeQuoteHandler {
        private static final TokenSet CONCAT_SET = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_STRING_TOKEN});

        @NotNull
        public TokenSet getConcatenatableStringTokenTypes() {
            TokenSet tokenSet = CONCAT_SET;
            if (tokenSet == null) {
                Concat.$$$reportNull$$$0(0);
            }
            return tokenSet;
        }

        public String getStringConcatenationOperatorRepresentation() {
            return "||";
        }

        public TokenSet getStringTokenTypes() {
            return null;
        }

        public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                Concat.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean needParenthesesAroundConcatenation(PsiElement element2) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlQuoteHandler$Concat";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcatenatableStringTokenTypes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlQuoteHandler$Concat";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAppropriateElementTypeForLiteral";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

