/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.editor.SqlCodeBlockProviderUtils;
import com.intellij.sql.editor.SqlFoldingSettings;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.psi.stubs.SqlLazyParseablePsiElement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final int EXPRESSION_LIST_FOLD_MIN = 3;
    private static final int RANGE_LENGTH_TO_FOLD = 12;
    private static final int MIN_FOLDABLE_NUMBER_LENGTH = 6;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root2, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (!(root2 instanceof SqlFile)) {
            return;
        }
        CharSequence charSequence = document.getCharsSequence();
        for (PsiElement e2 : SqlImplUtil.sqlTraverser(root2)) {
            if (!(e2 instanceof SqlStatement && !(e2 instanceof SqlSelectStatement) || e2 instanceof SqlProcedureDefinitionImpl || e2 instanceof SqlNamedQueryDefinitionImpl || e2 instanceof SqlLazyParseablePsiElement || e2 instanceof SqlResultSetExpression && !(e2 instanceof SqlParenthesizedExpression) || e2 instanceof PsiComment && ((PsiComment)e2).getTokenType() == SqlTokens.SQL_BLOCK_COMMENT || e2 instanceof SqlExpressionList) && !(e2 instanceof SqlLiteralExpression)) continue;
            SqlFoldingBuilder.addFoldingDescriptor(e2, charSequence, descriptors);
        }
    }

    private static void addFoldingDescriptor(@NotNull PsiElement o2, @NotNull CharSequence charSequence, @NotNull List<FoldingDescriptor> result2) {
        TextRange realRange;
        TextRange range;
        if (o2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (charSequence == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (!SqlFoldingBuilder.shouldFold(o2, range = o2.getTextRange(), charSequence)) {
            return;
        }
        int lastCharIndex = Math.min(range.getEndOffset(), charSequence.length()) - 1;
        SqlFoldingBuilder.checkLastIndexInRange(o2, charSequence, range, lastCharIndex);
        boolean leaveLastNewLine = '\n' == charSequence.charAt(lastCharIndex);
        TextRange textRange = realRange = leaveLastNewLine ? new TextRange(range.getStartOffset(), lastCharIndex) : range;
        if (PsiUtilCore.getElementType((PsiElement)o2) == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT) {
            PsiElement content = SqlImplUtil.getBlockContentElement(o2);
            if (content != null) {
                result2.add(new FoldingDescriptor(content, content.getTextRange()));
            } else {
                PsiElement[] children2 = o2.getChildren();
                if (children2.length > 0) {
                    PsiElement firstItem = children2[0];
                    PsiElement lastItem = children2[children2.length - 1];
                    if (firstItem != null && lastItem != null) {
                        result2.add(new FoldingDescriptor(o2, new TextRange(firstItem.getTextOffset(), lastItem.getTextRange().getEndOffset())));
                    }
                }
            }
        } else {
            result2.add(new FoldingDescriptor(o2, realRange));
        }
    }

    private static boolean shouldFold(@NotNull PsiElement element2, @NotNull TextRange range, @NotNull CharSequence charSequence) {
        if (element2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (range == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (charSequence == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (element2 instanceof SqlLiteralExpression) {
            return SqlFoldingBuilder.canFoldLiteral(element2);
        }
        if (range.getLength() <= 12) {
            return false;
        }
        if (element2 instanceof SqlExpressionList) {
            return ((SqlExpressionList)element2).getExpressionList().size() >= 3;
        }
        if (StringUtil.indexOfAny((CharSequence)charSequence, (String)"\r\n", (int)range.getStartOffset(), (int)range.getEndOffset()) != -1) {
            return true;
        }
        return InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectionHost(element2) != null;
    }

    private static boolean canFoldLiteral(@NotNull PsiElement element2) {
        int postfixSize;
        PsiElement integerToken;
        if (element2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (PsiUtilCore.getElementType((PsiElement)(integerToken = element2.getFirstChild())) != SqlTokens.SQL_INTEGER_TOKEN) {
            return false;
        }
        String literalText = element2.getText().trim();
        int length = literalText.length();
        int prefixSize = SqlFoldingBuilder.getIntPrefixSize(literalText);
        if (prefixSize + (postfixSize = SqlFoldingBuilder.getIntPostfixSize(literalText)) > length) {
            return false;
        }
        String value2 = literalText.substring(prefixSize, length - postfixSize);
        return value2.length() >= 6;
    }

    private static void checkLastIndexInRange(@NotNull PsiElement o2, @NotNull CharSequence charSequence, TextRange range, int lastCharIndex) {
        boolean inRange;
        if (o2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (charSequence == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(11);
        }
        boolean bl = inRange = lastCharIndex >= 0 && lastCharIndex < charSequence.length() && lastCharIndex > range.getStartOffset();
        if (!inRange) {
            PsiFile containingFile = o2.getContainingFile();
            FileViewProvider viewProvider = containingFile.getViewProvider();
            Object docInfo = "";
            if (containingFile.isValid()) {
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)containingFile.getProject());
                Document document = docManager.getDocument(containingFile);
                boolean committed = document != null && docManager.isCommitted(document);
                docInfo = (String)(document != null ? "Committed: " + committed + ", doc.length: " + document.getTextLength() + ", " : "") + "document: " + document + ",\n";
            }
            SqlDialectImplUtilCore.LOG.error("Length: " + charSequence.length() + ", Range: " + range + ",\n" + (String)docInfo + "element: " + o2.getClass() + ",\ncontainingFile: " + containingFile + ", file.length: " + containingFile.getText().length() + ", valid: " + containingFile.isValid() + ",\nviewProvider: " + viewProvider);
        }
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node2, @NotNull TextRange range) {
        if (node2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (range == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder();
        if (node2.getPsi() instanceof SqlLiteralExpression) {
            SqlFoldingBuilder.appendIntLiteral(node2, sb);
        } else {
            SqlFoldingBuilder.appendPlaceholder(node2, range.getStartOffset(), range.getStartOffset() + 12, sb);
        }
        String string = sb.toString().trim();
        if (string == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static int getIntPrefixSize(@NotNull String value2) {
        if (value2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(15);
        }
        if (value2.startsWith("0x") || value2.startsWith("0X") || value2.startsWith("0b")) {
            return 2;
        }
        int length = 0;
        for (int i2 = 0; i2 < value2.length() && !StringUtil.isDecimalDigit((char)value2.charAt(i2)); ++i2) {
            ++length;
        }
        return length;
    }

    private static int getIntPostfixSize(@NotNull String value2) {
        if (value2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(16);
        }
        boolean isHex = value2.startsWith("0x") || value2.startsWith("0X");
        int length = 0;
        for (int i2 = value2.length() - 1; i2 >= 0; --i2) {
            char c2 = value2.charAt(i2);
            if (isHex && StringUtil.isHexDigit((char)c2) || StringUtil.isDecimalDigit((char)c2)) break;
            ++length;
        }
        return length;
    }

    private static void appendIntLiteral(@NotNull ASTNode node2, @NotNull StringBuilder builder) {
        int headSize;
        int groupSize;
        if (node2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(17);
        }
        if (builder == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(18);
        }
        String literalText = node2.getText().trim();
        int prefixSize = SqlFoldingBuilder.getIntPrefixSize(literalText);
        int postfixSize = SqlFoldingBuilder.getIntPostfixSize(literalText);
        String value2 = literalText.substring(prefixSize, literalText.length() - postfixSize);
        String prefix = literalText.substring(0, prefixSize);
        String postfix = literalText.substring(literalText.length() - postfixSize);
        int n = groupSize = prefix.equalsIgnoreCase("0x") || prefix.equals("0b") ? 4 : 3;
        if (!prefix.isEmpty()) {
            builder.append(prefix);
        }
        if ((headSize = value2.length() % groupSize) > 0) {
            builder.append(value2, 0, headSize);
        }
        for (int i2 = headSize; i2 < value2.length(); i2 += groupSize) {
            if (i2 > 0) {
                builder.append('_');
            }
            builder.append(value2, i2, i2 + groupSize);
        }
        if (!postfix.isEmpty()) {
            builder.append(postfix);
        }
    }

    private static void appendPlaceholder(@NotNull ASTNode node2, int startOffset, int limitOffset, @NotNull StringBuilder builder) {
        PsiElement singleSign;
        NavigationItem nameElement;
        if (node2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(20);
        }
        PsiElement psi = node2.getPsi();
        JBIterable leaves = SqlImplUtil.sqlTraverser(psi).traverse(TreeTraversal.LEAVES_DFS);
        boolean hadNonWs = false;
        boolean keywordsDone = false;
        boolean hadFrom = false;
        PsiElement last2 = null;
        PsiElement first2 = null;
        for (PsiElement leaf : leaves) {
            if (leaf instanceof PsiComment) continue;
            if (!(leaf instanceof LeafPsiElement)) break;
            if (leaf instanceof PsiWhiteSpace) {
                if (!hadNonWs) continue;
                builder.append(' ');
                continue;
            }
            hadNonWs = true;
            IElementType elementType = ((LeafPsiElement)leaf).getElementType();
            if (elementType == SqlCommonKeywords.SQL_FROM) {
                hadFrom = true;
            }
            if (keywordsDone || elementType != SqlTokens.SQL_KEYWORD_TOKEN && elementType != SqlCommonTokens.SQL_ASTERISK) {
                keywordsDone = true;
                TextRange textRange = leaf.getTextRange();
                if (textRange.getEndOffset() < startOffset || textRange.getStartOffset() > limitOffset) {
                    if (elementType != SqlCommonKeywords.SQL_FROM || !(psi instanceof SqlQueryExpression)) break;
                    SqlFoldingBuilder.appendQueryName(builder, SqlFoldingBuilder.findNameElement(psi), (SqlQueryExpression)psi);
                    break;
                }
            }
            builder.append(leaf.getText());
            last2 = leaf;
            if (first2 != null) continue;
            first2 = leaf;
        }
        PsiElement lastLeave = (PsiElement)leaves.last();
        String ellipsis = SqlFoldingBuilder.getEllipsis(psi, last2);
        boolean hadEllipsis = false;
        boolean endsWithClosingElement = SqlFoldingBuilder.isClosingElement(first2, lastLeave);
        if (!endsWithClosingElement && builder.length() > 0 && builder.charAt(0) == '(') {
            builder.replace(0, 1, "");
        }
        if (endsWithClosingElement) {
            builder.append(ellipsis);
            builder.append(lastLeave.getText());
        }
        if ((nameElement = SqlFoldingBuilder.findNameElement(psi)) instanceof SqlElement) {
            if (psi instanceof SqlQueryExpression && !hadFrom) {
                if (!endsWithClosingElement) {
                    builder.append(ellipsis);
                    hadEllipsis = true;
                }
                SqlFoldingBuilder.appendQueryName(builder, nameElement, (SqlQueryExpression)psi);
            } else if (((SqlElement)nameElement).getTextOffset() >= limitOffset) {
                builder.append(SqlFoldingBuilder.getQueryName(nameElement));
            }
            if (((SqlElement)nameElement).getTextRange().getEndOffset() >= psi.getTextRange().getEndOffset()) {
                endsWithClosingElement = true;
            }
        }
        if (!endsWithClosingElement && !hadEllipsis) {
            builder.append(ellipsis);
        }
        if (psi instanceof SqlNAryExpression && (singleSign = ((SqlNAryExpression)psi).getOpSignElement()) != null && singleSign.getTextOffset() >= limitOffset) {
            builder.append(singleSign.getText());
            builder.append("... ");
        }
    }

    private static String getQueryName(@NotNull NavigationItem nameElement) {
        if (nameElement == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(21);
        }
        String name2 = nameElement.getName();
        return nameElement instanceof SqlAsExpression ? "[" + name2 + "]" : name2;
    }

    private static void appendQueryName(@NotNull StringBuilder builder, NavigationItem nameElement, @NotNull SqlQueryExpression query) {
        PsiElement fromKeyword;
        SqlTableExpression tableExpression;
        if (builder == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(22);
        }
        if (query == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(23);
        }
        SqlFromClause fromClause = (tableExpression = query.getTableExpression()) != null ? tableExpression.getFromClause() : null;
        PsiElement psiElement = fromKeyword = fromClause != null ? fromClause.getFirstChild() : null;
        if (nameElement != null) {
            if (fromKeyword != null) {
                builder.append(fromKeyword.getText()).append(" ");
            }
            builder.append(SqlFoldingBuilder.getQueryName(nameElement));
        }
    }

    private static boolean isClosingElement(PsiElement first2, PsiElement lastLeave) {
        if (!(lastLeave instanceof LeafPsiElement) || !(first2 instanceof LeafPsiElement)) {
            return false;
        }
        IElementType lastElementType = ((LeafPsiElement)lastLeave).getElementType();
        IElementType firstElementType = ((LeafPsiElement)first2).getElementType();
        if (lastElementType == SqlCommonTokens.SQL_RIGHT_PAREN) {
            return firstElementType == SqlCommonTokens.SQL_LEFT_PAREN;
        }
        if (lastElementType == SqlCommonKeywords.SQL_END) {
            return SqlCodeBlockProviderUtils.STARTERS.contains(firstElementType);
        }
        return false;
    }

    @NotNull
    private static String getEllipsis(@Nullable PsiElement psi, @Nullable PsiElement last2) {
        if (last2 != null && psi instanceof SqlExpressionList) {
            return SqlFoldingBuilder.getMoreText((JBIterable<? extends PsiElement>)SqlImplUtil.sqlChildren(psi).filter(SqlExpression.class), last2);
        }
        if (last2 != null && psi instanceof SqlDeclareStatement) {
            return SqlFoldingBuilder.getMoreText((JBIterable<? extends PsiElement>)SqlImplUtil.sqlChildren(psi).filter(SqlDefinition.class), last2);
        }
        return "... ";
    }

    @NotNull
    private static String getMoreText(@NotNull JBIterable<? extends PsiElement> items2, @NotNull PsiElement last2) {
        TextRange lastTextRange;
        long count;
        if (items2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(24);
        }
        if (last2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(25);
        }
        Object object = (count = (long)items2.filter(arg_0 -> SqlFoldingBuilder.lambda$getMoreText$0(lastTextRange = last2.getTextRange(), arg_0)).size()) == 0L ? "" : "...[" + count + " more]";
        if (object == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(26);
        }
        return object;
    }

    @Nullable
    private static NavigationItem findNameElement(@Nullable PsiElement psi) {
        if (psi instanceof SqlNAryExpression) {
            return SqlFoldingBuilder.findNameElement((PsiElement)((SqlNAryExpression)psi).getLOperand());
        }
        if (psi instanceof SqlDefinition) {
            return ((SqlDefinition)psi).getNameElement();
        }
        if (psi instanceof SqlAlterStatement) {
            return ((SqlAlterStatement)psi).getAlterTargetReference();
        }
        if (psi instanceof SqlQueryExpression) {
            SqlQueryExpression queryExpression = (SqlQueryExpression)psi;
            SqlTableExpression tableExpression = queryExpression.getTableExpression();
            return SqlFoldingBuilder.findNameNode((PsiElement)tableExpression);
        }
        return null;
    }

    @Nullable
    private static NavigationItem findNameNode(@Nullable PsiElement element2) {
        SqlFromClause fromClause;
        SqlAsExpression asExpression;
        if (element2 instanceof SqlTableExpression && (asExpression = (SqlAsExpression)SyntaxTraverser.psiTraverser((PsiElement)(fromClause = ((SqlTableExpression)element2).getFromClause())).filter(SqlAsExpression.class).first()) != null) {
            return asExpression;
        }
        return (NavigationItem)SyntaxTraverser.psiTraverser((PsiElement)element2).filter(SqlNameElement.class).first();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node2) {
        if (node2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(27);
        }
        if (node2.getPsi() instanceof SqlLiteralExpression) {
            return SqlFoldingSettings.getInstance().COLLAPSE_LONG_NUMBERS;
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node2) {
        if (node2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(28);
        }
        return node2.getElementType() instanceof SqlFileElementType;
    }

    private static /* synthetic */ boolean lambda$getMoreText$0(TextRange lastTextRange, PsiElement n) {
        return n.getTextRange().getStartOffset() > lastTextRange.getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: 
            case 17: 
            case 19: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlFoldingBuilder";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlFoldingBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagePlaceholderText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFoldingDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldFold";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canFoldLiteral";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkLastIndexInRange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 14: 
            case 26: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIntPrefixSize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIntPostfixSize";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendIntLiteral";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendPlaceholder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getQueryName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendQueryName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMoreText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 26 -> new IllegalStateException(string);
        };
    }
}

