/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.refactoring;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraExtractVariableHelper
extends SqlExtractVariableHelper {
    public OraExtractVariableHelper() {
        super(OraDialect.INSTANCE);
    }

    @Override
    @Nullable
    public PsiElement createDeclaration(@NotNull Project project, @NotNull String name2, @NotNull DataType type, @NotNull String expressionText) {
        if (project == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(1);
        }
        if (type == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(2);
        }
        if (expressionText == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(3);
        }
        String varText = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().type(type).getStatement();
        String statementText = "declare " + varText + "; begin end";
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)this.getDialect(), (CharSequence)statementText);
        return PsiTreeUtil.getChildOfType((PsiElement)fileFromText.getFirstChild(), SqlVariableDefinition.class);
    }

    @Override
    @Nullable
    public PsiElement createInitializerDeclaration(@NotNull Project project, @NotNull String name2, @NotNull String text2) {
        if (project == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(6);
        }
        String statementText = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().symbol(":=").space().plain(text2).getStatement();
        return SqlPsiElementFactory.createStatementFromText(statementText, this.getDialect(), project, null);
    }

    @Override
    public PsiElement addDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement block, @NotNull PsiElement anchor2) {
        PsiElement first2;
        if (declaration == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(7);
        }
        if (block == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(8);
        }
        if (anchor2 == null) {
            OraExtractVariableHelper.$$$reportNull$$$0(9);
        }
        if ((first2 = block.getFirstChild()) != null && first2.getNode().getElementType() != OraTypes.ORA_DECLARE) {
            PsiElement declare = SqlPsiElementFactory.createLeafFromText(declaration.getProject(), this.getDialect(), "declare");
            first2 = block.addBefore(declare, first2);
        }
        PsiElement element2 = block.addAfter(declaration, first2);
        PsiElement semi = SqlPsiElementFactory.createLeafFromText(declaration.getProject(), this.getDialect(), ";");
        block.addAfter(semi, element2);
        block.addBefore(SqlPsiElementFactory.newLine(block.getProject()), element2);
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/oracle/refactoring/OraExtractVariableHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeclaration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitializerDeclaration";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

