/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.oracle.OraDbSqlUtils;
import com.intellij.database.dialects.oracle.types.OraObjectDefinedType;
import com.intellij.database.dialects.oracle.types.OraRecordType;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraTypeMemberFunction;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasCollectionType;
import com.intellij.database.types.DasColumniationType;
import com.intellij.database.types.DasMapType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.oracle.OraDateTimeLanguageHelper;
import com.intellij.sql.dialects.oracle.OraElementFactory;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraOptionalKeywords;
import com.intellij.sql.dialects.oracle.OraPlReservedKeywords;
import com.intellij.sql.dialects.oracle.OraReservedKeywords;
import com.intellij.sql.dialects.oracle.OraTokens;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.OraValidationDelegate;
import com.intellij.sql.dialects.oracle.dataFlow.OraDFABuildingVisitor;
import com.intellij.sql.dialects.oracle.dataFlow.OraErrorSpecHelper;
import com.intellij.sql.dialects.oracle.psi.OraModelClauseImpl;
import com.intellij.sql.dialects.oracle.psi.OraReferenceTypeElementImpl;
import com.intellij.sql.dialects.oracle.psi.OraRowPatternDefClause;
import com.intellij.sql.dialects.oracle.psi.OraRowPatternMeasuresClause;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractFunctionHelper;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlVariableDefinitionImpl;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends SqlLanguageDialectBase {
    public static final OraDialect INSTANCE = new OraDialect();

    public OraDialect() {
        super("Oracle");
    }

    protected OraDialect(@NonNls @NotNull String id) {
        if (id == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        super(INSTANCE, id);
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        return new TokensHelper(OraTokens.class, OraPlReservedKeywords.class, SqlFunctionsUtil.loadFunctionDefinition(this));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean processConnectByPseudoColumns(@NotNull PsiElement element2, @NotNull SqlScopeProcessorBase processor2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        if (processor2.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity entity : LazyData.CONNECT_BY_PSEUDO_COLUMNS.values()) {
                if (processor2.executeTarget(entity, this.getTypeSystem().getIntType(), null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        ObjectKind kind;
        if (place == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        if (!this.processReservedEntitiesWithTypeDual(name2, place, resolve2, processor2)) {
            return false;
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor2)) {
            return false;
        }
        DasTypeSystemBase typeSystem = this.getTypeSystem();
        if (processor2.isExpected(ObjectKind.COLUMN) && DbImplUtilCore.isDataTable(kind = SqlImplUtil.getQualifierKind(place))) {
            for (ReservedEntity entity : LazyData.PSEUDO_COLUMNS.values()) {
                if (OraDialect.processReservedEntitiesWithTypeSimple(entity, typeSystem.getIntType(), name2, place, resolve2, processor2, true, null)) continue;
                return false;
            }
        }
        if ((processor2.isExpected(ObjectKind.COLUMN) || processor2.isExpected(ObjectKind.ROUTINE)) && (resolve2 || OraDialect.isCollectionAttribute(place) || OraDialect.isBulkUpdateAttribute(place))) {
            for (ReservedEntity entity : LazyData.PL_TABLE_ATTRIBUTES.values()) {
                if (OraDialect.processReservedEntitiesWithTypeSimple(entity, entity.getKind() == ObjectKind.COLUMN ? typeSystem.getIntType() : null, name2, place, resolve2, processor2, false, null)) continue;
                return false;
            }
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.RE_EXTEND.name, name2, resolve2) && OraDialect.isCollectionAttribute(place) && !processor2.executeTarget((DasSymbol)LazyData.RE_EXTEND, DasTypeSystemBase.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (!OraDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PROFILE_DEFAULT, DasTypeSystemBase.REFERENCE, name2, place, resolve2, processor2, true, null)) {
            return false;
        }
        if (place instanceof SqlReferenceExpression && resolve2 && ((SqlReferenceExpression)place).getQualifierExpression() == null) {
            for (ReservedEntity object : LazyData.ourObjects) {
                if (processor2.executeTarget((DasSymbol)object, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isCollectionAttribute(@NotNull PsiElement element2) {
        DasType dasType;
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        return (dasType = SqlImplUtil.getQualifierDasType(element2)) instanceof DasCollectionType || dasType instanceof DasMapType || dasType instanceof DasTableType;
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        SqlTableType tableType2;
        OraRefCursorType cursorType;
        DasType innerType;
        if (processor2 == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        if (state == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        if (ref2 == null) {
            OraDialect.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            OraDialect.$$$reportNull$$$0(10);
        }
        DasType dasType = DasTypeUtilsKt.unwrap(qualifier.getDasType());
        ResolveState qualifiedState = SqlImplUtil.setQualifier(state, (PsiElement)qualifier);
        if (dasType instanceof OraRecordType && processor2.mayAccept(ObjectKind.COLUMN) && !DasSymbolUtil.processScope(processor2, qualifiedState, ((OraRecordType)dasType).getColumnScope())) {
            return false;
        }
        if (dasType instanceof OraObjectDefinedType) {
            OraObjectDefinedType objectType = (OraObjectDefinedType)dasType;
            if (processor2.mayAccept(ObjectKind.COLUMN) && !DasSymbolUtil.processScope(processor2, qualifiedState, objectType.getColumnScope())) {
                return false;
            }
            if (processor2.mayAccept(ObjectKind.ROUTINE) && !DasSymbolUtil.processScope(processor2, qualifiedState, objectType.getFunctionScope())) {
                return false;
            }
        }
        if (dasType instanceof OraRefCursorType && (innerType = DasTypeUtilsKt.unwrap((DasType)ObjectUtils.notNull((Object)(cursorType = (OraRefCursorType)dasType).getReturnType(), DasTypeSystemBase.UNKNOWN))) instanceof SqlTableType && !SqlImplUtil.processDeclarationsInType(tableType2 = (SqlTableType)innerType, processor2, qualifiedState, ref2.getElement())) {
            return false;
        }
        SqlReference actualRef = ref2;
        if (qualifier instanceof SqlReferenceExpression && ((SqlReferenceExpression)qualifier).getKind() == ObjectKind.DB_LINK) {
            SqlReferenceExpression qualifiedRef = (SqlReferenceExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)qualifier, SqlReferenceExpression.class);
            if (qualifiedRef == null) {
                return true;
            }
            actualRef = qualifiedRef.getReference();
        }
        return super.processQualifiedResolve(processor2, state, actualRef, qualifier);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern2) {
        if (pattern2 == null) {
            OraDialect.$$$reportNull$$$0(13);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern2, dsNames, Collections.singletonList(ObjectName.quoted("PUBLIC")), false, SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            OraDialect.$$$reportNull$$$0(14);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target2) {
        if (target2 == null) {
            OraDialect.$$$reportNull$$$0(15);
        }
        Set<ObjectKind> set = target2 == ObjectKind.ROUTINE && SqlPsiMiscUtil.isDropTarget(context) ? LazyData.IGNORED_ROUTINE_DROP_TARGETS : super.getIgnoredParentKinds(context, target2);
        if (set == null) {
            OraDialect.$$$reportNull$$$0(16);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        PsiElement parent2;
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(17);
        }
        if (strict) {
            return false;
        }
        if (place != null && symbol != null && LazyData.PL_TABLE_ATTRIBUTES.containsKey(symbol.getName()) && (OraDialect.isCollectionAttribute(place) || OraDialect.isBulkUpdateAttribute(place))) {
            return true;
        }
        if (SqlDialectImplUtilCore.isLabelOrRoutineQualification(symbol instanceof PsiElement ? (PsiElement)symbol : null, type, place, isCompletion)) {
            return true;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.ARGUMENT)) {
            return true;
        }
        if (type == ObjectKind.OBJECT_ATTRIBUTE && expectedTypes.contains(ObjectKind.ARGUMENT)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && expectedTypes.contains(ObjectKind.COLUMN)) {
            DasRoutine routine2;
            DasRoutine dasRoutine = routine2 = symbol != null ? (DasRoutine)ObjectUtils.tryCast((Object)symbol.getDasObject(), DasRoutine.class) : null;
            if (routine2 == null) {
                return false;
            }
            DasArgument arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments(routine2).find(a -> !a.getName().equalsIgnoreCase("self") && a.getDefault() == null);
            return arg == null;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return symbol == null || symbol instanceof PsiElement && ((PsiElement)symbol).getParent() instanceof OraModelClauseImpl;
        }
        if ((type == ObjectKind.VARIABLE || type == ObjectKind.ARGUMENT) && expectedTypes.contains(ObjectKind.COLLECTION)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        PsiElement psiElement = parent2 = place != null ? place.getParent() : null;
        if (isCompletion && parent2 instanceof OraReferenceTypeElementImpl && parent2.getParent() instanceof SqlVariableDefinition) {
            return OraDialect.isTableTypeLookupCandidate(type, expectedTypes) || OraDialect.isColumnTypeLookupCandidate(type, expectedTypes);
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    private static boolean isBodyRoutine(@NotNull SqlResolveResult result2) {
        DasSymbol sym;
        if (result2 == null) {
            OraDialect.$$$reportNull$$$0(18);
        }
        DasObject obj2 = (sym = result2.getTargetSymbol()) != null ? sym.getDasObject() : null;
        return obj2 != null && OraDbSqlUtils.isBodyRoutine(obj2, true);
    }

    public void filterResolveResults(@NotNull Set<SqlResolveResult> results2) {
        if (results2 == null) {
            OraDialect.$$$reportNull$$$0(19);
        }
        if (ContainerUtil.find(results2, OraDialect::isBodyRoutine) == null) {
            return;
        }
        Iterator<SqlResolveResult> iterator = results2.iterator();
        while (iterator.hasNext()) {
            if (OraDialect.isBodyRoutine(iterator.next())) continue;
            iterator.remove();
        }
    }

    private static boolean isTableTypeLookupCandidate(ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(20);
        }
        return (type == ObjectKind.TABLE || type == ObjectKind.VIEW) && expectedTypes.contains(ObjectKind.OBJECT_TYPE);
    }

    private static boolean isColumnTypeLookupCandidate(ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(21);
        }
        return type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.OBJECT_TYPE);
    }

    @Override
    @Nullable
    public String adjustReferenceLookupString(@NotNull LookupElement element2, @NotNull ObjectKind kind, @NotNull Set<ObjectKind> expectedTypes) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(22);
        }
        if (kind == null) {
            OraDialect.$$$reportNull$$$0(23);
        }
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(24);
        }
        if (OraDialect.isTableTypeLookupCandidate(kind, expectedTypes)) {
            return element2.getLookupString() + "%rowtype";
        }
        if (OraDialect.isColumnTypeLookupCandidate(kind, expectedTypes)) {
            return element2.getLookupString() + "%type";
        }
        return null;
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            OraDialect.$$$reportNull$$$0(25);
        }
        ObjectKind kind = SqlImplUtil.getIdentifierKind(identifier);
        if (Registry.is((String)"database.oracle.names.long") || version == null || version.isOrGreater(12, 2)) {
            if (kind == ObjectKind.DATABASE) {
                SqlCreateStatement createDb = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlCreateStatement.class);
                return createDb != null && PsiUtilCore.getElementType((PsiElement)createDb) == OraTypes.ORA_CREATE_DATABASE_STATEMENT && PsiTreeUtil.findSiblingForward((PsiElement)createDb.getFirstChild(), (IElementType)OraTypes.ORA_PLUGGABLE, (boolean)true, null) != null ? 30 : 8;
            }
            return kind == OraElementTypes.Kinds.DISKGROUP || kind == OraElementTypes.Kinds.ROLLBACK_SEGMENT || kind == ObjectKind.TABLESPACE ? 30 : 128;
        }
        return kind == ObjectKind.DATABASE ? 8 : (kind == ObjectKind.DB_LINK ? 128 : 30);
    }

    @Override
    public boolean processNamedArgumentCandidates(@Nullable DasSymbol callableSymbol, Processor<? super DasSymbol> processor2, @NotNull Project project) {
        DasUserDefinedType typeDef;
        DasType dasType;
        DasObject object;
        SqlVariableDefinitionImpl curs;
        if (project == null) {
            OraDialect.$$$reportNull$$$0(26);
        }
        if ((curs = (SqlVariableDefinitionImpl)((Object)ObjectUtils.tryCast((Object)(object = callableSymbol != null ? callableSymbol.getDasObject() : null), SqlVariableDefinitionImpl.class))) != null && curs.getKind() == SqlDbElementType.CURSOR) {
            for (SqlParameterDefinition parameter : SqlImplUtil.childrenIt((PsiElement)curs).filter(SqlParameterDefinition.class)) {
                if (processor2.process((Object)parameter)) continue;
                return false;
            }
        }
        if (object instanceof DasUserDefinedType && (dasType = DasTypeUtilsKt.unwrap((typeDef = (DasUserDefinedType)object).getSelfDasType())) instanceof DasColumniationType) {
            for (DasTypedObject column2 : ((DasColumniationType)dasType).getColumnScope().getAllElements()) {
                if (processor2.process((Object)DasSymbolUtil.wrapObjectToSymbol((DasObject)column2, project))) continue;
                return false;
            }
        }
        return super.processNamedArgumentCandidates(callableSymbol, processor2, project);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.PACKAGE);
            result2.add((ObjectKind)ObjectKind.SCHEMA);
            result2.add((ObjectKind)SqlDbElementType.CURSOR);
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        if (type == ObjectKind.OPERATOR) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.BODY);
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    @Override
    public boolean respectsCurrentTracerContext(@Nullable SqlDefinition definition2) {
        return !(definition2 instanceof SqlSynonymDefinition) || !((SqlSynonymDefinition)definition2).isPublic();
    }

    @Override
    @NotNull
    public Trinity<ObjectKind, Boolean, String> getImplicitParentInfo(@Nullable SqlDefinition definition2, @NotNull ObjectKind parentKind) {
        if (parentKind == null) {
            OraDialect.$$$reportNull$$$0(27);
        }
        if (parentKind == ObjectKind.SCHEMA && definition2 instanceof SqlSynonymDefinition && ((SqlSynonymDefinition)definition2).isPublic()) {
            Trinity trinity = Trinity.create((Object)parentKind, (Object)false, (Object)"PUBLIC");
            if (trinity == null) {
                OraDialect.$$$reportNull$$$0(28);
            }
            return trinity;
        }
        Trinity<ObjectKind, Boolean, String> trinity = super.getImplicitParentInfo(definition2, parentKind);
        if (trinity == null) {
            OraDialect.$$$reportNull$$$0(29);
        }
        return trinity;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            OraDialect.$$$reportNull$$$0(30);
        }
        return kind == ObjectKind.CLUSTER || super.shouldSkipFromQualification(kind);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != OraElementTypes.Extra.CONDITIONAL_FLAG && (type != ObjectKind.EXCEPTION || o2 != null && !this.getExceptionNames().contains(o2.getName())) && super.shallResolve(o2, type);
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        if (name2 == null) {
            OraDialect.$$$reportNull$$$0(31);
        }
        if (name2.equals("JSON_PASSING_CLAUSE")) {
            return OraElementTypes.Misc.ORA_JSON_PASSING_CLAUSE;
        }
        if (name2.equals("JSON_EXISTS_ON_ERROR_CLAUSE")) {
            return OraElementTypes.Misc.ORA_JSON_EXISTS_ON_ERROR_CLAUSE;
        }
        IElementType res2 = OraElementFactory.findComposite(name2);
        return res2 == null ? super.getFunctionParserExtension(name2) : res2;
    }

    @Override
    @NotNull
    public Set<BuiltinFunction.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        Set<BuiltinFunction.Location> locations = super.getExpectedFunctionLocations(expression);
        PsiElement patternClause = (PsiElement)SqlImplUtil.sqlParents((PsiElement)expression).find(e2 -> e2 instanceof OraRowPatternDefClause || e2 instanceof OraRowPatternMeasuresClause);
        if (patternClause != null) {
            locations.add(BuiltinFunction.Location.ROW_NAVIGATION_OPERATION);
        }
        Set<BuiltinFunction.Location> set = locations;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(32);
        }
        return set;
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    public boolean supportsNaturalJoin() {
        return true;
    }

    @Override
    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            OraDialect.$$$reportNull$$$0(33);
        }
        return expression.getReferenceElementType() == OraElementTypes.Extra.ORA_DATABASE_LINK_REFERENCE;
    }

    @Override
    @NotNull
    public JBIterable<? extends DasArgument> getSignatureParameters(@NotNull DasRoutine routine2) {
        if (routine2 == null) {
            OraDialect.$$$reportNull$$$0(34);
        }
        JBIterable parameters2 = super.getSignatureParameters(routine2);
        if (DbUtil.getDasObject(routine2) instanceof OraTypeMemberFunction) {
            parameters2 = parameters2.filter(p2 -> !p2.getName().equalsIgnoreCase("self"));
        }
        JBIterable jBIterable = parameters2;
        if (jBIterable == null) {
            OraDialect.$$$reportNull$$$0(35);
        }
        return jBIterable;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(36);
        }
        if (super.isTableAliasAllowedAt(element2)) {
            return true;
        }
        SqlOnTargetClauseImpl onTargetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlOnTargetClauseImpl.class});
        return PsiTreeUtil.getContextOfType((PsiElement)onTargetClause, (Class[])new Class[]{SqlCreateIndexStatement.class}) != null;
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o2, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkIdentifierStartsWithLetter(o2, manager, onTheFly);
        if (result2 != null) {
            return result2;
        }
        SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)PsiTreeUtil.getTopmostParentOfType((PsiElement)o2, SqlStatement.class), SqlDefinition.class);
        boolean isPl = false;
        if (def != null && !PsiTreeUtil.isContextAncestor((PsiElement)def.getNameElement(), (PsiElement)o2, (boolean)false)) {
            ObjectKind kind = def.getKind();
            isPl = kind == ObjectKind.ROUTINE || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
        }
        return this.checkIdentifierIsKeyword(o2, manager, onTheFly, isPl);
    }

    @Override
    @NotNull
    public SqlValidatingHighlightVisitor.Delegate createValidationDelegate(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            OraDialect.$$$reportNull$$$0(37);
        }
        return new OraValidationDelegate(this, holder);
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new OraExtractVariableHelper();
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return OraExtractFunctionHelper.INSTANCE;
    }

    @Override
    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        OraErrorSpecHelper oraErrorSpecHelper = OraErrorSpecHelper.INSTANCE;
        if (oraErrorSpecHelper == null) {
            OraDialect.$$$reportNull$$$0(38);
        }
        return oraErrorSpecHelper;
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new OraDFABuildingVisitor(this);
    }

    @Override
    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        OraDateTimeLanguageHelper oraDateTimeLanguageHelper = OraDateTimeLanguageHelper.INSTANCE;
        if (oraDateTimeLanguageHelper == null) {
            OraDialect.$$$reportNull$$$0(39);
        }
        return oraDateTimeLanguageHelper;
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false)));
    }

    private static boolean isBulkUpdateAttribute(@NotNull PsiElement element2) {
        PsiElement parent2;
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(40);
        }
        if (!((parent2 = element2.getParent()) instanceof SqlBinaryExpression)) {
            return false;
        }
        SqlUnaryExpression prev = (SqlUnaryExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element2, SqlUnaryExpression.class);
        ASTNode node2 = prev == null ? null : prev.getNode();
        ASTNode bulkException = node2 == null ? null : node2.findChildByType(OraTypes.ORA_BULK_EXCEPTIONS);
        return bulkException != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 12, 14, 16, 28, 29, 32, 35, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraDialect";
                break;
            }
            case 2: 
            case 6: 
            case 22: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitParentInfo";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParameters";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processConnectByPseudoColumns";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionAttribute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBodyRoutine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterResolveResults";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTableTypeLookupCandidate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isColumnTypeLookupCandidate";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferenceLookupString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processNamedArgumentCandidates";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitParentInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureParameters";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createValidationDelegate";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isBulkUpdateAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 12, 14, 16, 28, 29, 32, 35, 38, 39 -> new IllegalStateException(string);
        };
    }

    protected static final class LazyData {
        static final Set<ObjectKind> IGNORED_ROUTINE_DROP_TARGETS = Set.of(ObjectKind.PACKAGE, ObjectKind.OBJECT_TYPE);
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadTokens(INSTANCE, "exceptions.txt"));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects(INSTANCE, "fallback.txt");
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV, SqlTokens.ORAP_SLASH_DELIMITER_TOKEN, SqlTokens.ORAP_DELIMITER_TOKEN, SqlTokens.ORAP_BIG_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.ORA_POWER, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.ORA_OP_JOIN, OraReservedKeywords.ORA_PRIOR, OraOptionalKeywords.ORA_LIKEC, OraOptionalKeywords.ORA_LIKE2, OraOptionalKeywords.ORA_LIKE4, OraTypes.ORA_AT, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_NEQ_WS, SqlTokens.SQL_OP_NEQ2_WS, SqlTokens.SQL_OP_NEQ3_WS, SqlTokens.SQL_YEAR, SqlTokens.SQL_DAY, SqlTokens.SQL_OP_ASSIGN, OraTypes.ORA_MEMBER, OraTypes.ORA_SUBMULTISET, OraTypes.ORA_CURSOR, OraOptionalKeywords.ORA_MULTISET);
        static final Map<String, ReservedEntity> PSEUDO_COLUMNS = SqlDialectImplUtilCore.buildEntities(Dbms.ORACLE, ObjectKind.COLUMN, "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "COLUMN_VALUE", "OBJECT_ID", "OBJECT_VALUE", "ORA_ROWSCN", "VERSIONS_STARTTIME", "VERSIONS_STARTSCN", "VERSIONS_ENDTIME", "VERSIONS_ENDSCN", "VERSIONS_XID", "VERSIONS_OPERATION", "XMLDATA", "ROWID", "ROWNUM");
        static final Map<String, ReservedEntity> CONNECT_BY_PSEUDO_COLUMNS = SqlDialectImplUtilCore.buildEntities(Dbms.ORACLE, ObjectKind.COLUMN, "CONNECT_BY_ISCYCLE", "CONNECT_BY_ISLEAF", "LEVEL");
        static final Map<String, ReservedEntity> PL_TABLE_ATTRIBUTES = SqlDialectImplUtilCore.buildEntities(Dbms.ORACLE, ObjectKind.COLUMN, "COUNT", "FIRST", "LAST");
        static final ReservedEntity RE_EXTEND = new ReservedEntity(Dbms.ORACLE, "extend", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_PROFILE_DEFAULT = new ReservedEntity(Dbms.ORACLE, "DEFAULT", SqlDbElementType.PROFILE);

        protected LazyData() {
        }

        static {
            PL_TABLE_ATTRIBUTES.putAll(SqlDialectImplUtilCore.buildEntities(Dbms.ORACLE, ObjectKind.ROUTINE, "EXISTS", "PRIOR", "NEXT", "DELETE"));
        }
    }
}

