/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.Version;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mysql.MysqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.dataFlow.MysqlErrorSpecHelper;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractFunctionHelper;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlColors;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlDialectBase
extends SqlLanguageDialectBase {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());

    public MysqlDialectBase(String id) {
        super(id);
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "Geometry", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "JSON", "json", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Curve", "curve", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "LineString", "linestring", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "LinearRing", "linearring", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Surface", "surface", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "GeometryCollection", "geometrycollection", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "MultiPoint", "multipoint", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "MultiCurve", "multicurve", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "MultiLineString", "Multilinestring", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "MultiSurface", "multisurface", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "MultiPolygon", "multipolygon", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MysqlDialectBase.$$$reportNull$$$0(0);
        }
        return set;
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MysqlDialectBase.$$$reportNull$$$0(1);
        }
        if (type == ObjectKind.VARIABLE && place instanceof SqlReferenceExpression) {
            PsiElement p2 = place.getParent();
            return p2 instanceof SqlFromClause || p2 instanceof SqlJoinExpression;
        }
        return super.isResolveTargetNotAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            MysqlDialectBase.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(3);
        }
        if (!this.processReservedEntitiesWithTypeDual(name2, place, resolve2, processor2)) {
            return false;
        }
        SqlStatement stmt2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)place, SqlStatement.class);
        if (stmt2 instanceof MysqlShowStatementImpl) {
            ReservedEntity.Typed[] cols2;
            MysqlShowStatementImpl showStatement = (MysqlShowStatementImpl)stmt2;
            Pair<IElementType, IElementType> type = showStatement.getShowType();
            ReservedEntity.Typed[] typedArray = cols2 = type == null ? null : ((LazyInstanceData)this.myInstanceData.getValue()).myShowColumnsByType.get(type);
            if (cols2 != null) {
                for (ReservedEntity.Typed col : cols2) {
                    if (MysqlDialectBase.processReservedEntitiesWithTypeSimple(col, col.type, name2, place, resolve2, processor2, true, false)) continue;
                    return false;
                }
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        ObjectKind kind;
        if (identifier == null) {
            MysqlDialectBase.$$$reportNull$$$0(4);
        }
        return (kind = SqlImplUtil.getIdentifierKind(identifier)) == null ? Integer.MAX_VALUE : (kind == SqlDbElementType.LOCAL_ALIAS ? 256 : (kind == ObjectKind.USER || kind == ObjectKind.ROLE ? 32 : 64));
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = MysqlDialectBase.getDefaultNamespace(dataSource2, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                MysqlDialectBase.$$$reportNull$$$0(5);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource2, dsNames, false);
        if (treePattern == null) {
            MysqlDialectBase.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        boolean autoInc;
        if (column2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(7);
        }
        if ((autoInc = super.isAutoIncrementColumn(column2)) || column2 instanceof SqlColumnDefinitionImpl && ((SqlColumnDefinitionImpl)((Object)column2)).getGreenStub() != null) {
            return autoInc;
        }
        String type = column2.getDasType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(8);
        }
        String result2 = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterateStatementsBackward((PsiFile)file, offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result2 = delimiter.getDelimiter();
                break;
            }
        }
        if (result2 == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                MysqlDialectBase.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            MysqlDialectBase.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref2) {
        if (ref2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(11);
        }
        return !this.getKeywords().contains(ref2);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(12);
        }
        return element2 == SqlCompositeElementTypes.SQL_STRING_LITERAL || element2 == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element2 == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection2 = LazyData.MAJOR_CHILD_KINDS;
        if (collection2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(13);
        }
        return collection2;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiReference ref2) {
        if (processor2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(14);
        }
        if (state == null) {
            MysqlDialectBase.$$$reportNull$$$0(15);
        }
        if (ref2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(16);
        }
        if (processor2.isExpected(MysqlElementTypes.Extra.USER_VARIABLE)) {
            SqlFileImpl sqlFile;
            PsiFile file = ref2.getElement().getContainingFile();
            if (file != null) {
                file = (PsiFile)ObjectUtils.chooseNotNull((Object)file.getOriginalFile(), (Object)file);
            }
            if ((sqlFile = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)file, SqlFileImpl.class))) != null) {
                for (SqlReferenceExpression expression : MysqlDialectBase.getGlobalVariables(sqlFile)) {
                    if (processor2.execute(DasSymbolUtil.getInlineSymbol(expression.getReference()), state)) continue;
                    return false;
                }
            }
            if (processor2.getReferenceName() != null && !processor2.isExpected(SqlDbElementType.ANY)) {
                return false;
            }
        }
        return super.processUnqualifiedResolve(processor2, state, ref2);
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    public boolean supportsNaturalJoin() {
        return true;
    }

    @Override
    protected boolean checkArgumentMatch(@NotNull DasRoutine routine2, @NotNull SqlFunctionCallExpression call2) {
        Object target2;
        if (routine2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(17);
        }
        if (call2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(18);
        }
        if ((target2 = routine2) instanceof DbRoutine) {
            target2 = ((DbRoutine)target2).getDelegate();
        }
        if (target2 instanceof SqlRoutineDefinition && SqlImplUtil.sqlChildren((PsiElement)((SqlRoutineDefinition)target2)).filter(e2 -> PsiUtilCore.getElementType((PsiElement)e2) == MysqlTypes.MYSQL_SONAME).isNotEmpty()) {
            return true;
        }
        return super.checkArgumentMatch(routine2, call2);
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper(this);
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MysqlExtractFunctionHelper.INSTANCE;
    }

    @Override
    @Nullable
    public TextAttributesKey getHighlightingByCustomKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            MysqlDialectBase.$$$reportNull$$$0(19);
        }
        if (kind == MysqlElementTypes.Extra.USER_VARIABLE) {
            return SqlColors.SQL_VARIABLE;
        }
        return super.getHighlightingByCustomKind(kind);
    }

    @Override
    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        MysqlErrorSpecHelper mysqlErrorSpecHelper = MysqlErrorSpecHelper.INSTANCE;
        if (mysqlErrorSpecHelper == null) {
            MysqlDialectBase.$$$reportNull$$$0(20);
        }
        return mysqlErrorSpecHelper;
    }

    @Override
    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = MysqlDateTimeLanguageHelper.INSTANCE;
        if (mysqlDateTimeLanguageHelper == null) {
            MysqlDialectBase.$$$reportNull$$$0(21);
        }
        return mysqlDateTimeLanguageHelper;
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_LOOP}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_IF}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()));
    }

    private ReservedEntity.Typed col(@NotNull String name2, @NotNull DasType type) {
        if (name2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(22);
        }
        if (type == null) {
            MysqlDialectBase.$$$reportNull$$$0(23);
        }
        return new ReservedEntity.Typed(this.getDbms(), name2, ObjectKind.COLUMN, type);
    }

    private static ReservedEntity.Typed[] cols(ReservedEntity.Typed ... entities) {
        return entities;
    }

    private static Pair<IElementType, IElementType> type(IElementType f, IElementType s2) {
        return Pair.create((Object)f, (Object)s2);
    }

    @NotNull
    public static List<SqlReferenceExpression> getGlobalVariables(@NotNull SqlFile file) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(24);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(MysqlDialectBase.calcGlobalVariables((SqlFileImpl)file), (Object[])new Object[]{file}));
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private static List<SqlReferenceExpression> calcGlobalVariables(SqlFileImpl file) {
        SqlLanguageDialectEx language = file.getSqlLanguage();
        if (!language.getDbms().isMysql() || file.getStub() != null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                MysqlDialectBase.$$$reportNull$$$0(26);
            }
            return list;
        }
        HashMap<String, Pair> gradedVariables = new HashMap<String, Pair>();
        for (SqlReferenceExpression ref2 : SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlReferenceExpression.class)) {
            String prefix;
            if (ref2.getReferenceElementType() != MysqlElementTypes.Extra.MYSQL_USER_VARIABLE_REFERENCE) continue;
            SqlIdentifier identifier = ref2.getIdentifier();
            String string = prefix = identifier == null ? null : identifier.getNamePrefix();
            if (!language.isVariablePrefix(prefix)) continue;
            int grade = MysqlDialectBase.getVariableReferenceGrade(ref2);
            String name2 = ref2.getName();
            Pair old2 = (Pair)gradedVariables.get(name2);
            if (old2 != null && grade >= (Integer)old2.second) continue;
            gradedVariables.put(name2, Pair.create((Object)ref2, (Object)grade));
        }
        List list = ContainerUtil.map(gradedVariables.values(), val -> (SqlReferenceExpression)val.first);
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static int getVariableReferenceGrade(@NotNull SqlReferenceExpression ref2) {
        if (ref2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(28);
        }
        int grade = 0;
        boolean insideRoutine = PsiTreeUtil.getParentOfType((PsiElement)ref2, SqlCreateProcedureStatement.class) != null;
        SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)ref2, SqlSetAssignment.class);
        if (assignment != null && assignment.getLValue() == ref2) {
            return insideRoutine ? grade + 1 : grade;
        }
        grade += 2;
        SqlBinaryExpression expr = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref2, SqlBinaryExpression.class);
        if (expr != null && expr.getLOperand() == ref2 && (expr.getOpSign() == SqlCommonTokens.SQL_OP_ASSIGN || expr.getOpSign() == SqlCommonTokens.SQL_OP_EQ)) {
            return insideRoutine ? grade + 1 : grade;
        }
        return insideRoutine ? grade + 1 : (grade += 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 7, 8, 11, 12, 14, 15, 16, 17, 18, 19, 22, 23, 24, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVariables";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGlobalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkArgumentMatch";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingByCustomKind";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalVariables";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferenceGrade";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 7, 8, 11, 12, 14, 15, 16, 17, 18, 19, 22, 23, 24, 28 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(MysqlDialect.INSTANCE));
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_COLLATE, SqlCommonKeywords.SQL_IN, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_INVERT, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.SQL_OP_LOGICAL_OR, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_LEFT_SHIFT, SqlCommonTokens.SQL_OP_RIGHT_SHIFT, SqlCommonTokens.SQL_OP_MODULO, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_NOT2, SqlCommonTokens.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY);
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);

        LazyData() {
        }
    }

    private final class LazyInstanceData {
        private final Map<Pair<IElementType, IElementType>, ReservedEntity.Typed[]> myShowColumnsByType;

        private LazyInstanceData() {
            DasTypeSystemBase typeSystem = MysqlDialectBase.this.getTypeSystem();
            this.myShowColumnsByType = Map.ofEntries(Map.entry(MysqlDialectBase.type((IElementType)MysqlReservedKeywords.MYSQL_CHARACTER, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Charset", typeSystem.getStringType()), MysqlDialectBase.this.col("Description", typeSystem.getStringType()), MysqlDialectBase.this.col("Default collation", typeSystem.getStringType()), MysqlDialectBase.this.col("Maxlen", typeSystem.getIntType()))), Map.entry(MysqlDialectBase.type((IElementType)SqlCommonKeywords.SQL_COLLATION, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Collation", typeSystem.getStringType()), MysqlDialectBase.this.col("Charset", typeSystem.getStringType()), MysqlDialectBase.this.col("Id", typeSystem.getIntType()), MysqlDialectBase.this.col("Default", typeSystem.getStringType()), MysqlDialectBase.this.col("Compiled", typeSystem.getStringType()), MysqlDialectBase.this.col("Sortlen", typeSystem.getIntType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_COLUMNS, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Field", typeSystem.getStringType()), MysqlDialectBase.this.col("Type", typeSystem.getStringType()), MysqlDialectBase.this.col("Null", typeSystem.getStringType()), MysqlDialectBase.this.col("Default", typeSystem.getStringType()), MysqlDialectBase.this.col("Extra", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_FULL, MysqlTypes.MYSQL_COLUMNS), MysqlDialectBase.cols(MysqlDialectBase.this.col("Field", typeSystem.getStringType()), MysqlDialectBase.this.col("Type", typeSystem.getStringType()), MysqlDialectBase.this.col("Collation", typeSystem.getStringType()), MysqlDialectBase.this.col("Null", typeSystem.getStringType()), MysqlDialectBase.this.col("Key", typeSystem.getStringType()), MysqlDialectBase.this.col("Default", typeSystem.getStringType()), MysqlDialectBase.this.col("Extra", typeSystem.getStringType()), MysqlDialectBase.this.col("Privileges", typeSystem.getStringType()), MysqlDialectBase.this.col("Comment", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type((IElementType)MysqlReservedKeywords.MYSQL_DATABASES, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("database", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_EVENTS, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Db", typeSystem.getStringType()), MysqlDialectBase.this.col("Name", typeSystem.getStringType()), MysqlDialectBase.this.col("Definer", typeSystem.getStringType()), MysqlDialectBase.this.col("Time Zone", typeSystem.getStringType()), MysqlDialectBase.this.col("Type", typeSystem.getStringType()), MysqlDialectBase.this.col("Execute At", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Interval Value", typeSystem.getStringType()), MysqlDialectBase.this.col("Interval Field", typeSystem.getStringType()), MysqlDialectBase.this.col("Starts", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Ends", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Status", typeSystem.getStringType()), MysqlDialectBase.this.col("Originator", typeSystem.getStringType()), MysqlDialectBase.this.col("character_set_client", typeSystem.getStringType()), MysqlDialectBase.this.col("collation_connection", typeSystem.getStringType()), MysqlDialectBase.this.col("Database Collation", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_STATUS), MysqlDialectBase.cols(MysqlDialectBase.this.col("Db", typeSystem.getStringType()), MysqlDialectBase.this.col("Name", typeSystem.getStringType()), MysqlDialectBase.this.col("Type", typeSystem.getStringType()), MysqlDialectBase.this.col("Definer", typeSystem.getStringType()), MysqlDialectBase.this.col("Modified", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Created", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Security_type", typeSystem.getStringType()), MysqlDialectBase.this.col("Comment", typeSystem.getStringType()), MysqlDialectBase.this.col("character_set_client", typeSystem.getStringType()), MysqlDialectBase.this.col("collation_connection", typeSystem.getStringType()), MysqlDialectBase.this.col("Database Collation", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type((IElementType)MysqlReservedKeywords.MYSQL_INDEX, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Table", typeSystem.getStringType()), MysqlDialectBase.this.col("Non_unique", typeSystem.getIntType()), MysqlDialectBase.this.col("Key_name", typeSystem.getStringType()), MysqlDialectBase.this.col("Seq_in_index", typeSystem.getIntType()), MysqlDialectBase.this.col("Column_name", typeSystem.getStringType()), MysqlDialectBase.this.col("Collation", typeSystem.getStringType()), MysqlDialectBase.this.col("Cardinality", typeSystem.getIntType()), MysqlDialectBase.this.col("Sub_part", typeSystem.getIntType()), MysqlDialectBase.this.col("Packed", typeSystem.getStringType()), MysqlDialectBase.this.col("Null", typeSystem.getStringType()), MysqlDialectBase.this.col("Index_type", typeSystem.getStringType()), MysqlDialectBase.this.col("Comment", typeSystem.getStringType()), MysqlDialectBase.this.col("Index_comment", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_TABLES), MysqlDialectBase.cols(MysqlDialectBase.this.col("Database", typeSystem.getStringType()), MysqlDialectBase.this.col("Table", typeSystem.getStringType()), MysqlDialectBase.this.col("In_use", typeSystem.getIntType()), MysqlDialectBase.this.col("Name_locked", typeSystem.getIntType()))), Map.entry(MysqlDialectBase.type((IElementType)MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_STATUS), MysqlDialectBase.cols(MysqlDialectBase.this.col("Db", typeSystem.getStringType()), MysqlDialectBase.this.col("Name", typeSystem.getStringType()), MysqlDialectBase.this.col("Type", typeSystem.getStringType()), MysqlDialectBase.this.col("Definer", typeSystem.getStringType()), MysqlDialectBase.this.col("Modified", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Created", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Security_type", typeSystem.getStringType()), MysqlDialectBase.this.col("Comment", typeSystem.getStringType()), MysqlDialectBase.this.col("character_set_client", typeSystem.getStringType()), MysqlDialectBase.this.col("collation_connection", typeSystem.getStringType()), MysqlDialectBase.this.col("Database Collation", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_STATUS, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Variable_name", typeSystem.getStringType()), MysqlDialectBase.this.col("Value", typeSystem.getIntType()))), Map.entry(MysqlDialectBase.type((IElementType)MysqlReservedKeywords.MYSQL_TABLE, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Name", typeSystem.getStringType()), MysqlDialectBase.this.col("Engine", typeSystem.getStringType()), MysqlDialectBase.this.col("Version", typeSystem.getIntType()), MysqlDialectBase.this.col("Row_format", typeSystem.getStringType()), MysqlDialectBase.this.col("Rows", typeSystem.getIntType()), MysqlDialectBase.this.col("Avg_row_length", typeSystem.getIntType()), MysqlDialectBase.this.col("Data_length", typeSystem.getIntType()), MysqlDialectBase.this.col("Max_data_length", typeSystem.getIntType()), MysqlDialectBase.this.col("Index_length", typeSystem.getIntType()), MysqlDialectBase.this.col("Data_free", typeSystem.getIntType()), MysqlDialectBase.this.col("Auto_increment", typeSystem.getIntType()), MysqlDialectBase.this.col("Create_time", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Update_time", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Check_time", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("Collation", typeSystem.getStringType()), MysqlDialectBase.this.col("Checksum", typeSystem.getIntType()), MysqlDialectBase.this.col("Create_options", typeSystem.getStringType()), MysqlDialectBase.this.col("Comment", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_TRIGGERS, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Trigger", typeSystem.getStringType()), MysqlDialectBase.this.col("Event", typeSystem.getStringType()), MysqlDialectBase.this.col("Table", typeSystem.getStringType()), MysqlDialectBase.this.col("Statement", typeSystem.getStringType()), MysqlDialectBase.this.col("Timing", typeSystem.getStringType()), MysqlDialectBase.this.col("Created", typeSystem.getDateTimeType()), MysqlDialectBase.this.col("sql_mode", typeSystem.getStringType()), MysqlDialectBase.this.col("Definer", typeSystem.getStringType()), MysqlDialectBase.this.col("character_set_client", typeSystem.getStringType()), MysqlDialectBase.this.col("collation_connection", typeSystem.getStringType()), MysqlDialectBase.this.col("Database Collation", typeSystem.getStringType()))), Map.entry(MysqlDialectBase.type(MysqlTypes.MYSQL_VARIABLES, null), MysqlDialectBase.cols(MysqlDialectBase.this.col("Variable_name", typeSystem.getStringType()), MysqlDialectBase.this.col("Value", typeSystem.getStringType()))));
        }
    }
}

