/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.psi.resolve.scopes;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReference;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.scopes.MongoJSScope;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSCollection;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSDatabase;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0002J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\nH\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010&\u001a\u00020\fH\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSFileScope;", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSScope;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "getDataSource", "()Lcom/intellij/database/model/DasDataSource;", "databaseMap", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSDatabase;", "getDatabaseMap", "()Lcom/intellij/util/containers/MultiMap;", "dbPsiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "Lorg/jetbrains/annotations/NotNull;", "getDbPsiFacade", "()Lcom/intellij/database/psi/DbPsiFacade;", "extraCollections", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSCollection;", "getExtraCollections", "searchPath", "Lcom/intellij/database/util/SearchPath;", "getSearchPath", "()Lcom/intellij/database/util/SearchPath;", "computeCurrentDatabases", "", "computeDatabaseMap", "computeExtraCollections", "equals", "", "other", "", "getCurrentDatabases", "getDatabases", "name", "database", "hashCode", "", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoJSFileScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoJSFileScope.kt\ncom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSFileScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MongoJSPsiUtil.kt\ncom/intellij/sql/dialects/mongo/js/MongoJSPsiUtilKt\n*L\n1#1,96:1\n1#2:97\n1549#3:98\n1620#3,3:99\n1360#3:102\n1446#3,5:103\n1855#3:108\n1856#3:110\n36#4:109\n*S KotlinDebug\n*F\n+ 1 MongoJSFileScope.kt\ncom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSFileScope\n*L\n62#1:98\n62#1:99,3\n64#1:102\n64#1:103,5\n70#1:108\n70#1:110\n72#1:109\n*E\n"})
public final class MongoJSFileScope
implements MongoJSScope {
    @NotNull
    private final PsiFile file;

    public MongoJSFileScope(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    private final DbPsiFacade getDbPsiFacade() {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(this.file.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"getInstance(...)");
        return dbPsiFacade;
    }

    private final MultiMap<String, MongoJSDatabase> getDatabaseMap() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.file), () -> MongoJSFileScope._get_databaseMap_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (MultiMap)object;
    }

    private final MultiMap<String, MongoJSCollection> getExtraCollections() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.file), () -> MongoJSFileScope._get_extraCollections_$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (MultiMap)object;
    }

    private final DasDataSource getDataSource() {
        JdbcConsoleCore console;
        DbDataSource dataSource2 = (DbDataSource)this.file.getUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY);
        if (dataSource2 != null) {
            return dataSource2;
        }
        VirtualFile virtualFile = DatabaseEditorHelperCore.getVirtualFile(this.file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        JdbcConsoleCore jdbcConsoleCore = console = JdbcConsoleProviderCore.getValidConsole(this.file.getProject(), virtualFile2);
        return jdbcConsoleCore != null ? jdbcConsoleCore.getDataSource() : null;
    }

    private final SearchPath getSearchPath() {
        return DatabaseEditorHelperCore.getSearchPath(this.file);
    }

    private final MultiMap<String, MongoJSDatabase> computeDatabaseMap() {
        Object object;
        MultiMap results2;
        block5: {
            block4: {
                results2 = new MultiMap();
                object = this.getDataSource();
                if (object == null) break block4;
                DasDataSource it2 = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it2);
                object = list;
                if (list != null) break block5;
            }
            List<DbDataSource> list = SqlImplUtil.getDataSources((PsiElement)this.file);
            object = list;
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        }
        Object dataSources2 = object;
        Iterator iterator = dataSources2.iterator();
        while (iterator.hasNext()) {
            DasDataSource dataSource2 = (DasDataSource)iterator.next();
            DbDataSource dbDs = this.getDbPsiFacade().findDataSource(dataSource2.getUniqueId());
            for (DasObject root2 : dataSource2.getModel().getModelRoots()) {
                DbElement psi;
                if (DbImplUtilCore.findElement(dbDs, root2) == null) continue;
                String string = root2.getName();
                String string2 = psi.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                results2.putValue((Object)string, (Object)new MongoJSDatabase(string2, psi));
            }
        }
        return results2;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<MongoJSDatabase> computeCurrentDatabases() {
        void $this$flatMapTo$iv$iv;
        List schemaNames2;
        Object object = this.getSearchPath();
        if (object != null && (object = ((SearchPath)object).elements) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ObjectPath objectPath = (ObjectPath)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.name);
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = schemaNames2 = CollectionsKt.emptyList();
        }
        if (schemaNames2.isEmpty()) {
            Collection collection3 = this.getDatabaseMap().values();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"values(...)");
            return collection3;
        }
        Iterable $this$flatMap$iv = schemaNames2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it3 = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it3);
            Iterable list$iv$iv = this.getDatabases(it3);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MultiMap<String, MongoJSCollection> computeExtraCollections() {
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper((PsiElement)this.file);
        if (mongoJSResolveHelper == null) {
            MultiMap multiMap = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
            return multiMap;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        MultiMap results2 = new MultiMap();
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.file)).filter(MongoJSReferenceExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolveResult[] resolveResultArray;
            MongoJSCollection collection2;
            ResolveResult resolveResult;
            MongoJSSymbol mongoJSSymbol;
            MongoJSReferenceExpression it2 = (MongoJSReferenceExpression)element$iv;
            boolean bl = false;
            MongoJSExpression mongoJSExpression = it2.getQualifier();
            MongoJSReferenceExpression qualifier = mongoJSExpression instanceof MongoJSReferenceExpression ? (MongoJSReferenceExpression)mongoJSExpression : null;
            if (qualifier == null) continue;
            MongoJSReferenceExpression $this$isDbReference$iv = qualifier;
            boolean $i$f$isDbReference = false;
            MongoJSReference mongoJSReference = $this$isDbReference$iv.getReference();
            Intrinsics.checkNotNullExpressionValue((Object)mongoJSReference, (String)"getReference(...)");
            if (!MongoJSPsiUtilKt.isDbReference(mongoJSReference)) continue;
            ResolveResult[] resolveResultArray2 = it2.getReference().multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray2, (String)"multiResolve(...)");
            if ((ResolveResult)ArraysKt.singleOrNull((Object[])resolveResultArray2) == null || ((mongoJSSymbol = helper.getSymbol(resolveResult)) instanceof MongoJSCollection ? (MongoJSCollection)mongoJSSymbol : null) == null) continue;
            collection2 = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)qualifier.getReference().multiResolve(false), (String)"multiResolve(...)");
            for (ResolveResult target2 : resolveResultArray) {
                MongoJSDatabase db;
                Intrinsics.checkNotNull((Object)target2);
                MongoJSSymbol mongoJSSymbol2 = helper.getSymbol(target2);
                if ((mongoJSSymbol2 instanceof MongoJSDatabase ? (MongoJSDatabase)mongoJSSymbol2 : null) == null) continue;
                db = db;
                results2.putValue((Object)db.getName(), (Object)collection2);
            }
        }
        return results2;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MongoJSFileScope && Intrinsics.areEqual((Object)this.file, (Object)((MongoJSFileScope)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public Collection<MongoJSDatabase> getDatabases(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Collection collection2 = this.getDatabaseMap().get((Object)name2);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        return collection2;
    }

    @Override
    @NotNull
    public Collection<MongoJSDatabase> getDatabases() {
        Collection collection2 = this.getDatabaseMap().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"values(...)");
        return collection2;
    }

    @Override
    @NotNull
    public Collection<MongoJSDatabase> getCurrentDatabases() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.file), () -> MongoJSFileScope.getCurrentDatabases$lambda$6(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Collection)object;
    }

    @Override
    @NotNull
    public Collection<MongoJSCollection> getExtraCollections(@NotNull MongoJSDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Collection collection2 = this.getExtraCollections().get((Object)database.getName());
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        return collection2;
    }

    private static final CachedValueProvider.Result _get_databaseMap_$lambda$0(MongoJSFileScope this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{this$0.getDbPsiFacade()};
        return new CachedValueProvider.Result(this$0.computeDatabaseMap(), objectArray);
    }

    private static final CachedValueProvider.Result _get_extraCollections_$lambda$1(MongoJSFileScope this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{this$0.getDbPsiFacade()};
        return new CachedValueProvider.Result(this$0.computeExtraCollections(), objectArray);
    }

    private static final CachedValueProvider.Result getCurrentDatabases$lambda$6(MongoJSFileScope this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{this$0.getDbPsiFacade()};
        return new CachedValueProvider.Result(this$0.computeCurrentDatabases(), objectArray);
    }
}

