/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.completion.MongoJsCompletionUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.context.MongoJSExpressionContext;
import com.intellij.sql.dialects.mongo.js.psi.resolve.place.MongoJSExpressionPlace;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSMethod;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J&\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/mongo/js/completion/MongoJSReferenceCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "suggestSymbols", "symbols", "", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSSymbol;", "isCall", "", "suggestTopLevelSymbols", "intellij.database.dialects.mongo"})
public final class MongoJSReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final MongoJSReferenceCompletionProvider INSTANCE = new MongoJSReferenceCompletionProvider();

    private MongoJSReferenceCompletionProvider() {
    }

    private final void suggestTopLevelSymbols(boolean isCall, CompletionResultSet result2) {
        this.suggestSymbols(MongoJSSymbol.Companion.getTopLevelSymbols(), isCall, result2);
    }

    private final void suggestSymbols(Collection<? extends MongoJSSymbol> symbols, boolean isCall, CompletionResultSet result2) {
        for (MongoJSSymbol mongoJSSymbol : symbols) {
            String lookupString = isCall || !(mongoJSSymbol instanceof MongoJSMethod) ? mongoJSSymbol.getName() : mongoJSSymbol.getName() + "()";
            result2.addElement(MongoJsCompletionUtilKt.createLookupElement$default(mongoJSSymbol, lookupString, null, 0.0, 12, null));
        }
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        MongoJSExpressionPlace expressionPlace;
        PsiElement qualifier;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters2.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        if (position.getParent() instanceof PsiErrorElement) {
            return;
        }
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper(position);
        if (mongoJSResolveHelper == null) {
            return;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        Class<? extends PsiElement> refExpressionClass = helper.getReferenceExpressionClass();
        PsiElement psiElement2 = MongoJSPsiUtilKt.parentIfInstanceOf(position, refExpressionClass);
        if (psiElement2 == null) {
            return;
        }
        PsiElement expression = psiElement2;
        PsiElement psiElement3 = parameters2.getOriginalPosition();
        PsiElement originalExpression = psiElement3 != null ? MongoJSPsiUtilKt.parentIfInstanceOf(psiElement3, refExpressionClass) : null;
        boolean isCall = originalExpression != null && helper.isCalleeReference(originalExpression);
        PsiReference psiReference = expression.getReference();
        PsiQualifiedReference psiQualifiedReference = psiReference instanceof PsiQualifiedReference ? (PsiQualifiedReference)psiReference : null;
        Object object = qualifier = psiQualifiedReference != null ? psiQualifiedReference.getQualifier() : null;
        if (qualifier != null) {
            if (!isCall) {
                PsiElement psiElement4 = originalExpression;
                PsiReference psiReference2 = psiElement4 != null ? psiElement4.getReference() : null;
                PsiQualifiedReference psiQualifiedReference2 = psiReference2 instanceof PsiQualifiedReference ? (PsiQualifiedReference)psiReference2 : null;
                String referenceName = psiQualifiedReference2 != null ? psiQualifiedReference2.getReferenceName() : null;
                MongoJsCompletionUtilKt.suggestCollectionsByQualifier(qualifier, referenceName, originalExpression, result2);
            }
            this.suggestSymbols(helper.getMongoType(qualifier).getMembers(qualifier.getText()), isCall, result2);
            return;
        }
        PsiFile psiFile = parameters2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        MongoJSExpressionPlace mongoJSExpressionPlace = expressionPlace = MongoJSExpressionPlace.Companion.fromIfCorrect(expression, file);
        switch (mongoJSExpressionPlace == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mongoJSExpressionPlace.ordinal()]) {
            case -1: {
                break;
            }
            case 1: {
                if (isCall) break;
                MongoJSExpressionContext expressionContext = ResolveUtilKt.mongoExpressionContext(expression, file);
                MongoJsCompletionUtilKt.suggestFields(expression, expressionPlace, expressionContext, result2);
                MongoJsCompletionUtilKt.suggestOperators(expressionContext, result2);
                break;
            }
            case 2: 
            case 3: {
                if (!isCall) {
                    MongoJSExpressionContext expressionContext = ResolveUtilKt.mongoExpressionContext(expression, file);
                    MongoJsCompletionUtilKt.suggestFields(expression, expressionPlace, expressionContext, result2);
                }
                this.suggestTopLevelSymbols(isCall, result2);
                break;
            }
            case 4: {
                if (isCall) break;
                MongoJsCompletionUtilKt.suggestDatabases(expression, result2);
                break;
            }
            case 5: {
                if (!isCall) {
                    result2.addElement(MongoJsCompletionUtilKt.createLookupElement$default("db", ObjectKind.DATABASE, 0.0, 4, null));
                }
                this.suggestTopLevelSymbols(isCall, result2);
                break;
            }
            case 6: {
                this.suggestTopLevelSymbols(isCall, result2);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MongoJSExpressionPlace.values().length];
            try {
                nArray[MongoJSExpressionPlace.PROPERTY_KEY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MongoJSExpressionPlace.PROPERTY_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MongoJSExpressionPlace.TOP_CALLEE_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MongoJSExpressionPlace.USE_STATEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MongoJSExpressionPlace.EXPRESSION_STATEMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MongoJSExpressionPlace.UNDEFINED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

